/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.concur.lock.OOneEntryPerKeyLockManager;
import com.orientechnologies.common.concur.lock.OPartitionedLockManager;
import com.orientechnologies.common.concur.lock.OReadersWriterSpinLock;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.OOrientShutdownListener;
import com.orientechnologies.orient.core.OOrientStartupListener;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexKeyCursor;
import com.orientechnologies.orient.core.index.OIndexMetadata;
import com.orientechnologies.orient.core.index.OIndexRebuildOutputListener;
import com.orientechnologies.orient.core.index.OIndexes;
import com.orientechnologies.orient.core.index.OPropertyIndexDefinition;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OIndexEngineCallback;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public abstract class OIndexAbstract<T>
implements OIndexInternal<T>,
OOrientStartupListener,
OOrientShutdownListener {
    protected static final String CONFIG_MAP_RID = "mapRid";
    protected static final String CONFIG_CLUSTERS = "clusters";
    protected final String type;
    protected final OLockManager<Object> keyLockManager;
    protected volatile IndexConfiguration configuration;
    protected final ODocument metadata;
    protected final OAbstractPaginatedStorage storage;
    private final String databaseName;
    private final String name;
    private final OReadersWriterSpinLock rwLock = new OReadersWriterSpinLock();
    private final AtomicLong rebuildVersion = new AtomicLong();
    private final int version;
    protected String valueContainerAlgorithm;
    protected int indexId = -1;
    private String algorithm;
    private Set<String> clustersToIndex = new HashSet<String>();
    private volatile OIndexDefinition indexDefinition;
    private volatile boolean rebuilding = false;
    private volatile ThreadLocal<IndexTxSnapshot> txSnapshot = new IndexTxSnapshotThreadLocal();
    private Map<String, String> engineProperties = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexAbstract(String name, String type, String algorithm, String valueContainerAlgorithm, ODocument metadata, int version, OStorage storage) {
        this.acquireExclusiveLock();
        try {
            this.databaseName = ODatabaseRecordThreadLocal.INSTANCE.get().getName();
            this.version = version;
            this.name = name;
            this.type = type;
            this.algorithm = algorithm;
            this.metadata = metadata;
            this.valueContainerAlgorithm = valueContainerAlgorithm;
            this.storage = (OAbstractPaginatedStorage)storage.getUnderlying();
            this.keyLockManager = Orient.instance().isRunningDistributed() ? new OOneEntryPerKeyLockManager(true, -1, OGlobalConfiguration.COMPONENTS_LOCK_CACHE.getValueAsInteger()) : new OPartitionedLockManager();
            Orient.instance().registerWeakOrientStartupListener(this);
            Orient.instance().registerWeakOrientShutdownListener(this);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public static OIndexMetadata loadMetadataInternal(ODocument config, String type, String algorithm, String valueContainerAlgorithm) {
        String indexName = (String)config.field("name");
        ODocument indexDefinitionDoc = (ODocument)config.field("indexDefinition");
        OIndexDefinition loadedIndexDefinition = null;
        if (indexDefinitionDoc != null) {
            try {
                String indexDefClassName = (String)config.field("indexDefinitionClass");
                Class<?> indexDefClass = Class.forName(indexDefClassName);
                loadedIndexDefinition = (OIndexDefinition)indexDefClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                loadedIndexDefinition.fromStream(indexDefinitionDoc);
            }
            catch (ClassNotFoundException e) {
                throw OException.wrapException(new OIndexException("Error during deserialization of index definition"), e);
            }
            catch (NoSuchMethodException e) {
                throw OException.wrapException(new OIndexException("Error during deserialization of index definition"), e);
            }
            catch (InvocationTargetException e) {
                throw OException.wrapException(new OIndexException("Error during deserialization of index definition"), e);
            }
            catch (InstantiationException e) {
                throw OException.wrapException(new OIndexException("Error during deserialization of index definition"), e);
            }
            catch (IllegalAccessException e) {
                throw OException.wrapException(new OIndexException("Error during deserialization of index definition"), e);
            }
        } else {
            Boolean isAutomatic = (Boolean)config.field("automatic");
            OIndexFactory factory = OIndexes.getFactory(type, algorithm);
            if (Boolean.TRUE.equals(isAutomatic)) {
                int pos = indexName.lastIndexOf(46);
                if (pos < 0) {
                    throw new OIndexException("Cannot convert from old index model to new one. Invalid index name. Dot (.) separator should be present");
                }
                String className = indexName.substring(0, pos);
                String propertyName = indexName.substring(pos + 1);
                String keyTypeStr = (String)config.field("keyType");
                if (keyTypeStr == null) {
                    throw new OIndexException("Cannot convert from old index model to new one. Index key type is absent");
                }
                OType keyType = OType.valueOf(keyTypeStr.toUpperCase(Locale.ENGLISH));
                loadedIndexDefinition = new OPropertyIndexDefinition(className, propertyName, keyType);
                config.removeField("automatic");
                config.removeField("keyType");
            } else if (config.field("keyType") != null) {
                String keyTypeStr = (String)config.field("keyType");
                OType keyType = OType.valueOf(keyTypeStr.toUpperCase(Locale.ENGLISH));
                loadedIndexDefinition = new OSimpleKeyIndexDefinition(factory.getLastVersion(), keyType);
                config.removeField("keyType");
            }
        }
        HashSet<String> clusters = new HashSet<String>((Collection)config.field(CONFIG_CLUSTERS, OType.EMBEDDEDSET));
        return new OIndexMetadata(indexName, loadedIndexDefinition, clusters, type, algorithm, valueContainerAlgorithm);
    }

    @Override
    public void onShutdown() {
        this.txSnapshot = null;
    }

    @Override
    public void onStartup() {
        if (this.txSnapshot == null) {
            this.txSnapshot = new IndexTxSnapshotThreadLocal();
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public boolean hasRangeQuerySupport() {
        this.acquireSharedLock();
        try {
            boolean bl = this.storage.hasIndexRangeQuerySupport(this.indexId);
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public OIndexInternal<?> create(OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener, OBinarySerializer valueSerializer) {
        this.acquireExclusiveLock();
        try {
            this.configuration = this.indexConfigurationInstance(new ODocument().setTrackingChanges(false));
            this.indexDefinition = indexDefinition;
            this.clustersToIndex = clustersToIndex != null ? new HashSet<String>(clustersToIndex) : new HashSet<String>();
            try {
                this.removeValuesContainer();
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Error during deletion of index '%s'", this.name);
            }
            Boolean durableInNonTxMode = this.isDurableInNonTxMode();
            this.indexId = this.storage.addIndexEngine(this.name, this.algorithm, this.type, indexDefinition, valueSerializer, this.isAutomatic(), durableInNonTxMode, this.version, this.getEngineProperties(), clustersToIndex, this.metadata);
            assert (this.indexId >= 0);
            this.onIndexEngineChange(this.indexId);
            if (rebuild) {
                this.fillIndex(progressListener);
            }
            this.updateConfiguration();
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Exception during index '%s' creation", e, this.name);
            try {
                if (this.indexId >= 0) {
                    this.storage.deleteIndexEngine(this.indexId);
                }
            }
            catch (Exception ex) {
                OLogManager.instance().error((Object)this, "Exception during index '%s' deletion", ex, this.name);
            }
            if (e instanceof OIndexException) {
                throw (OIndexException)e;
            }
            throw OException.wrapException(new OIndexException("Cannot create the index '" + this.name + "'"), e);
        }
        finally {
            this.releaseExclusiveLock();
        }
        return this;
    }

    @Override
    public long count(Object iKey) {
        Object result = this.get(iKey);
        if (result == null) {
            return 0L;
        }
        if (OMultiValue.isMultiValue(result)) {
            return OMultiValue.getSize(result);
        }
        return 1L;
    }

    private Boolean isDurableInNonTxMode() {
        Object durable = null;
        if (this.metadata != null) {
            durable = this.metadata.field("durableInNonTxMode");
        }
        Boolean durableInNonTxMode = durable instanceof Boolean ? (Boolean)durable : null;
        return durableInNonTxMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadFromConfiguration(ODocument config) {
        this.acquireExclusiveLock();
        try {
            block12: {
                block11: {
                    this.configuration = this.indexConfigurationInstance(config);
                    this.clustersToIndex.clear();
                    OIndexMetadata indexMetadata = this.loadMetadata(config);
                    this.indexDefinition = indexMetadata.getIndexDefinition();
                    this.clustersToIndex.addAll(indexMetadata.getClustersToIndex());
                    this.algorithm = indexMetadata.getAlgorithm();
                    this.valueContainerAlgorithm = indexMetadata.getValueContainerAlgorithm();
                    this.indexId = this.storage.loadIndexEngine(this.name);
                    if (this.indexId == -1) {
                        this.indexId = this.storage.loadExternalIndexEngine(this.name, this.algorithm, this.type, this.indexDefinition, this.determineValueSerializer(), this.isAutomatic(), this.isDurableInNonTxMode(), this.version, this.getEngineProperties());
                    }
                    if (this.indexId != -1) break block11;
                    boolean bl = false;
                    return bl;
                }
                try {
                    this.onIndexEngineChange(this.indexId);
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Error during load of index '%s'", e, this.name != null ? this.name : "null");
                    if (!this.isAutomatic()) break block12;
                    OLogManager.instance().warn((Object)this, "Cannot load index '%s' rebuilt it from scratch", this.getName());
                    try {
                        this.rebuild();
                    }
                    catch (Throwable t) {
                        OLogManager.instance().error((Object)this, "Cannot rebuild index '%s' because '" + t + "'. The index will be removed in configuration", e, this.getName());
                        boolean bl = false;
                        this.releaseExclusiveLock();
                        return bl;
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    protected Map<String, String> getEngineProperties() {
        return this.engineProperties;
    }

    @Override
    public OIndexMetadata loadMetadata(ODocument config) {
        return OIndexAbstract.loadMetadataInternal(config, this.type, this.algorithm, this.valueContainerAlgorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object key) {
        key = this.getCollatingValue(key);
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.acquireSharedLock(key);
        }
        try {
            this.acquireSharedLock();
            try {
                assert (this.indexId >= 0);
                boolean bl = this.storage.indexContainsKey(this.indexId, key);
                this.releaseSharedLock();
                return bl;
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
        }
        finally {
            if (!txIsActive) {
                this.keyLockManager.releaseSharedLock(key);
            }
        }
    }

    @Override
    public long rebuild() {
        return this.rebuild(new OIndexRebuildOutputListener(this));
    }

    @Override
    public void setRebuildingFlag() {
        this.rebuilding = true;
    }

    @Override
    public void close() {
    }

    @Override
    public Object getFirstKey() {
        this.acquireSharedLock();
        try {
            Object object = this.storage.getIndexFirstKey(this.indexId);
            return object;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Object getLastKey() {
        this.acquireSharedLock();
        try {
            Object object = this.storage.getIndexLastKey(this.indexId);
            return object;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long getRebuildVersion() {
        return 0L;
    }

    @Override
    public long rebuild(OProgressListener iProgressListener) {
        long documentIndexed = 0L;
        boolean intentInstalled = this.getDatabase().declareIntent(new OIntentMassiveInsert());
        this.acquireExclusiveLock();
        try {
            this.rebuilding = true;
            this.rebuildVersion.incrementAndGet();
            try {
                if (this.indexId >= 0) {
                    this.storage.deleteIndexEngine(this.indexId);
                }
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Error during index '%s' delete", this.name);
            }
            this.removeValuesContainer();
            this.indexId = this.storage.addIndexEngine(this.name, this.algorithm, this.type, this.indexDefinition, this.determineValueSerializer(), this.isAutomatic(), this.isDurableInNonTxMode(), this.version, this.getEngineProperties(), this.clustersToIndex, this.metadata);
            this.onIndexEngineChange(this.indexId);
        }
        catch (Exception e) {
            try {
                if (this.indexId >= 0) {
                    this.storage.clearIndex(this.indexId);
                }
            }
            catch (Exception e2) {
                OLogManager.instance().error((Object)this, "Error during index rebuild", e2, new Object[0]);
            }
            this.rebuilding = false;
            throw OException.wrapException(new OIndexException("Error on rebuilding the index for clusters: " + this.clustersToIndex), e);
        }
        finally {
            this.releaseExclusiveLock();
        }
        this.acquireSharedLock();
        try {
            documentIndexed = this.fillIndex(iProgressListener);
        }
        catch (Exception e) {
            try {
                if (this.indexId >= 0) {
                    this.storage.clearIndex(this.indexId);
                }
            }
            catch (Exception e2) {
                OLogManager.instance().error((Object)this, "Error during index rebuild", e2, new Object[0]);
            }
            throw OException.wrapException(new OIndexException("Error on rebuilding the index for clusters: " + this.clustersToIndex), e);
        }
        finally {
            this.rebuilding = false;
            if (intentInstalled) {
                this.getDatabase().declareIntent(null);
            }
            this.releaseSharedLock();
        }
        return documentIndexed;
    }

    private long fillIndex(OProgressListener iProgressListener) {
        long documentIndexed = 0L;
        try {
            long documentNum = 0L;
            long documentTotal = 0L;
            for (String cluster : this.clustersToIndex) {
                documentTotal += this.getDatabase().countClusterElements(cluster);
            }
            if (iProgressListener != null) {
                iProgressListener.onBegin(this, documentTotal, true);
            }
            for (String clusterName : this.clustersToIndex) {
                long[] metrics = this.indexCluster(clusterName, iProgressListener, documentNum, documentIndexed, documentTotal);
                documentNum = metrics[0];
                documentIndexed = metrics[1];
            }
            if (iProgressListener != null) {
                iProgressListener.onCompletition(this, true);
            }
        }
        catch (RuntimeException e) {
            if (iProgressListener != null) {
                iProgressListener.onCompletition(this, false);
            }
            throw e;
        }
        return documentIndexed;
    }

    @Override
    public boolean remove(Object key, OIdentifiable value) {
        return this.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key) {
        key = this.getCollatingValue(key);
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.acquireExclusiveLock(key);
        }
        try {
            this.acquireSharedLock();
            try {
                boolean bl = this.storage.removeKeyFromIndex(this.indexId, key);
                this.releaseSharedLock();
                return bl;
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
        }
        finally {
            if (!txIsActive) {
                this.keyLockManager.releaseExclusiveLock(key);
            }
        }
    }

    @Override
    public void lockKeysForUpdateNoTx(Object ... key) {
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.acquireExclusiveLocksInBatch((Object[])key);
        }
    }

    @Override
    public void lockKeysForUpdateNoTx(Collection<Object> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.acquireExclusiveLocksInBatch(keys);
        }
    }

    @Override
    public void releaseKeysForUpdateNoTx(Object ... key) {
        if (key == null) {
            return;
        }
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            for (Object k : key) {
                this.keyLockManager.releaseExclusiveLock(k);
            }
        }
    }

    @Override
    public void releaseKeysForUpdateNoTx(Collection<Object> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            for (Object k : keys) {
                this.keyLockManager.releaseExclusiveLock(k);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndex<T> clear() {
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.lockAllExclusive();
        }
        try {
            this.acquireSharedLock();
            try {
                this.storage.clearIndex(this.indexId);
                OIndexAbstract oIndexAbstract = this;
                this.releaseSharedLock();
                return oIndexAbstract;
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
        }
        finally {
            if (!txIsActive) {
                this.keyLockManager.unlockAllExclusive();
            }
        }
    }

    @Override
    public OIndexInternal<T> delete() {
        this.acquireExclusiveLock();
        try {
            this.storage.deleteIndexEngine(this.indexId);
            if (this.getDatabase().getMetadata() != null) {
                this.getDatabase().getMetadata().getIndexManager().removeClassPropertyIndex(this);
            }
            this.removeValuesContainer();
            OIndexAbstract oIndexAbstract = this;
            return oIndexAbstract;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public String getName() {
        this.acquireSharedLock();
        try {
            String string = this.name;
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public String getType() {
        this.acquireSharedLock();
        try {
            String string = this.type;
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public String getAlgorithm() {
        this.acquireSharedLock();
        try {
            String string = this.algorithm;
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public String toString() {
        this.acquireSharedLock();
        try {
            String string = this.name;
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexInternal<T> getInternal() {
        return this;
    }

    @Override
    public Set<String> getClusters() {
        this.acquireSharedLock();
        try {
            Set<String> set = Collections.unmodifiableSet(this.clustersToIndex);
            return set;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexAbstract<T> addCluster(String clusterName) {
        this.acquireExclusiveLock();
        try {
            if (this.clustersToIndex.add(clusterName)) {
                this.updateConfiguration();
                this.indexCluster(clusterName, null, 0L, 0L, 0L);
            }
            OIndexAbstract oIndexAbstract = this;
            return oIndexAbstract;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public OIndexAbstract<T> removeCluster(String iClusterName) {
        this.acquireExclusiveLock();
        try {
            if (this.clustersToIndex.remove(iClusterName)) {
                this.updateConfiguration();
                this.rebuild();
            }
            OIndexAbstract oIndexAbstract = this;
            return oIndexAbstract;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public ODocument checkEntry(OIdentifiable iRecord, Object iKey) {
        return null;
    }

    @Override
    public ODocument updateConfiguration() {
        this.configuration.updateConfiguration(this.type, this.name, this.version, this.indexDefinition, this.clustersToIndex, this.algorithm, this.valueContainerAlgorithm);
        return this.configuration.getDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTxOperation(OTransactionIndexChanges changes) {
        this.acquireSharedLock();
        try {
            IndexTxSnapshot indexTxSnapshot = this.txSnapshot.get();
            if (changes.cleared) {
                this.clearSnapshot(indexTxSnapshot);
            }
            Map<Object, Object> snapshot = indexTxSnapshot.indexSnapshot;
            for (OTransactionIndexChangesPerKey entry : changes.changesPerKey.values()) {
                this.applyIndexTxEntry(snapshot, entry);
            }
            this.applyIndexTxEntry(snapshot, changes.nullKeyChanges);
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private void applyIndexTxEntry(Map<Object, Object> snapshot, OTransactionIndexChangesPerKey entry) {
        for (OTransactionIndexChangesPerKey.OTransactionIndexEntry op : entry.entries) {
            switch (op.operation) {
                case PUT: {
                    this.putInSnapshot(entry.key, op.value, snapshot);
                    break;
                }
                case REMOVE: {
                    if (op.value != null) {
                        this.removeFromSnapshot(entry.key, op.value, snapshot);
                        break;
                    }
                    this.removeFromSnapshot(entry.key, snapshot);
                    break;
                }
            }
        }
    }

    @Override
    public void commit() {
        this.acquireSharedLock();
        try {
            IndexTxSnapshot indexTxSnapshot = this.txSnapshot.get();
            if (indexTxSnapshot.clear) {
                this.clear();
            }
            this.commitSnapshot(indexTxSnapshot.indexSnapshot);
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void preCommit() {
        this.txSnapshot.set(new IndexTxSnapshot());
    }

    @Override
    public void postCommit() {
        this.txSnapshot.set(new IndexTxSnapshot());
    }

    @Override
    public ODocument getConfiguration() {
        return this.configuration.getDocument();
    }

    @Override
    public ODocument getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public boolean isAutomatic() {
        this.acquireSharedLock();
        try {
            boolean bl = this.indexDefinition != null && this.indexDefinition.getClassName() != null;
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OType[] getKeyTypes() {
        this.acquireSharedLock();
        try {
            if (this.indexDefinition == null) {
                OType[] oTypeArray = null;
                return oTypeArray;
            }
            OType[] oTypeArray = this.indexDefinition.getTypes();
            return oTypeArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexKeyCursor keyCursor() {
        this.acquireSharedLock();
        try {
            OIndexKeyCursor oIndexKeyCursor = this.storage.getIndexKeyCursor(this.indexId);
            return oIndexKeyCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexDefinition getDefinition() {
        return this.indexDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        this.acquireSharedLock();
        try {
            if (this == o) {
                boolean bl = true;
                return bl;
            }
            if (o == null || this.getClass() != o.getClass()) {
                boolean bl = false;
                return bl;
            }
            OIndexAbstract that = (OIndexAbstract)o;
            if (!this.name.equals(that.name)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public int hashCode() {
        this.acquireSharedLock();
        try {
            int n = this.name.hashCode();
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public int getIndexId() {
        return this.indexId;
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public boolean isRebuilding() {
        return this.rebuilding;
    }

    protected abstract OBinarySerializer determineValueSerializer();

    protected void populateIndex(ODocument doc, Object fieldValue) {
        if (fieldValue instanceof Collection) {
            for (Object fieldValueItem : (Collection)fieldValue) {
                this.put(fieldValueItem, doc);
            }
        } else {
            this.put(fieldValue, doc);
        }
    }

    @Override
    public Object getCollatingValue(Object key) {
        if (key != null && this.getDefinition() != null) {
            return this.getDefinition().getCollate().transform(key);
        }
        return key;
    }

    protected void commitSnapshot(Map<Object, Object> snapshot) {
    }

    protected void putInSnapshot(Object key, OIdentifiable value, Map<Object, Object> snapshot) {
        this.put(key, value);
    }

    protected void removeFromSnapshot(Object key, OIdentifiable value, Map<Object, Object> snapshot) {
        this.remove(key, value);
    }

    protected void removeFromSnapshot(Object key, Map<Object, Object> snapshot) {
        this.remove(key);
    }

    protected void clearSnapshot(IndexTxSnapshot indexTxSnapshot) {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compareTo(OIndex<T> index) {
        this.acquireSharedLock();
        try {
            String name = index.getName();
            int n = this.name.compareTo(name);
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void setType(OType type) {
        this.indexDefinition = new OSimpleKeyIndexDefinition(this.version, type);
        this.updateConfiguration();
    }

    protected ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    protected long[] indexCluster(String clusterName, OProgressListener iProgressListener, long documentNum, long documentIndexed, long documentTotal) {
        try {
            for (ORecord record : this.getDatabase().browseCluster(clusterName)) {
                if (Thread.interrupted()) {
                    throw new OCommandExecutionException("The index rebuild has been interrupted");
                }
                if (record instanceof ODocument) {
                    ODocument doc = (ODocument)record;
                    if (this.indexDefinition == null) {
                        throw new OConfigurationException("Index '" + this.name + "' cannot be rebuilt because has no a valid definition (" + this.indexDefinition + ")");
                    }
                    Object fieldValue = this.indexDefinition.getDocumentValueToIndex(doc);
                    if (fieldValue != null || !this.indexDefinition.isNullValuesIgnored()) {
                        try {
                            this.populateIndex(doc, fieldValue);
                        }
                        catch (OIndexException e) {
                            OLogManager.instance().error((Object)this, "Exception during index rebuild. Exception was caused by following key/ value pair - key %s, value %s. Rebuild will continue from this point", e, fieldValue, doc.getIdentity());
                        }
                        ++documentIndexed;
                    }
                }
                ++documentNum;
                if (iProgressListener == null) continue;
                iProgressListener.onProgress(this, documentNum, (float)((double)documentNum * 100.0 / (double)documentTotal));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return new long[]{documentNum, documentIndexed};
    }

    protected void releaseExclusiveLock() {
        this.rwLock.releaseWriteLock();
    }

    protected void acquireExclusiveLock() {
        this.rwLock.acquireWriteLock();
    }

    protected void releaseSharedLock() {
        this.rwLock.releaseReadLock();
    }

    protected void acquireSharedLock() {
        this.rwLock.acquireReadLock();
    }

    private void removeValuesContainer() {
        if (this.valueContainerAlgorithm.equals("SBTREEBONSAISET")) {
            OAtomicOperation atomicOperation = this.storage.getAtomicOperationsManager().getCurrentOperation();
            OReadCache readCache = this.storage.getReadCache();
            OWriteCache writeCache = this.storage.getWriteCache();
            if (atomicOperation == null) {
                try {
                    String fileName = this.getName() + ".irs";
                    if (writeCache.exists(fileName)) {
                        long fileId = readCache.openFile(fileName, writeCache);
                        readCache.deleteFile(fileId, writeCache);
                    }
                }
                catch (IOException e) {
                    OLogManager.instance().error((Object)this, "Cannot delete file for value containers", e, new Object[0]);
                }
            } else {
                try {
                    String fileName = this.getName() + ".irs";
                    if (atomicOperation.isFileExists(fileName)) {
                        long fileId = atomicOperation.openFile(fileName);
                        atomicOperation.deleteFile(fileId);
                    }
                }
                catch (IOException e) {
                    OLogManager.instance().error((Object)this, "Cannot delete file for value containers", e, new Object[0]);
                }
            }
        }
    }

    protected void onIndexEngineChange(int indexId) {
        this.storage.callIndexEngine(false, false, indexId, new OIndexEngineCallback<Object>(){

            @Override
            public Object callEngine(OIndexEngine engine) {
                engine.init(OIndexAbstract.this.getName(), OIndexAbstract.this.getType(), OIndexAbstract.this.getDefinition(), OIndexAbstract.this.isAutomatic(), OIndexAbstract.this.getMetadata());
                return null;
            }
        });
    }

    protected IndexConfiguration indexConfigurationInstance(ODocument document) {
        return new IndexConfiguration(document);
    }

    protected static class IndexConfiguration {
        protected final ODocument document;

        public IndexConfiguration(ODocument document) {
            this.document = document;
        }

        public ODocument getDocument() {
            return this.document;
        }

        public synchronized ODocument updateConfiguration(String type, String name, int version, OIndexDefinition indexDefinition, Set<String> clustersToIndex, String algorithm, String valueContainerAlgorithm) {
            this.document.field("type", type);
            this.document.field("name", name);
            this.document.field("indexVersion", version);
            if (indexDefinition != null) {
                ODocument indexDefDocument = indexDefinition.toStream();
                if (!indexDefDocument.hasOwners()) {
                    ODocumentInternal.addOwner(indexDefDocument, this.document);
                }
                this.document.field("indexDefinition", indexDefDocument, OType.EMBEDDED);
                this.document.field("indexDefinitionClass", indexDefinition.getClass().getName());
            } else {
                this.document.removeField("indexDefinition");
                this.document.removeField("indexDefinitionClass");
            }
            this.document.field(OIndexAbstract.CONFIG_CLUSTERS, clustersToIndex, OType.EMBEDDEDSET);
            this.document.field("algorithm", algorithm);
            this.document.field("valueContainerAlgorithm", valueContainerAlgorithm);
            return this.document;
        }
    }

    private static class IndexTxSnapshotThreadLocal
    extends ThreadLocal<IndexTxSnapshot> {
        private IndexTxSnapshotThreadLocal() {
        }

        @Override
        protected IndexTxSnapshot initialValue() {
            return new IndexTxSnapshot();
        }
    }

    protected static final class IndexTxSnapshot {
        public Map<Object, Object> indexSnapshot = new HashMap<Object, Object>();
        public boolean clear = false;

        protected IndexTxSnapshot() {
        }
    }
}

