/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OMultiKey;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OIndexManagerAbstract;
import com.orientechnologies.orient.core.index.OIndexMetadata;
import com.orientechnologies.orient.core.index.OIndexRebuildOutputListener;
import com.orientechnologies.orient.core.index.OIndexes;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.OSecurityNull;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
public class OIndexManagerShared
extends OIndexManagerAbstract {
    private static final long serialVersionUID = 1L;
    protected volatile transient Thread recreateIndexesThread = null;
    private volatile boolean rebuildCompleted = false;

    public OIndexManagerShared(ODatabaseDocument iDatabase) {
        super(iDatabase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndex<?> getIndexInternal(String name) {
        this.acquireSharedLock();
        try {
            Locale locale = this.getServerLocale();
            OIndex oIndex = (OIndex)this.indexes.get(name.toLowerCase(locale));
            return oIndex;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndex<?> createIndex(String iName, String iType, OIndexDefinition indexDefinition, int[] clusterIdsToIndex, OProgressListener progressListener, ODocument metadata) {
        return this.createIndex(iName, iType, indexDefinition, clusterIdsToIndex, progressListener, metadata, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndex<?> createIndex(String iName, String type, OIndexDefinition indexDefinition, int[] clusterIdsToIndex, OProgressListener progressListener, ODocument metadata, String algorithm) {
        OIndexInternal<?> index;
        if (OIndexManagerShared.getDatabase().getTransaction().isActive()) {
            throw new IllegalStateException("Cannot create a new index inside a transaction");
        }
        Character c = OSchemaShared.checkFieldNameIfValid(iName);
        if (c != null) {
            throw new IllegalArgumentException("Invalid index name '" + iName + "'. Character '" + c + "' is invalid");
        }
        ODatabaseDocumentInternal database = OIndexManagerShared.getDatabase();
        OStorage storage = database.getStorage();
        Locale locale = this.getServerLocale();
        type = type.toUpperCase(locale);
        if (algorithm == null) {
            algorithm = OIndexes.chooseDefaultIndexAlgorithm(type);
        }
        String valueContainerAlgorithm = this.chooseContainerAlgorithm(type);
        this.acquireExclusiveLock();
        try {
            if (this.indexes.containsKey(iName.toLowerCase(locale))) {
                throw new OIndexException("Index with name " + iName.toLowerCase(locale) + " already exists.");
            }
            if (clusterIdsToIndex == null || clusterIdsToIndex.length == 0) {
                Object durable;
                if (metadata == null) {
                    metadata = new ODocument().setTrackingChanges(false);
                }
                if (!((durable = metadata.field("durableInNonTxMode")) instanceof Boolean)) {
                    metadata.field("durableInNonTxMode", true);
                }
                if (metadata.field("trackMode") == null) {
                    metadata.field("trackMode", "FULL");
                }
            }
            index = OIndexes.createIndex(OIndexManagerShared.getDatabase(), iName, type, algorithm, valueContainerAlgorithm, metadata, -1);
            if (progressListener == null) {
                progressListener = new OIndexRebuildOutputListener(index);
            }
            Set<String> clustersToIndex = this.findClustersByIds(clusterIdsToIndex, database);
            if (indexDefinition != null) {
                Object ignoreNullValues;
                Object v0 = ignoreNullValues = metadata == null ? null : metadata.field("ignoreNullValues");
                if (Boolean.TRUE.equals(ignoreNullValues)) {
                    indexDefinition.setNullValuesIgnored(true);
                } else if (Boolean.FALSE.equals(ignoreNullValues)) {
                    indexDefinition.setNullValuesIgnored(false);
                } else {
                    indexDefinition.setNullValuesIgnored(OGlobalConfiguration.INDEX_IGNORE_NULL_VALUES_DEFAULT.getValueAsBoolean());
                }
            }
            String clusterName = indexDefinition != null && indexDefinition.getClassName() != null ? this.defaultClusterName : this.manualClusterName;
            index.create(iName, indexDefinition, clusterName, clustersToIndex, true, progressListener);
            this.addIndexInternal(index);
            if (metadata != null) {
                ODocument config = index.getConfiguration();
                config.field("metadata", metadata, OType.EMBEDDED);
            }
            this.setDirty();
            this.save();
        }
        finally {
            this.releaseExclusiveLock();
        }
        this.notifyInvolvedClasses(clusterIdsToIndex);
        if (OGlobalConfiguration.INDEX_FLUSH_AFTER_CREATE.getValueAsBoolean()) {
            storage.synch();
        }
        return OIndexManagerShared.preProcessBeforeReturn(index);
    }

    protected void notifyInvolvedClasses(int[] clusterIdsToIndex) {
        if (clusterIdsToIndex == null || clusterIdsToIndex.length == 0) {
            return;
        }
        ODatabaseDocumentInternal database = OIndexManagerShared.getDatabase();
        HashSet<String> classes = new HashSet<String>();
        for (int clusterId : clusterIdsToIndex) {
            OClass cls = database.getMetadata().getSchema().getClassByClusterId(clusterId);
            if (cls == null || !(cls instanceof OClassImpl) || classes.contains(cls.getName())) continue;
            ((OClassImpl)cls).onPostIndexManagement();
            classes.add(cls.getName());
        }
    }

    private Set<String> findClustersByIds(int[] clusterIdsToIndex, ODatabase database) {
        HashSet<String> clustersToIndex = new HashSet<String>();
        if (clusterIdsToIndex != null) {
            for (int clusterId : clusterIdsToIndex) {
                String clusterNameToIndex = database.getClusterNameById(clusterId);
                if (clusterNameToIndex == null) {
                    throw new OIndexException("Cluster with id " + clusterId + " does not exist.");
                }
                clustersToIndex.add(clusterNameToIndex);
            }
        }
        return clustersToIndex;
    }

    private String chooseContainerAlgorithm(String type) {
        String valueContainerAlgorithm = OClass.INDEX_TYPE.NOTUNIQUE.toString().equals(type) || OClass.INDEX_TYPE.NOTUNIQUE_HASH_INDEX.toString().equals(type) || OClass.INDEX_TYPE.FULLTEXT_HASH_INDEX.toString().equals(type) || OClass.INDEX_TYPE.FULLTEXT.toString().equals(type) ? "SBTREEBONSAISET" : "NONE";
        return valueContainerAlgorithm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexManager dropIndex(String iIndexName) {
        if (OIndexManagerShared.getDatabase().getTransaction().isActive()) {
            throw new IllegalStateException("Cannot drop an index inside a transaction");
        }
        int[] clusterIdsToIndex = null;
        this.acquireExclusiveLock();
        try {
            Locale locale = this.getServerLocale();
            OIndex idx = (OIndex)this.indexes.remove(iIndexName.toLowerCase(locale));
            if (idx != null) {
                Set<String> clusters = idx.getClusters();
                if (clusters != null && !clusters.isEmpty()) {
                    ODatabaseDocumentInternal db = OIndexManagerShared.getDatabase();
                    clusterIdsToIndex = new int[clusters.size()];
                    int i = 0;
                    for (String cl : clusters) {
                        clusterIdsToIndex[i++] = db.getClusterIdByName(cl);
                    }
                }
                this.removeClassPropertyIndex(idx);
                idx.delete();
                this.setDirty();
                this.save();
                this.notifyInvolvedClasses(clusterIdsToIndex);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODocument toStream() {
        this.acquireExclusiveLock();
        try {
            this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
            try {
                OTrackedSet<ODocument> idxs = new OTrackedSet<ODocument>(this.document);
                for (OIndex i : this.indexes.values()) {
                    idxs.add(((OIndexInternal)i).updateConfiguration());
                }
                this.document.field("indexes", idxs, OType.EMBEDDEDSET);
            }
            finally {
                this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
            }
            this.document.setDirty();
            ODocument oDocument = this.document;
            return oDocument;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recreateIndexes() {
        this.acquireExclusiveLock();
        try {
            if (this.recreateIndexesThread != null && this.recreateIndexesThread.isAlive()) {
                return;
            }
            ODatabaseDocumentInternal db = OIndexManagerShared.getDatabase();
            this.document = (ODocument)db.load(new ORecordId(OIndexManagerShared.getDatabase().getStorage().getConfiguration().indexMgrRecordId));
            ODocument doc = new ODocument();
            this.document.copyTo(doc);
            ODatabaseDocumentTx newDb = new ODatabaseDocumentTx(db.getURL());
            RecreateIndexesTask recreateIndexesTask = new RecreateIndexesTask(newDb, doc);
            this.recreateIndexesThread = new Thread((Runnable)recreateIndexesTask, "OrientDB rebuild indexes");
            this.recreateIndexesThread.start();
        }
        finally {
            this.releaseExclusiveLock();
        }
        if (OGlobalConfiguration.INDEX_SYNCHRONOUS_AUTO_REBUILD.getValueAsBoolean()) {
            this.waitTillIndexRestore();
            OIndexManagerShared.getDatabase().getMetadata().reload();
        }
    }

    @Override
    public void waitTillIndexRestore() {
        if (this.recreateIndexesThread != null && this.recreateIndexesThread.isAlive()) {
            if (Thread.currentThread().equals(this.recreateIndexesThread)) {
                return;
            }
            OLogManager.instance().info((Object)this, "Wait till indexes restore after crash was finished.", new Object[0]);
            while (this.recreateIndexesThread.isAlive()) {
                try {
                    this.recreateIndexesThread.join();
                    OLogManager.instance().info((Object)this, "Indexes restore after crash was finished.", new Object[0]);
                }
                catch (InterruptedException e) {
                    OLogManager.instance().info((Object)this, "Index rebuild task was interrupted.", new Object[0]);
                }
            }
        }
    }

    @Override
    public boolean autoRecreateIndexesAfterCrash() {
        if (this.rebuildCompleted) {
            return false;
        }
        ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.INSTANCE.get();
        OStorage storage = database.getStorage().getUnderlying();
        if (storage instanceof OAbstractPaginatedStorage) {
            OAbstractPaginatedStorage paginatedStorage = (OAbstractPaginatedStorage)storage;
            return paginatedStorage.wereDataRestoredAfterOpen() && paginatedStorage.wereNonTxOperationsPerformedInPreviousOpen();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fromStream() {
        this.acquireExclusiveLock();
        try {
            HashMap oldIndexes = new HashMap(this.indexes);
            this.clearMetadata();
            Collection idxs = (Collection)this.document.field("indexes");
            Locale locale = this.getServerLocale();
            if (idxs != null) {
                boolean configUpdated = false;
                Iterator indexConfigurationIterator = idxs.iterator();
                while (indexConfigurationIterator.hasNext()) {
                    ODocument d = (ODocument)indexConfigurationIterator.next();
                    try {
                        int indexVersion = d.field("indexVersion") == null ? 1 : (Integer)d.field("indexVersion");
                        OIndexMetadata newIndexMetadata = OIndexAbstract.loadMetadataInternal(d, (String)d.field("type"), (String)d.field("algorithm"), (String)d.field("valueContainerAlgorithm"));
                        OIndexInternal<?> index = OIndexes.createIndex(OIndexManagerShared.getDatabase(), newIndexMetadata.getName(), newIndexMetadata.getType(), newIndexMetadata.getAlgorithm(), newIndexMetadata.getValueContainerAlgorithm(), (ODocument)d.field("metadata"), indexVersion);
                        String normalizedName = newIndexMetadata.getName().toLowerCase(locale);
                        OIndex oldIndex = (OIndex)oldIndexes.remove(normalizedName);
                        if (oldIndex != null) {
                            OIndexMetadata oldIndexMetadata = oldIndex.getInternal().loadMetadata(oldIndex.getConfiguration());
                            if (!oldIndexMetadata.equals(newIndexMetadata) && newIndexMetadata.getIndexDefinition() != null) {
                                oldIndex.delete();
                            }
                            if (index.loadFromConfiguration(d)) {
                                this.addIndexInternal(index);
                                continue;
                            }
                            indexConfigurationIterator.remove();
                            configUpdated = true;
                            continue;
                        }
                        if (index.loadFromConfiguration(d)) {
                            this.addIndexInternal(index);
                            continue;
                        }
                        indexConfigurationIterator.remove();
                        configUpdated = true;
                    }
                    catch (RuntimeException e) {
                        indexConfigurationIterator.remove();
                        configUpdated = true;
                        OLogManager.instance().error((Object)this, "Error on loading index by configuration: %s", e, d);
                    }
                }
                for (OIndex oldIndex : oldIndexes.values()) {
                    try {
                        OLogManager.instance().warn((Object)this, "Index '%s' was not found after reload and will be removed", oldIndex.getName());
                        oldIndex.delete();
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "Error on deletion of index '%s'", e, oldIndex.getName());
                    }
                }
                if (configUpdated) {
                    this.document.field("indexes", idxs);
                    this.save();
                }
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeClassPropertyIndex(OIndex<?> idx) {
        this.acquireExclusiveLock();
        try {
            OIndexDefinition indexDefinition = idx.getDefinition();
            if (indexDefinition == null || indexDefinition.getClassName() == null) {
                return;
            }
            Locale locale = this.getServerLocale();
            HashMap map = (HashMap)this.classPropertyIndex.get(indexDefinition.getClassName().toLowerCase(locale));
            if (map == null) {
                return;
            }
            map = new HashMap(map);
            int paramCount = indexDefinition.getParamCount();
            for (int i = 1; i <= paramCount; ++i) {
                List<String> fields = this.normalizeFieldNames(indexDefinition.getFields().subList(0, i));
                OMultiKey multiKey = new OMultiKey(fields);
                HashSet indexSet = (HashSet)map.get(multiKey);
                if (indexSet == null) continue;
                indexSet = new HashSet(indexSet);
                indexSet.remove(idx);
                if (indexSet.isEmpty()) {
                    map.remove(multiKey);
                    continue;
                }
                map.put(multiKey, indexSet);
            }
            if (map.isEmpty()) {
                this.classPropertyIndex.remove(indexDefinition.getClassName().toLowerCase(locale));
            } else {
                this.classPropertyIndex.put(indexDefinition.getClassName().toLowerCase(locale), OIndexManagerShared.copyPropertyMap(map));
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    private class RecreateIndexesTask
    implements Runnable {
        private final ODatabaseDocumentTx newDb;
        private final ODocument doc;
        private int ok;
        private int errors;

        public RecreateIndexesTask(ODatabaseDocumentTx newDb, ODocument doc) {
            this.newDb = newDb;
            this.doc = doc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                OAbstractPaginatedStorage abstractPaginatedStorage;
                this.setUpDatabase();
                Collection<ODocument> idxs = this.getConfiguration();
                OStorage storage = this.newDb.getStorage().getUnderlying();
                if (storage instanceof OAbstractPaginatedStorage) {
                    abstractPaginatedStorage = (OAbstractPaginatedStorage)storage;
                    abstractPaginatedStorage.getAtomicOperationsManager().switchOnUnsafeMode();
                }
                try {
                    this.recreateIndexes(idxs);
                }
                finally {
                    if (storage instanceof OAbstractPaginatedStorage) {
                        abstractPaginatedStorage = (OAbstractPaginatedStorage)storage;
                        abstractPaginatedStorage.getAtomicOperationsManager().switchOffUnsafeMode();
                        abstractPaginatedStorage.synch();
                    }
                }
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Error when attempt to restore indexes after crash was performed", e, new Object[0]);
            }
        }

        private void recreateIndexes(Collection<ODocument> idxs) {
            this.ok = 0;
            this.errors = 0;
            for (ODocument idx : idxs) {
                try {
                    this.recreateIndex(idx);
                }
                catch (RuntimeException e) {
                    OLogManager.instance().error((Object)this, "Error during addition of index '%s'", e, idx);
                    ++this.errors;
                }
            }
            OIndexManagerShared.this.save();
            OIndexManagerShared.this.rebuildCompleted = true;
            OLogManager.instance().info((Object)this, "%d indexes were restored successfully, %d errors", this.ok, this.errors);
        }

        private void recreateIndex(ODocument idx) {
            OIndexInternal<?> index = this.createIndex(idx);
            OIndexMetadata indexMetadata = index.loadMetadata(idx);
            OIndexDefinition indexDefinition = indexMetadata.getIndexDefinition();
            if (indexDefinition != null && indexDefinition.isAutomatic()) {
                try {
                    index.loadFromConfiguration(idx);
                    index.delete();
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Error on removing index '%s' on rebuilding. Trying removing index files (Cause: %s)", index.getName(), e);
                    Iterator<OIndexFactory> it = OIndexes.getAllFactories();
                    while (it.hasNext()) {
                        try {
                            OIndexFactory indexFactory = it.next();
                            OIndexEngine engine = indexFactory.createIndexEngine(null, index.getName(), false, OIndexManagerAbstract.getDatabase().getStorage(), 0, null);
                            engine.deleteWithoutLoad(index.getName());
                        }
                        catch (Exception exception) {}
                    }
                }
                this.createAutomaticIndex(idx, index, indexMetadata, indexDefinition);
            } else {
                this.addIndexAsIs(idx, index, indexMetadata);
            }
        }

        private void createAutomaticIndex(ODocument idx, OIndexInternal<?> index, OIndexMetadata indexMetadata, OIndexDefinition indexDefinition) {
            String indexName = indexMetadata.getName();
            Set<String> clusters = indexMetadata.getClustersToIndex();
            String type = indexMetadata.getType();
            if (indexName != null && clusters != null && !clusters.isEmpty() && type != null) {
                OLogManager.instance().info((Object)this, "Start creation of index '%s'", indexName);
                index.create(indexName, indexDefinition, OIndexManagerShared.this.defaultClusterName, clusters, false, new OIndexRebuildOutputListener(index));
                index.setRebuildingFlag();
                OIndexManagerShared.this.addIndexInternal(index);
                OLogManager.instance().info((Object)this, "Index '%s' was successfully created and rebuild is going to be started", indexName);
                index.rebuild(new OIndexRebuildOutputListener(index));
                index.flush();
                OIndexManagerShared.this.setDirty();
                ++this.ok;
                OLogManager.instance().info((Object)this, "Rebuild of '%s index was successfully finished", indexName);
            } else {
                ++this.errors;
                OLogManager.instance().error((Object)this, "Information about index was restored incorrectly, following data were loaded : index name '%s', index definition '%s', clusters %s, type %s", indexName, indexDefinition, clusters, type);
            }
        }

        private void addIndexAsIs(ODocument idx, OIndexInternal<?> index, OIndexMetadata indexMetadata) {
            OLogManager.instance().info((Object)this, "Index '%s' is not automatic index and will be added as is", indexMetadata.getName());
            if (index.loadFromConfiguration(idx)) {
                OIndexManagerShared.this.addIndexInternal(index);
                OIndexManagerShared.this.setDirty();
                ++this.ok;
                OLogManager.instance().info((Object)this, "Index '%s' was added in DB index list", index.getName());
            } else {
                index.delete();
                ++this.errors;
            }
        }

        private OIndexInternal<?> createIndex(ODocument idx) {
            String indexName = (String)idx.field("name");
            String indexType = (String)idx.field("type");
            String algorithm = (String)idx.field("algorithm");
            String valueContainerAlgorithm = (String)idx.field("valueContainerAlgorithm");
            ODocument metadata = (ODocument)idx.field("metadata");
            if (indexType == null) {
                OLogManager.instance().error((Object)this, "Index type is null, will process other record", new Object[0]);
                throw new OIndexException("Index type is null, will process other record. Index configuration: " + idx.toString());
            }
            return OIndexes.createIndex(this.newDb, indexName, indexType, algorithm, valueContainerAlgorithm, metadata, -1);
        }

        private Collection<ODocument> getConfiguration() {
            Collection idxs = (Collection)this.doc.field("indexes");
            if (idxs == null) {
                OLogManager.instance().warn((Object)this, "List of indexes is empty", new Object[0]);
                return Collections.emptyList();
            }
            return idxs;
        }

        private void setUpDatabase() {
            this.newDb.activateOnCurrentThread();
            this.newDb.resetInitialization();
            this.newDb.setProperty(ODatabase.OPTIONS.SECURITY.toString(), OSecurityNull.class);
            this.newDb.open("admin", "nopass");
            ODatabaseRecordThreadLocal.INSTANCE.set(this.newDb);
        }
    }
}

