/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexKeyCursor;
import com.orientechnologies.orient.core.index.OIndexMetadata;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
public class OIndexRecorder
implements OIndex<OIdentifiable>,
OIndexInternal<OIdentifiable> {
    private final OIndexInternal<OIdentifiable> delegate;
    private final Set<Object> removedKeys = new HashSet<Object>();
    private final Map<Object, OIdentifiable> updatedKeys = new HashMap<Object, OIdentifiable>();

    public OIndexRecorder(OIndexInternal<OIdentifiable> delegate) {
        this.delegate = delegate;
    }

    public List<Object> getAffectedKeys() {
        ArrayList<Object> result = new ArrayList<Object>(this.removedKeys.size() + this.updatedKeys.size());
        for (Object key : this.removedKeys) {
            result.add(this.copyKeyIfNeeded(key));
        }
        for (Object key : this.updatedKeys.keySet()) {
            result.add(this.copyKeyIfNeeded(key));
        }
        return result;
    }

    private Object copyKeyIfNeeded(Object object) {
        if (object instanceof ORecordId) {
            return new ORecordId((ORecordId)object);
        }
        if (object instanceof OCompositeKey) {
            OCompositeKey copy = new OCompositeKey();
            for (Object key : ((OCompositeKey)object).getKeys()) {
                copy.addKey(this.copyKeyIfNeeded(key));
            }
            return copy;
        }
        return object;
    }

    @Override
    public OIndex<OIdentifiable> create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener) {
        throw new UnsupportedOperationException("Not allowed operation.");
    }

    @Override
    public String getDatabaseName() {
        return this.delegate.getDatabaseName();
    }

    @Override
    public OType[] getKeyTypes() {
        return this.delegate.getKeyTypes();
    }

    @Override
    public OIdentifiable get(Object iKey) {
        if (this.removedKeys.contains(iKey = this.delegate.getCollatingValue(iKey))) {
            return null;
        }
        OIdentifiable updated = this.updatedKeys.get(iKey);
        if (updated != null) {
            return updated;
        }
        return (OIdentifiable)this.delegate.get(iKey);
    }

    @Override
    public boolean contains(Object iKey) {
        return this.get(iKey) != null;
    }

    @Override
    public OIndex<OIdentifiable> put(Object iKey, OIdentifiable iValue) {
        iKey = this.delegate.getCollatingValue(iKey);
        this.removedKeys.remove(iKey);
        this.updatedKeys.put(iKey, iValue);
        return this;
    }

    @Override
    public boolean remove(Object key) {
        key = this.delegate.getCollatingValue(key);
        this.removedKeys.add(key);
        this.updatedKeys.remove(key);
        return false;
    }

    @Override
    public boolean remove(Object iKey, OIdentifiable iRID) {
        iKey = this.delegate.getCollatingValue(iKey);
        this.removedKeys.add(iKey);
        this.updatedKeys.remove(iKey);
        return false;
    }

    @Override
    public OIndex<OIdentifiable> clear() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public long getSize() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public long count(Object iKey) {
        return this.get(iKey) != null ? 1L : 0L;
    }

    @Override
    public long getKeySize() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public ODocument checkEntry(OIdentifiable iRecord, Object iKey) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public long getRebuildVersion() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public void flush() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public OIndex<OIdentifiable> delete() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public String getType() {
        return this.delegate.getType();
    }

    @Override
    public boolean isAutomatic() {
        return this.delegate.isAutomatic();
    }

    @Override
    public long rebuild() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public long rebuild(OProgressListener iProgressListener) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public ODocument getConfiguration() {
        return this.delegate.getConfiguration();
    }

    @Override
    public OIndexInternal<OIdentifiable> getInternal() {
        return this;
    }

    @Override
    public OIndexCursor iterateEntries(Collection<?> keys, boolean ascSortOrder) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public OIndexDefinition getDefinition() {
        return this.delegate.getDefinition();
    }

    @Override
    public Set<String> getClusters() {
        return this.delegate.getClusters();
    }

    @Override
    public OIndexCursor iterateEntriesBetween(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, boolean ascOrder) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean fromInclusive, boolean ascOrder) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public OIndexCursor iterateEntriesMinor(Object toKey, boolean toInclusive, boolean ascOrder) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public OIndexCursor cursor() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public OIndexCursor descCursor() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public OIndexKeyCursor keyCursor() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public ODocument getMetadata() {
        return this.delegate.getMetadata();
    }

    @Override
    public boolean supportsOrderedIterations() {
        return this.delegate.supportsOrderedIterations();
    }

    @Override
    public boolean isRebuilding() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public Object getFirstKey() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public Object getLastKey() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public int getIndexId() {
        return this.delegate.getIndexId();
    }

    @Override
    public boolean isUnique() {
        return this.delegate.isUnique();
    }

    @Override
    public int compareTo(OIndex<OIdentifiable> o) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public Object getCollatingValue(Object key) {
        return this.delegate.getCollatingValue(key);
    }

    @Override
    public boolean loadFromConfiguration(ODocument iConfig) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public ODocument updateConfiguration() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public OIndex<OIdentifiable> addCluster(String iClusterName) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public OIndex<OIdentifiable> removeCluster(String iClusterName) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public boolean canBeUsedInEqualityOperators() {
        return this.delegate.canBeUsedInEqualityOperators();
    }

    @Override
    public boolean hasRangeQuerySupport() {
        return this.delegate.hasRangeQuerySupport();
    }

    @Override
    public void lockKeysForUpdateNoTx(Object ... key) {
    }

    @Override
    public void lockKeysForUpdateNoTx(Collection<Object> keys) {
    }

    @Override
    public void releaseKeysForUpdateNoTx(Object ... key) {
    }

    @Override
    public void releaseKeysForUpdateNoTx(Collection<Object> keys) {
    }

    @Override
    public void setType(OType type) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public OIndexMetadata loadMetadata(ODocument iConfig) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public void setRebuildingFlag() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public String getAlgorithm() {
        return this.delegate.getAlgorithm();
    }

    @Override
    public void preCommit() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public void addTxOperation(OTransactionIndexChanges changes) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public void commit() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public void postCommit() {
        throw new UnsupportedOperationException("Not allowed operation");
    }
}

