/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndexOneValue;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;

public class OIndexUnique
extends OIndexOneValue {
    public OIndexUnique(String name, String typeId, String algorithm, int version, OAbstractPaginatedStorage storage, String valueContainerAlgorithm, ODocument metadata) {
        super(name, typeId, algorithm, version, storage, valueContainerAlgorithm, metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexOneValue put(Object key, OIdentifiable iSingleValue) {
        key = this.getCollatingValue(key);
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.acquireExclusiveLock(key);
        }
        try {
            block13: {
                OIndexUnique oIndexUnique;
                this.acquireSharedLock();
                try {
                    OIdentifiable value = (OIdentifiable)this.storage.getIndexValue(this.indexId, key);
                    if (value == null) break block13;
                    if (!value.equals(iSingleValue)) {
                        Boolean mergeSameKey;
                        Boolean bl = mergeSameKey = this.metadata != null ? (Boolean)this.metadata.field("mergeKeys") : Boolean.FALSE;
                        if (mergeSameKey == null || !mergeSameKey.booleanValue()) {
                            throw new ORecordDuplicatedException(String.format("Cannot index record %s: found duplicated key '%s' in index '%s' previously assigned to the record %s", iSingleValue.getIdentity(), key, this.getName(), value.getIdentity()), this.getName(), value.getIdentity());
                        }
                        break block13;
                    }
                    oIndexUnique = this;
                }
                catch (Throwable throwable) {
                    this.releaseSharedLock();
                    throw throwable;
                }
                this.releaseSharedLock();
                return oIndexUnique;
            }
            if (!iSingleValue.getIdentity().isPersistent()) {
                iSingleValue.getRecord().save();
            }
            this.storage.putIndexValue(this.indexId, key, iSingleValue.getIdentity());
            OIndexUnique oIndexUnique = this;
            this.releaseSharedLock();
            return oIndexUnique;
        }
        finally {
            if (!txIsActive) {
                this.keyLockManager.releaseExclusiveLock(key);
            }
        }
    }

    @Override
    public boolean canBeUsedInEqualityOperators() {
        return true;
    }

    @Override
    public boolean supportsOrderedIterations() {
        return this.storage.hasIndexRangeQuerySupport(this.indexId);
    }
}

