/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.annotation.OBeforeDeserialization;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.security.OIdentity;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ORole
extends OIdentity
implements OSecurityRole {
    public static final String ADMIN = "admin";
    public static final String CLASS_NAME = "ORole";
    public static final int PERMISSION_NONE = 0;
    public static final int PERMISSION_CREATE = ORole.registerPermissionBit(0, "Create");
    public static final int PERMISSION_READ = ORole.registerPermissionBit(1, "Read");
    public static final int PERMISSION_UPDATE = ORole.registerPermissionBit(2, "Update");
    public static final int PERMISSION_DELETE = ORole.registerPermissionBit(3, "Delete");
    public static final int PERMISSION_EXECUTE = ORole.registerPermissionBit(4, "Execute");
    public static final int PERMISSION_ALL = PERMISSION_CREATE + PERMISSION_READ + PERMISSION_UPDATE + PERMISSION_DELETE;
    protected static final byte STREAM_DENY = 0;
    protected static final byte STREAM_ALLOW = 1;
    private static final long serialVersionUID = 1L;
    private static Map<Integer, String> PERMISSION_BIT_NAMES;
    protected OSecurityRole.ALLOW_MODES mode = OSecurityRole.ALLOW_MODES.DENY_ALL_BUT;
    protected ORole parentRole;
    private Map<ORule.ResourceGeneric, ORule> rules = new HashMap<ORule.ResourceGeneric, ORule>();

    public ORole() {
    }

    public ORole(String iName, ORole iParent, OSecurityRole.ALLOW_MODES iAllowMode) {
        super(CLASS_NAME);
        this.document.field("name", iName);
        this.parentRole = iParent;
        this.document.field("inheritedRole", iParent != null ? iParent.getDocument() : null);
        this.setMode(iAllowMode);
        this.updateRolesDocumentContent();
    }

    public ORole(ODocument iSource) {
        this.fromStream(iSource);
    }

    public static String permissionToString(int iPermission) {
        int permission = iPermission;
        StringBuilder returnValue = new StringBuilder(128);
        for (Map.Entry<Integer, String> p : PERMISSION_BIT_NAMES.entrySet()) {
            if ((permission & p.getKey()) != p.getKey()) continue;
            if (returnValue.length() > 0) {
                returnValue.append(", ");
            }
            returnValue.append(p.getValue());
            permission &= ~p.getKey().intValue();
        }
        if (permission != 0) {
            if (returnValue.length() > 0) {
                returnValue.append(", ");
            }
            returnValue.append("Unknown 0x");
            returnValue.append(Integer.toHexString(permission));
        }
        return returnValue.toString();
    }

    public static int registerPermissionBit(int iBitNo, String iName) {
        if (iBitNo < 0 || iBitNo > 31) {
            throw new IndexOutOfBoundsException("Permission bit number must be positive and less than 32");
        }
        int value = 1 << iBitNo;
        if (PERMISSION_BIT_NAMES == null) {
            PERMISSION_BIT_NAMES = new HashMap<Integer, String>();
        }
        if (PERMISSION_BIT_NAMES.containsKey(value)) {
            throw new IndexOutOfBoundsException("Permission bit number " + String.valueOf(iBitNo) + " already in use");
        }
        PERMISSION_BIT_NAMES.put(value, iName);
        return value;
    }

    @Override
    @OBeforeDeserialization
    public void fromStream(ODocument iSource) {
        if (this.document != null) {
            return;
        }
        this.document = iSource;
        try {
            Number modeField = (Number)this.document.field("mode");
            this.mode = modeField == null ? OSecurityRole.ALLOW_MODES.DENY_ALL_BUT : (modeField.byteValue() == 1 ? OSecurityRole.ALLOW_MODES.ALLOW_ALL_BUT : OSecurityRole.ALLOW_MODES.DENY_ALL_BUT);
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "illegal mode " + ex.getMessage(), new Object[0]);
            this.mode = OSecurityRole.ALLOW_MODES.DENY_ALL_BUT;
        }
        OIdentifiable role = (OIdentifiable)this.document.field("inheritedRole");
        this.parentRole = role != null ? this.document.getDatabase().getMetadata().getSecurity().getRole(role) : null;
        boolean rolesNeedToBeUpdated = false;
        Object loadedRules = this.document.field("rules");
        if (loadedRules instanceof Map) {
            this.loadOldVersionOfRules((Map)loadedRules);
        } else {
            Set storedRules = (Set)loadedRules;
            if (storedRules != null) {
                for (ODocument ruleDoc : storedRules) {
                    ORule.ResourceGeneric resourceGeneric = ORule.ResourceGeneric.valueOf((String)ruleDoc.field("resourceGeneric"));
                    if (resourceGeneric == null) continue;
                    Map specificResources = (Map)ruleDoc.field("specificResources");
                    Byte access = (Byte)ruleDoc.field("access");
                    ORule rule = new ORule(resourceGeneric, specificResources, access);
                    this.rules.put(resourceGeneric, rule);
                }
            }
            rolesNeedToBeUpdated = true;
        }
        if (this.getName().equals(ADMIN) && !this.hasRule(ORule.ResourceGeneric.BYPASS_RESTRICTED, null)) {
            this.addRule(ORule.ResourceGeneric.BYPASS_RESTRICTED, null, PERMISSION_ALL).save();
        }
        if (rolesNeedToBeUpdated) {
            this.updateRolesDocumentContent();
            this.save();
        }
    }

    @Override
    public boolean allow(ORule.ResourceGeneric resourceGeneric, String resourceSpecific, int iCRUDOperation) {
        Boolean allowed;
        ORule rule = this.rules.get(resourceGeneric);
        if (rule != null && (allowed = rule.isAllowed(resourceSpecific, iCRUDOperation)) != null) {
            return allowed;
        }
        if (this.parentRole != null) {
            return this.parentRole.allow(resourceGeneric, resourceSpecific, iCRUDOperation);
        }
        return this.mode == OSecurityRole.ALLOW_MODES.ALLOW_ALL_BUT;
    }

    @Override
    public boolean hasRule(ORule.ResourceGeneric resourceGeneric, String resourceSpecific) {
        ORule rule = this.rules.get(resourceGeneric);
        if (rule == null) {
            return false;
        }
        return resourceSpecific == null || rule.containsSpecificResource(resourceSpecific);
    }

    @Override
    public ORole addRule(ORule.ResourceGeneric resourceGeneric, String resourceSpecific, int iOperation) {
        ORule rule = this.rules.get(resourceGeneric);
        if (rule == null) {
            rule = new ORule(resourceGeneric, null, null);
            this.rules.put(resourceGeneric, rule);
        }
        rule.grantAccess(resourceSpecific, iOperation);
        this.rules.put(resourceGeneric, rule);
        this.updateRolesDocumentContent();
        return this;
    }

    @Override
    @Deprecated
    public boolean allow(String iResource, int iCRUDOperation) {
        String specificResource = ORule.mapLegacyResourceToSpecificResource(iResource);
        ORule.ResourceGeneric resourceGeneric = ORule.mapLegacyResourceToGenericResource(iResource);
        if (specificResource == null || specificResource.equals("*")) {
            return this.allow(resourceGeneric, null, iCRUDOperation);
        }
        return this.allow(resourceGeneric, specificResource, iCRUDOperation);
    }

    @Override
    @Deprecated
    public boolean hasRule(String iResource) {
        String specificResource = ORule.mapLegacyResourceToSpecificResource(iResource);
        ORule.ResourceGeneric resourceGeneric = ORule.mapLegacyResourceToGenericResource(iResource);
        if (specificResource == null || specificResource.equals("*")) {
            return this.hasRule(resourceGeneric, null);
        }
        return this.hasRule(resourceGeneric, specificResource);
    }

    @Override
    @Deprecated
    public OSecurityRole addRule(String iResource, int iOperation) {
        String specificResource = ORule.mapLegacyResourceToSpecificResource(iResource);
        ORule.ResourceGeneric resourceGeneric = ORule.mapLegacyResourceToGenericResource(iResource);
        if (specificResource == null || specificResource.equals("*")) {
            return this.addRule(resourceGeneric, null, iOperation);
        }
        return this.addRule(resourceGeneric, specificResource, iOperation);
    }

    @Override
    @Deprecated
    public OSecurityRole grant(String iResource, int iOperation) {
        String specificResource = ORule.mapLegacyResourceToSpecificResource(iResource);
        ORule.ResourceGeneric resourceGeneric = ORule.mapLegacyResourceToGenericResource(iResource);
        if (specificResource == null || specificResource.equals("*")) {
            return this.grant(resourceGeneric, null, iOperation);
        }
        return this.grant(resourceGeneric, specificResource, iOperation);
    }

    @Override
    @Deprecated
    public OSecurityRole revoke(String iResource, int iOperation) {
        String specificResource = ORule.mapLegacyResourceToSpecificResource(iResource);
        ORule.ResourceGeneric resourceGeneric = ORule.mapLegacyResourceToGenericResource(iResource);
        if (specificResource == null || specificResource.equals("*")) {
            return this.revoke(resourceGeneric, null, iOperation);
        }
        return this.revoke(resourceGeneric, specificResource, iOperation);
    }

    @Override
    public ORole grant(ORule.ResourceGeneric resourceGeneric, String resourceSpecific, int iOperation) {
        ORule rule = this.rules.get(resourceGeneric);
        if (rule == null) {
            rule = new ORule(resourceGeneric, null, null);
            this.rules.put(resourceGeneric, rule);
        }
        rule.grantAccess(resourceSpecific, iOperation);
        this.rules.put(resourceGeneric, rule);
        this.updateRolesDocumentContent();
        return this;
    }

    @Override
    public ORole revoke(ORule.ResourceGeneric resourceGeneric, String resourceSpecific, int iOperation) {
        if (iOperation == 0) {
            return this;
        }
        ORule rule = this.rules.get(resourceGeneric);
        if (rule == null) {
            rule = new ORule(resourceGeneric, null, null);
            this.rules.put(resourceGeneric, rule);
        }
        rule.revokeAccess(resourceSpecific, iOperation);
        this.rules.put(resourceGeneric, rule);
        this.updateRolesDocumentContent();
        return this;
    }

    @Override
    public String getName() {
        return (String)this.document.field("name");
    }

    @Override
    public OSecurityRole.ALLOW_MODES getMode() {
        return this.mode;
    }

    @Override
    public ORole setMode(OSecurityRole.ALLOW_MODES iMode) {
        this.mode = iMode;
        this.document.field("mode", this.mode == OSecurityRole.ALLOW_MODES.ALLOW_ALL_BUT ? (byte)1 : 0);
        return this;
    }

    @Override
    public ORole getParentRole() {
        return this.parentRole;
    }

    @Override
    public ORole setParentRole(OSecurityRole iParent) {
        this.parentRole = (ORole)iParent;
        this.document.field("inheritedRole", this.parentRole != null ? this.parentRole.getDocument() : null);
        return this;
    }

    public ORole save() {
        this.document.save(ORole.class.getSimpleName());
        return this;
    }

    @Override
    public Set<ORule> getRuleSet() {
        return new HashSet<ORule>(this.rules.values());
    }

    @Deprecated
    public Map<String, Byte> getRules() {
        HashMap<String, Byte> result = new HashMap<String, Byte>();
        for (ORule rule : this.rules.values()) {
            String name = ORule.mapResourceGenericToLegacyResource(rule.getResourceGeneric());
            if (rule.getAccess() != null) {
                result.put(name, rule.getAccess());
            }
            for (Map.Entry<String, Byte> specificResource : rule.getSpecificResources().entrySet()) {
                result.put(name + "." + specificResource.getKey(), specificResource.getValue());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public OIdentifiable getIdentity() {
        return this.document;
    }

    private void loadOldVersionOfRules(Map<String, Number> storedRules) {
        if (storedRules != null) {
            for (Map.Entry<String, Number> a : storedRules.entrySet()) {
                String specificResource;
                ORule.ResourceGeneric resourceGeneric = ORule.mapLegacyResourceToGenericResource(a.getKey());
                ORule rule = this.rules.get(resourceGeneric);
                if (rule == null) {
                    rule = new ORule(resourceGeneric, null, null);
                    this.rules.put(resourceGeneric, rule);
                }
                if ((specificResource = ORule.mapLegacyResourceToSpecificResource(a.getKey())) == null || specificResource.equals("*")) {
                    rule.grantAccess(null, a.getValue().intValue());
                    continue;
                }
                rule.grantAccess(specificResource, a.getValue().intValue());
            }
        }
    }

    private ODocument updateRolesDocumentContent() {
        return this.document.field("rules", this.getRules());
    }
}

