/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.sequence;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OSequenceException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import java.util.Random;
import java.util.concurrent.Callable;

public abstract class OSequence
extends ODocumentWrapper {
    public static final long DEFAULT_START = 0L;
    public static final int DEFAULT_INCREMENT = 1;
    public static final int DEFAULT_CACHE = 20;
    protected static final int DEF_MAX_RETRY = OGlobalConfiguration.SEQUENCE_MAX_RETRY.getValueAsInteger();
    public static final String CLASS_NAME = "OSequence";
    private static final String FIELD_START = "start";
    private static final String FIELD_INCREMENT = "incr";
    private static final String FIELD_VALUE = "value";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_TYPE = "type";
    private int maxRetry = DEF_MAX_RETRY;

    protected OSequence() {
        this(null, null);
    }

    protected OSequence(ODocument iDocument) {
        this(iDocument, null);
    }

    protected OSequence(ODocument iDocument, CreateParams params) {
        super(iDocument != null ? iDocument : new ODocument(CLASS_NAME));
        if (iDocument == null) {
            if (params == null) {
                params = new CreateParams().setDefaults();
            }
            this.initSequence(params);
        }
    }

    protected void initSequence(CreateParams params) {
        this.setStart(params.start);
        this.setIncrement(params.increment);
        this.setValue(params.start);
        this.setSequenceType();
    }

    public boolean updateParams(CreateParams params) {
        boolean any = false;
        if (params.start != null && this.getStart() != params.start.longValue()) {
            this.setStart(params.start);
            any = true;
        }
        if (params.increment != null && this.getIncrement() != params.increment.intValue()) {
            this.setIncrement(params.increment);
            any = true;
        }
        return any;
    }

    public void onUpdate(ODocument iDocument) {
        this.document = iDocument;
    }

    protected long getValue() {
        return (Long)this.document.field(FIELD_VALUE, OType.LONG);
    }

    protected void setValue(long value) {
        this.document.field(FIELD_VALUE, value);
    }

    protected int getIncrement() {
        return (Integer)this.document.field(FIELD_INCREMENT, OType.INTEGER);
    }

    protected void setIncrement(int value) {
        this.document.field(FIELD_INCREMENT, value);
    }

    protected long getStart() {
        return (Long)this.document.field(FIELD_START, OType.LONG);
    }

    protected void setStart(long value) {
        this.document.field(FIELD_START, value);
    }

    public int getMaxRetry() {
        return this.maxRetry;
    }

    public void setMaxRetry(int maxRetry) {
        this.maxRetry = maxRetry;
    }

    public String getName() {
        return OSequence.getSequenceName(this.document);
    }

    public OSequence setName(String name) {
        this.document.field(FIELD_NAME, name);
        return this;
    }

    private void setSequenceType() {
        this.document.field(FIELD_TYPE, (Object)this.getSequenceType());
    }

    protected ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    public static String getSequenceName(ODocument iDocument) {
        return (String)iDocument.field(FIELD_NAME, OType.STRING);
    }

    public static SEQUENCE_TYPE getSequenceType(ODocument document) {
        String sequenceTypeStr = (String)document.field(FIELD_TYPE);
        return SEQUENCE_TYPE.valueOf(sequenceTypeStr);
    }

    public static void initClass(OClassImpl sequenceClass) {
        sequenceClass.createProperty(FIELD_START, OType.LONG, (OType)null, true);
        sequenceClass.createProperty(FIELD_INCREMENT, OType.INTEGER, (OType)null, true);
        sequenceClass.createProperty(FIELD_VALUE, OType.LONG, (OType)null, true);
        sequenceClass.createProperty(FIELD_NAME, OType.STRING, (OType)null, true);
        sequenceClass.createProperty(FIELD_TYPE, OType.STRING, (OType)null, true);
    }

    protected void reloadSequence() {
        this.reload(null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T callInTx(Callable<T> callable) throws Exception {
        boolean startTx;
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean bl = startTx = !database.getTransaction().isActive();
        if (startTx) {
            database.begin();
        }
        try {
            T t = callable.call();
            return t;
        }
        finally {
            if (startTx) {
                database.commit();
            }
        }
    }

    protected <T> T callRetry(Callable<T> callable, String method) {
        for (int retry = 0; retry < this.maxRetry; ++retry) {
            try {
                return this.callInTx(callable);
            }
            catch (OConcurrentModificationException ex) {
                try {
                    Thread.sleep(1 + new Random().nextInt(OGlobalConfiguration.SEQUENCE_RETRY_DELAY.getValueAsInteger()));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                this.reloadSequence();
                continue;
            }
            catch (OStorageException e) {
                if (e.getCause() instanceof OConcurrentModificationException) {
                    this.reloadSequence();
                    continue;
                }
                throw OException.wrapException(new OSequenceException("Error in transactional processing of " + this.getName() + "." + method + "()"), e);
            }
            catch (OException ex) {
                this.reloadSequence();
                continue;
            }
            catch (Exception e) {
                throw OException.wrapException(new OSequenceException("Error in transactional processing of " + this.getName() + "." + method + "()"), e);
            }
        }
        try {
            return this.callInTx(callable);
        }
        catch (Exception e) {
            if (e.getCause() instanceof OConcurrentModificationException) {
                throw (OConcurrentModificationException)e.getCause();
            }
            throw OException.wrapException(new OSequenceException("Error in transactional processing of " + this.getName() + "." + method + "()"), e);
        }
    }

    public abstract long next();

    public abstract long current();

    public abstract long reset();

    public abstract SEQUENCE_TYPE getSequenceType();

    public static enum SEQUENCE_TYPE {
        CACHED,
        ORDERED;

    }

    public static class CreateParams {
        public Long start;
        public Integer increment;
        public Integer cacheSize;

        public CreateParams setStart(Long start) {
            this.start = start;
            return this;
        }

        public CreateParams setIncrement(Integer increment) {
            this.increment = increment;
            return this;
        }

        public CreateParams setCacheSize(Integer cacheSize) {
            this.cacheSize = cacheSize;
            return this;
        }

        public CreateParams setDefaults() {
            this.start = this.start != null ? this.start : 0L;
            this.increment = this.increment != null ? this.increment : 1;
            this.cacheSize = this.cacheSize != null ? this.cacheSize : 20;
            return this;
        }
    }
}

