/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.sequence;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceLibrary;
import com.orientechnologies.orient.core.record.impl.ODocument;

public class OSequenceTrigger
extends ODocumentHookAbstract {
    public OSequenceTrigger(ODatabaseDocument database) {
        super(database);
        this.setIncludeClasses("OSequence");
    }

    @Override
    public ORecordHook.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return ORecordHook.DISTRIBUTED_EXECUTION_MODE.TARGET_NODE;
    }

    @Override
    public void onRecordAfterCreate(ODocument iDocument) {
        if (OSequenceTrigger.getDatabase().getStorage().isDistributed()) {
            this.getSequenceLibrary().onSequenceCreated(iDocument);
        }
    }

    private static ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    @Override
    public void onRecordAfterUpdate(ODocument iDocument) {
        if (OSequenceTrigger.getDatabase().getStorage().isDistributed()) {
            this.getSequenceLibrary().onSequenceUpdated(iDocument);
        }
    }

    @Override
    public void onRecordAfterDelete(ODocument iDocument) {
        if (OSequenceTrigger.getDatabase().getStorage().isDistributed()) {
            this.getSequenceLibrary().onSequenceDropped(iDocument);
        }
    }

    private OSequenceLibrary getSequenceLibrary() {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.get();
        return db.getMetadata().getSequenceLibrary();
    }
}

