/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.query.live;

import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.query.live.OLiveQueryListener;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;

public class OLiveQueryQueueThread
extends Thread {
    private final BlockingQueue<ORecordOperation> queue;
    private final ConcurrentMap<Integer, OLiveQueryListener> subscribers;
    private boolean stopped = false;

    private OLiveQueryQueueThread(BlockingQueue<ORecordOperation> queue, ConcurrentMap<Integer, OLiveQueryListener> subscribers) {
        this.queue = queue;
        this.subscribers = subscribers;
    }

    public OLiveQueryQueueThread() {
        this(new LinkedBlockingQueue<ORecordOperation>(), new ConcurrentHashMap<Integer, OLiveQueryListener>());
        this.setName("LiveQueryQueueThread");
        this.setDaemon(true);
    }

    @Override
    public OLiveQueryQueueThread clone() {
        return new OLiveQueryQueueThread(this.queue, this.subscribers);
    }

    @Override
    public void run() {
        while (!this.stopped) {
            ORecordOperation next = null;
            try {
                next = this.queue.take();
            }
            catch (InterruptedException e) {
                break;
            }
            if (next == null) continue;
            for (OLiveQueryListener listener : this.subscribers.values()) {
                listener.onLiveResult(next);
            }
        }
    }

    public void stopExecution() {
        this.stopped = true;
        this.interrupt();
    }

    public void enqueue(ORecordOperation item) {
        this.queue.offer(item);
    }

    public Integer subscribe(Integer id, OLiveQueryListener iListener) {
        this.subscribers.put(id, iListener);
        return id;
    }

    public void unsubscribe(Integer id) {
        OLiveQueryListener res = (OLiveQueryListener)this.subscribers.remove(id);
        if (res != null) {
            res.onLiveResultEnd();
        }
    }

    public boolean hasListeners() {
        return !this.subscribers.isEmpty();
    }
}

