/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.storage.OCluster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OCommandExecutorSQLAlterCluster
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_ALTER = "ALTER";
    public static final String KEYWORD_CLUSTER = "CLUSTER";
    protected String clusterName;
    protected int clusterId = -1;
    protected OCluster.ATTRIBUTES attribute;
    protected String value;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCommandExecutorSQLAlterCluster parse(OCommandRequest iRequest) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        String originalQuery = queryText = textRequest.getText();
        try {
            queryText = this.preParse(queryText, iRequest);
            textRequest.setText(queryText);
            ODatabaseDocumentInternal database = OCommandExecutorSQLAlterCluster.getDatabase();
            this.init((OCommandRequestText)iRequest);
            StringBuilder word = new StringBuilder();
            int oldPos = 0;
            int pos = OCommandExecutorSQLAlterCluster.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true);
            if (pos == -1 || !word.toString().equals(KEYWORD_ALTER)) {
                throw new OCommandSQLParsingException("Keyword ALTER not found. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            oldPos = pos;
            if ((pos = OCommandExecutorSQLAlterCluster.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_CLUSTER)) {
                throw new OCommandSQLParsingException("Keyword CLUSTER not found. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            oldPos = pos;
            if ((pos = OCommandExecutorSQLAlterCluster.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, false)) == -1) {
                throw new OCommandSQLParsingException("Expected <cluster-name>. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            this.clusterName = word.toString();
            this.clusterName = this.decodeClassName(this.clusterName);
            Pattern p = Pattern.compile("([0-9]*)");
            Matcher m = p.matcher(this.clusterName);
            if (m.matches()) {
                this.clusterId = Integer.parseInt(this.clusterName);
            }
            if ((pos = OCommandExecutorSQLAlterCluster.nextWord(this.parserText, this.parserTextUpperCase, oldPos = pos, word, true)) == -1) {
                throw new OCommandSQLParsingException("Missing cluster attribute to change. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            String attributeAsString = word.toString();
            try {
                this.attribute = OCluster.ATTRIBUTES.valueOf(attributeAsString.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw new OCommandSQLParsingException("Unknown class attribute '" + attributeAsString + "'. Supported attributes are: " + Arrays.toString((Object[])OCluster.ATTRIBUTES.values()), this.parserText, oldPos);
            }
            this.value = this.parserText.substring(pos + 1).trim();
            this.value = this.decodeClassName(this.value);
            if (this.attribute == OCluster.ATTRIBUTES.NAME) {
                this.value = this.value.replaceAll(" ", "");
            }
            if (this.value.length() == 0) {
                throw new OCommandSQLParsingException("Missing property value to change for attribute '" + (Object)((Object)this.attribute) + "'. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            if (this.value.equalsIgnoreCase("null")) {
                this.value = null;
            }
        }
        finally {
            textRequest.setText(originalQuery);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.attribute == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        List<OCluster> clusters = this.getClusters();
        if (clusters.isEmpty()) {
            throw new OCommandExecutionException("Cluster '" + this.clusterName + "' not found");
        }
        Object result = null;
        for (OCluster cluster : this.getClusters()) {
            if (this.clusterId > -1 && this.clusterName.equals(String.valueOf(this.clusterId))) {
                this.clusterName = cluster.getName();
            } else {
                this.clusterId = cluster.getId();
            }
            try {
                if (this.attribute == OCluster.ATTRIBUTES.STATUS && OStorageClusterConfiguration.STATUS.OFFLINE.toString().equalsIgnoreCase(this.value)) {
                    OCommandExecutorSQLAlterCluster.getDatabase().getMetadata().getCommandCache().invalidateResultsOfCluster(this.clusterName);
                }
                if (this.attribute == OCluster.ATTRIBUTES.NAME) {
                    OCommandExecutorSQLAlterCluster.getDatabase().getMetadata().getCommandCache().invalidateResultsOfCluster(this.clusterName);
                }
                result = cluster.set(this.attribute, this.value);
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OCommandExecutionException("Error altering cluster '" + this.clusterName + "'"), ioe);
            }
        }
        return result;
    }

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_COMMAND_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    protected List<OCluster> getClusters() {
        ODatabaseDocumentInternal database = OCommandExecutorSQLAlterCluster.getDatabase();
        ArrayList<OCluster> result = new ArrayList<OCluster>();
        if (this.clusterName.endsWith("*")) {
            String toMatch = this.clusterName.substring(0, this.clusterName.length() - 1).toLowerCase();
            for (String cl : database.getStorage().getClusterNames()) {
                if (!cl.startsWith(toMatch)) continue;
                result.add(database.getStorage().getClusterByName(cl));
            }
        } else if (this.clusterId > -1) {
            result.add(database.getStorage().getClusterById(this.clusterId));
        } else {
            result.add(database.getStorage().getClusterById(database.getStorage().getClusterIdByName(this.clusterName)));
        }
        return result;
    }

    @Override
    public String getSyntax() {
        return "ALTER CLUSTER <cluster-name>|<cluster-id> <attribute-name> <attribute-value>";
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }
}

