/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.parser.OCreateClassStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OCommandExecutorSQLCreateClass
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_CREATE = "CREATE";
    public static final String KEYWORD_CLASS = "CLASS";
    public static final String KEYWORD_EXTENDS = "EXTENDS";
    public static final String KEYWORD_ABSTRACT = "ABSTRACT";
    public static final String KEYWORD_CLUSTER = "CLUSTER";
    public static final String KEYWORD_CLUSTERS = "CLUSTERS";
    private String className;
    private List<OClass> superClasses = new ArrayList<OClass>();
    private int[] clusterIds;
    private Integer clusters = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCommandExecutorSQLCreateClass parse(OCommandRequest iRequest) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        String originalQuery = queryText = textRequest.getText();
        try {
            int clusterId;
            queryText = this.preParse(queryText, iRequest);
            textRequest.setText(queryText);
            ODatabaseDocumentInternal database = OCommandExecutorSQLCreateClass.getDatabase();
            this.init((OCommandRequestText)iRequest);
            StringBuilder word = new StringBuilder();
            int oldPos = 0;
            int pos = OCommandExecutorSQLCreateClass.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true);
            if (pos == -1 || !word.toString().equals(KEYWORD_CREATE)) {
                throw new OCommandSQLParsingException("Keyword CREATE not found. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            oldPos = pos;
            if ((pos = OCommandExecutorSQLCreateClass.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_CLASS)) {
                throw new OCommandSQLParsingException("Keyword CLASS not found. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            oldPos = pos;
            if ((pos = OCommandExecutorSQLCreateClass.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, false)) == -1) {
                throw new OCommandSQLParsingException("Expected <class>", this.parserText, oldPos);
            }
            this.className = word.toString();
            if (this.preParsedStatement != null) {
                this.className = ((OCreateClassStatement)this.preParsedStatement).name.getStringValue();
            }
            if (this.className == null) {
                throw new OCommandSQLParsingException("Expected <class>", this.parserText, oldPos);
            }
            oldPos = pos;
            while ((pos = OCommandExecutorSQLCreateClass.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true)) > -1) {
                String k = word.toString();
                if (k.equals(KEYWORD_EXTENDS)) {
                    boolean hasNext;
                    block6: do {
                        oldPos = pos;
                        if ((pos = OCommandExecutorSQLCreateClass.nextWord(this.parserText, this.parserTextUpperCase, pos, word, false)) == -1) {
                            throw new OCommandSQLParsingException("Syntax error after EXTENDS for class " + this.className + ". Expected the super-class name. Use " + this.getSyntax(), this.parserText, oldPos);
                        }
                        String superclassName = this.decodeClassName(word.toString());
                        if (!database.getMetadata().getSchema().existsClass(superclassName)) {
                            throw new OCommandSQLParsingException("Super-class " + word + " not exists", this.parserText, oldPos);
                        }
                        OClass superClass = database.getMetadata().getSchema().getClass(superclassName);
                        this.superClasses.add(superClass);
                        hasNext = false;
                        while (pos < this.parserText.length()) {
                            char ch = this.parserText.charAt(pos);
                            if (ch == ',') {
                                hasNext = true;
                            } else if (Character.isLetterOrDigit(ch)) continue block6;
                            ++pos;
                        }
                    } while (hasNext);
                } else if (k.equals(KEYWORD_CLUSTER)) {
                    oldPos = pos;
                    if ((pos = OCommandExecutorSQLCreateClass.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, false, " =><()")) == -1) {
                        throw new OCommandSQLParsingException("Syntax error after CLUSTER for class " + this.className + ". Expected the cluster id or name. Use " + this.getSyntax(), this.parserText, oldPos);
                    }
                    String[] clusterIdsAsStrings = word.toString().split(",");
                    if (clusterIdsAsStrings.length > 0) {
                        this.clusterIds = new int[clusterIdsAsStrings.length];
                        for (int i = 0; i < clusterIdsAsStrings.length; ++i) {
                            this.clusterIds[i] = Character.isDigit(clusterIdsAsStrings[i].charAt(0)) ? Integer.parseInt(clusterIdsAsStrings[i]) : database.getStorage().getClusterIdByName(clusterIdsAsStrings[i]);
                            if (this.clusterIds[i] == -1) {
                                throw new OCommandSQLParsingException("Cluster with id " + this.clusterIds[i] + " does not exists", this.parserText, oldPos);
                            }
                            try {
                                database.getStorage().getClusterById(this.clusterIds[i]);
                                continue;
                            }
                            catch (Exception e) {
                                throw new OCommandSQLParsingException("Cluster with id " + this.clusterIds[i] + " does not exists", this.parserText, oldPos);
                            }
                        }
                    }
                } else if (k.equals(KEYWORD_CLUSTERS)) {
                    oldPos = pos;
                    if ((pos = OCommandExecutorSQLCreateClass.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, false, " =><()")) == -1) {
                        throw new OCommandSQLParsingException("Syntax error after CLUSTERS for class " + this.className + ". Expected the number of clusters. Use " + this.getSyntax(), this.parserText, oldPos);
                    }
                    this.clusters = Integer.parseInt(word.toString());
                } else if (k.equals(KEYWORD_ABSTRACT)) {
                    this.clusterIds = new int[]{-1};
                } else {
                    throw new OCommandSQLParsingException("Invalid keyword: " + k);
                }
                oldPos = pos;
            }
            if (this.clusterIds == null && (clusterId = database.getStorage().getClusterIdByName(this.className)) > -1) {
                this.clusterIds = new int[]{clusterId};
            }
        }
        finally {
            textRequest.setText(originalQuery);
        }
        return this;
    }

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_COMMAND_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.className == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseDocumentInternal database = OCommandExecutorSQLCreateClass.getDatabase();
        if (this.clusters != null) {
            database.getMetadata().getSchema().createClass(this.className, this.clusters, this.superClasses.toArray(new OClass[0]));
        } else {
            database.getMetadata().getSchema().createClass(this.className, this.clusterIds, this.superClasses.toArray(new OClass[0]));
        }
        return database.getMetadata().getSchema().getClasses().size();
    }

    @Override
    public String getSyntax() {
        return "CREATE CLASS <class> [EXTENDS <super-class> [,<super-class2>*] ] [CLUSTER <clusterId>*] [CLUSTERS <total-cluster-number>] [ABSTRACT]";
    }

    @Override
    public String getUndoCommand() {
        return "drop class " + this.className;
    }

    @Override
    public boolean involveSchema() {
        return true;
    }
}

