/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.util.Map;

public class OCommandExecutorSQLCreateCluster
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_CREATE = "CREATE";
    public static final String KEYWORD_BLOB = "BLOB";
    public static final String KEYWORD_CLUSTER = "CLUSTER";
    public static final String KEYWORD_ID = "ID";
    private String clusterName;
    private int requestedId = -1;
    private boolean blob = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCommandExecutorSQLCreateCluster parse(OCommandRequest iRequest) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        String originalQuery = queryText = textRequest.getText();
        try {
            queryText = this.preParse(queryText, iRequest);
            textRequest.setText(queryText);
            ODatabaseDocumentInternal database = OCommandExecutorSQLCreateCluster.getDatabase();
            this.init((OCommandRequestText)iRequest);
            this.parserRequiredKeyword(KEYWORD_CREATE);
            String nextWord = this.parserRequiredWord(true);
            if (nextWord.equals(KEYWORD_BLOB)) {
                this.parserRequiredKeyword(KEYWORD_CLUSTER);
                this.blob = true;
            } else if (!nextWord.equals(KEYWORD_CLUSTER)) {
                throw new OCommandSQLParsingException("Invalid Syntax: " + queryText);
            }
            this.clusterName = this.parserRequiredWord(false);
            this.clusterName = this.decodeClassName(this.clusterName);
            if (!this.clusterName.isEmpty() && Character.isDigit(this.clusterName.charAt(0))) {
                throw new IllegalArgumentException("Cluster name cannot begin with a digit");
            }
            String temp = this.parseOptionalWord(true, new String[0]);
            while (temp != null) {
                if (temp.equals(KEYWORD_ID)) {
                    this.requestedId = Integer.parseInt(this.parserRequiredWord(false));
                }
                temp = this.parseOptionalWord(true, new String[0]);
                if (!this.parserIsEnded()) continue;
                break;
            }
        }
        finally {
            textRequest.setText(originalQuery);
        }
        return this;
    }

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_COMMAND_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.clusterName == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseDocumentInternal database = OCommandExecutorSQLCreateCluster.getDatabase();
        int clusterId = database.getClusterIdByName(this.clusterName);
        if (clusterId > -1) {
            throw new OCommandSQLParsingException("Cluster '" + this.clusterName + "' already exists");
        }
        if (this.blob) {
            if (this.requestedId == -1) {
                return database.addBlobCluster(this.clusterName, new Object[0]);
            }
            throw new OCommandExecutionException("Request id not supported by blob cluster creation.");
        }
        if (this.requestedId == -1) {
            return database.addCluster(this.clusterName, new Object[0]);
        }
        return database.addCluster(this.clusterName, this.requestedId, (Object[])null);
    }

    @Override
    public String getUndoCommand() {
        return "drop cluster " + this.clusterName;
    }

    @Override
    public String getSyntax() {
        return "CREATE CLUSTER <name> [ID <requested cluster id>]";
    }
}

