/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.query.live.OLiveQueryHook;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import java.util.Map;

public class OCommandExecutorSQLLiveUnsubscribe
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_LIVE_UNSUBSCRIBE = "LIVE UNSUBSCRIBE";
    protected String unsubscribeToken;

    private Object executeUnsubscribe() {
        try {
            OLiveQueryHook.unsubscribe(Integer.parseInt(this.unsubscribeToken), OCommandExecutorSQLLiveUnsubscribe.getDatabase());
            ODocument result = new ODocument();
            result.field("unsubscribed", this.unsubscribeToken);
            result.field("unsubscribe", true);
            result.field("token", this.unsubscribeToken);
            return result;
        }
        catch (Exception e) {
            OLogManager.instance().warn((Object)this, "error unsubscribing token " + this.unsubscribeToken + ": " + e.getClass().getName() + " - " + e.getMessage(), new Object[0]);
            ODocument result = new ODocument();
            result.field("error-unsubscribe", this.unsubscribeToken);
            result.field("error-description", e.getMessage());
            result.field("error-type", e.getClass().getName());
            return result;
        }
    }

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_COMMAND_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.unsubscribeToken != null) {
            return this.executeUnsubscribe();
        }
        ODocument result = new ODocument();
        result.field("error-unsubscribe", "no token");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCommandExecutorSQLLiveUnsubscribe parse(OCommandRequest iRequest) {
        OCommandRequestText requestText = (OCommandRequestText)iRequest;
        String originalText = requestText.getText();
        String remainingText = requestText.getText().trim().substring(5).trim();
        requestText.setText(remainingText);
        try {
            if (remainingText.toLowerCase().startsWith("unsubscribe")) {
                if ((remainingText = remainingText.substring("unsubscribe".length()).trim()).contains(" ")) {
                    throw new OQueryParsingException("invalid unsubscribe token for live query: " + remainingText);
                }
                this.unsubscribeToken = remainingText;
            }
        }
        finally {
            requestText.setText(originalText);
        }
        return this;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE;
    }
}

