/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public class OCommandExecutorSQLTruncateClass
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_TRUNCATE = "TRUNCATE";
    public static final String KEYWORD_CLASS = "CLASS";
    public static final String KEYWORD_POLYMORPHIC = "POLYMORPHIC";
    private OClass schemaClass;
    private boolean unsafe = false;
    private boolean deep = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCommandExecutorSQLTruncateClass parse(OCommandRequest iRequest) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        String originalQuery = queryText = textRequest.getText();
        try {
            queryText = this.preParse(queryText, iRequest);
            textRequest.setText(queryText);
            ODatabaseDocumentInternal database = OCommandExecutorSQLTruncateClass.getDatabase();
            this.init((OCommandRequestText)iRequest);
            StringBuilder word = new StringBuilder();
            int oldPos = 0;
            int pos = OCommandExecutorSQLTruncateClass.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true);
            if (pos == -1 || !word.toString().equals(KEYWORD_TRUNCATE)) {
                throw new OCommandSQLParsingException("Keyword TRUNCATE not found. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            oldPos = pos;
            if ((pos = OCommandExecutorSQLTruncateClass.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_CLASS)) {
                throw new OCommandSQLParsingException("Keyword CLASS not found. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            oldPos = pos;
            if ((pos = OCommandExecutorSQLTruncateClass.nextWord(this.parserText, this.parserText, oldPos, word, true)) == -1) {
                throw new OCommandSQLParsingException("Expected class name. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            String className = word.toString();
            this.schemaClass = database.getMetadata().getSchema().getClass(className);
            if (this.schemaClass == null) {
                throw new OCommandSQLParsingException("Class '" + className + "' not found", this.parserText, oldPos);
            }
            oldPos = pos;
            pos = OCommandExecutorSQLTruncateClass.nextWord(this.parserText, this.parserText, oldPos, word, true);
            while (pos > 0) {
                String nextWord = word.toString();
                if (nextWord.toUpperCase().equals("UNSAFE")) {
                    this.unsafe = true;
                } else if (nextWord.toUpperCase().equals(KEYWORD_POLYMORPHIC)) {
                    this.deep = true;
                }
                oldPos = pos;
                pos = OCommandExecutorSQLTruncateClass.nextWord(this.parserText, this.parserText, oldPos, word, true);
            }
        }
        finally {
            textRequest.setText(originalQuery);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.schemaClass == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        long recs = this.schemaClass.count();
        if (recs > 0L && !this.unsafe) {
            if (this.schemaClass.isSubClassOf("V")) {
                throw new OCommandExecutionException("'TRUNCATE CLASS' command cannot be used on not empty vertex classes. Apply the 'UNSAFE' keyword to force it (at your own risk)");
            }
            if (this.schemaClass.isSubClassOf("E")) {
                throw new OCommandExecutionException("'TRUNCATE CLASS' command cannot be used on not empty edge classes. Apply the 'UNSAFE' keyword to force it (at your own risk)");
            }
        }
        Collection<OClass> subclasses = this.schemaClass.getAllSubclasses();
        if (this.deep && !this.unsafe) {
            for (OClass subclass : subclasses) {
                long subclassRecs = this.schemaClass.count();
                if (subclassRecs <= 0L) continue;
                if (subclass.isSubClassOf("V")) {
                    throw new OCommandExecutionException("'TRUNCATE CLASS' command cannot be used on not empty vertex classes (" + subclass.getName() + "). Apply the 'UNSAFE' keyword to force it (at your own risk)");
                }
                if (!subclass.isSubClassOf("E")) continue;
                throw new OCommandExecutionException("'TRUNCATE CLASS' command cannot be used on not empty edge classes (" + subclass.getName() + "). Apply the 'UNSAFE' keyword to force it (at your own risk)");
            }
        }
        try {
            this.schemaClass.truncate();
            if (this.deep) {
                for (OClass subclass : subclasses) {
                    subclass.truncate();
                }
            }
        }
        catch (IOException e) {
            throw OException.wrapException(new OCommandExecutionException("Error on executing command"), e);
        }
        return recs;
    }

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_COMMAND_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    @Override
    public String getSyntax() {
        return "TRUNCATE CLASS <class-name>";
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }
}

