/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.common.util.OTriple;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OTrackedMap;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLRetryAbstract;
import com.orientechnologies.orient.core.sql.OCommandParameters;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OOriginalRecordsReturnHandler;
import com.orientechnologies.orient.core.sql.ORecordCountHandler;
import com.orientechnologies.orient.core.sql.OReturnHandler;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.OUpdatedRecordsReturnHandler;
import com.orientechnologies.orient.core.sql.filter.OSQLFilter;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItem;
import com.orientechnologies.orient.core.sql.parser.OUpdateStatement;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class OCommandExecutorSQLUpdate
extends OCommandExecutorSQLRetryAbstract
implements OCommandDistributedReplicateRequest,
OCommandResultListener {
    public static final String KEYWORD_UPDATE = "UPDATE";
    private static final String KEYWORD_ADD = "ADD";
    private static final String KEYWORD_PUT = "PUT";
    private static final String KEYWORD_REMOVE = "REMOVE";
    private static final String KEYWORD_INCREMENT = "INCREMENT";
    private static final String KEYWORD_MERGE = "MERGE";
    private static final String KEYWORD_UPSERT = "UPSERT";
    private static final String KEYWORD_EDGE = "EDGE";
    private static final Object EMPTY_VALUE = new Object();
    private List<OPair<String, Object>> setEntries = new ArrayList<OPair<String, Object>>();
    private List<OPair<String, Object>> addEntries = new ArrayList<OPair<String, Object>>();
    private List<OTriple<String, String, Object>> putEntries = new ArrayList<OTriple<String, String, Object>>();
    private List<OPair<String, Object>> removeEntries = new ArrayList<OPair<String, Object>>();
    private List<OPair<String, Object>> incrementEntries = new ArrayList<OPair<String, Object>>();
    private ODocument merge = null;
    private String lockStrategy = "NONE";
    private OReturnHandler returnHandler = new ORecordCountHandler();
    private OQuery<?> query;
    private OSQLFilter compiledFilter;
    private String subjectName;
    private OCommandParameters parameters;
    private boolean upsertMode = false;
    private boolean isUpsertAllowed = false;
    private boolean updated = false;
    private OClass clazz = null;
    private OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE distributedMode;
    private boolean updateEdge = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCommandExecutorSQLUpdate parse(OCommandRequest iRequest) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        String originalQuery = queryText = textRequest.getText();
        try {
            queryText = this.preParse(queryText, iRequest);
            if (this.isUpdateEdge()) {
                queryText = queryText.replaceFirst("EDGE ", "");
            }
            textRequest.setText(queryText);
            ODatabaseDocumentInternal database = OCommandExecutorSQLUpdate.getDatabase();
            this.init((OCommandRequestText)iRequest);
            this.setEntries.clear();
            this.addEntries.clear();
            this.putEntries.clear();
            this.removeEntries.clear();
            this.incrementEntries.clear();
            this.content = null;
            this.merge = null;
            this.query = null;
            this.parserRequiredKeyword(KEYWORD_UPDATE);
            this.subjectName = this.parserRequiredWord(false, "Invalid target", " =><,\r\n");
            if (this.subjectName == null) {
                this.throwSyntaxErrorException("Invalid subject name. Expected cluster, class, index or sub-query");
            }
            if (this.subjectName.equalsIgnoreCase(KEYWORD_EDGE)) {
                this.updateEdge = true;
                this.subjectName = this.parserRequiredWord(false, "Invalid target", " =><,\r\n");
            }
            this.clazz = this.extractClassFromTarget(this.subjectName);
            String word = this.parserNextWord(true);
            if (!(!this.parserIsEnded() && (word.equals("SET") || word.equals(KEYWORD_ADD) || word.equals(KEYWORD_PUT) || word.equals(KEYWORD_REMOVE) || word.equals(KEYWORD_INCREMENT) || word.equals("CONTENT") || word.equals(KEYWORD_MERGE) || word.equals("LOCK") || word.equals("RETURN") || word.equals(KEYWORD_UPSERT) || word.equals(KEYWORD_EDGE)))) {
                this.throwSyntaxErrorException("Expected keyword SET,ADD,CONTENT,MERGE,PUT,REMOVE,INCREMENT,LOCK or RETURN or UPSERT or EDGE");
            }
            while (!this.parserIsEnded() && !this.parserGetLastWord().equals("WHERE") || this.parserGetLastWord().equals(KEYWORD_UPSERT)) {
                word = this.parserGetLastWord();
                if (word.equals("CONTENT")) {
                    this.parseContent();
                } else if (word.equals(KEYWORD_MERGE)) {
                    this.parseMerge();
                } else if (word.equals("SET")) {
                    this.parseSetFields(this.clazz, this.setEntries);
                } else if (word.equals(KEYWORD_ADD)) {
                    this.parseAddFields();
                } else if (word.equals(KEYWORD_PUT)) {
                    this.parsePutFields();
                } else if (word.equals(KEYWORD_REMOVE)) {
                    this.parseRemoveFields();
                } else if (word.equals(KEYWORD_INCREMENT)) {
                    this.parseIncrementFields();
                } else if (word.equals("LOCK")) {
                    this.lockStrategy = this.parseLock();
                } else if (word.equals(KEYWORD_UPSERT)) {
                    this.upsertMode = true;
                } else if (word.equals("RETURN")) {
                    this.parseReturn();
                } else {
                    if (!word.equals("RETRY")) break;
                    OLogManager.instance().warn((Object)this, "RETRY keyword will be ignored in " + originalQuery, new Object[0]);
                    this.parseRetry();
                }
                this.parserNextWord(true);
            }
            String additionalStatement = this.parserGetLastWord();
            if (this.subjectName.startsWith("(")) {
                this.subjectName = this.subjectName.trim();
                this.query = (OQuery)database.command(new OSQLAsynchQuery(this.subjectName.substring(1, this.subjectName.length() - 1), this).setContext(this.context));
                if (additionalStatement.equals("WHERE") || additionalStatement.equals("LIMIT")) {
                    this.compiledFilter = OSQLEngine.getInstance().parseCondition(this.parserText.substring(this.parserGetCurrentPosition()), this.getContext(), "WHERE");
                }
            } else if (additionalStatement.equals("WHERE") || additionalStatement.equals("LIMIT") || additionalStatement.equals("LET") || additionalStatement.equals("LOCK")) {
                if (this.preParsedStatement != null) {
                    Map<Object, Object> params = ((OCommandRequestText)iRequest).getParameters();
                    OUpdateStatement updateStm = (OUpdateStatement)this.preParsedStatement;
                    StringBuilder selectString = new StringBuilder();
                    selectString.append("select from ");
                    updateStm.target.toString(params, selectString);
                    if (updateStm.whereClause != null) {
                        selectString.append(" WHERE ");
                        updateStm.whereClause.toString(params, selectString);
                    }
                    if (updateStm.limit != null) {
                        selectString.append(" ");
                        updateStm.limit.toString(params, selectString);
                    }
                    if (updateStm.timeout != null) {
                        selectString.append(" ");
                        updateStm.timeout.toString(params, selectString);
                    }
                    if (updateStm.lockRecord) {
                        selectString.append(" LOCK RECORD");
                    }
                    this.query = new OSQLAsynchQuery(selectString.toString(), this);
                } else {
                    this.query = new OSQLAsynchQuery("select from " + this.getSelectTarget() + " " + additionalStatement + " " + this.parserText.substring(this.parserGetCurrentPosition()), this);
                }
                this.isUpsertAllowed = ((OMetadataInternal)OCommandExecutorSQLUpdate.getDatabase().getMetadata()).getImmutableSchemaSnapshot().getClass(this.subjectName) != null;
            } else if (!additionalStatement.isEmpty()) {
                this.throwSyntaxErrorException("Invalid keyword " + additionalStatement);
            } else {
                this.query = new OSQLAsynchQuery("select from " + this.getSelectTarget(), this);
            }
            if (this.upsertMode && !this.isUpsertAllowed) {
                this.throwSyntaxErrorException("Upsert only works with class names ");
            }
            if (this.upsertMode && !additionalStatement.equals("WHERE")) {
                this.throwSyntaxErrorException("Upsert only works with WHERE keyword");
            }
            if (this.upsertMode && this.updateEdge) {
                this.throwSyntaxErrorException("Upsert is not supported with UPDATE EDGE");
            }
        }
        finally {
            textRequest.setText(originalQuery);
        }
        return this;
    }

    private boolean isUpdateEdge() {
        return this.updateEdge;
    }

    private String getSelectTarget() {
        if (this.preParsedStatement == null) {
            return this.subjectName;
        }
        return ((OUpdateStatement)this.preParsedStatement).target.toString();
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        Map<Object, Object> queryArgs;
        if (this.subjectName == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        this.parameters = new OCommandParameters(iArgs);
        if (this.parameters.size() > 0 && this.parameters.getByName(0) != null) {
            queryArgs = new HashMap<Object, Object>();
            for (int i = this.parameterCounter; i < this.parameters.size(); ++i) {
                if (this.parameters.getByName(i) == null) continue;
                queryArgs.put(i - this.parameterCounter, this.parameters.getByName(i));
            }
        } else {
            queryArgs = iArgs;
        }
        this.query.setUseCache(false);
        this.query.setContext(this.context);
        this.returnHandler.reset();
        if (this.lockStrategy.equals("RECORD")) {
            this.query.getContext().setVariable("$locking", (Object)OStorage.LOCKING_STRATEGY.EXCLUSIVE_LOCK);
        }
        OCommandExecutorSQLUpdate.getDatabase().query(this.query, queryArgs);
        if (this.upsertMode && !this.updated) {
            ODocument doc = this.subjectName != null ? new ODocument(this.subjectName) : new ODocument();
            String suspendedLockStrategy = this.lockStrategy;
            this.lockStrategy = "NONE";
            try {
                this.result(doc);
            }
            catch (ORecordDuplicatedException e) {
                if (this.upsertMode) {
                    OCommandExecutorSQLUpdate.getDatabase().query(this.query, queryArgs);
                }
                throw e;
            }
            catch (ORecordNotFoundException e) {
                if (this.upsertMode) {
                    OCommandExecutorSQLUpdate.getDatabase().query(this.query, queryArgs);
                }
                throw e;
            }
            catch (OConcurrentModificationException e) {
                if (this.upsertMode) {
                    OCommandExecutorSQLUpdate.getDatabase().query(this.query, queryArgs);
                }
                throw e;
            }
            this.lockStrategy = suspendedLockStrategy;
        }
        return this.returnHandler.ret();
    }

    @Override
    public boolean result(Object iRecord) {
        ODocument record = (ODocument)((OIdentifiable)iRecord).getRecord();
        if (this.isUpdateEdge() && !this.isRecordInstanceOf(iRecord, "E")) {
            throw new OCommandExecutionException("Using UPDATE EDGE on a record that is not an instance of E");
        }
        if (this.compiledFilter != null && !((Boolean)this.compiledFilter.evaluate(record, null, this.context)).booleanValue()) {
            return false;
        }
        this.parameters.reset();
        this.returnHandler.beforeUpdate(record);
        boolean updated = this.handleContent(record);
        updated |= this.handleMerge(record);
        updated |= this.handleSetEntries(record);
        updated |= this.handleIncrementEntries(record);
        updated |= this.handleAddEntries(record);
        updated |= this.handlePutEntries(record);
        if (updated |= this.handleRemoveEntries(record)) {
            this.handleUpdateEdge(record);
            record.setDirty();
            record.save();
            this.returnHandler.afterUpdate(record);
            this.updated = true;
        }
        return true;
    }

    private boolean isRecordInstanceOf(Object iRecord, String orientClass) {
        if (iRecord == null) {
            return false;
        }
        if (!(iRecord instanceof OIdentifiable)) {
            return false;
        }
        ODocument record = (ODocument)((OIdentifiable)iRecord).getRecord();
        if (iRecord == null) {
            return false;
        }
        return record.getSchemaClass().isSubClassOf(orientClass);
    }

    private void handleUpdateEdge(ODocument record) {
        if (!this.updateEdge) {
            return;
        }
        Object currentOut = record.field("out");
        Object currentIn = record.field("in");
        Object prevOut = record.getOriginalValue("out");
        Object prevIn = record.getOriginalValue("in");
        this.validateOutInForEdge(record, currentOut, currentIn);
        this.changeVertexEdgePointer(record, (OIdentifiable)prevIn, (OIdentifiable)currentIn, "in");
        this.changeVertexEdgePointer(record, (OIdentifiable)prevOut, (OIdentifiable)currentOut, "out");
    }

    private void changeVertexEdgePointer(ODocument edge, OIdentifiable prevVertex, OIdentifiable currentVertex, String direction) {
        if (prevVertex != null && !prevVertex.equals(currentVertex)) {
            ODocument currentVertexDoc;
            ORidBag currentBag;
            String vertexFieldName = direction + "_" + edge.getClassName();
            ODocument prevOutDoc = (ODocument)prevVertex.getRecord();
            ORidBag prevBag = (ORidBag)prevOutDoc.field(vertexFieldName);
            if (prevBag != null) {
                prevBag.remove(edge);
            }
            if ((currentBag = (ORidBag)(currentVertexDoc = (ODocument)currentVertex.getRecord()).field(vertexFieldName)) == null) {
                currentBag = new ORidBag();
                currentVertexDoc.field(vertexFieldName, currentBag);
            }
            currentBag.add(edge);
        }
    }

    private void validateOutInForEdge(ODocument record, Object currentOut, Object currentIn) {
        if (!this.isRecordInstanceOf(currentOut, "V")) {
            throw new OCommandExecutionException("Error updating edge: 'out' is not a vertex - " + currentOut + "");
        }
        if (!this.isRecordInstanceOf(currentIn, "V")) {
            throw new OCommandExecutionException("Error updating edge: 'in' is not a vertex - " + currentIn + "");
        }
    }

    @Override
    public String getSyntax() {
        return "UPDATE <class>|cluster:<cluster>> [SET|ADD|PUT|REMOVE|INCREMENT|CONTENT {<JSON>}|MERGE {<JSON>}] [[,] <field-name> = <expression>|<sub-command>]* [LOCK <NONE|RECORD>] [UPSERT] [RETURN <COUNT|BEFORE|AFTER>] [WHERE <conditions>]";
    }

    @Override
    public OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        if (this.distributedMode == null) {
            this.distributedMode = this.upsertMode || this.query == null || OCommandExecutorSQLUpdate.getDatabase().getTransaction().isActive() ? OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL : OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.REPLICATE;
        }
        return this.distributedMode;
    }

    @Override
    public OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT getDistributedResultManagement() {
        return this.distributedMode == OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL ? OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT.CHECK_FOR_EQUALS : OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT.MERGE;
    }

    @Override
    public void end() {
    }

    @Override
    public int getSecurityOperationType() {
        return ORole.PERMISSION_UPDATE;
    }

    protected void parseMerge() {
        if (!this.parserIsEnded() && !this.parserGetLastWord().equals("WHERE")) {
            String contentAsString = this.parserRequiredWord(false, "document to merge expected").trim();
            this.merge = new ODocument().fromJSON(contentAsString);
            this.parserSkipWhiteSpaces();
        }
        if (this.merge == null) {
            this.throwSyntaxErrorException("Document to merge not provided. Example: MERGE { \"name\": \"Jay\" }");
        }
    }

    protected String getBlock(String fieldValue) {
        int startPos = this.parserGetCurrentPosition();
        if (fieldValue.startsWith("{") || fieldValue.startsWith("[")) {
            if (startPos > 0) {
                this.parserSetCurrentPosition(startPos - fieldValue.length());
            } else {
                this.parserSetCurrentPosition(this.parserText.length() - fieldValue.length());
            }
            this.parserSkipWhiteSpaces();
            StringBuilder buffer = new StringBuilder();
            this.parserSetCurrentPosition(OStringSerializerHelper.parse(this.parserText, buffer, this.parserGetCurrentPosition(), -1, OStringSerializerHelper.DEFAULT_FIELD_SEPARATOR, true, true, false, -1, false, OStringSerializerHelper.DEFAULT_IGNORE_CHARS));
            fieldValue = buffer.toString();
        }
        return fieldValue;
    }

    protected void parseReturn() throws OCommandSQLParsingException {
        this.parserNextWord(false, " ");
        String mode = this.parserGetLastWord().trim();
        if (mode.equalsIgnoreCase("COUNT")) {
            this.returnHandler = new ORecordCountHandler();
        } else if (mode.equalsIgnoreCase("BEFORE") || mode.equalsIgnoreCase("AFTER")) {
            this.parserNextWord(false, " ");
            String returning = this.parserGetLastWord().trim();
            Object returnExpression = null;
            if (returning.equalsIgnoreCase("WHERE") || returning.equalsIgnoreCase("TIMEOUT") || returning.equalsIgnoreCase("LIMIT") || returning.equalsIgnoreCase(KEYWORD_UPSERT) || returning.equalsIgnoreCase("LOCK") || returning.length() == 0) {
                this.parserGoBack();
            } else if (returning.startsWith("$") || returning.startsWith("@")) {
                returnExpression = returning.length() > 0 ? OSQLHelper.parseValue(this, returning, this.getContext()) : null;
            } else {
                this.throwSyntaxErrorException("record attribute (@attributes) or functions with $current variable expected");
            }
            this.returnHandler = mode.equalsIgnoreCase("BEFORE") ? new OOriginalRecordsReturnHandler(returnExpression, this.getContext()) : new OUpdatedRecordsReturnHandler(returnExpression, this.getContext());
        } else {
            this.throwSyntaxErrorException(" COUNT | BEFORE | AFTER keywords expected");
        }
    }

    private boolean handleContent(ODocument record) {
        boolean updated = false;
        if (this.content != null) {
            OClass restricted = OCommandExecutorSQLUpdate.getDatabase().getMetadata().getSchema().getClass("ORestricted");
            ODocument restrictedFields = new ODocument();
            if (restricted != null) {
                for (OProperty prop : restricted.properties()) {
                    restrictedFields.field(prop.getName(), record.field(prop.getName()));
                }
                OImmutableClass recordClass = ODocumentInternal.getImmutableSchemaClass(record);
                if (recordClass != null && recordClass.isSubClassOf("V")) {
                    for (String fieldName : record.fieldNames()) {
                        if (!fieldName.startsWith("in_") && !fieldName.startsWith("out_")) continue;
                        restrictedFields.field(fieldName, record.field(fieldName));
                    }
                } else if (recordClass != null && recordClass.isSubClassOf("E")) {
                    for (String fieldName : record.fieldNames()) {
                        if (!fieldName.equals("in") && !fieldName.equals("out")) continue;
                        restrictedFields.field(fieldName, record.field(fieldName));
                    }
                }
            }
            record.merge(restrictedFields, false, false);
            record.merge(this.content, true, false);
            updated = true;
        }
        return updated;
    }

    private boolean handleMerge(ODocument record) {
        boolean updated = false;
        if (this.merge != null) {
            record.merge(this.merge, true, false);
            updated = true;
        }
        return updated;
    }

    private boolean handleSetEntries(ODocument record) {
        boolean updated = false;
        if (!this.setEntries.isEmpty()) {
            OSQLHelper.bindParameters(record, this.setEntries, this.parameters, this.context);
            updated = true;
        }
        return updated;
    }

    private boolean handleIncrementEntries(ODocument record) {
        boolean updated = false;
        if (!this.incrementEntries.isEmpty()) {
            for (OPair<String, Object> entry : this.incrementEntries) {
                Number current;
                Number prevValue = (Number)record.field((String)entry.getKey());
                if (entry.getValue() instanceof OSQLFilterItem) {
                    current = (Number)((OSQLFilterItem)entry.getValue()).getValue(record, null, this.context);
                } else if (entry.getValue() instanceof Number) {
                    current = (Number)entry.getValue();
                } else {
                    throw new OCommandExecutionException("Increment value is not a number (" + entry.getValue() + ")");
                }
                if (prevValue == null) {
                    record.field((String)entry.getKey(), current);
                    continue;
                }
                record.field((String)entry.getKey(), OType.increment(prevValue, current));
            }
            updated = true;
        }
        return updated;
    }

    private boolean handleAddEntries(ODocument record) {
        boolean updated = false;
        for (OPair<String, Object> entry : this.addEntries) {
            Collection coll = null;
            ORidBag bag = null;
            if (!record.containsField((String)entry.getKey())) {
                if (ODocumentInternal.getImmutableSchemaClass(record) != null) {
                    OProperty prop = ODocumentInternal.getImmutableSchemaClass(record).getProperty((String)entry.getKey());
                    if (prop != null && prop.getType() == OType.LINKSET) {
                        coll = new HashSet();
                    }
                    if (prop != null && prop.getType() == OType.LINKBAG) {
                        bag = new ORidBag();
                        bag.setOwner(record);
                        record.field((String)entry.getKey(), bag);
                    }
                }
                if (coll == null && bag == null) {
                    coll = new ArrayList();
                }
                if (coll != null) {
                    Collection currColl = (Collection)record.field((String)entry.getKey());
                    if (currColl == null) {
                        record.field((String)entry.getKey(), coll);
                        coll = (Collection)record.field((String)entry.getKey());
                    } else {
                        coll = currColl;
                    }
                }
            } else {
                Object fieldValue = record.field((String)entry.getKey());
                if (fieldValue instanceof Collection) {
                    coll = (Collection)fieldValue;
                } else {
                    if (!(fieldValue instanceof ORidBag)) continue;
                    bag = (ORidBag)fieldValue;
                }
            }
            Object value = this.extractValue(record, entry);
            if (coll != null) {
                if (value instanceof OIdentifiable) {
                    coll.add(value);
                } else {
                    OMultiValue.add(coll, value);
                }
            } else {
                if (!(value instanceof OIdentifiable)) {
                    throw new OCommandExecutionException("Only links or records can be added to LINKBAG");
                }
                bag.add((OIdentifiable)value);
            }
            updated = true;
        }
        return updated;
    }

    private boolean handlePutEntries(ODocument record) {
        boolean updated = false;
        if (!this.putEntries.isEmpty()) {
            for (OTriple<String, String, Object> entry : this.putEntries) {
                OProperty property;
                Object fieldValue = record.field(entry.getKey());
                if (fieldValue == null) {
                    OProperty property2;
                    if (ODocumentInternal.getImmutableSchemaClass(record) != null && (property2 = ODocumentInternal.getImmutableSchemaClass(record).getProperty(entry.getKey())) != null && property2.getType() != null && !property2.getType().equals((Object)OType.EMBEDDEDMAP) && !property2.getType().equals((Object)OType.LINKMAP)) {
                        throw new OCommandExecutionException("field " + entry.getKey() + " is not defined as a map");
                    }
                    fieldValue = new HashMap();
                    record.field(entry.getKey(), fieldValue);
                }
                if (!(fieldValue instanceof Map)) continue;
                OTrackedMap map = (OTrackedMap)fieldValue;
                OPair<String, Object> pair = entry.getValue();
                Object value = this.extractValue(record, pair);
                if (record.getSchemaClass() != null && (property = record.getSchemaClass().getProperty(entry.getKey())) != null && property.getType().equals((Object)OType.LINKMAP) && !(value instanceof OIdentifiable)) {
                    throw new OCommandExecutionException("field " + entry.getKey() + " defined of type LINKMAP accept only link values");
                }
                if (OType.LINKMAP.equals((Object)OType.getTypeByValue(fieldValue)) && !(value instanceof OIdentifiable)) {
                    map = new OTrackedMap(record, map, Object.class);
                    record.field(entry.getKey(), map, OType.EMBEDDEDMAP);
                }
                map.put(pair.getKey(), value);
                updated = true;
            }
        }
        return updated;
    }

    private boolean handleRemoveEntries(ODocument record) {
        boolean updated = false;
        if (!this.removeEntries.isEmpty()) {
            for (OPair<String, Object> entry : this.removeEntries) {
                Object value = this.extractValue(record, entry);
                if (value == EMPTY_VALUE) {
                    record.removeField((String)entry.getKey());
                    updated = true;
                    continue;
                }
                Object fieldValue = record.field((String)entry.getKey());
                if (fieldValue instanceof Collection) {
                    updated = this.removeFromCollection(updated, value, (Collection)fieldValue);
                    continue;
                }
                if (fieldValue instanceof Map) {
                    updated = this.removeFromMap(updated, value, (Map)fieldValue);
                    continue;
                }
                if (!(fieldValue instanceof ORidBag)) continue;
                updated = this.removeFromBag(record, updated, value, (ORidBag)fieldValue);
            }
        }
        return updated;
    }

    private boolean removeFromCollection(boolean updated, Object value, Collection<?> collection) {
        updated = value instanceof Collection ? (updated |= collection.removeAll((Collection)value)) : (updated |= collection.remove(value));
        return updated;
    }

    private boolean removeFromMap(boolean updated, Object value, Map<?, ?> map) {
        if (value instanceof Collection) {
            for (Object o : (Collection)value) {
                updated |= map.remove(o) != null;
            }
        } else {
            updated |= map.remove(value) != null;
        }
        return updated;
    }

    private boolean removeFromBag(ODocument record, boolean updated, Object value, ORidBag bag) {
        if (value instanceof Collection) {
            for (Object o : (Collection)value) {
                updated |= this.removeSingleValueFromBag(bag, o, record);
            }
        } else {
            updated |= this.removeSingleValueFromBag(bag, value, record);
        }
        return updated;
    }

    private boolean removeSingleValueFromBag(ORidBag bag, Object value, ODocument record) {
        if (!(value instanceof OIdentifiable)) {
            throw new OCommandExecutionException("Only links or records can be removed from LINKBAG");
        }
        bag.remove((OIdentifiable)value);
        return record.isDirty();
    }

    private Object extractValue(ODocument record, OPair<String, Object> entry) {
        Object value = entry.getValue();
        if (value instanceof OSQLFilterItem) {
            value = ((OSQLFilterItem)value).getValue(record, null, this.context);
        } else if (value instanceof OCommandRequest) {
            value = ((OCommandRequest)value).execute(record, null, this.context);
        }
        if (value instanceof OIdentifiable && ((OIdentifiable)value).getIdentity().isPersistent()) {
            value = ((OIdentifiable)value).getIdentity();
        }
        return value;
    }

    private void parseAddFields() {
        boolean firstLap = true;
        while (!(this.parserIsEnded() || !firstLap && this.parserGetLastSeparator() != ',' && this.parserGetCurrentChar() != ',' || this.parserGetLastWord().equals("WHERE"))) {
            String fieldName = this.parserRequiredWord(false, "Field name expected");
            this.parserRequiredKeyword("=");
            String fieldValue = this.parserRequiredWord(false, "Value expected", " =><,\r\n");
            Object v = this.convertValue(this.clazz, fieldName, this.getFieldValueCountingParameters(fieldValue));
            this.addEntries.add(new OPair<String, Object>(fieldName, v));
            this.parserSkipWhiteSpaces();
            firstLap = false;
        }
        if (this.addEntries.size() == 0) {
            this.throwSyntaxErrorException("Entries to add <field> = <value> are missed. Example: name = 'Bill', salary = 300.2.");
        }
    }

    private void parsePutFields() {
        boolean firstLap = true;
        while (!(this.parserIsEnded() || !firstLap && this.parserGetLastSeparator() != ',' && this.parserGetCurrentChar() != ',' || this.parserGetLastWord().equals("WHERE"))) {
            String fieldName = this.parserRequiredWord(false, "Field name expected");
            this.parserRequiredKeyword("=");
            String fieldKey = this.parserRequiredWord(false, "Key expected");
            String fieldValue = this.getBlock(this.parserRequiredWord(false, "Value expected", " =><,\r\n"));
            this.putEntries.add(new OTriple<String, String, Object>(fieldName, (String)this.getFieldValueCountingParameters(fieldKey), this.getFieldValueCountingParameters(fieldValue)));
            this.parserSkipWhiteSpaces();
            firstLap = false;
        }
        if (this.putEntries.size() == 0) {
            this.throwSyntaxErrorException("Entries to put <field> = <key>, <value> are missed. Example: name = 'Bill', 30");
        }
    }

    private void parseRemoveFields() {
        boolean firstLap = true;
        while (!(this.parserIsEnded() || !firstLap && this.parserGetLastSeparator() != ',' && this.parserGetCurrentChar() != ',' || this.parserGetLastWord().equals("WHERE"))) {
            Object value;
            String fieldName = this.parserRequiredWord(false, "Field name expected");
            boolean found = this.parserOptionalKeyword("=", "WHERE");
            if (found) {
                if (this.parserGetLastWord().equals("WHERE")) {
                    this.parserGoBack();
                    value = EMPTY_VALUE;
                } else {
                    String fieldValue = this.getBlock(this.parserRequiredWord(false, "Value expected", " =><,\r\n"));
                    value = this.getFieldValueCountingParameters(fieldValue);
                }
            } else {
                value = EMPTY_VALUE;
            }
            this.removeEntries.add(new OPair<String, Object>(fieldName, value));
            this.parserSkipWhiteSpaces();
            firstLap = false;
        }
        if (this.removeEntries.size() == 0) {
            this.throwSyntaxErrorException("Field(s) to remove are missed. Example: name, salary");
        }
    }

    private void parseIncrementFields() {
        boolean firstLap = true;
        while (!(this.parserIsEnded() || !firstLap && this.parserGetLastSeparator() != ',' || this.parserGetLastWord().equals("WHERE"))) {
            String fieldName = this.parserRequiredWord(false, "Field name expected");
            this.parserRequiredKeyword("=");
            String fieldValue = this.getBlock(this.parserRequiredWord(false, "Value expected"));
            this.incrementEntries.add(new OPair<String, Object>(fieldName, this.getFieldValueCountingParameters(fieldValue)));
            this.parserSkipWhiteSpaces();
            firstLap = false;
        }
        if (this.incrementEntries.size() == 0) {
            this.throwSyntaxErrorException("Entries to increment <field> = <value> are missed. Example: salary = -100");
        }
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    @Override
    public Object getResult() {
        return null;
    }
}

