/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.filter;

import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.parser.OBaseParser;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.BytesContainer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OBinaryField;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerBinary;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemAbstract;
import com.orientechnologies.orient.core.sql.method.OSQLMethodRuntime;
import java.util.Set;

public class OSQLFilterItemField
extends OSQLFilterItemAbstract {
    protected Set<String> preLoadedFields;
    protected String[] preLoadedFieldsArray;
    protected String name;
    protected OCollate collate;
    private boolean collatePreset = false;

    public OSQLFilterItemField(String iName, OClass iClass) {
        this.name = OIOUtils.getStringContent(iName);
        this.collate = this.getCollateForField(iClass, this.name);
        if (iClass != null) {
            this.collatePreset = true;
        }
    }

    public OSQLFilterItemField(OBaseParser iQueryToParse, String iName, OClass iClass) {
        super(iQueryToParse, iName);
        this.collate = this.getCollateForField(iClass, iName);
        if (iClass != null) {
            this.collatePreset = true;
        }
    }

    @Override
    public Object getValue(OIdentifiable iRecord, Object iCurrentResult, OCommandContext iContext) {
        OClass schemaClass;
        if (iRecord == null) {
            throw new OCommandExecutionException("expression item '" + this.name + "' cannot be resolved because current record is NULL");
        }
        ODocument doc = (ODocument)iRecord.getRecord();
        if (this.preLoadedFieldsArray == null && this.preLoadedFields != null && this.preLoadedFields.size() > 0 && this.preLoadedFields.size() < 5) {
            this.preLoadedFieldsArray = new String[this.preLoadedFields.size()];
            this.preLoadedFields.toArray(this.preLoadedFieldsArray);
        }
        if (this.preLoadedFieldsArray != null && !doc.deserializeFields(this.preLoadedFieldsArray)) {
            return null;
        }
        Object v = doc.rawField(this.name);
        if (!this.collatePreset && doc != null && (schemaClass = doc.getSchemaClass()) != null) {
            this.collate = this.getCollateForField(schemaClass, this.name);
        }
        return this.transformValue(iRecord, iContext, v);
    }

    public OBinaryField getBinaryField(OIdentifiable iRecord) {
        if (iRecord == null) {
            throw new OCommandExecutionException("expression item '" + this.name + "' cannot be resolved because current record is NULL");
        }
        if (this.operationsChain != null && this.operationsChain.size() > 0) {
            return null;
        }
        Object rec = iRecord.getRecord();
        return ORecordSerializerBinary.INSTANCE.getCurrentSerializer().deserializeField(new BytesContainer(rec.toStream()).skip(1), rec instanceof ODocument ? ((ODocument)rec).getSchemaClass() : null, this.name);
    }

    @Override
    public String getRoot() {
        return this.name;
    }

    @Override
    public void setRoot(OBaseParser iQueryToParse, String iRoot) {
        this.name = OIOUtils.getStringContent(iRoot);
    }

    public boolean isFieldChain() {
        if (this.operationsChain == null) {
            return true;
        }
        for (OPair pair : this.operationsChain) {
            if (((OSQLMethodRuntime)pair.getKey()).getMethod().getName().equals("field")) continue;
            return false;
        }
        return true;
    }

    public FieldChain getFieldChain() {
        if (!this.isFieldChain()) {
            throw new IllegalStateException("Filter item field contains not only field operators");
        }
        return new FieldChain();
    }

    public void setPreLoadedFields(Set<String> iPrefetchedFieldList) {
        this.preLoadedFields = iPrefetchedFieldList;
    }

    public OCollate getCollate() {
        return this.collate;
    }

    public OCollate getCollate(Object doc) {
        if (this.collate != null || this.operationsChain == null || !this.isFieldChain()) {
            return this.collate;
        }
        if (!(doc instanceof OIdentifiable)) {
            return null;
        }
        FieldChain chain = this.getFieldChain();
        ODocument lastDoc = (ODocument)((OIdentifiable)doc).getRecord();
        for (int i = 0; i < chain.getItemCount() - 1; ++i) {
            if (lastDoc == null) {
                return null;
            }
            Object nextDoc = lastDoc.field(chain.getItemName(i));
            if (nextDoc == null || !(nextDoc instanceof OIdentifiable)) {
                return null;
            }
            lastDoc = (ODocument)((OIdentifiable)nextDoc).getRecord();
        }
        if (lastDoc == null) {
            return null;
        }
        OClass schemaClass = lastDoc.getSchemaClass();
        if (schemaClass == null) {
            return null;
        }
        OProperty property = schemaClass.getProperty(chain.getItemName(chain.getItemCount() - 1));
        if (property == null) {
            return null;
        }
        return property.getCollate();
    }

    public class FieldChain {
        private FieldChain() {
        }

        public String getItemName(int fieldIndex) {
            if (fieldIndex == 0) {
                return OSQLFilterItemField.this.name;
            }
            return ((Object[])((OPair)OSQLFilterItemField.this.operationsChain.get(fieldIndex - 1)).getValue())[0].toString();
        }

        public int getItemCount() {
            if (OSQLFilterItemField.this.operationsChain == null) {
                return 1;
            }
            return OSQLFilterItemField.this.operationsChain.size() + 1;
        }

        public boolean isLong() {
            return OSQLFilterItemField.this.operationsChain != null && OSQLFilterItemField.this.operationsChain.size() > 0;
        }

        public boolean belongsTo(OSQLFilterItemField filterItemField) {
            return OSQLFilterItemField.this == filterItemField;
        }
    }
}

