/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexCursorCollectionValue;
import com.orientechnologies.orient.core.index.OIndexCursorSingleValue;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItem;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemParameter;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEqualityNotNulls;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEquals;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class OQueryOperatorIn
extends OQueryOperatorEqualityNotNulls {
    public OQueryOperatorIn() {
        super("IN", 5, false);
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        return OIndexReuseType.INDEX_METHOD;
    }

    @Override
    public OIndexCursor executeIndexQuery(OCommandContext iContext, OIndex<?> index, List<Object> keyParams, boolean ascSortOrder) {
        OIndexCursor cursor;
        OIndexDefinition indexDefinition = index.getDefinition();
        OIndexInternal internalIndex = index.getInternal();
        if (!internalIndex.canBeUsedInEqualityOperators()) {
            return null;
        }
        if (indexDefinition.getParamCount() == 1) {
            Object inKeyValue = keyParams.get(0);
            Collection<Object> inParams = inKeyValue instanceof List ? (Set<Object>)inKeyValue : (inKeyValue instanceof OSQLFilterItem ? (Collection)((OSQLFilterItem)inKeyValue).getValue(null, null, iContext) : Collections.singleton(inKeyValue));
            ArrayList<Object> inKeys = new ArrayList<Object>();
            boolean containsNotCompatibleKey = false;
            for (Object e : inParams) {
                Object key = indexDefinition instanceof OIndexDefinitionMultiValue ? ((OIndexDefinitionMultiValue)indexDefinition).createSingleValue(OSQLHelper.getValue(e)) : indexDefinition.createValue(OSQLHelper.getValue(e));
                if (key == null) {
                    containsNotCompatibleKey = true;
                    break;
                }
                inKeys.add(key);
            }
            if (containsNotCompatibleKey) {
                return null;
            }
            cursor = index.iterateEntries(inKeys, ascSortOrder);
        } else {
            boolean bl;
            Collection inParams;
            ArrayList<Object> partialKey = new ArrayList<Object>();
            partialKey.addAll(keyParams);
            partialKey.remove(keyParams.size() - 1);
            Object inKeyValue = keyParams.get(keyParams.size() - 1);
            if (inKeyValue instanceof List) {
                inParams = (Collection)inKeyValue;
            } else if (inKeyValue instanceof OSQLFilterItem) {
                inParams = (Collection)((OSQLFilterItem)inKeyValue).getValue(null, null, iContext);
            } else {
                throw new IllegalArgumentException("Key '" + inKeyValue + "' is not valid");
            }
            ArrayList<OCompositeKey> inKeys = new ArrayList<OCompositeKey>();
            OCompositeIndexDefinition compositeIndexDefinition = (OCompositeIndexDefinition)indexDefinition;
            boolean bl2 = false;
            for (Object keyValue : inParams) {
                ArrayList<Object> fullKey = new ArrayList<Object>();
                fullKey.addAll(partialKey);
                fullKey.add(keyValue);
                OCompositeKey key = compositeIndexDefinition.createSingleValue(fullKey);
                if (key == null) {
                    bl = true;
                    break;
                }
                inKeys.add(key);
            }
            if (bl) {
                return null;
            }
            if (inKeys == null) {
                return null;
            }
            if (indexDefinition.getParamCount() == keyParams.size()) {
                OIndexCursor indexResult = index.iterateEntries(inKeys, ascSortOrder);
                cursor = indexResult == null || indexResult instanceof OIdentifiable ? new OIndexCursorSingleValue((OIdentifiable)((Object)indexResult), inKeys) : (indexResult instanceof OIndexCursor ? indexResult : new OIndexCursorCollectionValue((Collection)((Object)indexResult), inKeys));
            } else {
                return null;
            }
        }
        this.updateProfiler(iContext, internalIndex, keyParams, indexDefinition);
        return cursor;
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        int ridSize;
        Iterable<Object> ridCollection;
        if (iRight instanceof OSQLFilterItemField && "@rid".equals(((OSQLFilterItemField)iRight).getRoot())) {
            if (iLeft instanceof OSQLFilterItem) {
                iLeft = ((OSQLFilterItem)iLeft).getValue(null, null, null);
            }
            ridCollection = OMultiValue.getMultiValueIterable(iLeft);
            ridSize = OMultiValue.getSize(iLeft);
        } else if (iLeft instanceof OSQLFilterItemField && "@rid".equals(((OSQLFilterItemField)iLeft).getRoot())) {
            if (iRight instanceof OSQLFilterItem) {
                iRight = ((OSQLFilterItem)iRight).getValue(null, null, null);
            }
            ridCollection = OMultiValue.getMultiValueIterable(iRight);
            ridSize = OMultiValue.getSize(iRight);
        } else {
            return null;
        }
        List<ORID> rids = this.addRangeResults(ridCollection, ridSize);
        return rids == null ? null : Collections.min(rids);
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        int ridSize;
        Iterable<Object> ridCollection;
        if (iRight instanceof OSQLFilterItemField && "@rid".equals(((OSQLFilterItemField)iRight).getRoot())) {
            if (iLeft instanceof OSQLFilterItem) {
                iLeft = ((OSQLFilterItem)iLeft).getValue(null, null, null);
            }
            ridCollection = OMultiValue.getMultiValueIterable(iLeft, false);
            ridSize = OMultiValue.getSize(iLeft);
        } else if (iLeft instanceof OSQLFilterItemField && "@rid".equals(((OSQLFilterItemField)iLeft).getRoot())) {
            if (iRight instanceof OSQLFilterItem) {
                iRight = ((OSQLFilterItem)iRight).getValue(null, null, null);
            }
            ridCollection = OMultiValue.getMultiValueIterable(iRight, false);
            ridSize = OMultiValue.getSize(iRight);
        } else {
            return null;
        }
        List<ORID> rids = this.addRangeResults(ridCollection, ridSize);
        return rids == null ? null : Collections.max(rids);
    }

    @Override
    protected boolean evaluateExpression(OIdentifiable iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        block10: {
            block12: {
                block11: {
                    block9: {
                        if (!OMultiValue.isMultiValue(iLeft)) break block9;
                        if (iRight instanceof Collection) {
                            Collection collectionToMatch = (Collection)iRight;
                            boolean found = false;
                            block0: for (Object o1 : OMultiValue.getMultiValueIterable(iLeft, false)) {
                                for (Object o2 : collectionToMatch) {
                                    if (!OQueryOperatorEquals.equals(o1, o2)) continue;
                                    found = true;
                                    continue block0;
                                }
                            }
                            return found;
                        }
                        if (iLeft instanceof Set) {
                            return ((Set)iLeft).contains(iRight);
                        }
                        for (Object o : OMultiValue.getMultiValueIterable(iLeft, false)) {
                            if (!OQueryOperatorEquals.equals(iRight, o)) continue;
                            return true;
                        }
                        break block10;
                    }
                    if (!OMultiValue.isMultiValue(iRight)) break block11;
                    if (iRight instanceof Set) {
                        return ((Set)iRight).contains(iLeft);
                    }
                    for (Object o : OMultiValue.getMultiValueIterable(iRight, false)) {
                        if (!OQueryOperatorEquals.equals(iLeft, o)) continue;
                        return true;
                    }
                    break block10;
                }
                if (!iLeft.getClass().isArray()) break block12;
                for (Object o : (Object[])iLeft) {
                    if (!OQueryOperatorEquals.equals(iRight, o)) continue;
                    return true;
                }
                break block10;
            }
            if (!iRight.getClass().isArray()) break block10;
            for (Object o : (Object[])iRight) {
                if (!OQueryOperatorEquals.equals(iLeft, o)) continue;
                return true;
            }
        }
        return iLeft.equals(iRight);
    }

    protected List<ORID> addRangeResults(Iterable<?> ridCollection, int ridSize) {
        if (ridCollection == null) {
            return null;
        }
        ArrayList<ORID> rids = null;
        for (Object rid : ridCollection) {
            ORID r;
            if (rid instanceof OSQLFilterItemParameter) {
                rid = ((OSQLFilterItemParameter)rid).getValue(null, null, null);
            }
            if (!(rid instanceof OIdentifiable) || !(r = ((OIdentifiable)rid).getIdentity()).isPersistent()) continue;
            if (rids == null) {
                rids = new ArrayList<ORID>(ridSize);
            }
            rids.add(r);
        }
        return rids;
    }
}

