/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.ONumber;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.List;
import java.util.Map;

public class OAlterClassStatement
extends OStatement {
    protected OIdentifier name;
    public OClass.ATTRIBUTES property;
    protected OIdentifier identifierValue;
    protected List<OIdentifier> identifierListValue;
    protected Boolean add;
    protected Boolean remove;
    protected ONumber numberValue;
    protected Boolean booleanValue;
    public OIdentifier customKey;
    public OExpression customValue;
    protected String customString;
    protected boolean unsafe;

    public OAlterClassStatement(int id) {
        super(id);
    }

    public OAlterClassStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("ALTER CLASS ");
        this.name.toString(params, builder);
        builder.append(" " + this.property.name() + " ");
        switch (this.property) {
            case NAME: 
            case SHORTNAME: 
            case ADDCLUSTER: 
            case REMOVECLUSTER: 
            case DESCRIPTION: 
            case ENCRYPTION: {
                if (this.numberValue != null) {
                    this.numberValue.toString(params, builder);
                    break;
                }
                if (this.identifierValue != null) {
                    this.identifierValue.toString(params, builder);
                    break;
                }
                builder.append("null");
                break;
            }
            case CLUSTERSELECTION: {
                if (this.identifierValue != null) {
                    this.identifierValue.toString(params, builder);
                    break;
                }
                if (this.customString != null) {
                    builder.append('\'').append(this.customString).append('\'');
                    break;
                }
                builder.append("null");
                break;
            }
            case SUPERCLASS: {
                if (Boolean.TRUE.equals(this.add)) {
                    builder.append("+");
                } else if (Boolean.TRUE.equals(this.remove)) {
                    builder.append("-");
                }
                if (this.identifierValue == null) {
                    builder.append("null");
                    break;
                }
                this.identifierValue.toString(params, builder);
                break;
            }
            case SUPERCLASSES: {
                if (this.identifierListValue == null) {
                    builder.append("null");
                    break;
                }
                boolean first = true;
                for (OIdentifier ident : this.identifierListValue) {
                    if (!first) {
                        builder.append(", ");
                    }
                    ident.toString(params, builder);
                    first = false;
                }
                break;
            }
            case OVERSIZE: {
                this.numberValue.toString(params, builder);
                break;
            }
            case STRICTMODE: 
            case ABSTRACT: {
                builder.append(this.booleanValue);
                break;
            }
            case CUSTOM: {
                this.customKey.toString(params, builder);
                builder.append("=");
                if (this.customValue == null) {
                    builder.append("null");
                    break;
                }
                this.customValue.toString(params, builder);
            }
        }
        if (this.unsafe) {
            builder.append(" UNSAFE");
        }
    }
}

