/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OContainsCondition
extends OBooleanExpression {
    protected OExpression left;
    protected OExpression right;
    protected OBooleanExpression condition;

    public OContainsCondition(int id) {
        super(id);
    }

    public OContainsCondition(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public boolean execute(Object left, Object right) {
        if (left instanceof Collection) {
            if (right instanceof Collection) {
                return ((Collection)((Object)left)).containsAll((Collection)((Object)right));
            }
            if (right instanceof Iterable) {
                right = ((Iterable)((Object)right)).iterator();
            }
            if (right instanceof Iterator) {
                Iterator iterator = right;
                while (iterator.hasNext()) {
                    Object next = iterator.next();
                    if (((Collection)((Object)left)).contains(next)) continue;
                    return false;
                }
            }
            return ((Collection)((Object)left)).contains(right);
        }
        if (left instanceof Iterable) {
            left = ((Iterable)((Object)left)).iterator();
        }
        if (left instanceof Iterator) {
            if (right instanceof Iterable) {
                right = ((Iterable)((Object)right)).iterator();
            }
            Iterator leftIterator = right;
            Iterator rightIterator = left;
            while (leftIterator.hasNext()) {
                Object leftItem = leftIterator.next();
                boolean found = false;
                while (rightIterator.hasNext()) {
                    Object rightItem = rightIterator.next();
                    if (leftItem == null || !leftItem.equals(rightItem)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean evaluate(OIdentifiable currentRecord, OCommandContext ctx) {
        Object leftValue = this.left.execute(currentRecord, ctx);
        Object rightValue = this.right.execute(currentRecord, ctx);
        return this.execute(leftValue, rightValue);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        this.left.toString(params, builder);
        builder.append(" CONTAINS ");
        if (this.right != null) {
            this.right.toString(params, builder);
        } else if (this.condition != null) {
            builder.append("(");
            this.condition.toString(params, builder);
            builder.append(")");
        }
    }

    @Override
    public boolean supportsBasicCalculation() {
        if (!this.left.supportsBasicCalculation()) {
            return false;
        }
        if (!this.right.supportsBasicCalculation()) {
            return false;
        }
        return this.condition.supportsBasicCalculation();
    }

    @Override
    protected int getNumberOfExternalCalculations() {
        int total = 0;
        if (this.condition != null) {
            total += this.condition.getNumberOfExternalCalculations();
        }
        if (!this.left.supportsBasicCalculation()) {
            ++total;
        }
        if (this.right != null && !this.right.supportsBasicCalculation()) {
            ++total;
        }
        return total;
    }

    @Override
    protected List<Object> getExternalCalculationConditions() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.condition != null) {
            result.addAll(this.condition.getExternalCalculationConditions());
        }
        if (!this.left.supportsBasicCalculation()) {
            result.add(this.left);
        }
        if (this.right != null && !this.right.supportsBasicCalculation()) {
            result.add(this.right);
        }
        return result;
    }
}

