/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClassDescendentOrder;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.parser.OFetchPlan;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OFromItem;
import com.orientechnologies.orient.core.sql.parser.OGroupBy;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OLetClause;
import com.orientechnologies.orient.core.sql.parser.OLimit;
import com.orientechnologies.orient.core.sql.parser.OOrderBy;
import com.orientechnologies.orient.core.sql.parser.OProjection;
import com.orientechnologies.orient.core.sql.parser.OProjectionItem;
import com.orientechnologies.orient.core.sql.parser.OQueryCursor;
import com.orientechnologies.orient.core.sql.parser.OSkip;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OTimeout;
import com.orientechnologies.orient.core.sql.parser.OUnwind;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class OSelectStatement
extends OStatement {
    protected OFromClause target;
    protected OProjection projection;
    protected OWhereClause whereClause;
    protected OGroupBy groupBy;
    protected OOrderBy orderBy;
    protected OUnwind unwind;
    protected OSkip skip;
    protected OLimit limit;
    protected Boolean lockRecord;
    protected OFetchPlan fetchPlan;
    protected OLetClause letClause;
    protected OTimeout timeout;
    protected Boolean parallel;
    protected Boolean noCache;

    public OSelectStatement(int id) {
        super(id);
    }

    public OSelectStatement(OrientSql p, int id) {
        super(p, id);
    }

    private OIdentifier getAlias(OProjectionItem item) {
        if (item.getAlias() != null) {
            return item.getAlias();
        }
        return item.getDefaultAlias();
    }

    public OProjection getProjection() {
        return this.projection;
    }

    public void setProjection(OProjection projection) {
        this.projection = projection;
    }

    public OFromClause getTarget() {
        return this.target;
    }

    public void setTarget(OFromClause target) {
        this.target = target;
    }

    public OWhereClause getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(OWhereClause whereClause) {
        this.whereClause = whereClause;
    }

    public OGroupBy getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(OGroupBy groupBy) {
        this.groupBy = groupBy;
    }

    public OOrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(OOrderBy orderBy) {
        this.orderBy = orderBy;
    }

    public OSkip getSkip() {
        return this.skip;
    }

    public void setSkip(OSkip skip) {
        this.skip = skip;
    }

    public OLimit getLimit() {
        return this.limit;
    }

    public void setLimit(OLimit limit) {
        this.limit = limit;
    }

    public Boolean getLockRecord() {
        return this.lockRecord;
    }

    public void setLockRecord(Boolean lockRecord) {
        this.lockRecord = lockRecord;
    }

    public OFetchPlan getFetchPlan() {
        return this.fetchPlan;
    }

    public void setFetchPlan(OFetchPlan fetchPlan) {
        this.fetchPlan = fetchPlan;
    }

    public OLetClause getLetClause() {
        return this.letClause;
    }

    public void setLetClause(OLetClause letClause) {
        this.letClause = letClause;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("SELECT");
        if (this.projection != null) {
            builder.append(" ");
            this.projection.toString(params, builder);
        }
        if (this.target != null) {
            builder.append(" FROM ");
            this.target.toString(params, builder);
        }
        if (this.letClause != null) {
            builder.append(" ");
            this.letClause.toString(params, builder);
        }
        if (this.whereClause != null) {
            builder.append(" WHERE ");
            this.whereClause.toString(params, builder);
        }
        if (this.groupBy != null) {
            builder.append(" ");
            this.groupBy.toString(params, builder);
        }
        if (this.orderBy != null) {
            builder.append(" ");
            this.orderBy.toString(params, builder);
        }
        if (this.unwind != null) {
            builder.append(" ");
            this.unwind.toString(params, builder);
        }
        if (this.skip != null) {
            this.skip.toString(params, builder);
        }
        if (this.limit != null) {
            this.limit.toString(params, builder);
        }
        if (Boolean.TRUE.equals(this.lockRecord)) {
            builder.append(" LOCK RECORD");
        }
        if (this.fetchPlan != null) {
            builder.append(" ");
            this.fetchPlan.toString(params, builder);
        }
        if (this.timeout != null) {
            this.timeout.toString(params, builder);
        }
        if (Boolean.TRUE.equals(this.parallel)) {
            builder.append(" PARALLEL");
        }
        if (Boolean.TRUE.equals(this.noCache)) {
            builder.append(" NOCACHE");
        }
    }

    @Override
    public void validate(OrientSql.ValidationStats stats) throws OCommandSQLParsingException {
    }

    private boolean isClassTarget(OFromClause target) {
        return target != null && target.item != null && target.item.identifier != null && target.item.identifier.suffix != null && target.item.identifier.suffix.identifier != null;
    }

    private boolean isIndexTarget(OFromClause target) {
        return target != null && target.item != null && target.item.index != null;
    }

    public OQueryCursor execute(OCommandContext ctx) {
        return new OQueryCursor(this.fetchFromTarget(ctx), this.whereClause, this.orderBy, this.calculateSkip(ctx), this.calculateLimit(ctx), ctx);
    }

    private int calculateLimit(OCommandContext ctx) {
        return -1;
    }

    private int calculateSkip(OCommandContext ctx) {
        return -1;
    }

    private Iterator<OIdentifiable> fetchFromTarget(OCommandContext ctx) {
        OFromItem targetItem = this.target.getItem();
        Iterator<Object> result = null;
        if (targetItem.cluster == null && targetItem.identifier != null) {
            if (targetItem.identifier.isBaseIdentifier()) {
                Iterable resultIterable;
                String className = targetItem.identifier.toString();
                OClass oClass = OSelectStatement.getDatabase().getMetadata().getSchema().getClass(className);
                if (oClass == null) {
                    throw new OCommandExecutionException("Class not found in database schema: " + className);
                }
                if (this.whereClause != null && (resultIterable = this.whereClause.fetchFromIndexes(oClass, ctx)) != null) {
                    result = resultIterable.iterator();
                }
                if (result == null) {
                    boolean ascendingOrder = true;
                    result = this.searchInClasses(oClass, true, ascendingOrder);
                }
            } else {
                Object calculationResult = targetItem.identifier.execute(null, ctx);
                if (calculationResult instanceof Iterable) {
                    result = ((Iterable)calculationResult).iterator();
                } else if (calculationResult instanceof OIdentifiable) {
                    result = Collections.singleton(calculationResult).iterator();
                }
            }
        }
        return result;
    }

    protected Iterator<? extends OIdentifiable> searchInClasses(OClass iCls, boolean iPolymorphic, boolean iAscendentOrder) {
        ODatabaseDocumentInternal database = OSelectStatement.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_READ, (Object)iCls.getName().toLowerCase());
        ORID[] range = new ORID[2];
        boolean useCache = false;
        if (iAscendentOrder) {
            return new ORecordIteratorClass(database, database, iCls.getName(), iPolymorphic, useCache).setRange(range[0], range[1]);
        }
        return new ORecordIteratorClassDescendentOrder(database, database, iCls.getName(), iPolymorphic).setRange(range[0], range[1]);
    }
}

