/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.parser.OMatchExpression;
import com.orientechnologies.orient.core.sql.parser.OMatchFilter;
import com.orientechnologies.orient.core.sql.parser.OMatchPathItem;
import com.orientechnologies.orient.core.sql.parser.PatternNode;
import java.util.LinkedHashMap;
import java.util.Map;

class Pattern {
    Map<String, PatternNode> aliasToNode = new LinkedHashMap<String, PatternNode>();
    int numOfEdges = 0;

    Pattern() {
    }

    void addExpression(OMatchExpression expression) {
        PatternNode originNode = this.getOrCreateNode(expression.origin);
        for (OMatchPathItem item : expression.items) {
            String nextAlias = item.filter.getAlias();
            PatternNode nextNode = this.getOrCreateNode(item.filter);
            this.numOfEdges += originNode.addEdge(item, nextNode);
            originNode = nextNode;
        }
    }

    private PatternNode getOrCreateNode(OMatchFilter origin) {
        PatternNode originNode = this.get(origin.getAlias());
        if (originNode == null) {
            originNode = new PatternNode();
            originNode.alias = origin.getAlias();
            this.aliasToNode.put(originNode.alias, originNode);
        }
        return originNode;
    }

    PatternNode get(String alias) {
        return this.aliasToNode.get(alias);
    }

    int getNumOfEdges() {
        return this.numOfEdges;
    }
}

