/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache;

import com.orientechnologies.common.directmemory.OByteBufferPool;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class OCachePointer {
    private static final int WRITERS_OFFSET = 32;
    private static final int READERS_MASK = -1;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final AtomicInteger referrersCount = new AtomicInteger();
    private final AtomicLong readersWritersReferrer = new AtomicLong();
    private final AtomicInteger usagesCounter = new AtomicInteger();
    private volatile OLogSequenceNumber lastFlushedLsn;
    private volatile WritersListener writersListener;
    private final ByteBuffer buffer;
    private final OByteBufferPool bufferPool;
    private final ThreadLocal<ByteBuffer> threadLocalBuffer = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            if (OCachePointer.this.buffer != null) {
                ByteBuffer b = OCachePointer.this.buffer.duplicate();
                b.position(0);
                b.order(OCachePointer.this.buffer.order());
                return b;
            }
            return null;
        }
    };
    private final long fileId;
    private final long pageIndex;

    public OCachePointer(ByteBuffer buffer, OByteBufferPool bufferPool, OLogSequenceNumber lastFlushedLsn, long fileId, long pageIndex) {
        this.lastFlushedLsn = lastFlushedLsn;
        this.buffer = buffer;
        this.bufferPool = bufferPool;
        this.fileId = fileId;
        this.pageIndex = pageIndex;
    }

    public void setWritersListener(WritersListener writersListener) {
        this.writersListener = writersListener;
    }

    public long getFileId() {
        return this.fileId;
    }

    public long getPageIndex() {
        return this.pageIndex;
    }

    public OLogSequenceNumber getLastFlushedLsn() {
        return this.lastFlushedLsn;
    }

    public void setLastFlushedLsn(OLogSequenceNumber lastFlushedLsn) {
        this.lastFlushedLsn = lastFlushedLsn;
    }

    public void incrementReadersReferrer() {
        long readersWriters = this.readersWritersReferrer.get();
        int readers = this.getReaders(readersWriters);
        int writers = this.getWriters(readersWriters);
        ++readers;
        while (!this.readersWritersReferrer.compareAndSet(readersWriters, this.composeReadersWriters(readers, writers))) {
            readersWriters = this.readersWritersReferrer.get();
            readers = this.getReaders(readersWriters);
            writers = this.getWriters(readersWriters);
            ++readers;
        }
        WritersListener wl = this.writersListener;
        if (wl != null && writers > 0 && readers == 1) {
            wl.removeOnlyWriters(this.fileId, this.pageIndex);
        }
        this.incrementReferrer();
    }

    public void decrementReadersReferrer() {
        long readersWriters = this.readersWritersReferrer.get();
        int readers = this.getReaders(readersWriters);
        int writers = this.getWriters(readersWriters);
        assert (--readers >= 0);
        while (!this.readersWritersReferrer.compareAndSet(readersWriters, this.composeReadersWriters(readers, writers))) {
            readersWriters = this.readersWritersReferrer.get();
            readers = this.getReaders(readersWriters);
            writers = this.getWriters(readersWriters);
            assert (--readers >= 0);
        }
        WritersListener wl = this.writersListener;
        if (wl != null && writers > 0 && readers == 0) {
            wl.addOnlyWriters(this.fileId, this.pageIndex);
        }
        this.decrementReferrer();
    }

    public void incrementWritersReferrer() {
        long readersWriters = this.readersWritersReferrer.get();
        int readers = this.getReaders(readersWriters);
        int writers = this.getWriters(readersWriters);
        ++writers;
        while (!this.readersWritersReferrer.compareAndSet(readersWriters, this.composeReadersWriters(readers, writers))) {
            readersWriters = this.readersWritersReferrer.get();
            readers = this.getReaders(readersWriters);
            writers = this.getWriters(readersWriters);
            ++writers;
        }
        this.incrementReferrer();
    }

    public void decrementWritersReferrer() {
        long readersWriters = this.readersWritersReferrer.get();
        int readers = this.getReaders(readersWriters);
        int writers = this.getWriters(readersWriters);
        assert (--writers >= 0);
        while (!this.readersWritersReferrer.compareAndSet(readersWriters, this.composeReadersWriters(readers, writers))) {
            readersWriters = this.readersWritersReferrer.get();
            readers = this.getReaders(readersWriters);
            writers = this.getWriters(readersWriters);
            assert (--writers >= 0);
        }
        WritersListener wl = this.writersListener;
        if (wl != null && readers == 0 && writers == 0) {
            wl.removeOnlyWriters(this.fileId, this.pageIndex);
        }
        this.decrementReferrer();
    }

    public boolean isLockAcquiredByCurrentThread() {
        return this.readWriteLock.getReadHoldCount() > 0 || this.readWriteLock.isWriteLockedByCurrentThread();
    }

    public void incrementReferrer() {
        this.referrersCount.incrementAndGet();
    }

    public void decrementReferrer() {
        int rf = this.referrersCount.decrementAndGet();
        if (rf == 0 && this.buffer != null) {
            this.bufferPool.release(this.buffer);
        }
        if (rf < 0) {
            throw new IllegalStateException("Invalid direct memory state, number of referrers cannot be negative " + rf);
        }
    }

    public ByteBuffer getSharedBuffer() {
        return this.threadLocalBuffer.get();
    }

    public ByteBuffer getExclusiveBuffer() {
        return this.buffer;
    }

    public void acquireExclusiveLock() {
        this.readWriteLock.writeLock().lock();
    }

    public boolean tryAcquireExclusiveLock() {
        return this.readWriteLock.writeLock().tryLock();
    }

    public void releaseExclusiveLock() {
        this.readWriteLock.writeLock().unlock();
    }

    public void acquireSharedLock() {
        this.readWriteLock.readLock().lock();
    }

    public void releaseSharedLock() {
        this.readWriteLock.readLock().unlock();
    }

    public boolean tryAcquireSharedLock() {
        return this.readWriteLock.readLock().tryLock();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.referrersCount.get() > 0 && this.buffer != null) {
            this.bufferPool.release(this.buffer);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCachePointer that = (OCachePointer)o;
        this.buffer.position(0);
        that.buffer.position(0);
        return !(this.buffer != null ? !this.buffer.equals(that.buffer) : that.buffer != null);
    }

    public int hashCode() {
        return this.buffer != null ? this.buffer.hashCode() : 0;
    }

    public String toString() {
        return "OCachePointer{referrersCount=" + this.referrersCount + ", usagesCount=" + this.usagesCounter + '}';
    }

    private long composeReadersWriters(int readers, int writers) {
        return (long)writers << 32 | (long)readers;
    }

    private int getReaders(long readersWriters) {
        return (int)(readersWriters & 0xFFFFFFFFFFFFFFFFL);
    }

    private int getWriters(long readersWriters) {
        return (int)(readersWriters >>> 32);
    }

    public static interface WritersListener {
        public void addOnlyWriters(long var1, long var3);

        public void removeOnlyWriters(long var1, long var3);
    }
}

