/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache.local;

import com.orientechnologies.common.concur.lock.ODistributedCounter;
import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.concur.lock.OPartitionedLockManager;
import com.orientechnologies.common.concur.lock.OReadersWriterSpinLock;
import com.orientechnologies.common.directmemory.OByteBufferPool;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.exception.OWriteCacheException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import com.orientechnologies.orient.core.storage.cache.OAbstractWriteCache;
import com.orientechnologies.orient.core.storage.cache.OCachePointer;
import com.orientechnologies.orient.core.storage.cache.OPageDataVerificationError;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.cache.local.PageGroup;
import com.orientechnologies.orient.core.storage.fs.OFileClassic;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceInformation;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceListener;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OPerformanceStatisticManager;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OSessionStoragePerformanceStatistic;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.zip.CRC32;

public class OWOWCache
extends OAbstractWriteCache
implements OWriteCache,
OCachePointer.WritersListener {
    private final int MAX_PAGES_PER_FLUSH;
    public static final String NAME_ID_MAP_EXTENSION = ".cm";
    private static final String NAME_ID_MAP = "name_id_map.cm";
    public static final int MIN_CACHE_SIZE = 16;
    public static final long MAGIC_NUMBER = 4207608830L;
    private final long freeSpaceLimit = OGlobalConfiguration.DISK_CACHE_FREE_SPACE_LIMIT.getValueAsLong() * 1024L * 1024L;
    private final int diskSizeCheckInterval = OGlobalConfiguration.DISC_CACHE_FREE_SPACE_CHECK_INTERVAL_IN_PAGES.getValueAsInteger();
    private final List<WeakReference<OLowDiskSpaceListener>> listeners = new CopyOnWriteArrayList<WeakReference<OLowDiskSpaceListener>>();
    private final AtomicLong lastDiskSpaceCheck = new AtomicLong(0L);
    private final String storagePath;
    private final ConcurrentSkipListMap<PageKey, PageGroup> writeCachePages = new ConcurrentSkipListMap();
    private final ConcurrentSkipListSet<PageKey> exclusiveWritePages = new ConcurrentSkipListSet();
    private final ODistributedCounter writeCacheSize = new ODistributedCounter();
    private final ODistributedCounter exclusiveWriteCacheSize = new ODistributedCounter();
    private final ODistributedCounter cacheOverflowCount = new ODistributedCounter();
    private final OBinarySerializer<String> stringSerializer;
    private final ConcurrentMap<Integer, OFileClassic> files;
    private final boolean syncOnPageFlush;
    private final int pageSize;
    private final long groupTTL;
    private final OWriteAheadLog writeAheadLog;
    private final AtomicLong amountOfNewPagesAdded = new AtomicLong();
    private final OPartitionedLockManager<PageKey> lockManager = new OPartitionedLockManager();
    private final OLocalPaginatedStorage storageLocal;
    private final OReadersWriterSpinLock filesLock = new OReadersWriterSpinLock();
    private final ScheduledExecutorService commitExecutor;
    private final ExecutorService lowSpaceEventsPublisher;
    private volatile ConcurrentMap<String, Integer> nameIdMap;
    private RandomAccessFile nameIdMapHolder;
    private final int writeCacheMaxSize;
    private final int cacheMaxSize;
    private int fileCounter = 1;
    private PageKey lastPageKey = new PageKey(0, -1L);
    private PageKey lastWritePageKey = new PageKey(0, -1L);
    private File nameIdMapHolderFile;
    private final int id;
    private final OPerformanceStatisticManager performanceStatisticManager;
    private final OByteBufferPool bufferPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWOWCache(boolean syncOnPageFlush, int pageSize, OByteBufferPool bufferPool, long groupTTL, OWriteAheadLog writeAheadLog, long pageFlushInterval, long writeCacheMaxSize, long cacheMaxSize, OLocalPaginatedStorage storageLocal, boolean checkMinSize, int id) {
        this.filesLock.acquireWriteLock();
        try {
            this.id = id;
            this.files = new ConcurrentHashMap<Integer, OFileClassic>();
            this.syncOnPageFlush = syncOnPageFlush;
            this.pageSize = pageSize;
            this.groupTTL = groupTTL;
            this.writeAheadLog = writeAheadLog;
            this.bufferPool = bufferPool;
            int writeNormalizedSize = this.normalizeMemory(writeCacheMaxSize, pageSize);
            if (checkMinSize && writeNormalizedSize < 16) {
                writeNormalizedSize = 16;
            }
            int normalizedSize = this.normalizeMemory(cacheMaxSize, pageSize);
            if (checkMinSize && normalizedSize < 16) {
                normalizedSize = 16;
            }
            this.writeCacheMaxSize = writeNormalizedSize;
            this.cacheMaxSize = normalizedSize;
            this.storageLocal = storageLocal;
            this.storagePath = storageLocal.getVariableParser().resolveVariables(storageLocal.getStoragePath());
            this.performanceStatisticManager = storageLocal.getPerformanceStatisticManager();
            OBinarySerializerFactory binarySerializerFactory = storageLocal.getComponentsFactory().binarySerializerFactory;
            this.stringSerializer = binarySerializerFactory.getObjectSerializer(OType.STRING);
            this.commitExecutor = Executors.newSingleThreadScheduledExecutor(new FlushThreadFactory(storageLocal.getName()));
            this.lowSpaceEventsPublisher = Executors.newCachedThreadPool(new LowSpaceEventsPublisherFactory(storageLocal.getName()));
            this.MAX_PAGES_PER_FLUSH = (int)(4000.0 / (1000.0 / (double)pageFlushInterval));
            if (pageFlushInterval > 0L) {
                this.commitExecutor.scheduleWithFixedDelay(new PeriodicFlushTask(), pageFlushInterval, pageFlushInterval, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    private int normalizeMemory(long maxSize, int pageSize) {
        long tmpMaxSize = maxSize / (long)pageSize;
        if (tmpMaxSize >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)tmpMaxSize;
    }

    @Override
    public File getRootDirectory() {
        return new File(this.storagePath);
    }

    @Override
    public OPerformanceStatisticManager getPerformanceStatisticManager() {
        return this.performanceStatisticManager;
    }

    @Override
    public void startFuzzyCheckpoints() {
        if (this.writeAheadLog != null) {
            long fuzzyCheckPointInterval = OGlobalConfiguration.WAL_FUZZY_CHECKPOINT_INTERVAL.getValueAsInteger();
            this.commitExecutor.scheduleWithFixedDelay(new PeriodicalFuzzyCheckpointTask(), fuzzyCheckPointInterval, fuzzyCheckPointInterval, TimeUnit.SECONDS);
        }
    }

    @Override
    public void addLowDiskSpaceListener(OLowDiskSpaceListener listener) {
        this.listeners.add(new WeakReference<OLowDiskSpaceListener>(listener));
    }

    @Override
    public void removeLowDiskSpaceListener(OLowDiskSpaceListener listener) {
        ArrayList<WeakReference<OLowDiskSpaceListener>> itemsToRemove = new ArrayList<WeakReference<OLowDiskSpaceListener>>();
        for (WeakReference<OLowDiskSpaceListener> ref : this.listeners) {
            OLowDiskSpaceListener lowDiskSpaceListener = (OLowDiskSpaceListener)ref.get();
            if (lowDiskSpaceListener != null && !lowDiskSpaceListener.equals(listener)) continue;
            itemsToRemove.add(ref);
        }
        for (WeakReference<OLowDiskSpaceListener> ref : itemsToRemove) {
            this.listeners.remove(ref);
        }
    }

    private void freeSpaceCheckAfterNewPageAdd() {
        long lastSpaceCheck;
        long newPagesAdded = this.amountOfNewPagesAdded.incrementAndGet();
        if (newPagesAdded - (lastSpaceCheck = this.lastDiskSpaceCheck.get()) > (long)this.diskSizeCheckInterval || lastSpaceCheck == 0L) {
            File storageDir = new File(this.storagePath);
            long freeSpace = storageDir.getFreeSpace();
            if (freeSpace < this.freeSpaceLimit) {
                this.callLowSpaceListeners(new OLowDiskSpaceInformation(freeSpace, this.freeSpaceLimit));
            }
            this.lastDiskSpaceCheck.lazySet(newPagesAdded);
        }
    }

    private void callLowSpaceListeners(final OLowDiskSpaceInformation information) {
        this.lowSpaceEventsPublisher.execute(new Runnable(){

            @Override
            public void run() {
                for (WeakReference lowDiskSpaceListenerWeakReference : OWOWCache.this.listeners) {
                    OLowDiskSpaceListener listener = (OLowDiskSpaceListener)lowDiskSpaceListenerWeakReference.get();
                    if (listener == null) continue;
                    try {
                        listener.lowDiskSpace(information);
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "Error during notification of low disk space for storage " + OWOWCache.this.storageLocal.getName(), e, new Object[0]);
                    }
                }
            }
        });
    }

    private static int calculatePageCrc(byte[] pageData) {
        int systemSize = 12;
        CRC32 crc32 = new CRC32();
        crc32.update(pageData, 12, pageData.length - 12);
        return (int)crc32.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long bookFileId(String fileName) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            this.initNameIdMapping();
            Integer fileId = (Integer)this.nameIdMap.get(fileName);
            if (fileId != null && fileId < 0) {
                long l = OWOWCache.composeFileId(this.id, -fileId.intValue());
                return l;
            }
            ++this.fileCounter;
            long l = OWOWCache.composeFileId(this.id, this.fileCounter);
            return l;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    @Override
    public boolean fileIdsAreEqual(long firsId, long secondId) {
        int secondIntId;
        int firstIntId = OWOWCache.extractFileId(firsId);
        return firstIntId == (secondIntId = OWOWCache.extractFileId(secondId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long openFile(String fileName) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            this.initNameIdMapping();
            Integer fileId = (Integer)this.nameIdMap.get(fileName);
            OFileClassic fileClassic = fileId == null || fileId < 0 ? null : (OFileClassic)this.files.get(fileId);
            if (fileClassic == null) {
                fileClassic = this.createFile(fileName);
                if (!fileClassic.exists()) {
                    throw new OStorageException("File with name " + fileName + " does not exist in storage " + this.storageLocal.getName());
                }
                OLogManager.instance().debug((Object)this, "File '" + fileName + "' is not registered in 'file name - id' map, but exists in file system. Registering it", new Object[0]);
                if (fileId == null) {
                    ++this.fileCounter;
                    fileId = this.fileCounter;
                } else {
                    fileId = -fileId.intValue();
                }
                this.files.put(fileId, fileClassic);
                this.nameIdMap.put(fileName, fileId);
                this.writeNameIdEntry(new NameFileIdEntry(fileName, fileId), true);
            }
            this.openFile(fileClassic);
            long l = OWOWCache.composeFileId(this.id, fileId);
            return l;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addFile(String fileName) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            this.initNameIdMapping();
            Integer fileId = (Integer)this.nameIdMap.get(fileName);
            if (fileId != null && fileId >= 0) {
                throw new OStorageException("File with name " + fileName + " already exists in storage " + this.storageLocal.getName());
            }
            if (fileId == null) {
                ++this.fileCounter;
                fileId = this.fileCounter;
            } else {
                fileId = -fileId.intValue();
            }
            OFileClassic fileClassic = this.createFile(fileName);
            this.files.put(fileId, fileClassic);
            this.nameIdMap.put(fileName, fileId);
            this.writeNameIdEntry(new NameFileIdEntry(fileName, fileId), true);
            this.addFile(fileClassic);
            long l = OWOWCache.composeFileId(this.id, fileId);
            return l;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public int internalFileId(long fileId) {
        return OWOWCache.extractFileId(fileId);
    }

    @Override
    public long externalFileId(int fileId) {
        return OWOWCache.composeFileId(this.id, fileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openFile(String fileName, long fileId) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            this.initNameIdMapping();
            Integer existingFileId = (Integer)this.nameIdMap.get(fileName);
            if (existingFileId != null && fileId >= 0L) {
                if (existingFileId != OWOWCache.extractFileId(fileId)) {
                    throw new OStorageException("File with given name already exists but has different id " + existingFileId + " vs. proposed " + fileId);
                }
            } else {
                throw new OStorageException("File with name " + fileName + " does not exist in storage " + this.storageLocal.getName());
            }
            OFileClassic fileClassic = (OFileClassic)this.files.get(existingFileId);
            this.openFile(fileClassic);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addFile(String fileName, long fileId) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            this.initNameIdMapping();
            Integer existingFileId = (Integer)this.nameIdMap.get(fileName);
            int intId = OWOWCache.extractFileId(fileId);
            if (existingFileId != null && existingFileId >= 0) {
                if (existingFileId == intId) {
                    throw new OStorageException("File with name '" + fileName + "'' already exists in storage '" + this.storageLocal.getName() + "'");
                }
                throw new OStorageException("File with given name already exists but has different id " + existingFileId + " vs. proposed " + fileId);
            }
            OFileClassic fileClassic = (OFileClassic)this.files.get(intId);
            if (fileClassic != null) {
                throw new OStorageException("File with given id exists but has different name " + fileClassic.getName() + " vs. proposed " + fileName);
            }
            if (this.fileCounter < intId) {
                this.fileCounter = intId;
            }
            fileClassic = this.createFile(fileName);
            this.files.put(intId, fileClassic);
            this.nameIdMap.put(fileName, intId);
            this.writeNameIdEntry(new NameFileIdEntry(fileName, intId), true);
            this.addFile(fileClassic);
            long l = OWOWCache.composeFileId(this.id, intId);
            return l;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public boolean checkLowDiskSpace() {
        File storageDir = new File(this.storagePath);
        long freeSpace = storageDir.getFreeSpace();
        return freeSpace < this.freeSpaceLimit;
    }

    @Override
    public void makeFuzzyCheckpoint() {
        if (this.writeAheadLog != null) {
            this.writeAheadLog.flush();
            Future<?> future = this.commitExecutor.submit(new PeriodicalFuzzyCheckpointTask());
            try {
                future.get();
            }
            catch (Exception e) {
                throw OException.wrapException(new OStorageException("Error during fuzzy checkpoint execution for storage " + this.storageLocal.getName()), e);
            }
        }
    }

    @Override
    public void lock() throws IOException {
        for (OFileClassic file : this.files.values()) {
            file.lock();
        }
    }

    @Override
    public void unlock() throws IOException {
        for (OFileClassic file : this.files.values()) {
            file.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openFile(long fileId) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            this.initNameIdMapping();
            int intId = OWOWCache.extractFileId(fileId);
            OFileClassic fileClassic = (OFileClassic)this.files.get(intId);
            if (fileClassic == null) {
                throw new OStorageException("File with id " + fileId + " does not exist.");
            }
            this.openFile(fileClassic);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String fileName) {
        this.filesLock.acquireReadLock();
        try {
            Integer fileId;
            if (this.nameIdMap != null && (fileId = (Integer)this.nameIdMap.get(fileName)) != null && fileId >= 0) {
                boolean bl = true;
                return bl;
            }
            File file = new File(this.storageLocal.getVariableParser().resolveVariables(this.storageLocal.getStoragePath() + File.separator + fileName));
            boolean bl = file.exists();
            return bl;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(long fileId) {
        this.filesLock.acquireReadLock();
        try {
            int intId = OWOWCache.extractFileId(fileId);
            OFileClassic file = (OFileClassic)this.files.get(intId);
            if (file == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = file.exists();
            return bl;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future store(long fileId, long pageIndex, OCachePointer dataPointer) {
        Future<?> future = null;
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireReadLock();
        try {
            PageKey pageKey = new PageKey(intId, pageIndex);
            Lock groupLock = this.lockManager.acquireExclusiveLock(pageKey);
            try {
                PageGroup pageGroup = this.writeCachePages.get(pageKey);
                if (pageGroup == null) {
                    pageGroup = new PageGroup(System.currentTimeMillis(), dataPointer);
                    this.writeCachePages.put(pageKey, pageGroup);
                    this.writeCacheSize.increment();
                    dataPointer.setWritersListener(this);
                    dataPointer.incrementWritersReferrer();
                }
                assert (pageGroup.page.equals(dataPointer));
                pageGroup.recencyBit = true;
            }
            finally {
                this.lockManager.releaseLock(groupLock);
            }
            if (this.exclusiveWriteCacheSize.get() > (long)this.writeCacheMaxSize) {
                this.cacheOverflowCount.increment();
                future = this.commitExecutor.submit(new PeriodicFlushTask());
            }
            Future<?> future2 = future;
            return future2;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Long> files() {
        this.filesLock.acquireReadLock();
        try {
            HashMap result = new HashMap();
            for (Map.Entry entry : this.nameIdMap.entrySet()) {
                if ((Integer)entry.getValue() <= 0) continue;
                result.put(entry.getKey(), OWOWCache.composeFileId(this.id, (Integer)entry.getValue()));
            }
            HashMap hashMap = result;
            return hashMap;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCachePointer[] load(long fileId, long startPageIndex, int pageCount, boolean addNewPages, OModifiableBoolean cacheHit) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        if (pageCount < 1) {
            throw new IllegalArgumentException("Amount of pages to load should be not less than 1 but provided value is " + pageCount);
        }
        this.filesLock.acquireReadLock();
        try {
            OCachePointer[] oCachePointerArray;
            PageGroup pageGroup;
            Lock[] pageLocks;
            block18: {
                OCachePointer[] pagePointers;
                PageKey[] pageKeys;
                block19: {
                    pageKeys = new PageKey[pageCount];
                    for (int i = 0; i < pageCount; ++i) {
                        pageKeys[i] = new PageKey(intId, startPageIndex + (long)i);
                    }
                    pageLocks = this.lockManager.acquireSharedLocksInBatch((PageKey[])pageKeys);
                    pageGroup = this.writeCachePages.get(pageKeys[0]);
                    if (pageGroup != null) break block18;
                    pagePointers = this.cacheFileContent(fileId, intId, startPageIndex, pageCount, addNewPages, cacheHit);
                    if (pagePointers.length != 0) break block19;
                    OCachePointer[] oCachePointerArray2 = pagePointers;
                    for (Lock lock : pageLocks) {
                        lock.unlock();
                    }
                    return oCachePointerArray2;
                }
                for (int n = 0; n < pagePointers.length; ++n) {
                    pagePointers[n].incrementReadersReferrer();
                    if (n <= 0) continue;
                    pageGroup = this.writeCachePages.get(pageKeys[n]);
                    assert (pageKeys[n].pageIndex == pagePointers[n].getPageIndex());
                    if (pageGroup == null) continue;
                    pagePointers[n].decrementReadersReferrer();
                    pagePointers[n] = pageGroup.page;
                }
                OCachePointer[] oCachePointerArray3 = pagePointers;
                for (Lock lock : pageLocks) {
                    lock.unlock();
                }
                return oCachePointerArray3;
            }
            try {
                OCachePointer pagePointer = pageGroup.page;
                pagePointer.incrementReadersReferrer();
                cacheHit.setValue(true);
                oCachePointerArray = new OCachePointer[]{pagePointer};
            }
            catch (Throwable throwable) {
                for (Lock lock : pageLocks) {
                    lock.unlock();
                }
                throw throwable;
            }
            for (Lock lock : pageLocks) {
                lock.unlock();
            }
            return oCachePointerArray;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    @Override
    public void addOnlyWriters(long fileId, long pageIndex) {
        this.exclusiveWriteCacheSize.increment();
        this.exclusiveWritePages.add(new PageKey(OWOWCache.extractFileId(fileId), pageIndex));
    }

    @Override
    public void removeOnlyWriters(long fileId, long pageIndex) {
        this.exclusiveWriteCacheSize.decrement();
        this.exclusiveWritePages.remove(new PageKey(OWOWCache.extractFileId(fileId), pageIndex));
    }

    @Override
    public void flush(long fileId) {
        Future<Void> future = this.commitExecutor.submit(new FileFlushTask(OWOWCache.extractFileId(fileId)));
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new OInterruptedException("File flush was interrupted");
        }
        catch (Exception e) {
            throw OException.wrapException(new OWriteCacheException("File flush was abnormally terminated"), e);
        }
    }

    @Override
    public void flush() {
        Iterator iterator = this.files.keySet().iterator();
        while (iterator.hasNext()) {
            long fileId = ((Integer)iterator.next()).intValue();
            this.flush(fileId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFilledUpTo(long fileId) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireReadLock();
        try {
            long l = ((OFileClassic)this.files.get(intId)).getFileSize() / (long)this.pageSize;
            return l;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    @Override
    public long getExclusiveWriteCachePagesSize() {
        return this.exclusiveWriteCacheSize.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen(long fileId) {
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireReadLock();
        try {
            OFileClassic fileClassic = (OFileClassic)this.files.get(intId);
            if (fileClassic != null) {
                boolean bl = fileClassic.isOpen();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long isOpen(String fileName) throws IOException {
        Long lightResult = this.isOpenLightCheck(fileName);
        if (lightResult != null) {
            return lightResult;
        }
        this.filesLock.acquireWriteLock();
        try {
            this.initNameIdMapping();
            Integer fileId = (Integer)this.nameIdMap.get(fileName);
            if (fileId == null || fileId < 0) {
                Long l = null;
                return l;
            }
            OFileClassic fileClassic = (OFileClassic)this.files.get(fileId);
            if (fileClassic == null || !fileClassic.isOpen()) {
                Long l = null;
                return l;
            }
            Long l = OWOWCache.composeFileId(this.id, fileId);
            return l;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    private Long isOpenLightCheck(String fileName) {
        ConcurrentMap<String, Integer> map = this.nameIdMap;
        if (map != null) {
            Integer fileId = (Integer)map.get(fileName);
            if (fileId == null || fileId < 0) {
                return null;
            }
            OFileClassic fileClassic = (OFileClassic)this.files.get(fileId);
            if (fileClassic == null || !fileClassic.isOpen()) {
                return null;
            }
            return OWOWCache.composeFileId(this.id, fileId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFile(long fileId) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireWriteLock();
        try {
            String name = this.doDeleteFile(intId);
            if (name != null) {
                this.nameIdMap.put(name, -intId);
                this.writeNameIdEntry(new NameFileIdEntry(name, -intId), true);
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncateFile(long fileId) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireWriteLock();
        try {
            if (!this.isOpen(fileId)) {
                return;
            }
            this.removeCachedPages(intId);
            ((OFileClassic)this.files.get(intId)).shrink(0L);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameFile(long fileId, String oldFileName, String newFileName) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireWriteLock();
        try {
            if (!this.files.containsKey(intId)) {
                return;
            }
            OFileClassic file = (OFileClassic)this.files.get(intId);
            String osFileName = file.getName();
            if (osFileName.startsWith(oldFileName)) {
                File newFile = new File(this.storageLocal.getStoragePath() + File.separator + newFileName + osFileName.substring(osFileName.lastIndexOf(oldFileName) + oldFileName.length()));
                boolean renamed = file.renameTo(newFile);
                while (!renamed) {
                    renamed = file.renameTo(newFile);
                }
            }
            this.nameIdMap.remove(oldFileName);
            this.nameIdMap.put(newFileName, intId);
            this.writeNameIdEntry(new NameFileIdEntry(oldFileName, -1), false);
            this.writeNameIdEntry(new NameFileIdEntry(newFileName, intId), true);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] close() throws IOException {
        this.flush();
        if (!this.commitExecutor.isShutdown()) {
            this.commitExecutor.shutdown();
            try {
                if (!this.commitExecutor.awaitTermination(5L, TimeUnit.MINUTES)) {
                    throw new OWriteCacheException("Background data flush task cannot be stopped.");
                }
            }
            catch (InterruptedException e) {
                OLogManager.instance().error((Object)this, "Data flush thread was interrupted", new Object[0]);
                Thread.interrupted();
                throw OException.wrapException(new OWriteCacheException("Data flush thread was interrupted"), e);
            }
        }
        this.filesLock.acquireWriteLock();
        try {
            long[] result = new long[this.files.size()];
            int counter = 0;
            for (Map.Entry fileEntry : this.files.entrySet()) {
                OFileClassic fileClassic = (OFileClassic)fileEntry.getValue();
                if (fileClassic.isOpen()) {
                    fileClassic.close();
                }
                result[counter++] = OWOWCache.composeFileId(this.id, (Integer)fileEntry.getKey());
            }
            if (this.nameIdMapHolder != null) {
                this.nameIdMapHolder.setLength(0L);
                for (Map.Entry entry : this.nameIdMap.entrySet()) {
                    this.writeNameIdEntry(new NameFileIdEntry((String)entry.getKey(), (Integer)entry.getValue()), false);
                }
                this.nameIdMapHolder.getFD().sync();
                this.nameIdMapHolder.close();
            }
            Iterator iterator = (Iterator)result;
            return iterator;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(long fileId, boolean flush) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireWriteLock();
        try {
            if (!this.isOpen(intId)) {
                return;
            }
            if (flush) {
                this.flush(intId);
            } else {
                this.removeCachedPages(intId);
            }
            ((OFileClassic)this.files.get(intId)).close();
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPageDataVerificationError[] checkStoredPages(OCommandOutputListener commandOutputListener) {
        int notificationTimeOut = 5000;
        ArrayList<OPageDataVerificationError> errors = new ArrayList<OPageDataVerificationError>();
        this.filesLock.acquireWriteLock();
        try {
            for (Map.Entry entry : this.files.entrySet()) {
                boolean fileIsCorrect;
                int fileId = (Integer)entry.getKey();
                OFileClassic fileClassic = (OFileClassic)entry.getValue();
                try {
                    if (commandOutputListener != null) {
                        commandOutputListener.onMessage("Flashing file " + fileClassic.getName() + "... ");
                    }
                    this.flush(fileId);
                    if (commandOutputListener != null) {
                        commandOutputListener.onMessage("Start verification of content of " + fileClassic.getName() + "file ...");
                    }
                    long time = System.currentTimeMillis();
                    long filledUpTo = fileClassic.getFileSize();
                    fileIsCorrect = true;
                    for (long pos = 0L; pos < filledUpTo; pos += (long)this.pageSize) {
                        int calculatedCRC32;
                        int storedCRC32;
                        boolean checkSumIncorrect = false;
                        boolean magicNumberIncorrect = false;
                        byte[] data = new byte[this.pageSize];
                        fileClassic.read(pos, data, data.length);
                        long magicNumber = OLongSerializer.INSTANCE.deserializeNative(data, 0);
                        if (magicNumber != 4207608830L) {
                            magicNumberIncorrect = true;
                            if (commandOutputListener != null) {
                                commandOutputListener.onMessage("Error: Magic number for page " + pos / (long)this.pageSize + " in file " + fileClassic.getName() + " does not much !!!");
                            }
                            fileIsCorrect = false;
                        }
                        if ((storedCRC32 = OIntegerSerializer.INSTANCE.deserializeNative(data, 8)) != (calculatedCRC32 = OWOWCache.calculatePageCrc(data))) {
                            checkSumIncorrect = true;
                            if (commandOutputListener != null) {
                                commandOutputListener.onMessage("Error: Checksum for page " + pos / (long)this.pageSize + " in file " + fileClassic.getName() + " is incorrect !!!");
                            }
                            fileIsCorrect = false;
                        }
                        if (magicNumberIncorrect || checkSumIncorrect) {
                            errors.add(new OPageDataVerificationError(magicNumberIncorrect, checkSumIncorrect, pos / (long)this.pageSize, fileClassic.getName()));
                        }
                        if (commandOutputListener == null || System.currentTimeMillis() - time <= 5000L) continue;
                        time = 5000L;
                        commandOutputListener.onMessage(pos / (long)this.pageSize + " pages were processed ...");
                    }
                }
                catch (IOException ioe) {
                    if (commandOutputListener != null) {
                        commandOutputListener.onMessage("Error: Error during processing of file " + fileClassic.getName() + ". " + ioe.getMessage());
                    }
                    fileIsCorrect = false;
                }
                if (!fileIsCorrect) {
                    if (commandOutputListener == null) continue;
                    commandOutputListener.onMessage("Verification of file " + fileClassic.getName() + " is finished with errors.");
                    continue;
                }
                if (commandOutputListener == null) continue;
                commandOutputListener.onMessage("Verification of file " + fileClassic.getName() + " is successfully finished.");
            }
            OPageDataVerificationError[] oPageDataVerificationErrorArray = errors.toArray(new OPageDataVerificationError[errors.size()]);
            return oPageDataVerificationErrorArray;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] delete() throws IOException {
        long[] result = null;
        this.filesLock.acquireWriteLock();
        try {
            result = new long[this.files.size()];
            int counter = 0;
            Iterator iterator = this.files.keySet().iterator();
            while (iterator.hasNext()) {
                int fileId = (Integer)iterator.next();
                this.doDeleteFile(fileId);
                result[counter++] = OWOWCache.composeFileId(this.id, fileId);
            }
            if (this.nameIdMapHolderFile != null) {
                if (this.nameIdMapHolderFile.exists()) {
                    this.nameIdMapHolder.close();
                    if (!this.nameIdMapHolderFile.delete()) {
                        throw new OStorageException("Cannot delete disk cache file which contains name-id mapping.");
                    }
                }
                this.nameIdMapHolder = null;
                this.nameIdMapHolderFile = null;
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
        if (!this.commitExecutor.isShutdown()) {
            this.commitExecutor.shutdown();
            try {
                if (!this.commitExecutor.awaitTermination(5L, TimeUnit.MINUTES)) {
                    throw new OWriteCacheException("Background data flush task cannot be stopped.");
                }
            }
            catch (InterruptedException e) {
                OLogManager.instance().error((Object)this, "Data flush thread was interrupted", new Object[0]);
                Thread.interrupted();
                throw new OInterruptedException("Data flush thread was interrupted");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String fileNameById(long fileId) {
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireReadLock();
        try {
            OFileClassic f = (OFileClassic)this.files.get(intId);
            String string = f != null ? f.getName() : null;
            return string;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    public long getCacheOverflowCount() {
        return this.cacheOverflowCount.get();
    }

    public long getWriteCacheSize() {
        return this.writeCacheSize.get();
    }

    public long getExclusiveWriteCacheSize() {
        return this.exclusiveWriteCacheSize.get();
    }

    private void openFile(OFileClassic fileClassic) throws IOException {
        if (fileClassic.exists()) {
            if (!fileClassic.isOpen()) {
                fileClassic.open();
            }
        } else {
            throw new OStorageException("File " + fileClassic + " does not exist.");
        }
    }

    private void addFile(OFileClassic fileClassic) throws IOException {
        if (fileClassic.exists()) {
            throw new OStorageException("File '" + fileClassic.getName() + "' already exists.");
        }
        fileClassic.create();
        fileClassic.synch();
    }

    private void initNameIdMapping() throws IOException {
        if (this.nameIdMapHolder == null) {
            File storagePath = new File(this.storageLocal.getStoragePath());
            if (!storagePath.exists() && !storagePath.mkdirs()) {
                throw new OStorageException("Cannot create directories for the path '" + storagePath + "'");
            }
            this.nameIdMapHolderFile = new File(storagePath, NAME_ID_MAP);
            this.nameIdMapHolder = new RandomAccessFile(this.nameIdMapHolderFile, "rw");
            this.readNameIdMap();
        }
    }

    private OFileClassic createFile(String fileName) {
        String path = this.storageLocal.getVariableParser().resolveVariables(this.storageLocal.getStoragePath() + File.separator + fileName);
        OFileClassic fileClassic = new OFileClassic(path, this.storageLocal.getMode());
        return fileClassic;
    }

    private void readNameIdMap() throws IOException {
        NameFileIdEntry nameFileIdEntry;
        this.nameIdMap = new ConcurrentHashMap<String, Integer>();
        long localFileCounter = -1L;
        this.nameIdMapHolder.seek(0L);
        while ((nameFileIdEntry = this.readNextNameIdEntry()) != null) {
            long absFileId = Math.abs(nameFileIdEntry.fileId);
            if (localFileCounter < absFileId) {
                localFileCounter = absFileId;
            }
            this.nameIdMap.put(nameFileIdEntry.name, nameFileIdEntry.fileId);
        }
        if (localFileCounter > 0L) {
            this.fileCounter = (int)localFileCounter;
        }
        for (Map.Entry nameIdEntry : this.nameIdMap.entrySet()) {
            if ((Integer)nameIdEntry.getValue() < 0 || this.files.containsKey(nameIdEntry.getValue())) continue;
            OFileClassic fileClassic = this.createFile((String)nameIdEntry.getKey());
            if (fileClassic.exists()) {
                this.files.put((Integer)nameIdEntry.getValue(), fileClassic);
                continue;
            }
            Integer fileId = (Integer)this.nameIdMap.get(nameIdEntry.getKey());
            if (fileId == null || fileId <= 0) continue;
            this.nameIdMap.put((String)nameIdEntry.getKey(), -fileId.intValue());
        }
    }

    private NameFileIdEntry readNextNameIdEntry() throws IOException {
        try {
            int nameSize = this.nameIdMapHolder.readInt();
            byte[] serializedName = new byte[nameSize];
            this.nameIdMapHolder.readFully(serializedName);
            String name = this.stringSerializer.deserialize(serializedName, 0);
            int fileId = (int)this.nameIdMapHolder.readLong();
            return new NameFileIdEntry(name, fileId);
        }
        catch (EOFException eof) {
            return null;
        }
    }

    private void writeNameIdEntry(NameFileIdEntry nameFileIdEntry, boolean sync) throws IOException {
        this.nameIdMapHolder.seek(this.nameIdMapHolder.length());
        int nameSize = this.stringSerializer.getObjectSize(nameFileIdEntry.name, new Object[0]);
        byte[] serializedRecord = new byte[4 + nameSize + 8];
        OIntegerSerializer.INSTANCE.serializeLiteral(nameSize, serializedRecord, 0);
        this.stringSerializer.serialize(nameFileIdEntry.name, serializedRecord, 4, new Object[0]);
        OLongSerializer.INSTANCE.serializeLiteral(nameFileIdEntry.fileId, serializedRecord, 4 + nameSize);
        this.nameIdMapHolder.write(serializedRecord);
        if (sync) {
            this.nameIdMapHolder.getFD().sync();
        }
    }

    private String doDeleteFile(int fileId) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        if (this.isOpen(fileId)) {
            this.removeCachedPages(intId);
        }
        OFileClassic fileClassic = (OFileClassic)this.files.remove(fileId);
        String name = null;
        if (fileClassic != null) {
            name = fileClassic.getName();
            if (fileClassic.exists()) {
                fileClassic.delete();
            }
        }
        return name;
    }

    private void removeCachedPages(int fileId) {
        Future<Void> future = this.commitExecutor.submit(new RemoveFilePagesTask(fileId));
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new OInterruptedException("File data removal was interrupted");
        }
        catch (Exception e) {
            throw OException.wrapException(new OWriteCacheException("File data removal was abnormally terminated"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OCachePointer[] cacheFileContent(long fileId, int intId, long startPageIndex, int pageCount, boolean addNewPages, OModifiableBoolean cacheHit) throws IOException {
        OFileClassic fileClassic = (OFileClassic)this.files.get(intId);
        if (fileClassic == null) {
            throw new IllegalArgumentException("File with id " + intId + " not found in WOW Cache");
        }
        OLogSequenceNumber lastLsn = this.writeAheadLog != null ? this.writeAheadLog.getFlushedLsn() : new OLogSequenceNumber(-1L, -1L);
        long firstPageStartPosition = startPageIndex * (long)this.pageSize;
        long firstPageEndPosition = firstPageStartPosition + (long)this.pageSize;
        if (fileClassic.getFileSize() >= firstPageEndPosition) {
            OSessionStoragePerformanceStatistic sessionStoragePerformanceStatistic = this.performanceStatisticManager.getSessionPerformanceStatistic();
            if (sessionStoragePerformanceStatistic != null) {
                sessionStoragePerformanceStatistic.startPageReadFromFileTimer();
            }
            int pagesRead = 0;
            try {
                int n;
                if (pageCount == 1) {
                    ByteBuffer buffer = this.bufferPool.acquireDirect(false);
                    fileClassic.read(firstPageStartPosition, buffer);
                    buffer.position(0);
                    OCachePointer dataPointer = new OCachePointer(buffer, this.bufferPool, lastLsn, fileId, startPageIndex);
                    pagesRead = 1;
                    OCachePointer[] oCachePointerArray = new OCachePointer[]{dataPointer};
                    return oCachePointerArray;
                }
                long maxPageCount = (fileClassic.getFileSize() - firstPageStartPosition) / (long)this.pageSize;
                int realPageCount = Math.min((int)maxPageCount, pageCount);
                ByteBuffer[] buffers = new ByteBuffer[realPageCount];
                for (int i = 0; i < buffers.length; ++i) {
                    buffers[i] = this.bufferPool.acquireDirect(false);
                    assert (buffers[i].position() == 0);
                }
                long bytesRead = fileClassic.read(firstPageStartPosition, buffers);
                assert (bytesRead % (long)this.pageSize == 0L);
                int buffersRead = (int)(bytesRead / (long)this.pageSize);
                OCachePointer[] dataPointers = new OCachePointer[buffersRead];
                for (n = 0; n < buffersRead; ++n) {
                    buffers[n].position(0);
                    dataPointers[n] = new OCachePointer(buffers[n], this.bufferPool, lastLsn, fileId, startPageIndex + (long)n);
                }
                for (n = buffersRead; n < buffers.length; ++n) {
                    this.bufferPool.release(buffers[n]);
                }
                pagesRead = dataPointers.length;
                OCachePointer[] oCachePointerArray = dataPointers;
                return oCachePointerArray;
            }
            finally {
                if (sessionStoragePerformanceStatistic != null) {
                    sessionStoragePerformanceStatistic.stopPageReadFromFileTimer(pagesRead);
                }
            }
        }
        if (addNewPages) {
            int space = (int)(firstPageEndPosition - fileClassic.getFileSize());
            if (space > 0) {
                fileClassic.allocateSpace(space);
            }
            this.freeSpaceCheckAfterNewPageAdd();
            ByteBuffer buffer = this.bufferPool.acquireDirect(true);
            OCachePointer dataPointer = new OCachePointer(buffer, this.bufferPool, lastLsn, fileId, startPageIndex);
            cacheHit.setValue(true);
            return new OCachePointer[]{dataPointer};
        }
        return new OCachePointer[0];
    }

    private void flushPage(int fileId, long pageIndex, ByteBuffer buffer) throws IOException {
        if (this.writeAheadLog != null) {
            OLogSequenceNumber lsn = ODurablePage.getLogSequenceNumberFromPage(buffer);
            OLogSequenceNumber flushedLSN = this.writeAheadLog.getFlushedLsn();
            if (flushedLSN == null || flushedLSN.compareTo(lsn) < 0) {
                this.writeAheadLog.flush();
            }
        }
        byte[] content = new byte[this.pageSize];
        buffer.position(0);
        buffer.get(content);
        OLongSerializer.INSTANCE.serializeNative(4207608830L, content, 0, new Object[0]);
        int crc32 = OWOWCache.calculatePageCrc(content);
        OIntegerSerializer.INSTANCE.serializeNative(crc32, content, 8, new Object[0]);
        OFileClassic fileClassic = (OFileClassic)this.files.get(fileId);
        fileClassic.write(pageIndex * (long)this.pageSize, content);
        if (this.syncOnPageFlush) {
            fileClassic.synch();
        }
    }

    private static class LowSpaceEventsPublisherFactory
    implements ThreadFactory {
        private final String storageName;

        private LowSpaceEventsPublisherFactory(String storageName) {
            this.storageName = storageName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(OStorageAbstract.storageThreadGroup, r);
            thread.setDaemon(true);
            thread.setName("OrientDB Low Disk Space Publisher (" + this.storageName + ")");
            return thread;
        }
    }

    private static class FlushThreadFactory
    implements ThreadFactory {
        private final String storageName;

        private FlushThreadFactory(String storageName) {
            this.storageName = storageName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(OStorageAbstract.storageThreadGroup, r);
            thread.setDaemon(true);
            thread.setPriority(10);
            thread.setName("OrientDB Write Cache Flush Task (" + this.storageName + ")");
            return thread;
        }
    }

    private final class RemoveFilePagesTask
    implements Callable<Void> {
        private final int fileId;

        private RemoveFilePagesTask(int fileId) {
            this.fileId = fileId;
        }

        @Override
        public Void call() throws Exception {
            PageKey firstKey = new PageKey(this.fileId, 0L);
            PageKey lastKey = new PageKey(this.fileId, Long.MAX_VALUE);
            this.removeFromRing(OWOWCache.this.writeCachePages.subMap(firstKey, true, lastKey, true));
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeFromRing(NavigableMap<PageKey, PageGroup> subMap) {
            Iterator entryIterator = subMap.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry entry = entryIterator.next();
                PageGroup pageGroup = (PageGroup)entry.getValue();
                PageKey pageKey = (PageKey)entry.getKey();
                Lock groupLock = OWOWCache.this.lockManager.acquireExclusiveLock(pageKey);
                try {
                    OCachePointer pagePointer = pageGroup.page;
                    pagePointer.acquireExclusiveLock();
                    try {
                        pagePointer.decrementWritersReferrer();
                        pagePointer.setWritersListener(null);
                        OWOWCache.this.writeCacheSize.decrement();
                    }
                    finally {
                        pagePointer.releaseExclusiveLock();
                    }
                    entryIterator.remove();
                }
                finally {
                    OWOWCache.this.lockManager.releaseLock(groupLock);
                }
            }
        }
    }

    private final class FileFlushTask
    implements Callable<Void> {
        private final int fileId;

        private FileFlushTask(int fileId) {
            this.fileId = fileId;
        }

        @Override
        public Void call() throws Exception {
            PageKey firstKey = new PageKey(this.fileId, 0L);
            PageKey lastKey = new PageKey(this.fileId, Long.MAX_VALUE);
            this.flushRing(OWOWCache.this.writeCachePages.subMap(firstKey, true, lastKey, true));
            ((OFileClassic)OWOWCache.this.files.get(this.fileId)).synch();
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushRing(NavigableMap<PageKey, PageGroup> subMap) throws IOException {
            Iterator entryIterator = subMap.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry entry = entryIterator.next();
                PageGroup pageGroup = (PageGroup)entry.getValue();
                PageKey pageKey = (PageKey)entry.getKey();
                Lock groupLock = OWOWCache.this.lockManager.acquireExclusiveLock(pageKey);
                try {
                    OCachePointer pagePointer = pageGroup.page;
                    if (!pagePointer.tryAcquireSharedLock()) continue;
                    try {
                        ByteBuffer buffer = pagePointer.getSharedBuffer();
                        OWOWCache.this.flushPage(pageKey.fileId, pageKey.pageIndex, buffer);
                    }
                    finally {
                        pagePointer.releaseSharedLock();
                    }
                    pagePointer.decrementWritersReferrer();
                    pagePointer.setWritersListener(null);
                    OWOWCache.this.writeCacheSize.decrement();
                    entryIterator.remove();
                }
                finally {
                    OWOWCache.this.lockManager.releaseLock(groupLock);
                }
            }
        }
    }

    private final class PeriodicalFuzzyCheckpointTask
    implements Runnable {
        private PeriodicalFuzzyCheckpointTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            OSessionStoragePerformanceStatistic statistic = OWOWCache.this.performanceStatisticManager.getSessionPerformanceStatistic();
            if (statistic != null) {
                statistic.startFuzzyCheckpointTimer();
            }
            try {
                OLogSequenceNumber minLsn = OWOWCache.this.writeAheadLog.getFlushedLsn();
                minLsn = this.findMinLsn(minLsn, OWOWCache.this.writeCachePages);
                OLogManager.instance().debug((Object)this, "Start fuzzy checkpoint flushed LSN is %s", minLsn);
                try {
                    OWOWCache.this.writeAheadLog.logFuzzyCheckPointStart(minLsn);
                    for (OFileClassic fileClassic : OWOWCache.this.files.values()) {
                        fileClassic.synch();
                    }
                    OWOWCache.this.writeAheadLog.logFuzzyCheckPointEnd();
                    OWOWCache.this.writeAheadLog.flush();
                    if (minLsn.compareTo(new OLogSequenceNumber(-1L, -1L)) > 0) {
                        OWOWCache.this.writeAheadLog.cutTill(minLsn);
                    }
                }
                catch (IOException ioe) {
                    OLogManager.instance().error((Object)this, "Error during fuzzy checkpoint", ioe, new Object[0]);
                }
                OLogManager.instance().debug((Object)this, "End fuzzy checkpoint", new Object[0]);
            }
            finally {
                if (statistic != null) {
                    statistic.stopFuzzyCheckpointTimer();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private OLogSequenceNumber findMinLsn(OLogSequenceNumber minLsn, ConcurrentSkipListMap<PageKey, PageGroup> ring) {
            for (Map.Entry<PageKey, PageGroup> entry : ring.entrySet()) {
                Lock groupLock = OWOWCache.this.lockManager.acquireExclusiveLock(entry.getKey());
                try {
                    PageGroup group = entry.getValue();
                    OCachePointer pagePointer = group.page;
                    if (pagePointer.getLastFlushedLsn() == null || minLsn.compareTo(pagePointer.getLastFlushedLsn()) <= 0) continue;
                    minLsn = pagePointer.getLastFlushedLsn();
                }
                finally {
                    OWOWCache.this.lockManager.releaseLock(groupLock);
                }
            }
            return minLsn;
        }
    }

    private final class PeriodicFlushTask
    implements Runnable {
        private PeriodicFlushTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            OSessionStoragePerformanceStatistic statistic = OWOWCache.this.performanceStatisticManager.getSessionPerformanceStatistic();
            if (statistic != null) {
                statistic.startWriteCacheFlushTimer();
            }
            int flushedPages = 0;
            boolean iterateByWritePagesFirst = false;
            try {
                double cacheThreshold;
                if (OWOWCache.this.writeCachePages.isEmpty()) {
                    return;
                }
                int writePagesToFlush = 0;
                long wcs = OWOWCache.this.exclusiveWriteCacheSize.get();
                long cs = OWOWCache.this.writeCacheSize.get();
                boolean forceFlush = false;
                double writeCacheThreshold = (double)wcs / (double)OWOWCache.this.writeCacheMaxSize;
                if (writeCacheThreshold > 0.3) {
                    writePagesToFlush = (int)Math.floor((writeCacheThreshold - 0.3) / 0.4 * (double)OWOWCache.this.MAX_PAGES_PER_FLUSH);
                    iterateByWritePagesFirst = true;
                    if (writeCacheThreshold > 0.7) {
                        forceFlush = true;
                    }
                }
                if ((cacheThreshold = (double)cs / (double)OWOWCache.this.cacheMaxSize) > 0.3) {
                    int pagesToFlush = (int)Math.floor((cacheThreshold - 0.3) / 0.4 * (double)OWOWCache.this.MAX_PAGES_PER_FLUSH);
                    writePagesToFlush = Math.max(pagesToFlush, writePagesToFlush);
                    if (cacheThreshold > 0.7) {
                        forceFlush = true;
                    }
                }
                if ((flushedPages = this.flushRing(writePagesToFlush = Math.max(4, Math.min(OWOWCache.this.MAX_PAGES_PER_FLUSH, writePagesToFlush)), flushedPages, false, iterateByWritePagesFirst)) < writePagesToFlush) {
                    flushedPages = this.flushRing(writePagesToFlush, flushedPages, false, iterateByWritePagesFirst);
                }
                if (flushedPages < writePagesToFlush && iterateByWritePagesFirst) {
                    flushedPages = this.flushRing(writePagesToFlush, flushedPages, false, false);
                }
                if (flushedPages < writePagesToFlush && forceFlush && (flushedPages = this.flushRing(writePagesToFlush, flushedPages, true, iterateByWritePagesFirst)) < writePagesToFlush && iterateByWritePagesFirst && (flushedPages = this.flushRing(writePagesToFlush, flushedPages, true, false)) < writePagesToFlush) {
                    flushedPages = this.flushRing(writePagesToFlush, flushedPages, true, false);
                }
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Exception during data flush", e, new Object[0]);
            }
            catch (RuntimeException e) {
                OLogManager.instance().error((Object)this, "Exception during data flush", e, new Object[0]);
            }
            finally {
                if (statistic != null) {
                    statistic.stopWriteCacheFlushTimer(flushedPages);
                }
            }
        }

        private int flushRing(int writePagesToFlush, int flushedPages, boolean forceFlush, boolean iterateByWritePagesFirst) throws IOException {
            NavigableMap subMap = null;
            NavigableSet<PageKey> writePagesSubset = null;
            if (iterateByWritePagesFirst) {
                writePagesSubset = OWOWCache.this.exclusiveWritePages.tailSet(OWOWCache.this.lastWritePageKey, false);
            } else {
                subMap = OWOWCache.this.writeCachePages.tailMap(OWOWCache.this.lastPageKey, false);
            }
            flushedPages = this.iterateBySubRing(subMap, writePagesSubset, writePagesToFlush, flushedPages, forceFlush, iterateByWritePagesFirst);
            if (flushedPages < writePagesToFlush) {
                flushedPages = this.iterateBySubRing(OWOWCache.this.writeCachePages, OWOWCache.this.exclusiveWritePages, writePagesToFlush, flushedPages, forceFlush, iterateByWritePagesFirst);
            }
            return flushedPages;
        }

        private int iterateBySubRing(NavigableMap<PageKey, PageGroup> subMap, NavigableSet<PageKey> subSet, int writePagesToFlush, int flushedWritePages, boolean forceFlush, boolean iterateByWritePagesFirst) throws IOException {
            if (!iterateByWritePagesFirst) {
                return this.iterateByCacheSubRing(subMap, writePagesToFlush, flushedWritePages, forceFlush);
            }
            return this.iterateByWritePagesSubRing(subSet, writePagesToFlush, flushedWritePages, forceFlush);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int iterateByWritePagesSubRing(NavigableSet<PageKey> subSet, int writePagesToFlush, int flushedWritePages, boolean forceFlush) throws IOException {
            Iterator<PageKey> entriesIterator = subSet.iterator();
            long currentTime = System.currentTimeMillis();
            int flushedRegions = 0;
            long lastPageIndex = -1L;
            while (entriesIterator.hasNext()) {
                PageKey entry;
                block12: {
                    entry = entriesIterator.next();
                    if (lastPageIndex >= 0L && entry.pageIndex != lastPageIndex + 1L) {
                        ++flushedRegions;
                    }
                    if (flushedWritePages > writePagesToFlush && flushedRegions >= 4) break;
                    Lock groupLock = OWOWCache.this.lockManager.acquireExclusiveLock(entry);
                    try {
                        boolean weakLockMode;
                        PageGroup group = (PageGroup)OWOWCache.this.writeCachePages.get(entry);
                        if (group == null) {
                            entriesIterator.remove();
                            continue;
                        }
                        boolean bl = weakLockMode = group.creationTime - currentTime < OWOWCache.this.groupTTL && !forceFlush;
                        if (group.recencyBit && weakLockMode) {
                            group.recencyBit = false;
                            break block12;
                        }
                        group.recencyBit = false;
                        OCachePointer pagePointer = group.page;
                        if (!pagePointer.tryAcquireSharedLock()) continue;
                        try {
                            ByteBuffer buffer = pagePointer.getSharedBuffer();
                            OWOWCache.this.flushPage(entry.fileId, entry.pageIndex, buffer);
                            OLogSequenceNumber flushedLSN = ODurablePage.getLogSequenceNumberFromPage(buffer);
                            pagePointer.setLastFlushedLsn(flushedLSN);
                        }
                        finally {
                            pagePointer.releaseSharedLock();
                        }
                        pagePointer.decrementWritersReferrer();
                        pagePointer.setWritersListener(null);
                        entriesIterator.remove();
                        OWOWCache.this.writeCachePages.remove(entry);
                    }
                    finally {
                        OWOWCache.this.lockManager.releaseLock(groupLock);
                        continue;
                    }
                }
                OWOWCache.this.lastWritePageKey = entry;
                ++flushedWritePages;
                lastPageIndex = entry.pageIndex;
                OWOWCache.this.writeCacheSize.decrement();
            }
            return flushedWritePages;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int iterateByCacheSubRing(NavigableMap<PageKey, PageGroup> subMap, int writePagesToFlush, int flushedWritePages, boolean forceFlush) throws IOException {
            Iterator entriesIterator = subMap.entrySet().iterator();
            long currentTime = System.currentTimeMillis();
            int flushedRegions = 0;
            long lastPageIndex = -1L;
            while (entriesIterator.hasNext()) {
                PageKey pageKey;
                block10: {
                    boolean weakLockMode;
                    Map.Entry entry = entriesIterator.next();
                    PageGroup group = (PageGroup)entry.getValue();
                    pageKey = (PageKey)entry.getKey();
                    if (lastPageIndex >= 0L && pageKey.pageIndex != lastPageIndex + 1L && flushedWritePages > writePagesToFlush && ++flushedRegions >= 4) break;
                    boolean bl = weakLockMode = group.creationTime - currentTime < OWOWCache.this.groupTTL && !forceFlush;
                    if (group.recencyBit && weakLockMode) {
                        group.recencyBit = false;
                        continue;
                    }
                    Lock groupLock = OWOWCache.this.lockManager.acquireExclusiveLock(entry.getKey());
                    try {
                        if (group.recencyBit && weakLockMode) {
                            group.recencyBit = false;
                            break block10;
                        }
                        group.recencyBit = false;
                        OCachePointer pagePointer = group.page;
                        if (!pagePointer.tryAcquireSharedLock()) continue;
                        try {
                            ByteBuffer buffer = pagePointer.getSharedBuffer();
                            OWOWCache.this.flushPage(pageKey.fileId, pageKey.pageIndex, buffer);
                            OLogSequenceNumber flushedLSN = ODurablePage.getLogSequenceNumberFromPage(buffer);
                            pagePointer.setLastFlushedLsn(flushedLSN);
                        }
                        finally {
                            pagePointer.releaseSharedLock();
                        }
                        pagePointer.decrementWritersReferrer();
                        pagePointer.setWritersListener(null);
                        entriesIterator.remove();
                    }
                    finally {
                        OWOWCache.this.lockManager.releaseLock(groupLock);
                        continue;
                    }
                }
                OWOWCache.this.lastPageKey = pageKey;
                ++flushedWritePages;
                lastPageIndex = pageKey.pageIndex;
                OWOWCache.this.writeCacheSize.decrement();
            }
            return flushedWritePages;
        }
    }

    private static final class PageKey
    implements Comparable<PageKey> {
        private final int fileId;
        private final long pageIndex;

        private PageKey(int fileId, long pageIndex) {
            this.fileId = fileId;
            this.pageIndex = pageIndex;
        }

        @Override
        public int compareTo(PageKey other) {
            if (this.fileId > other.fileId) {
                return 1;
            }
            if (this.fileId < other.fileId) {
                return -1;
            }
            if (this.pageIndex > other.pageIndex) {
                return 1;
            }
            if (this.pageIndex < other.pageIndex) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PageKey pageKey = (PageKey)o;
            if (this.fileId != pageKey.fileId) {
                return false;
            }
            return this.pageIndex == pageKey.pageIndex;
        }

        public int hashCode() {
            int result = this.fileId;
            result = 31 * result + (int)(this.pageIndex ^ this.pageIndex >>> 32);
            return result;
        }

        public String toString() {
            return "PageKey{fileId=" + this.fileId + ", pageIndex=" + this.pageIndex + '}';
        }
    }

    private static final class NameFileIdEntry {
        private final String name;
        private final int fileId;

        private NameFileIdEntry(String name, int fileId) {
            this.name = name;
            this.fileId = fileId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NameFileIdEntry that = (NameFileIdEntry)o;
            if (this.fileId != that.fileId) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.fileId;
            return result;
        }
    }
}

