/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations;

import com.orientechnologies.common.concur.lock.ODistributedCounter;
import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.concur.lock.OOneEntryPerKeyLockManager;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.OOrientListenerAbstract;
import com.orientechnologies.orient.core.OUncompletedCommit;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsMangerMXBean;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.ONestedRollbackException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ONonTxOperationPerformedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OPerformanceStatisticManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class OAtomicOperationsManager
implements OAtomicOperationsMangerMXBean {
    public static final String MBEAN_NAME = "com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations:type=OAtomicOperationsMangerMXBean";
    private volatile boolean trackAtomicOperations = OGlobalConfiguration.TX_TRACK_ATOMIC_OPERATIONS.getValueAsBoolean();
    private final AtomicBoolean mbeanIsRegistered = new AtomicBoolean();
    private final ODistributedCounter atomicOperationsCount = new ODistributedCounter();
    private final AtomicInteger freezeRequests = new AtomicInteger();
    private final ConcurrentMap<Long, FreezeParameters> freezeParametersIdMap = new ConcurrentHashMap<Long, FreezeParameters>();
    private final AtomicLong freezeIdGen = new AtomicLong();
    private final AtomicReference<WaitingListNode> waitingHead = new AtomicReference();
    private final AtomicReference<WaitingListNode> waitingTail = new AtomicReference();
    private static volatile ThreadLocal<OAtomicOperation> currentOperation = new ThreadLocal();
    private final OPerformanceStatisticManager performanceStatisticManager;
    private static final ThreadLocal<Boolean> unsafeMode = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private final OAbstractPaginatedStorage storage;
    private final OWriteAheadLog writeAheadLog;
    private final OOneEntryPerKeyLockManager<String> lockManager = new OOneEntryPerKeyLockManager(true, -1, OGlobalConfiguration.COMPONENTS_LOCK_CACHE.getValueAsInteger());
    private final OReadCache readCache;
    private final OWriteCache writeCache;
    private final Map<OOperationUnitId, OPair<String, StackTraceElement[]>> activeAtomicOperations = new ConcurrentHashMap<OOperationUnitId, OPair<String, StackTraceElement[]>>();

    public OAtomicOperationsManager(OAbstractPaginatedStorage storage) {
        this.storage = storage;
        this.writeAheadLog = storage.getWALInstance();
        this.readCache = storage.getReadCache();
        this.writeCache = storage.getWriteCache();
        this.performanceStatisticManager = storage.getPerformanceStatisticManager();
        this.performanceStatisticManager.registerComponent("atomic operation");
    }

    public OAtomicOperation startAtomicOperation(ODurableComponent durableComponent, boolean trackNonTxOperations) throws IOException {
        if (durableComponent != null) {
            return this.startAtomicOperation(durableComponent.getFullName(), trackNonTxOperations);
        }
        return this.startAtomicOperation((String)null, trackNonTxOperations);
    }

    public OAtomicOperation startAtomicOperation(String lockName, boolean trackNonTxOperations) throws IOException {
        if (unsafeMode.get().booleanValue() || this.writeAheadLog == null) {
            return null;
        }
        OAtomicOperation operation = currentOperation.get();
        if (operation != null) {
            operation.incrementCounter();
            if (lockName != null) {
                this.acquireExclusiveLockTillOperationComplete(operation, lockName);
            }
            return operation;
        }
        this.atomicOperationsCount.increment();
        while (this.freezeRequests.get() > 0) {
            assert (this.freezeRequests.get() >= 0);
            this.atomicOperationsCount.decrement();
            this.throwFreezeExceptionIfNeeded();
            Thread thread = Thread.currentThread();
            this.addThreadInWaitingList(thread);
            if (this.freezeRequests.get() > 0) {
                LockSupport.park(this);
            }
            this.atomicOperationsCount.increment();
        }
        assert (this.freezeRequests.get() >= 0);
        OOperationUnitId unitId = OOperationUnitId.generateId();
        OLogSequenceNumber lsn = this.writeAheadLog.logAtomicOperationStartRecord(true, unitId);
        operation = new OAtomicOperation(lsn, unitId, this.readCache, this.writeCache, this.storage.getId(), this.performanceStatisticManager);
        currentOperation.set(operation);
        if (this.trackAtomicOperations) {
            Thread thread = Thread.currentThread();
            this.activeAtomicOperations.put(unitId, new OPair<String, StackTraceElement[]>(thread.getName(), thread.getStackTrace()));
        }
        if (trackNonTxOperations && this.storage.getStorageTransaction() == null) {
            this.writeAheadLog.log(new ONonTxOperationPerformedWALRecord());
        }
        if (lockName != null) {
            this.acquireExclusiveLockTillOperationComplete(operation, lockName);
        }
        return operation;
    }

    public void switchOnUnsafeMode() {
        unsafeMode.set(true);
    }

    public void switchOffUnsafeMode() {
        unsafeMode.set(false);
    }

    private void addThreadInWaitingList(Thread thread) {
        WaitingListNode last;
        WaitingListNode node = new WaitingListNode(thread);
        while (!this.waitingTail.compareAndSet(last = this.waitingTail.get(), node)) {
        }
        if (last == null) {
            this.waitingHead.set(node);
        } else {
            last.next = node;
        }
        node.linkLatch.countDown();
    }

    private WaitingListNode cutWaitingList() {
        WaitingListNode head;
        WaitingListNode tail;
        while (true) {
            tail = this.waitingTail.get();
            head = this.waitingHead.get();
            if (tail == null) {
                return null;
            }
            if (head == null) {
                Thread.yield();
                continue;
            }
            if (head == tail) {
                return new WaitingListNode(head.item);
            }
            if (this.waitingHead.compareAndSet(head, tail)) break;
        }
        WaitingListNode node = head;
        node.waitTillAllLinksWillBeCreated();
        while (node.next != tail) {
            node = node.next;
            node.waitTillAllLinksWillBeCreated();
        }
        node.next = new WaitingListNode(tail.item);
        return head;
    }

    public long freezeAtomicOperations(Class<? extends OException> exceptionClass, String message) {
        long id = this.freezeIdGen.incrementAndGet();
        this.freezeRequests.incrementAndGet();
        this.freezeParametersIdMap.put(id, new FreezeParameters(message, exceptionClass));
        while (this.atomicOperationsCount.get() > 0L) {
            Thread.yield();
        }
        assert (this.atomicOperationsCount.get() == 0L);
        return id;
    }

    public void releaseAtomicOperations(long id) {
        FreezeParameters freezeParameters;
        if (id >= 0L && (freezeParameters = (FreezeParameters)this.freezeParametersIdMap.remove(id)) == null) {
            throw new IllegalStateException("Invalid value for freeze id " + id);
        }
        HashMap<Long, FreezeParameters> freezeParametersMap = new HashMap<Long, FreezeParameters>(this.freezeParametersIdMap);
        long requests = this.freezeRequests.decrementAndGet();
        if (requests == 0L) {
            for (Long freezeId : freezeParametersMap.keySet()) {
                this.freezeParametersIdMap.remove(freezeId);
            }
            WaitingListNode node = this.cutWaitingList();
            while (node != null) {
                LockSupport.unpark(node.item);
                node = node.next;
            }
        }
    }

    private void throwFreezeExceptionIfNeeded() {
        for (FreezeParameters freezeParameters : this.freezeParametersIdMap.values()) {
            if (freezeParameters.exceptionClass == null) continue;
            if (freezeParameters.message != null) {
                try {
                    Constructor mConstructor = freezeParameters.exceptionClass.getConstructor(String.class);
                    throw (OException)mConstructor.newInstance(freezeParameters.message);
                }
                catch (InstantiationException ie) {
                    OLogManager.instance().error((Object)this, "Can not create instance of exception " + freezeParameters.exceptionClass + " with message will try empty constructor instead", ie, new Object[0]);
                    this.throwFreezeExceptionWithoutMessage(freezeParameters);
                    continue;
                }
                catch (IllegalAccessException iae) {
                    OLogManager.instance().error((Object)this, "Can not create instance of exception " + freezeParameters.exceptionClass + " with message will try empty constructor instead", iae, new Object[0]);
                    this.throwFreezeExceptionWithoutMessage(freezeParameters);
                    continue;
                }
                catch (NoSuchMethodException nsme) {
                    OLogManager.instance().error((Object)this, "Can not create instance of exception " + freezeParameters.exceptionClass + " with message will try empty constructor instead", nsme, new Object[0]);
                    this.throwFreezeExceptionWithoutMessage(freezeParameters);
                    continue;
                }
                catch (SecurityException se) {
                    OLogManager.instance().error((Object)this, "Can not create instance of exception " + freezeParameters.exceptionClass + " with message will try empty constructor instead", se, new Object[0]);
                    this.throwFreezeExceptionWithoutMessage(freezeParameters);
                    continue;
                }
                catch (InvocationTargetException ite) {
                    OLogManager.instance().error((Object)this, "Can not create instance of exception " + freezeParameters.exceptionClass + " with message will try empty constructor instead", ite, new Object[0]);
                    this.throwFreezeExceptionWithoutMessage(freezeParameters);
                    continue;
                }
            }
            this.throwFreezeExceptionWithoutMessage(freezeParameters);
        }
    }

    private void throwFreezeExceptionWithoutMessage(FreezeParameters freezeParameters) {
        try {
            throw (OException)freezeParameters.exceptionClass.newInstance();
        }
        catch (InstantiationException ie) {
            OLogManager.instance().error((Object)this, "Can not create instance of exception " + freezeParameters.exceptionClass + " will park thread instead of throwing of exception", ie, new Object[0]);
        }
        catch (IllegalAccessException iae) {
            OLogManager.instance().error((Object)this, "Can not create instance of exception " + freezeParameters.exceptionClass + " will park thread instead of throwing of exception", iae, new Object[0]);
        }
    }

    public OAtomicOperation getCurrentOperation() {
        return currentOperation.get();
    }

    public OAtomicOperation endAtomicOperation(boolean rollback, Exception exception) throws IOException {
        if (unsafeMode.get().booleanValue() || this.writeAheadLog == null) {
            return null;
        }
        OAtomicOperation operation = currentOperation.get();
        assert (operation != null);
        if (rollback) {
            operation.rollback(exception);
        }
        if (operation.isRollback() && !rollback) {
            StringWriter writer = new StringWriter();
            writer.append("Atomic operation was rolled back by internal component");
            if (operation.getRollbackException() != null) {
                writer.append(", exception which caused this rollback is :\n");
                operation.getRollbackException().printStackTrace(new PrintWriter(writer));
                writer.append("\r\n");
            }
            this.atomicOperationsCount.decrement();
            ONestedRollbackException nre = new ONestedRollbackException(writer.toString());
            throw OException.wrapException(nre, exception);
        }
        int counter = operation.getCounter();
        assert (counter > 0);
        if (counter == 1) {
            if (!operation.isRollback()) {
                operation.commitChanges(this.writeAheadLog);
            }
            this.writeAheadLog.logAtomicOperationEndRecord(operation.getOperationUnitId(), rollback, operation.getStartLSN(), operation.getMetadata());
            operation.decrementCounter();
            currentOperation.set(null);
            if (this.trackAtomicOperations) {
                this.activeAtomicOperations.remove(operation.getOperationUnitId());
            }
            for (String lockObject : operation.lockedObjects()) {
                this.lockManager.releaseLock(this, lockObject, OOneEntryPerKeyLockManager.LOCK.EXCLUSIVE);
            }
            this.atomicOperationsCount.decrement();
        } else {
            operation.decrementCounter();
        }
        return operation;
    }

    public OUncompletedCommit<OAtomicOperation> initiateCommit() throws IOException {
        if (unsafeMode.get().booleanValue() || this.writeAheadLog == null) {
            return new OUncompletedCommit.NoOperation<Object>(null);
        }
        OAtomicOperation operation = currentOperation.get();
        assert (operation != null);
        int counter = operation.decrementCounter();
        assert (counter >= 0);
        if (counter > 0) {
            return new OUncompletedCommit.NoOperation<OAtomicOperation>(operation);
        }
        return new UncompletedCommit(operation, operation.initiateCommit(this.writeAheadLog));
    }

    private void acquireExclusiveLockTillOperationComplete(OAtomicOperation operation, String fullName) {
        if (operation.containsInLockedObjects(fullName)) {
            return;
        }
        this.lockManager.acquireLock(fullName, OOneEntryPerKeyLockManager.LOCK.EXCLUSIVE);
        operation.addLockedObject(fullName);
    }

    public void acquireReadLock(ODurableComponent durableComponent) {
        if (unsafeMode.get().booleanValue() || this.writeAheadLog == null) {
            return;
        }
        assert (durableComponent.getLockName() != null);
        this.lockManager.acquireLock(durableComponent.getLockName(), OOneEntryPerKeyLockManager.LOCK.SHARED);
    }

    public void releaseReadLock(ODurableComponent durableComponent) {
        if (unsafeMode.get().booleanValue() || this.writeAheadLog == null) {
            return;
        }
        assert (durableComponent.getName() != null);
        assert (durableComponent.getLockName() != null);
        this.lockManager.releaseLock(this, durableComponent.getLockName(), OOneEntryPerKeyLockManager.LOCK.SHARED);
    }

    public void registerMBean() {
        if (this.mbeanIsRegistered.compareAndSet(false, true)) {
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                ObjectName mbeanName = new ObjectName(this.getMBeanName());
                if (!server.isRegistered(mbeanName)) {
                    server.registerMBean(this, mbeanName);
                } else {
                    this.mbeanIsRegistered.set(false);
                    OLogManager.instance().warn((Object)this, "MBean with name %s has already registered. Probably your system was not shutdown correctly or you have several running applications which use OrientDB engine inside", mbeanName.getCanonicalName());
                }
            }
            catch (MalformedObjectNameException e) {
                throw OException.wrapException(new OStorageException("Error during registration of atomic manager MBean"), e);
            }
            catch (InstanceAlreadyExistsException e) {
                throw OException.wrapException(new OStorageException("Error during registration of atomic manager MBean"), e);
            }
            catch (MBeanRegistrationException e) {
                throw OException.wrapException(new OStorageException("Error during registration of atomic manager MBean"), e);
            }
            catch (NotCompliantMBeanException e) {
                throw OException.wrapException(new OStorageException("Error during registration of atomic manager MBean"), e);
            }
        }
    }

    private String getMBeanName() {
        return "com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations:type=OAtomicOperationsMangerMXBean,name=" + ObjectName.quote(this.storage.getName()) + ",id=" + this.storage.getId();
    }

    public void unregisterMBean() {
        if (this.mbeanIsRegistered.compareAndSet(true, false)) {
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                ObjectName mbeanName = new ObjectName(this.getMBeanName());
                server.unregisterMBean(mbeanName);
            }
            catch (MalformedObjectNameException e) {
                throw OException.wrapException(new OStorageException("Error during unregistration of atomic manager MBean"), e);
            }
            catch (InstanceNotFoundException e) {
                throw OException.wrapException(new OStorageException("Error during unregistration of atomic manager MBean"), e);
            }
            catch (MBeanRegistrationException e) {
                throw OException.wrapException(new OStorageException("Error during unregistration of atomic manager MBean"), e);
            }
        }
    }

    @Override
    public void trackAtomicOperations() {
        this.activeAtomicOperations.clear();
        this.trackAtomicOperations = true;
    }

    @Override
    public void doNotTrackAtomicOperations() {
        this.trackAtomicOperations = false;
        this.activeAtomicOperations.clear();
    }

    @Override
    public String dumpActiveAtomicOperations() {
        if (!this.trackAtomicOperations) {
            this.activeAtomicOperations.clear();
        }
        StringWriter writer = new StringWriter();
        writer.append("List of active atomic operations: \r\n");
        writer.append("------------------------------------------------------------------------------------------------\r\n");
        for (Map.Entry<OOperationUnitId, OPair<String, StackTraceElement[]>> entry : this.activeAtomicOperations.entrySet()) {
            writer.append("Operation unit id :").append(entry.getKey().toString()).append("\r\n");
            writer.append("Started at thread : ").append((CharSequence)entry.getValue().getKey()).append("\r\n");
            writer.append("Stack trace of method which started this operation : \r\n");
            StackTraceElement[] stackTraceElements = entry.getValue().getValue();
            for (int i = 1; i < stackTraceElements.length; ++i) {
                writer.append("\tat ").append(stackTraceElements[i].toString()).append("\r\n");
            }
            writer.append("\r\n\r\n");
        }
        writer.append("-------------------------------------------------------------------------------------------------\r\n");
        return writer.toString();
    }

    static {
        Orient.instance().registerListener(new OOrientListenerAbstract(){

            @Override
            public void onStartup() {
                if (currentOperation == null) {
                    currentOperation = new ThreadLocal();
                }
            }

            @Override
            public void onShutdown() {
                currentOperation = null;
            }
        });
    }

    private class UncompletedCommit
    implements OUncompletedCommit<OAtomicOperation> {
        private final OAtomicOperation operation;
        private final OUncompletedCommit<Void> nestedCommit;

        public UncompletedCommit(OAtomicOperation operation, OUncompletedCommit<Void> nestedCommit) {
            this.operation = operation;
            this.nestedCommit = nestedCommit;
        }

        @Override
        public OAtomicOperation complete() {
            this.nestedCommit.complete();
            try {
                OAtomicOperationsManager.this.writeAheadLog.logAtomicOperationEndRecord(this.operation.getOperationUnitId(), false, this.operation.getStartLSN(), this.operation.getMetadata());
            }
            catch (IOException e) {
                throw OException.wrapException(new OStorageException("Error while completing an uncompleted commit."), e);
            }
            currentOperation.set(null);
            if (OAtomicOperationsManager.this.trackAtomicOperations) {
                OAtomicOperationsManager.this.activeAtomicOperations.remove(this.operation.getOperationUnitId());
            }
            for (String lockObject : this.operation.lockedObjects()) {
                OAtomicOperationsManager.this.lockManager.releaseLock(this, lockObject, OOneEntryPerKeyLockManager.LOCK.EXCLUSIVE);
            }
            OAtomicOperationsManager.this.atomicOperationsCount.decrement();
            return this.operation;
        }

        @Override
        public void rollback() {
            this.operation.rollback(null);
            this.nestedCommit.rollback();
            try {
                OAtomicOperationsManager.this.writeAheadLog.logAtomicOperationEndRecord(this.operation.getOperationUnitId(), true, this.operation.getStartLSN(), this.operation.getMetadata());
            }
            catch (IOException e) {
                throw OException.wrapException(new OStorageException("Error while rollbacking an uncompleted commit."), e);
            }
            currentOperation.set(null);
            if (OAtomicOperationsManager.this.trackAtomicOperations) {
                OAtomicOperationsManager.this.activeAtomicOperations.remove(this.operation.getOperationUnitId());
            }
            for (String lockObject : this.operation.lockedObjects()) {
                OAtomicOperationsManager.this.lockManager.releaseLock(this, lockObject, OOneEntryPerKeyLockManager.LOCK.EXCLUSIVE);
            }
            OAtomicOperationsManager.this.atomicOperationsCount.decrement();
        }
    }

    private static final class WaitingListNode {
        private final CountDownLatch linkLatch = new CountDownLatch(1);
        private final Thread item;
        private volatile WaitingListNode next;

        public WaitingListNode(Thread item) {
            this.item = item;
        }

        public void waitTillAllLinksWillBeCreated() {
            try {
                this.linkLatch.await();
            }
            catch (InterruptedException e) {
                throw new OInterruptedException("Thread was interrupted while was waiting for completion of 'waiting linked list' operation");
            }
        }
    }

    private static final class FreezeParameters {
        private final String message;
        private final Class<? extends OException> exceptionClass;

        public FreezeParameters(String message, Class<? extends OException> exceptionClass) {
            this.message = message;
            this.exceptionClass = exceptionClass;
        }
    }
}

