/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OLogSequenceNumber
implements Comparable<OLogSequenceNumber> {
    private final long segment;
    private final long position;

    public OLogSequenceNumber(long segment, long position) {
        this.segment = segment;
        this.position = position;
    }

    public OLogSequenceNumber(ObjectInput in) throws IOException, ClassNotFoundException {
        this.segment = in.readLong();
        this.position = in.readLong();
    }

    public long getSegment() {
        return this.segment;
    }

    public long getPosition() {
        return this.position;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OLogSequenceNumber that = (OLogSequenceNumber)o;
        if (this.position != that.position) {
            return false;
        }
        return this.segment == that.segment;
    }

    public int hashCode() {
        int result = (int)(this.segment ^ this.segment >>> 32);
        result = 31 * result + (int)(this.position ^ this.position >>> 32);
        return result;
    }

    @Override
    public int compareTo(OLogSequenceNumber otherNumber) {
        if (this.segment > otherNumber.segment) {
            return 1;
        }
        if (this.segment < otherNumber.segment) {
            return -1;
        }
        if (this.position > otherNumber.position) {
            return 1;
        }
        if (this.position < otherNumber.position) {
            return -1;
        }
        return 0;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.segment);
        out.writeLong(this.position);
    }

    public String toString() {
        return "OLogSequenceNumber{segment=" + this.segment + ", position=" + this.position + '}';
    }
}

