/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.statistic;

import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OOperation;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OSessionStoragePerformanceStatistic;

public class OClusterCountersHolder
extends OSessionStoragePerformanceStatistic.PerformanceCountersHolder {
    long createdRecords;
    long timeRecordCreation;
    long createRecordPages;
    long createRecordFilePages;
    long createRecordPageReadTime;
    long createRecordFilePageReadTime;
    long deletedRecords;
    long timeRecordDeletion;
    long deleteRecordPages;
    long deleteRecordFilePages;
    long deleteRecordPageReadTime = 0L;
    long deleteRecordFilePageReadTime = 0L;
    long updatedRecords;
    long timeRecordUpdate;
    long updateRecordPages;
    long updateRecordFilePages;
    long updateRecordPageReadTime;
    long updateRecordFilePageReadTime;
    long readRecords;
    long timeRecordRead;
    long readRecordPages;
    long readRecordFilePages;
    long readRecordPageReadTime;
    long readRecordFilePageReadTime;

    @Override
    public OClusterCountersHolder newInstance() {
        return new OClusterCountersHolder();
    }

    @Override
    public void clean() {
        super.clean();
        this.createdRecords = 0L;
        this.timeRecordCreation = 0L;
        this.createRecordPages = 0L;
        this.createRecordFilePages = 0L;
        this.createRecordPageReadTime = 0L;
        this.createRecordFilePageReadTime = 0L;
        this.deletedRecords = 0L;
        this.timeRecordDeletion = 0L;
        this.deleteRecordPages = 0L;
        this.deleteRecordFilePages = 0L;
        this.deleteRecordPageReadTime = 0L;
        this.deleteRecordFilePageReadTime = 0L;
        this.updatedRecords = 0L;
        this.timeRecordUpdate = 0L;
        this.updateRecordPages = 0L;
        this.updateRecordFilePages = 0L;
        this.updateRecordPageReadTime = 0L;
        this.updateRecordFilePageReadTime = 0L;
        this.readRecords = 0L;
        this.timeRecordRead = 0L;
        this.readRecordPages = 0L;
        this.readRecordFilePages = 0L;
        this.readRecordPageReadTime = 0L;
        this.readRecordFilePageReadTime = 0L;
    }

    public long getRecordCreationTime() {
        if (this.createdRecords == 0L) {
            return -1L;
        }
        return this.timeRecordCreation / this.createdRecords;
    }

    public long getRecordCreationPages() {
        if (this.createdRecords == 0L) {
            return -1L;
        }
        return this.createRecordPages / this.createdRecords;
    }

    public int getRecordCreationHitRate() {
        if (this.createRecordPages == 0L) {
            return -1;
        }
        return (int)(100L * (this.createRecordPages - this.createRecordFilePages) / this.createRecordPages);
    }

    public long getRecordCreationPageTime() {
        if (this.createRecordPages == 0L) {
            return -1L;
        }
        return this.createRecordPageReadTime / this.createRecordPages;
    }

    public long getRecordCreationFilePageTime() {
        if (this.createRecordFilePages == 0L) {
            return -1L;
        }
        return this.createRecordFilePageReadTime / this.createRecordFilePages;
    }

    public long getRecordDeletionTime() {
        if (this.deletedRecords == 0L) {
            return -1L;
        }
        return this.timeRecordDeletion / this.deletedRecords;
    }

    public long getRecordDeletionPages() {
        if (this.deletedRecords == 0L) {
            return -1L;
        }
        return this.deleteRecordPages / this.deletedRecords;
    }

    public long getRecordDeletionHitRate() {
        if (this.deleteRecordPages == 0L) {
            return -1L;
        }
        return (int)(100L * (this.deleteRecordPages - this.deleteRecordFilePages) / this.deleteRecordPages);
    }

    public long getRecordDeletionPageTime() {
        if (this.deleteRecordPages == 0L) {
            return -1L;
        }
        return this.deleteRecordPageReadTime / this.deleteRecordPages;
    }

    public long getRecordDeletionFilePageTime() {
        if (this.deleteRecordFilePages == 0L) {
            return -1L;
        }
        return this.deleteRecordFilePageReadTime / this.deleteRecordFilePages;
    }

    public long getRecordUpdateTime() {
        if (this.updatedRecords == 0L) {
            return -1L;
        }
        return this.timeRecordUpdate / this.updatedRecords;
    }

    public long getRecordUpdatePages() {
        if (this.updatedRecords == 0L) {
            return -1L;
        }
        return this.updateRecordPages / this.updatedRecords;
    }

    public long getRecordUpdateHitRate() {
        if (this.updateRecordPages == 0L) {
            return -1L;
        }
        return (int)(100L * (this.updateRecordPages - this.updateRecordFilePages) / this.updateRecordPages);
    }

    public long getRecordUpdatePageTime() {
        if (this.updateRecordPages == 0L) {
            return -1L;
        }
        return this.updateRecordPageReadTime / this.updateRecordPages;
    }

    public long getRecordUpdateFilePageTime() {
        if (this.updateRecordFilePages == 0L) {
            return -1L;
        }
        return this.updateRecordFilePageReadTime / this.updateRecordFilePages;
    }

    public long getRecordReadTime() {
        if (this.readRecords == 0L) {
            return -1L;
        }
        return this.timeRecordRead / this.readRecords;
    }

    public long getRecordReadPages() {
        if (this.readRecords == 0L) {
            return -1L;
        }
        return this.readRecordPages / this.readRecords;
    }

    public long getRecordReadHitRate() {
        if (this.readRecordPages == 0L) {
            return -1L;
        }
        return (int)(100L * (this.readRecordPages - this.readRecordFilePages) / this.readRecordPages);
    }

    public long getRecordReadPageTime() {
        if (this.readRecordPages == 0L) {
            return -1L;
        }
        return this.readRecordPageReadTime / this.readRecordPages;
    }

    public long getRecordReadFilePageTime() {
        if (this.readRecordFilePages == 0L) {
            return -1L;
        }
        return this.readRecordFilePageReadTime / this.readRecordFilePages;
    }

    @Override
    public ODocument toDocument() {
        ODocument document = super.toDocument();
        document.field("recordCreationTime", this.getRecordCreationTime());
        document.field("recordCreationPages", this.getRecordCreationPages());
        document.field("recordCreationHitRate", this.getRecordCreationHitRate());
        document.field("recordCreationPageTime", this.getRecordCreationPageTime());
        document.field("recordCreationFilePageTime", this.getRecordCreationFilePageTime());
        document.field("recordDeletionTime", this.getRecordDeletionTime());
        document.field("recordDeletionPages", this.getRecordDeletionPages());
        document.field("recordDeletionHitRate", this.getRecordDeletionHitRate());
        document.field("recordDeletionPageTime", this.getRecordDeletionPageTime());
        document.field("recordDeletionFilePageTime", this.getRecordDeletionFilePageTime());
        document.field("recordUpdateTime", this.getRecordUpdateTime());
        document.field("recordUpdatePages", this.getRecordUpdatePages());
        document.field("recordUpdateHitRate", this.getRecordUpdateHitRate());
        document.field("recordUpdatePageTime", this.getRecordUpdatePageTime());
        document.field("recordUpdateFilePageTime", this.getRecordUpdateFilePageTime());
        document.field("recordReadTime", this.getRecordReadTime());
        document.field("recordReadPages", this.getRecordReadPages());
        document.field("recordReadHitRate", this.getRecordReadHitRate());
        document.field("recordReadPageTime", this.getRecordReadPageTime());
        document.field("recordReadFilePageTime", this.getRecordReadFilePageTime());
        return document;
    }

    public class ReadRecordPages
    extends OOperation {
        @Override
        void incrementOperationsCounter(int pages, int filePages) {
            OClusterCountersHolder.this.readRecordPages += (long)pages;
            OClusterCountersHolder.this.readRecordFilePages += (long)filePages;
        }
    }

    public class DeleteRecordPages
    extends OOperation {
        @Override
        void incrementOperationsCounter(int pages, int filePages) {
            OClusterCountersHolder.this.deleteRecordPages += (long)pages;
            OClusterCountersHolder.this.deleteRecordFilePages += (long)filePages;
        }
    }

    public class UpdateRecordOperation
    extends OOperation {
        @Override
        void incrementOperationsCounter(int pages, int filePages) {
            OClusterCountersHolder.this.updateRecordPages += (long)pages;
            OClusterCountersHolder.this.updateRecordFilePages += (long)filePages;
        }
    }

    public class CreateRecordOperation
    extends OOperation {
        @Override
        void incrementOperationsCounter(int pages, int filePages) {
            OClusterCountersHolder.this.createRecordPages += (long)pages;
            OClusterCountersHolder.this.createRecordFilePages += (long)filePages;
        }
    }
}

