/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.OIdentityChangeListener;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordListener;
import com.orientechnologies.orient.core.record.impl.ODirtyManager;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerJSON;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OOfflineClusterException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;

public abstract class ORecordAbstract
implements ORecord {
    protected ORecordId _recordId;
    protected int _recordVersion = 0;
    protected byte[] _source;
    protected int _size;
    protected transient ORecordSerializer _recordFormat;
    protected boolean _dirty = true;
    protected boolean _contentChanged = true;
    protected ORecordElement.STATUS _status = ORecordElement.STATUS.LOADED;
    protected transient Set<ORecordListener> _listeners = null;
    private transient Set<OIdentityChangeListener> newIdentityChangeListeners = null;
    protected ODirtyManager _dirtyManager;

    public ORecordAbstract() {
    }

    public ORecordAbstract(byte[] iSource) {
        this._source = iSource;
        this._size = iSource.length;
        this.unsetDirty();
    }

    @Override
    public ORID getIdentity() {
        return this._recordId;
    }

    protected ORecordAbstract setIdentity(ORecordId iIdentity) {
        this._recordId = iIdentity;
        this.getDirtyManager().setDirty(this);
        return this;
    }

    @Override
    public ORecordElement getOwner() {
        return null;
    }

    public ORecord getRecord() {
        return this;
    }

    @Override
    public boolean detach() {
        return true;
    }

    public ORecordAbstract clear() {
        this.setDirty();
        this.invokeListenerEvent(ORecordListener.EVENT.CLEAR);
        return this;
    }

    public ORecordAbstract reset() {
        this._status = ORecordElement.STATUS.LOADED;
        this._recordVersion = 0;
        this._size = 0;
        this._source = null;
        this.setDirty();
        if (this._recordId != null) {
            this._recordId.reset();
        }
        this.invokeListenerEvent(ORecordListener.EVENT.RESET);
        return this;
    }

    @Override
    public byte[] toStream() {
        if (this._source == null) {
            this._source = this._recordFormat.toStream(this, false);
        }
        this.invokeListenerEvent(ORecordListener.EVENT.MARSHALL);
        return this._source;
    }

    @Override
    public ORecordAbstract fromStream(byte[] iRecordBuffer) {
        this._dirty = false;
        this._contentChanged = false;
        this._dirtyManager = null;
        this._source = iRecordBuffer;
        this._size = iRecordBuffer != null ? iRecordBuffer.length : 0;
        this._status = ORecordElement.STATUS.LOADED;
        this.invokeListenerEvent(ORecordListener.EVENT.UNMARSHALL);
        return this;
    }

    public ORecordAbstract setDirty() {
        if (!this._dirty && this._status != ORecordElement.STATUS.UNMARSHALLING) {
            this._dirty = true;
            this._source = null;
        }
        this._contentChanged = true;
        return this;
    }

    @Override
    public void setDirtyNoChanged() {
        if (!this._dirty && this._status != ORecordElement.STATUS.UNMARSHALLING) {
            this._dirty = true;
            this._source = null;
        }
    }

    @Override
    public boolean isDirty() {
        return this._dirty;
    }

    public <RET extends ORecord> RET fromJSON(String iSource, String iOptions) {
        ORecordSerializerJSON.INSTANCE.fromString(iSource, this, null, iOptions, false);
        return (RET)this;
    }

    @Override
    public <RET extends ORecord> RET fromJSON(String iSource) {
        ORecordSerializerJSON.INSTANCE.fromString(iSource, this, null);
        return (RET)this;
    }

    public <RET extends ORecord> RET fromJSON(String iSource, boolean needReload) {
        return (RET)ORecordSerializerJSON.INSTANCE.fromString(iSource, this, null, needReload);
    }

    public <RET extends ORecord> RET fromJSON(InputStream iContentResult) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OIOUtils.copyStream(iContentResult, out, -1L);
        ORecordSerializerJSON.INSTANCE.fromString(out.toString(), this, null);
        return (RET)this;
    }

    @Override
    public String toJSON() {
        return this.toJSON("rid,version,class,type,attribSameRow,keepTypes,alwaysFetchEmbedded,fetchPlan:*:0");
    }

    @Override
    public String toJSON(String iFormat) {
        return ORecordSerializerJSON.INSTANCE.toString(this, new StringBuilder(1024), iFormat == null ? "" : iFormat).toString();
    }

    public void toJSON(String iFormat, OutputStream stream) throws IOException {
        stream.write(this.toJSON(iFormat).toString().getBytes());
    }

    public void toJSON(OutputStream stream) throws IOException {
        stream.write(this.toJSON().toString().getBytes());
    }

    public String toString() {
        return (this._recordId.isValid() ? this._recordId : "") + (this._source != null ? Arrays.toString(this._source) : "[]") + " v" + this._recordVersion;
    }

    @Override
    public int getVersion() {
        return this._recordVersion;
    }

    protected void setVersion(int iVersion) {
        this._recordVersion = iVersion;
    }

    public ORecordAbstract unload() {
        this._status = ORecordElement.STATUS.NOT_LOADED;
        this._source = null;
        this.unsetDirty();
        this.invokeListenerEvent(ORecordListener.EVENT.UNLOAD);
        return this;
    }

    public ORecord load() {
        if (!this.getIdentity().isValid()) {
            throw new ORecordNotFoundException(this.getIdentity(), "The record has no id, probably it's new or transient yet ");
        }
        try {
            ORecord result = (ORecord)this.getDatabase().load(this);
            if (result == null) {
                throw new ORecordNotFoundException(this.getIdentity());
            }
            return result;
        }
        catch (Exception e) {
            throw OException.wrapException(new ORecordNotFoundException(this.getIdentity()), e);
        }
    }

    @Override
    public ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    public ODatabaseDocument getDatabaseIfDefined() {
        return ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
    }

    public ORecord reload() {
        return this.reload(null, true, true);
    }

    public ORecord reload(String fetchPlan) {
        return this.reload(fetchPlan, true);
    }

    public ORecord reload(String fetchPlan, boolean ignoreCache) {
        return this.reload(fetchPlan, ignoreCache, true);
    }

    public ORecord reload(String fetchPlan, boolean ignoreCache, boolean force) throws ORecordNotFoundException {
        if (!this.getIdentity().isValid()) {
            throw new ORecordNotFoundException(this.getIdentity(), "The record has no id. It is probably new or still transient");
        }
        try {
            this.getDatabase().reload(this, fetchPlan, ignoreCache, force);
            return this;
        }
        catch (OOfflineClusterException e) {
            throw e;
        }
        catch (ORecordNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw OException.wrapException(new ORecordNotFoundException(this.getIdentity()), e);
        }
    }

    public ORecordAbstract save() {
        return this.save(false);
    }

    public ORecordAbstract save(String iClusterName) {
        return this.save(iClusterName, false);
    }

    public ORecordAbstract save(boolean forceCreate) {
        this.getDatabase().save(this, ODatabase.OPERATION_MODE.SYNCHRONOUS, forceCreate, null, null);
        return this;
    }

    public ORecordAbstract save(String iClusterName, boolean forceCreate) {
        return (ORecordAbstract)this.getDatabase().save(this, iClusterName, ODatabase.OPERATION_MODE.SYNCHRONOUS, forceCreate, null, null);
    }

    public ORecordAbstract delete() {
        this.getDatabase().delete(this);
        this.setDirty();
        return this;
    }

    @Override
    public int getSize() {
        return this._size;
    }

    @Override
    public void lock(boolean iExclusive) {
        ODatabaseRecordThreadLocal.INSTANCE.get().getTransaction().lockRecord(this, iExclusive ? OStorage.LOCKING_STRATEGY.EXCLUSIVE_LOCK : OStorage.LOCKING_STRATEGY.SHARED_LOCK);
    }

    @Override
    public boolean isLocked() {
        return ODatabaseRecordThreadLocal.INSTANCE.get().getTransaction().isLockedRecord(this);
    }

    @Override
    public OStorage.LOCKING_STRATEGY lockingStrategy() {
        return ODatabaseRecordThreadLocal.INSTANCE.get().getTransaction().lockingStrategy(this);
    }

    @Override
    public void unlock() {
        ODatabaseRecordThreadLocal.INSTANCE.get().getTransaction().unlockRecord(this);
    }

    public int hashCode() {
        return this._recordId != null ? this._recordId.hashCode() : 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof OIdentifiable) {
            return this._recordId.equals(((OIdentifiable)obj).getIdentity());
        }
        return false;
    }

    @Override
    public int compare(OIdentifiable iFirst, OIdentifiable iSecond) {
        if (iFirst == null || iSecond == null) {
            return -1;
        }
        return iFirst.compareTo(iSecond);
    }

    @Override
    public int compareTo(OIdentifiable iOther) {
        if (iOther == null) {
            return 1;
        }
        if (this._recordId == null) {
            return iOther.getIdentity() == null ? 0 : 1;
        }
        return this._recordId.compareTo(iOther.getIdentity());
    }

    @Override
    public ORecordElement.STATUS getInternalStatus() {
        return this._status;
    }

    @Override
    public void setInternalStatus(ORecordElement.STATUS iStatus) {
        this._status = iStatus;
    }

    public ORecordAbstract copyTo(ORecordAbstract cloned) {
        cloned._source = this._source;
        cloned._size = this._size;
        cloned._recordId = this._recordId.copy();
        cloned._recordVersion = this._recordVersion;
        cloned._status = this._status;
        cloned._recordFormat = this._recordFormat;
        cloned._listeners = null;
        cloned._dirty = false;
        cloned._contentChanged = false;
        cloned._dirtyManager = null;
        return cloned;
    }

    protected ORecordAbstract fill(ORID iRid, int iVersion, byte[] iBuffer, boolean iDirty) {
        this._recordId.clusterId = iRid.getClusterId();
        this._recordId.clusterPosition = iRid.getClusterPosition();
        this._recordVersion = iVersion;
        this._status = ORecordElement.STATUS.LOADED;
        this._source = iBuffer;
        int n = this._size = iBuffer != null ? iBuffer.length : 0;
        if (this._source != null && this._source.length > 0) {
            this._dirty = iDirty;
            this._contentChanged = iDirty;
            if (!iDirty && this._dirtyManager != null) {
                this._dirtyManager.removePointed(this);
            }
        }
        return this;
    }

    protected ORecordAbstract setIdentity(int iClusterId, long iClusterPosition) {
        if (this._recordId == null || this._recordId == ORecordId.EMPTY_RECORD_ID) {
            this._recordId = new ORecordId(iClusterId, iClusterPosition);
        } else {
            this._recordId.clusterId = iClusterId;
            this._recordId.clusterPosition = iClusterPosition;
        }
        return this;
    }

    protected void unsetDirty() {
        this._contentChanged = false;
        this._dirty = false;
        if (this._dirtyManager != null) {
            this._dirtyManager.removePointed(this);
        }
    }

    protected abstract byte getRecordType();

    protected void onBeforeIdentityChanged(ORecord iRecord) {
        if (this.newIdentityChangeListeners != null) {
            for (OIdentityChangeListener changeListener : this.newIdentityChangeListeners) {
                changeListener.onBeforeIdentityChange(this);
            }
        }
    }

    protected void onAfterIdentityChanged(ORecord iRecord) {
        this.invokeListenerEvent(ORecordListener.EVENT.IDENTITY_CHANGED);
        if (this.newIdentityChangeListeners != null) {
            for (OIdentityChangeListener changeListener : this.newIdentityChangeListeners) {
                changeListener.onAfterIdentityChange(this);
            }
        }
    }

    protected ODatabaseDocumentInternal getDatabaseInternal() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    protected ODatabaseDocumentInternal getDatabaseIfDefinedInternal() {
        return ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
    }

    protected void addListener(ORecordListener iListener) {
        if (this._listeners == null) {
            this._listeners = Collections.newSetFromMap(new WeakHashMap());
        }
        this._listeners.add(iListener);
    }

    protected void removeListener(ORecordListener listener) {
        if (this._listeners != null) {
            this._listeners.remove(listener);
            if (this._listeners.isEmpty()) {
                this._listeners = null;
            }
        }
    }

    protected <RET extends ORecord> RET flatCopy() {
        return this.copy();
    }

    protected void addIdentityChangeListener(OIdentityChangeListener identityChangeListener) {
        if (this.newIdentityChangeListeners == null) {
            this.newIdentityChangeListeners = Collections.newSetFromMap(new WeakHashMap());
        }
        this.newIdentityChangeListeners.add(identityChangeListener);
    }

    protected void removeIdentityChangeListener(OIdentityChangeListener identityChangeListener) {
        if (this.newIdentityChangeListeners != null) {
            this.newIdentityChangeListeners.remove(identityChangeListener);
        }
    }

    protected void setup() {
        if (this._recordId == null) {
            this._recordId = new ORecordId();
        }
    }

    protected void invokeListenerEvent(ORecordListener.EVENT iEvent) {
        if (this._listeners != null) {
            for (ORecordListener listener : this._listeners) {
                if (listener == null) continue;
                listener.onEvent(this, iEvent);
            }
        }
    }

    protected void checkForLoading() {
        if (this._status == ORecordElement.STATUS.NOT_LOADED && ODatabaseRecordThreadLocal.INSTANCE.isDefined()) {
            this.reload(null, true);
        }
    }

    protected boolean isContentChanged() {
        return this._contentChanged;
    }

    protected void setContentChanged(boolean contentChanged) {
        this._contentChanged = contentChanged;
    }

    protected void clearSource() {
        this._source = null;
    }

    protected ODirtyManager getDirtyManager() {
        if (this._dirtyManager == null) {
            this._dirtyManager = new ODirtyManager();
            if (this.getIdentity().isNew() && this.getOwner() == null) {
                this._dirtyManager.setDirty(this);
            }
        }
        return this._dirtyManager;
    }

    protected void setDirtyManager(ODirtyManager dirtyManager) {
        if (this._dirtyManager != null && dirtyManager != null) {
            dirtyManager.merge(this._dirtyManager);
        }
        this._dirtyManager = dirtyManager;
        if (this.getIdentity().isNew() && this.getOwner() == null && this._dirtyManager != null) {
            this._dirtyManager.setDirty(this);
        }
    }

    protected void track(OIdentifiable id) {
        this.getDirtyManager().track(this, id);
    }

    protected void unTrack(OIdentifiable id) {
        this.getDirtyManager().unTrack(this, id);
    }
}

