/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.method;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.parser.OBaseParser;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandExecutorNotFoundException;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemAbstract;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemVariable;
import com.orientechnologies.orient.core.sql.filter.OSQLPredicate;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.core.sql.method.OSQLMethod;
import java.util.List;

public class OSQLMethodRuntime
extends OSQLFilterItemAbstract
implements Comparable<OSQLMethodRuntime> {
    public OSQLMethod method;
    public Object[] configuredParameters;
    public Object[] runtimeParameters;

    public OSQLMethodRuntime(OBaseParser iQueryToParse, String iText) {
        super(iQueryToParse, iText);
    }

    public OSQLMethodRuntime(OSQLMethod iFunction) {
        this.method = iFunction;
    }

    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, OCommandContext iContext) {
        if (iThis == null) {
            return null;
        }
        if (this.configuredParameters != null) {
            for (int i = 0; i < this.configuredParameters.length; ++i) {
                this.runtimeParameters[i] = this.configuredParameters[i];
                if (!this.method.evaluateParameters()) continue;
                if (this.configuredParameters[i] instanceof OSQLFilterItemField) {
                    this.runtimeParameters[i] = ((OSQLFilterItemField)this.configuredParameters[i]).getValue(iCurrentRecord, iCurrentResult, iContext);
                    if (this.runtimeParameters[i] != null || !(iCurrentResult instanceof OIdentifiable)) continue;
                    this.runtimeParameters[i] = ((OSQLFilterItemField)this.configuredParameters[i]).getValue((OIdentifiable)iCurrentResult, iCurrentResult, iContext);
                    continue;
                }
                if (this.configuredParameters[i] instanceof OSQLMethodRuntime) {
                    this.runtimeParameters[i] = ((OSQLMethodRuntime)this.configuredParameters[i]).execute(iThis, iCurrentRecord, iCurrentResult, iContext);
                    continue;
                }
                if (this.configuredParameters[i] instanceof OSQLFunctionRuntime) {
                    this.runtimeParameters[i] = ((OSQLFunctionRuntime)this.configuredParameters[i]).execute(iThis, iCurrentRecord, iCurrentResult, iContext);
                    continue;
                }
                if (this.configuredParameters[i] instanceof OSQLFilterItemVariable) {
                    this.runtimeParameters[i] = ((OSQLFilterItemVariable)this.configuredParameters[i]).getValue(iCurrentRecord, iCurrentResult, iContext);
                    if (this.runtimeParameters[i] != null || !(iCurrentResult instanceof OIdentifiable)) continue;
                    this.runtimeParameters[i] = ((OSQLFilterItemVariable)this.configuredParameters[i]).getValue((OIdentifiable)iCurrentResult, iCurrentResult, iContext);
                    continue;
                }
                if (this.configuredParameters[i] instanceof OCommandSQL) {
                    try {
                        this.runtimeParameters[i] = ((OCommandSQL)this.configuredParameters[i]).setContext(iContext).execute(new Object[0]);
                    }
                    catch (OCommandExecutorNotFoundException e) {
                        String text = ((OCommandSQL)this.configuredParameters[i]).getText();
                        OSQLPredicate pred = new OSQLPredicate(text);
                        this.runtimeParameters[i] = pred.evaluate(iCurrentRecord instanceof ORecord ? (ORecord)iCurrentRecord : null, (ODocument)iCurrentResult, iContext);
                        this.configuredParameters[i] = pred;
                    }
                    continue;
                }
                if (this.configuredParameters[i] instanceof OSQLPredicate) {
                    this.runtimeParameters[i] = ((OSQLPredicate)this.configuredParameters[i]).evaluate((OIdentifiable)iCurrentRecord.getRecord(), iCurrentRecord instanceof ODocument ? (ODocument)iCurrentResult : null, iContext);
                    continue;
                }
                if (!(this.configuredParameters[i] instanceof String) || !this.configuredParameters[i].toString().startsWith("\"") && !this.configuredParameters[i].toString().startsWith("'")) continue;
                this.runtimeParameters[i] = OIOUtils.getStringContent(this.configuredParameters[i]);
            }
            if ((this.method.getMaxParams() == -1 || this.method.getMaxParams() > 0) && (this.runtimeParameters.length < this.method.getMinParams() || this.method.getMaxParams() > -1 && this.runtimeParameters.length > this.method.getMaxParams())) {
                throw new OCommandExecutionException("Syntax error: function '" + this.method.getName() + "' needs " + (this.method.getMinParams() == this.method.getMaxParams() ? Integer.valueOf(this.method.getMinParams()) : this.method.getMinParams() + "-" + this.method.getMaxParams()) + " argument(s) while has been received " + this.runtimeParameters.length);
            }
        }
        Object functionResult = this.method.execute(iThis, iCurrentRecord, iContext, iCurrentResult, this.runtimeParameters);
        return this.transformValue(iCurrentRecord, iContext, functionResult);
    }

    @Override
    public Object getValue(OIdentifiable iRecord, Object iCurrentResult, OCommandContext iContext) {
        ODocument current = iRecord != null ? (ODocument)iRecord.getRecord() : null;
        return this.execute(current, current, null, iContext);
    }

    @Override
    public String getRoot() {
        return this.method.getName();
    }

    @Override
    protected void setRoot(OBaseParser iQueryToParse, String iText) {
        int beginParenthesis = iText.indexOf(40);
        String funcName = iText.substring(0, beginParenthesis);
        List<String> funcParamsText = OStringSerializerHelper.getParameters(iText);
        OSQLEngine.getInstance();
        this.method = OSQLEngine.getMethod(funcName);
        if (this.method == null) {
            throw new OCommandSQLParsingException("Unknown method " + funcName + "()");
        }
        this.configuredParameters = new Object[funcParamsText.size()];
        for (int i = 0; i < funcParamsText.size(); ++i) {
            this.configuredParameters[i] = funcParamsText.get(i);
        }
        this.setParameters(this.configuredParameters, true);
    }

    public OSQLMethodRuntime setParameters(Object[] iParameters, boolean iEvaluate) {
        if (iParameters != null) {
            int i;
            this.configuredParameters = new Object[iParameters.length];
            for (i = 0; i < iParameters.length; ++i) {
                this.configuredParameters[i] = iParameters[i];
                if (iParameters[i] != null) {
                    Object v;
                    if (!(iParameters[i] instanceof String) || iParameters[i].toString().startsWith("[") || (v = OSQLHelper.parseValue(null, null, iParameters[i].toString(), null)) == "_NOT_PARSED_" || v != null && OMultiValue.isMultiValue(v) && OMultiValue.getFirstValue(v) == "_NOT_PARSED_") continue;
                    this.configuredParameters[i] = v;
                    continue;
                }
                this.configuredParameters[i] = null;
            }
            this.runtimeParameters = new Object[this.configuredParameters.length];
            for (i = 0; i < this.configuredParameters.length; ++i) {
                if (this.configuredParameters[i] instanceof OSQLFilterItemField || this.configuredParameters[i] instanceof OSQLMethodRuntime) continue;
                this.runtimeParameters[i] = this.configuredParameters[i];
            }
        }
        return this;
    }

    public OSQLMethod getMethod() {
        return this.method;
    }

    public Object[] getConfiguredParameters() {
        return this.configuredParameters;
    }

    public Object[] getRuntimeParameters() {
        return this.runtimeParameters;
    }

    @Override
    public int compareTo(OSQLMethodRuntime o) {
        return this.method.compareTo(o.getMethod());
    }
}

