/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.Map;

public class OProjectionItem
extends SimpleNode {
    protected boolean all = false;
    protected OIdentifier alias;
    protected OExpression expression;

    public OProjectionItem(int id) {
        super(id);
    }

    public OProjectionItem(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public boolean isAll() {
        if (this.all) {
            return true;
        }
        return this.expression != null && "*".equals(this.expression.toString());
    }

    public void setAll(boolean all) {
        this.all = all;
    }

    public OIdentifier getAlias() {
        return this.alias;
    }

    public void setAlias(OIdentifier alias) {
        this.alias = alias;
    }

    public OExpression getExpression() {
        return this.expression;
    }

    public void setExpression(OExpression expression) {
        this.expression = expression;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.all) {
            builder.append("*");
        } else {
            this.expression.toString(params, builder);
            if (this.alias != null) {
                builder.append(" AS ");
                this.alias.toString(params, builder);
            }
        }
    }

    public OIdentifier getDefaultAlias() {
        if (this.expression == null) {
            OIdentifier result = new OIdentifier(-1);
            result.setValue("null");
            return result;
        }
        return this.expression.getDefaultAlias();
    }
}

