/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.config.OStorageFileConfiguration;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.fs.OFile;
import com.orientechnologies.orient.core.storage.impl.local.OSingleFileSegment;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Map;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
public class OStorageConfigurationSegment
extends OStorageConfiguration {
    private static final long serialVersionUID = 638874446554389034L;
    private static final int START_SIZE = 10000;
    private final transient OSingleFileSegment segment;

    public OStorageConfigurationSegment(OLocalPaginatedStorage iStorage) throws IOException {
        super(iStorage);
        this.segment = new OSingleFileSegment((OLocalPaginatedStorage)this.storage, new OStorageFileConfiguration(null, this.getDirectory() + "/database.ocf", "classic", this.fileTemplate.maxSize, this.fileTemplate.fileIncrementSize));
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.segment.close();
    }

    @Override
    public void delete() throws IOException {
        super.delete();
        this.segment.delete();
    }

    @Override
    public void create() throws IOException {
        this.segment.create(10000);
        super.create();
        OFile f = this.segment.getFile();
        if (OGlobalConfiguration.STORAGE_CONFIGURATION_SYNC_ON_UPDATE.getValueAsBoolean()) {
            f.synch();
        }
    }

    @Override
    public OStorageConfiguration load(Map<String, Object> iProperties) throws OSerializationException {
        try {
            this.initConfiguration();
            this.bindPropertiesToContext(iProperties);
            if (!this.segment.getFile().exists()) {
                this.segment.create(10000);
                ORawBuffer rawRecord = this.storage.readRecord(CONFIG_RID, null, false, false, null).getResult();
                if (rawRecord != null) {
                    this.fromStream(rawRecord.buffer);
                }
                this.update();
                return this;
            }
            this.segment.open();
            int size = this.segment.getFile().readInt(0L);
            byte[] buffer = new byte[size];
            this.segment.getFile().read(4L, buffer, size);
            this.fromStream(buffer);
        }
        catch (IOException e) {
            throw OException.wrapException(new OSerializationException("Cannot load database configuration. The database seems corrupted"), e);
        }
        return this;
    }

    @Override
    public void lock() throws IOException {
    }

    @Override
    public void unlock() throws IOException {
    }

    @Override
    public void update() throws OSerializationException {
        try {
            OFile f = this.segment.getFile();
            if (!f.isOpen()) {
                return;
            }
            byte[] buffer = this.toStream();
            int len = buffer.length + 4;
            if ((long)len > f.getFileSize()) {
                f.allocateSpace((long)len - f.getFileSize());
            }
            f.writeInt(0L, buffer.length);
            f.write(4L, buffer);
            if (OGlobalConfiguration.STORAGE_CONFIGURATION_SYNC_ON_UPDATE.getValueAsBoolean()) {
                f.synch();
            }
        }
        catch (Exception e) {
            throw OException.wrapException(new OSerializationException("Error on update storage configuration"), e);
        }
    }

    @Override
    public void synch() throws IOException {
        this.segment.getFile().synch();
    }

    @Override
    public void setSoftlyClosed(boolean softlyClosed) throws IOException {
    }

    public String getFileName() {
        return this.segment.getFile().getName();
    }
}

