/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.tx;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.cache.OLocalRecordCache;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.tx.OTransaction;
import java.util.HashMap;
import java.util.Map;

public abstract class OTransactionAbstract
implements OTransaction {
    protected final ODatabaseDocumentTx database;
    protected OTransaction.TXSTATUS status = OTransaction.TXSTATUS.INVALID;
    protected OTransaction.ISOLATION_LEVEL isolationLevel = OTransaction.ISOLATION_LEVEL.READ_COMMITTED;
    protected HashMap<ORID, LockedRecordMetadata> locks = new HashMap();

    protected OTransactionAbstract(ODatabaseDocumentTx iDatabase) {
        this.database = iDatabase;
    }

    public static void updateCacheFromEntries(OTransaction tx, Iterable<? extends ORecordOperation> entries, boolean updateStrategy) {
        OLocalRecordCache dbCache = tx.getDatabase().getLocalCache();
        for (ORecordOperation oRecordOperation : entries) {
            if (!updateStrategy) {
                dbCache.deleteRecord(oRecordOperation.getRecord().getIdentity());
                continue;
            }
            if (oRecordOperation.type == 2) {
                dbCache.deleteRecord(oRecordOperation.getRecord().getIdentity());
                continue;
            }
            if (oRecordOperation.type != 1 && oRecordOperation.type != 3) continue;
            dbCache.updateRecord(oRecordOperation.getRecord());
        }
    }

    @Override
    public OTransaction.ISOLATION_LEVEL getIsolationLevel() {
        return this.isolationLevel;
    }

    @Override
    public OTransaction setIsolationLevel(OTransaction.ISOLATION_LEVEL isolationLevel) {
        if (isolationLevel == OTransaction.ISOLATION_LEVEL.REPEATABLE_READ && this.getDatabase().getStorage() instanceof OStorageProxy) {
            throw new IllegalArgumentException("Remote storage does not support isolation level '" + (Object)((Object)isolationLevel) + "'");
        }
        this.isolationLevel = isolationLevel;
        return this;
    }

    @Override
    public boolean isActive() {
        return this.status != OTransaction.TXSTATUS.INVALID && this.status != OTransaction.TXSTATUS.COMPLETED && this.status != OTransaction.TXSTATUS.ROLLED_BACK;
    }

    @Override
    public OTransaction.TXSTATUS getStatus() {
        return this.status;
    }

    @Override
    public ODatabaseDocumentTx getDatabase() {
        return this.database;
    }

    @Override
    public void close() {
        for (Map.Entry<ORID, LockedRecordMetadata> lock : this.locks.entrySet()) {
            try {
                int i;
                LockedRecordMetadata lockedRecordMetadata = lock.getValue();
                if (lockedRecordMetadata.strategy.equals((Object)OStorage.LOCKING_STRATEGY.EXCLUSIVE_LOCK)) {
                    for (i = 0; i < lockedRecordMetadata.locksCount; ++i) {
                        ((OAbstractPaginatedStorage)this.getDatabase().getStorage()).releaseWriteLock(lock.getKey());
                    }
                    continue;
                }
                if (!lockedRecordMetadata.strategy.equals((Object)OStorage.LOCKING_STRATEGY.SHARED_LOCK)) continue;
                for (i = 0; i < lockedRecordMetadata.locksCount; ++i) {
                    ((OAbstractPaginatedStorage)this.getDatabase().getStorage()).releaseReadLock(lock.getKey());
                }
            }
            catch (Exception e) {
                OLogManager.instance().debug((Object)this, "Error on releasing lock against record " + lock.getKey(), e, new Object[0]);
            }
        }
        this.locks.clear();
    }

    @Override
    public OTransaction lockRecord(OIdentifiable iRecord, OStorage.LOCKING_STRATEGY lockingStrategy) {
        OStorage stg = this.database.getStorage();
        if (!(stg.getUnderlying() instanceof OAbstractPaginatedStorage)) {
            throw new OLockException("Cannot lock record across remote connections");
        }
        ORecordId rid = new ORecordId(iRecord.getIdentity());
        LockedRecordMetadata lockedRecordMetadata = this.locks.get(rid);
        boolean addItem = false;
        if (lockedRecordMetadata == null) {
            lockedRecordMetadata = new LockedRecordMetadata(lockingStrategy);
            addItem = true;
        } else if (lockedRecordMetadata.strategy != lockingStrategy) {
            assert (lockedRecordMetadata.locksCount == 0);
            lockedRecordMetadata = new LockedRecordMetadata(lockingStrategy);
            addItem = true;
        }
        if (lockingStrategy == OStorage.LOCKING_STRATEGY.EXCLUSIVE_LOCK) {
            ((OAbstractPaginatedStorage)stg.getUnderlying()).acquireWriteLock(rid);
        } else if (lockingStrategy == OStorage.LOCKING_STRATEGY.SHARED_LOCK) {
            ((OAbstractPaginatedStorage)stg.getUnderlying()).acquireReadLock(rid);
        } else {
            throw new IllegalStateException("Unsupported locking strategy " + (Object)((Object)lockingStrategy));
        }
        lockedRecordMetadata.locksCount++;
        if (addItem) {
            this.locks.put(rid, lockedRecordMetadata);
        }
        return this;
    }

    @Override
    public boolean isLockedRecord(OIdentifiable iRecord) {
        ORID rid = iRecord.getIdentity();
        LockedRecordMetadata lockedRecordMetadata = this.locks.get(rid);
        return lockedRecordMetadata != null && lockedRecordMetadata.locksCount != 0;
    }

    @Override
    public OStorage.LOCKING_STRATEGY lockingStrategy(OIdentifiable record) {
        ORID rid = record.getIdentity();
        LockedRecordMetadata lockedRecordMetadata = this.locks.get(rid);
        if (lockedRecordMetadata == null || lockedRecordMetadata.locksCount == 0) {
            return null;
        }
        return lockedRecordMetadata.strategy;
    }

    @Override
    public OTransaction unlockRecord(OIdentifiable iRecord) {
        OStorage stg = this.database.getStorage();
        if (!(stg.getUnderlying() instanceof OAbstractPaginatedStorage)) {
            throw new OLockException("Cannot lock record across remote connections");
        }
        ORID rid = iRecord.getIdentity();
        LockedRecordMetadata lockedRecordMetadata = this.locks.get(rid);
        if (lockedRecordMetadata == null || lockedRecordMetadata.locksCount == 0) {
            throw new OLockException("Cannot unlock a never acquired lock");
        }
        if (lockedRecordMetadata.strategy == OStorage.LOCKING_STRATEGY.EXCLUSIVE_LOCK) {
            ((OAbstractPaginatedStorage)stg.getUnderlying()).releaseWriteLock(rid);
        } else if (lockedRecordMetadata.strategy == OStorage.LOCKING_STRATEGY.SHARED_LOCK) {
            ((OAbstractPaginatedStorage)stg.getUnderlying()).releaseReadLock(rid);
        } else {
            throw new IllegalStateException("Unsupported locking strategy " + (Object)((Object)lockedRecordMetadata.strategy));
        }
        lockedRecordMetadata.locksCount--;
        if (lockedRecordMetadata.locksCount == 0) {
            this.locks.remove(rid);
        }
        return this;
    }

    @Override
    public HashMap<ORID, OStorage.LOCKING_STRATEGY> getLockedRecords() {
        HashMap<ORID, OStorage.LOCKING_STRATEGY> lockedRecords = new HashMap<ORID, OStorage.LOCKING_STRATEGY>();
        for (Map.Entry<ORID, LockedRecordMetadata> entry : this.locks.entrySet()) {
            if (entry.getValue().locksCount <= 0) continue;
            lockedRecords.put(entry.getKey(), entry.getValue().strategy);
        }
        return lockedRecords;
    }

    public String getClusterName(ORecord record) {
        if (ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().isRemote()) {
            return null;
        }
        int clusterId = record.getIdentity().getClusterId();
        if (clusterId == -1) {
            OImmutableClass schemaClass = null;
            if (record instanceof ODocument) {
                schemaClass = ODocumentInternal.getImmutableSchemaClass((ODocument)record);
            }
            if (schemaClass != null) {
                if (schemaClass.isAbstract()) {
                    throw new OSchemaException("Document belongs to abstract class '" + schemaClass.getName() + "' and cannot be saved");
                }
                clusterId = schemaClass.getClusterForNewInstance((ODocument)record);
                return this.database.getClusterNameById(clusterId);
            }
            return this.database.getClusterNameById(this.database.getStorage().getDefaultClusterId());
        }
        return this.database.getClusterNameById(clusterId);
    }

    private static final class LockedRecordMetadata {
        private final OStorage.LOCKING_STRATEGY strategy;
        private int locksCount;

        public LockedRecordMetadata(OStorage.LOCKING_STRATEGY strategy) {
            this.strategy = strategy;
        }
    }
}

