/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.directmemory;

import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.directmemory.OByteBufferPoolMXBean;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.exception.OSystemException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.LogManager;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class OByteBufferPool
implements OByteBufferPoolMXBean {
    public static final String MBEAN_NAME = "com.orientechnologies.common.directmemory:type=OByteBufferPoolMXBean";
    private static final boolean TRACK = OGlobalConfiguration.DIRECT_MEMORY_TRACK_MODE.getValueAsBoolean();
    private final int pageSize;
    private final ByteBuffer zeroPage;
    private final AtomicReference<BufferHolder> lastPreallocatedArea;
    private final AtomicLong nextAllocationPosition = new AtomicLong();
    private final int maxPagesPerSingleArea;
    private final long preAllocationLimit;
    private final ConcurrentLinkedQueue<ByteBuffer> pool = new ConcurrentLinkedQueue();
    private final AtomicLong overflowBufferCount = new AtomicLong();
    private final AtomicBoolean mbeanIsRegistered = new AtomicBoolean();
    private final ReferenceQueue<ByteBuffer> trackedBuffersQueue;
    private final Set<TrackedBufferReference> trackedReferences;
    private final Map<TrackedBufferKey, TrackedBufferReference> trackedBuffers;
    private final Map<TrackedBufferKey, Exception> trackedReleases;

    public static OByteBufferPool instance() {
        return InstanceHolder.INSTANCE;
    }

    public OByteBufferPool(int pageSize) {
        this(pageSize, -1, -1L);
    }

    public OByteBufferPool(int pageSize, int maxChunkSize, long preAllocationLimit) {
        this.pageSize = pageSize;
        this.zeroPage = ByteBuffer.allocateDirect(pageSize).order(ByteOrder.nativeOrder());
        this.preAllocationLimit = preAllocationLimit / (long)pageSize * (long)pageSize;
        int pagesPerArea = maxChunkSize / pageSize;
        if (pagesPerArea > 1) {
            pagesPerArea = this.closestPowerOfTwo(pagesPerArea);
            while ((long)pagesPerArea * (long)pageSize >= (long)maxChunkSize) {
                pagesPerArea >>>= 1;
            }
            this.maxPagesPerSingleArea = pagesPerArea;
            this.lastPreallocatedArea = new AtomicReference();
        } else {
            this.maxPagesPerSingleArea = 1;
            this.lastPreallocatedArea = null;
        }
        if (TRACK) {
            this.trackedBuffersQueue = new ReferenceQueue();
            this.trackedReferences = new HashSet<TrackedBufferReference>();
            this.trackedBuffers = new HashMap<TrackedBufferKey, TrackedBufferReference>();
            this.trackedReleases = new HashMap<TrackedBufferKey, Exception>();
        } else {
            this.trackedBuffersQueue = null;
            this.trackedReferences = null;
            this.trackedBuffers = null;
            this.trackedReleases = null;
        }
    }

    public int getSize() {
        return this.pool.size();
    }

    public int getMaxPagesPerChunk() {
        return this.maxPagesPerSingleArea;
    }

    private int closestPowerOfTwo(int value) {
        int n = value - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer acquireDirect(boolean clear) {
        ByteBuffer buffer = this.pool.poll();
        if (buffer != null) {
            if (clear) {
                buffer.position(0);
                buffer.put(this.zeroPage.duplicate());
            }
            buffer.position(0);
            return this.trackBuffer(buffer);
        }
        if (this.maxPagesPerSingleArea > 1) {
            long currentAllocationPosition = this.nextAllocationPosition.getAndIncrement();
            int position = (int)(currentAllocationPosition & (long)(this.maxPagesPerSingleArea - 1));
            int bufferIndex = (int)(currentAllocationPosition / (long)this.maxPagesPerSingleArea);
            if (currentAllocationPosition >= this.preAllocationLimit) {
                return this.trackBuffer(ByteBuffer.allocateDirect(this.pageSize).order(ByteOrder.nativeOrder()));
            }
            int allocationSize = (int)Math.min((long)(this.maxPagesPerSingleArea * this.pageSize), (this.preAllocationLimit - (long)(bufferIndex * this.maxPagesPerSingleArea)) * (long)this.pageSize);
            BufferHolder bfh = null;
            try {
                block20: {
                    while (true) {
                        BufferHolder bufferHolder;
                        bfh = this.lastPreallocatedArea.get();
                        assert (bfh == null || bfh.index <= bufferIndex);
                        if (bfh == null) {
                            bfh = new BufferHolder(bufferIndex);
                            if (!this.lastPreallocatedArea.compareAndSet(null, bfh)) continue;
                            this.allocateBuffer(bfh, allocationSize);
                        } else if (bfh.buffer == null) {
                            try {
                                bfh.latch.await();
                            }
                            catch (InterruptedException e) {
                                throw OException.wrapException(new OInterruptedException("Wait of new preallocated memory area was interrupted"), e);
                            }
                        }
                        if (bfh.index >= bufferIndex) break block20;
                        int requestedPages = bfh.requested.get();
                        if (requestedPages < this.maxPagesPerSingleArea) {
                            try {
                                bfh.filled.await();
                            }
                            catch (InterruptedException e) {
                                throw OException.wrapException(new OInterruptedException("Wait of new preallocated memory area was interrupted"), e);
                            }
                        }
                        if (this.lastPreallocatedArea.compareAndSet(bfh, bufferHolder = new BufferHolder(bufferIndex))) {
                            bfh = bufferHolder;
                            this.allocateBuffer(bfh, allocationSize);
                            break block20;
                        }
                        if (!$assertionsDisabled && bufferHolder.index != bufferIndex) break;
                    }
                    throw new AssertionError();
                }
                int rawPosition = position * this.pageSize;
                ByteBuffer db = bfh.buffer.duplicate();
                db.position(rawPosition);
                db.limit(rawPosition + this.pageSize);
                ByteBuffer slice = db.slice();
                slice.order(ByteOrder.nativeOrder());
                if (clear) {
                    slice.position(0);
                    slice.put(this.zeroPage.duplicate());
                }
                slice.position(0);
                ByteBuffer byteBuffer = this.trackBuffer(slice);
                return byteBuffer;
            }
            finally {
                int completedRequests;
                if (bfh != null && (completedRequests = bfh.requested.incrementAndGet()) == this.maxPagesPerSingleArea) {
                    bfh.filled.countDown();
                }
            }
        }
        this.overflowBufferCount.incrementAndGet();
        return this.trackBuffer(ByteBuffer.allocateDirect(this.pageSize).order(ByteOrder.nativeOrder()));
    }

    private void allocateBuffer(BufferHolder bfh, int allocationSize) {
        try {
            bfh.buffer = ByteBuffer.allocateDirect(allocationSize).order(ByteOrder.nativeOrder());
        }
        finally {
            bfh.latch.countDown();
        }
    }

    public void release(ByteBuffer buffer) {
        this.pool.offer(this.untrackBuffer(buffer));
    }

    @Override
    public int getBufferSize() {
        return this.pageSize;
    }

    @Override
    public long getAllocatedBufferCount() {
        return this.nextAllocationPosition.get();
    }

    @Override
    public long getOverflowBufferCount() {
        return this.overflowBufferCount.get();
    }

    @Override
    public int getBuffersInThePool() {
        return this.getSize();
    }

    @Override
    public long getAllocatedMemory() {
        long memory = this.getOverflowBufferCount();
        long allocatedAreas = (this.getAllocatedBufferCount() + (long)this.maxPagesPerSingleArea - 1L) / (long)this.maxPagesPerSingleArea;
        return (memory += allocatedAreas * (long)this.maxPagesPerSingleArea) * (long)this.pageSize;
    }

    @Override
    public long getAllocatedMemoryInMB() {
        return this.getAllocatedMemory() / 0x100000L;
    }

    @Override
    public double getAllocatedMemoryInGB() {
        return Math.ceil((double)(this.getAllocatedMemory() * 100L) / 1.073741824E9) / 100.0;
    }

    public void registerMBean() {
        if (this.mbeanIsRegistered.compareAndSet(false, true)) {
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                ObjectName mbeanName = new ObjectName(MBEAN_NAME);
                if (!server.isRegistered(mbeanName)) {
                    server.registerMBean(this, mbeanName);
                } else {
                    this.mbeanIsRegistered.set(false);
                    OLogManager.instance().warn((Object)this, "MBean with name %s has already registered. Probably your system was not shutdown correctly or you have several running applications which use OrientDB engine inside", mbeanName.getCanonicalName());
                }
            }
            catch (MalformedObjectNameException e) {
                throw OException.wrapException(new OSystemException("Error during registration of byte buffer pool MBean"), e);
            }
            catch (InstanceAlreadyExistsException e) {
                throw OException.wrapException(new OSystemException("Error during registration of byte buffer pool MBean"), e);
            }
            catch (MBeanRegistrationException e) {
                throw OException.wrapException(new OSystemException("Error during registration of byte buffer pool MBean"), e);
            }
            catch (NotCompliantMBeanException e) {
                throw OException.wrapException(new OSystemException("Error during registration of byte buffer pool MBean"), e);
            }
        }
    }

    public void unregisterMBean() {
        if (this.mbeanIsRegistered.compareAndSet(true, false)) {
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                ObjectName mbeanName = new ObjectName(MBEAN_NAME);
                server.unregisterMBean(mbeanName);
            }
            catch (MalformedObjectNameException e) {
                throw OException.wrapException(new OSystemException("Error during unregistration of byte buffer pool MBean"), e);
            }
            catch (InstanceNotFoundException e) {
                throw OException.wrapException(new OSystemException("Error during unregistration of byte buffer pool MBean"), e);
            }
            catch (MBeanRegistrationException e) {
                throw OException.wrapException(new OSystemException("Error during unregistration of byte buffer pool MBean"), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyState() {
        if (TRACK) {
            OByteBufferPool oByteBufferPool = this;
            synchronized (oByteBufferPool) {
                boolean logsInAssertions = OByteBufferPool.logInAssertion();
                StringBuilder builder = logsInAssertions ? new StringBuilder() : null;
                for (TrackedBufferReference reference : this.trackedReferences) {
                    OByteBufferPool.log(builder, this, "DIRECT-TRACK: unreleased direct memory buffer `%X` detected.", reference.stackTrace, reference.id);
                }
                this.checkTrackedBuffersLeaks(builder);
                if (logsInAssertions) {
                    if (builder.length() > 0) {
                        throw new AssertionError((Object)builder.toString());
                    }
                } else assert (this.trackedReferences.size() == 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer trackBuffer(ByteBuffer buffer) {
        if (TRACK) {
            OByteBufferPool oByteBufferPool = this;
            synchronized (oByteBufferPool) {
                boolean logInAssertion = OByteBufferPool.logInAssertion();
                StringBuilder logBuilder = logInAssertion ? new StringBuilder() : null;
                TrackedBufferReference reference = new TrackedBufferReference(buffer, this.trackedBuffersQueue);
                this.trackedReferences.add(reference);
                this.trackedBuffers.put(new TrackedBufferKey(buffer), reference);
                this.checkTrackedBuffersLeaks(logBuilder);
                if (logInAssertion && logBuilder.length() > 0) {
                    throw new AssertionError((Object)logBuilder.toString());
                }
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer untrackBuffer(ByteBuffer buffer) {
        if (TRACK) {
            OByteBufferPool oByteBufferPool = this;
            synchronized (oByteBufferPool) {
                boolean logInAssertion = OByteBufferPool.logInAssertion();
                StringBuilder logBuilder = logInAssertion ? new StringBuilder() : null;
                TrackedBufferKey trackedBufferKey = new TrackedBufferKey(buffer);
                TrackedBufferReference reference = this.trackedBuffers.remove(trackedBufferKey);
                if (reference == null) {
                    OByteBufferPool.log(logBuilder, this, "DIRECT-TRACK: untracked direct byte buffer `%X` detected.", new Exception(), OByteBufferPool.id(buffer));
                    Exception lastRelease = this.trackedReleases.get(trackedBufferKey);
                    if (lastRelease != null) {
                        OByteBufferPool.log(logBuilder, this, "DIRECT-TRACK: last release.", lastRelease, new Object[0]);
                    }
                    if (logInAssertion) {
                        if (logBuilder.length() > 0) {
                            throw new AssertionError((Object)logBuilder.toString());
                        }
                    } else assert (false);
                } else {
                    this.trackedReferences.remove(reference);
                }
                this.trackedReleases.put(trackedBufferKey, new Exception());
                this.checkTrackedBuffersLeaks(logBuilder);
                if (logInAssertion && logBuilder.length() > 0) {
                    throw new AssertionError((Object)logBuilder.toString());
                }
            }
        }
        return buffer;
    }

    private void checkTrackedBuffersLeaks(StringBuilder logBuilder) {
        TrackedBufferReference reference;
        boolean leaked = false;
        while ((reference = (TrackedBufferReference)this.trackedBuffersQueue.poll()) != null) {
            if (!this.trackedReferences.remove(reference)) continue;
            OByteBufferPool.log(logBuilder, this, "DIRECT-TRACK: unreleased direct byte buffer `%X` detected.", reference.stackTrace, reference.id);
            leaked = true;
        }
        if (logBuilder == null) assert (!leaked);
    }

    private static int id(Object object) {
        return System.identityHashCode(object);
    }

    private static boolean logInAssertion() {
        boolean assertionsEnabled = false;
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return assertionsEnabled && !(LogManager.getLogManager() instanceof OLogManager.DebugLogManager);
    }

    private static void log(StringBuilder builder, Object from, String message, Throwable exception, Object ... args) {
        if (builder == null) {
            OLogManager.instance().error(from, message, exception, args);
        } else {
            String newLine = String.format("%n", new Object[0]);
            builder.append(String.format(message, args)).append(newLine);
            if (exception != null) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                exception.printStackTrace(printWriter);
                builder.append(stringWriter.toString());
            }
        }
    }

    private static class InstanceHolder {
        private static final OByteBufferPool INSTANCE;

        private InstanceHolder() {
        }

        static {
            int pageSize = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024;
            int memoryChunkSize = OGlobalConfiguration.MEMORY_CHUNK_SIZE.getValueAsInteger();
            long diskCacheSize = (long)OGlobalConfiguration.DISK_CACHE_SIZE.getValueAsInteger() * 1024L * 1024L;
            INSTANCE = new OByteBufferPool(pageSize, memoryChunkSize, diskCacheSize);
        }
    }

    private static class TrackedBufferKey
    extends WeakReference<ByteBuffer> {
        private final int hashCode;

        public TrackedBufferKey(ByteBuffer referent) {
            super(referent);
            this.hashCode = System.identityHashCode(referent);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            ByteBuffer buffer = (ByteBuffer)this.get();
            return buffer != null && buffer == ((TrackedBufferKey)obj).get();
        }
    }

    private static class TrackedBufferReference
    extends WeakReference<ByteBuffer> {
        public final int id;
        public final Exception stackTrace;

        public TrackedBufferReference(ByteBuffer referent, ReferenceQueue<? super ByteBuffer> q) {
            super(referent, q);
            this.id = OByteBufferPool.id(referent);
            this.stackTrace = new Exception();
        }
    }

    private static final class BufferHolder {
        private volatile ByteBuffer buffer;
        private final CountDownLatch latch = new CountDownLatch(1);
        private final CountDownLatch filled = new CountDownLatch(1);
        private final AtomicInteger requested = new AtomicInteger();
        private final int index;

        public BufferHolder(int index) {
            this.index = index;
        }
    }
}

