/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.util;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class OMemory {
    private static final String XX_MAX_DIRECT_MEMORY_SIZE = "-XX:MaxDirectMemorySize=";

    public static long getCappedRuntimeMaxMemory(long unlimitedCap) {
        long jvmMaxMemory = Runtime.getRuntime().maxMemory();
        return jvmMaxMemory == Long.MAX_VALUE ? unlimitedCap : jvmMaxMemory;
    }

    public static long getPhysicalMemorySize() {
        long osMemory = -1L;
        OperatingSystemMXBean mxBean = ManagementFactory.getOperatingSystemMXBean();
        try {
            Method memorySize = mxBean.getClass().getDeclaredMethod("getTotalPhysicalMemorySize", new Class[0]);
            memorySize.setAccessible(true);
            osMemory = (Long)memorySize.invoke((Object)mxBean, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            if (!OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().warn(OMemory.class, "Unable to determine the amount of installed RAM.", new Object[0]);
            } else {
                OLogManager.instance().debug(OMemory.class, "Unable to determine the amount of installed RAM.", e, new Object[0]);
            }
        }
        catch (InvocationTargetException e) {
            if (!OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().warn(OMemory.class, "Unable to determine the amount of installed RAM.", new Object[0]);
            } else {
                OLogManager.instance().debug(OMemory.class, "Unable to determine the amount of installed RAM.", e, new Object[0]);
            }
        }
        catch (IllegalAccessException e) {
            if (!OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().warn(OMemory.class, "Unable to determine the amount of installed RAM.", new Object[0]);
            }
            OLogManager.instance().debug(OMemory.class, "Unable to determine the amount of installed RAM.", e, new Object[0]);
        }
        return osMemory;
    }

    public static long getConfiguredMaxDirectMemory() {
        long maxDirectMemorySize = -1L;
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> vmArgs = runtimeMXBean.getInputArguments();
        for (String arg : vmArgs) {
            if (!arg.startsWith(XX_MAX_DIRECT_MEMORY_SIZE)) continue;
            try {
                maxDirectMemorySize = OMemory.parseVmArgsSize(arg.substring(XX_MAX_DIRECT_MEMORY_SIZE.length()));
            }
            catch (IllegalArgumentException e) {
                OLogManager.instance().error(OMemory.class, "Unable to parse the value of -XX:MaxDirectMemorySize option.", e, new Object[0]);
            }
            break;
        }
        return maxDirectMemorySize;
    }

    public static long getMaxCacheMemorySize() {
        return OGlobalConfiguration.DISK_CACHE_SIZE.getValueAsLong() * 1024L * 1024L;
    }

    public static void checkDirectMemoryConfiguration() throws OConfigurationException {
        long physicalMemory = OMemory.getPhysicalMemorySize();
        long maxDirectMemory = OMemory.getConfiguredMaxDirectMemory();
        if (maxDirectMemory == -1L) {
            if (physicalMemory != -1L) {
                OLogManager.instance().warn(OMemory.class, "MaxDirectMemorySize JVM option is not set or has invalid value, that may cause out of memory errors. Please set the -XX:MaxDirectMemorySize=" + physicalMemory / 0x100000L + "m option when you start the JVM.", new Object[0]);
            } else {
                OLogManager.instance().warn(OMemory.class, "MaxDirectMemorySize JVM option is not set or has invalid value, that may cause out of memory errors. Please set the -XX:MaxDirectMemorySize=<SIZE>m JVM option when you start the JVM, where <SIZE> is the memory size of this machine in megabytes.", new Object[0]);
            }
        }
    }

    public static void checkCacheMemoryConfiguration() {
        long maxHeapSize = Runtime.getRuntime().maxMemory();
        long maxCacheSize = OMemory.getMaxCacheMemorySize();
        long physicalMemory = OMemory.getPhysicalMemorySize();
        long maxDirectMemory = OMemory.getConfiguredMaxDirectMemory();
        if (maxDirectMemory != -1L && maxCacheSize > maxDirectMemory) {
            OLogManager.instance().warn(OMemory.class, "Configured maximum amount of memory available to the cache (" + maxCacheSize + " bytes) is larger than configured JVM maximum direct memory size (" + maxDirectMemory + " bytes). That may cause out of memory errors, please tune the configuration up. Use the -XX:MaxDirectMemorySize JVM option to raise the JVM maximum direct memory size or storage.diskCache.bufferSize OrientDB option to lower memory requirements of the cache.", new Object[0]);
        }
        if (maxHeapSize != Long.MAX_VALUE && physicalMemory != -1L && maxHeapSize + maxCacheSize > physicalMemory) {
            OLogManager.instance().warn(OMemory.class, "The sum of the configured JVM maximum heap size (" + maxHeapSize + " bytes) and the OrientDB maximum cache size (" + maxCacheSize + " bytes) is larger than the available physical memory size (" + physicalMemory + " bytes). That may cause out of memory errors, please tune the configuration up. Use the -Xmx JVM option to lower the JVM maximum heap memory size or storage.diskCache.bufferSize OrientDB option to lower memory requirements of the cache.", new Object[0]);
        }
    }

    public static void checkByteBufferPoolConfiguration() {
        long maxDirectMemory = OMemory.getConfiguredMaxDirectMemory();
        long memoryChunkSize = OGlobalConfiguration.MEMORY_CHUNK_SIZE.getValueAsLong();
        long maxCacheSize = OMemory.getMaxCacheMemorySize();
        if (maxDirectMemory != -1L && memoryChunkSize > maxDirectMemory) {
            OLogManager.instance().warn(OMemory.class, "The configured memory chunk size (" + memoryChunkSize + " bytes) is larger than the configured maximum amount of JVM direct memory (" + maxDirectMemory + " bytes). That may cause out of memory errors, please tune the configuration up. Use the -XX:MaxDirectMemorySize JVM option to raise the JVM maximum direct memory size or memory.chunk.size OrientDB option to lower memory chunk size.", new Object[0]);
        }
        if (memoryChunkSize > maxCacheSize) {
            OLogManager.instance().warn(OMemory.class, "The configured memory chunk size (" + memoryChunkSize + " bytes) is larger than the configured maximum cache size (" + maxCacheSize + " bytes). That may cause overallocation of a memory which will be wasted, please tune the configuration up. Use the storage.diskCache.bufferSize OrientDB option to raise the cache memory size or memory.chunk.size OrientDB option to lower memory chunk size.", new Object[0]);
        }
    }

    public static void fixCommonConfigurationProblems() {
        long maxDiskCacheSize;
        long maxDirectMemory = OMemory.getConfiguredMaxDirectMemory();
        long diskCacheSize = OGlobalConfiguration.DISK_CACHE_SIZE.getValueAsLong();
        if (maxDirectMemory != -1L && diskCacheSize > (maxDiskCacheSize = Math.min(maxDirectMemory / 1024L / 1024L, Integer.MAX_VALUE))) {
            OLogManager.instance().info(OGlobalConfiguration.class, "Lowering disk cache size from %,dMB to %,dMB.", diskCacheSize, maxDiskCacheSize);
            OGlobalConfiguration.DISK_CACHE_SIZE.setValue(maxDiskCacheSize);
            diskCacheSize = maxDiskCacheSize;
        }
        int max32BitCacheSize = 512;
        if (OMemory.getJavaBitWidth() == 32 && diskCacheSize > 512L) {
            OLogManager.instance().info(OGlobalConfiguration.class, "32 bit JVM is detected. Lowering disk cache size from %,dMB to %,dMB.", diskCacheSize, 512);
            OGlobalConfiguration.DISK_CACHE_SIZE.setValue(512);
        }
        if (OGlobalConfiguration.MEMORY_CHUNK_SIZE.getValueAsLong() > OGlobalConfiguration.DISK_CACHE_SIZE.getValueAsLong() * 1024L * 1024L) {
            long newChunkSize = Math.min(OGlobalConfiguration.DISK_CACHE_SIZE.getValueAsLong() * 1024L * 1024L, Integer.MAX_VALUE);
            OLogManager.instance().info(OGlobalConfiguration.class, "Lowering memory chunk size from %,dB to %,dB.", OGlobalConfiguration.MEMORY_CHUNK_SIZE.getValueAsLong(), newChunkSize);
            OGlobalConfiguration.MEMORY_CHUNK_SIZE.setValue(newChunkSize);
        }
    }

    private static int getJavaBitWidth() {
        String dataModel = System.getProperty("sun.arch.data.model", "64");
        int size = 64;
        try {
            size = Integer.parseInt(dataModel);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return size;
    }

    public static long parseVmArgsSize(String text) throws IllegalArgumentException {
        if (text == null) {
            throw new IllegalArgumentException("text can't be null");
        }
        if (text.length() == 0) {
            throw new IllegalArgumentException("text can't be empty");
        }
        char unit = text.charAt(text.length() - 1);
        if (Character.isDigit(unit)) {
            return Long.parseLong(text);
        }
        long value = Long.parseLong(text.substring(0, text.length() - 1));
        switch (Character.toLowerCase(unit)) {
            case 'g': {
                return value * 1024L * 1024L * 1024L;
            }
            case 'm': {
                return value * 1024L * 1024L;
            }
            case 'k': {
                return value * 1024L;
            }
        }
        throw new IllegalArgumentException("text '" + text + "' is not a size specifier.");
    }

    private OMemory() {
    }
}

