/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.sequence;

import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.sequence.OSequence;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.concurrent.Callable;

public class OSequenceCached
extends OSequence {
    private static final String FIELD_CACHE = "cache";
    private long cacheStart = 0L;
    private long cacheEnd = 0L;

    public OSequenceCached() {
    }

    public OSequenceCached(ODocument iDocument) {
        super(iDocument);
    }

    public OSequenceCached(ODocument iDocument, OSequence.CreateParams params) {
        super(iDocument, params);
    }

    @Override
    public boolean updateParams(OSequence.CreateParams params) {
        boolean any = super.updateParams(params);
        if (params.cacheSize != null && this.getCacheSize() != params.cacheSize.intValue()) {
            this.setCacheSize(params.cacheSize);
            any = true;
        }
        return any;
    }

    @Override
    protected void initSequence(OSequence.CreateParams params) {
        super.initSequence(params);
        this.setCacheSize(params.cacheSize);
    }

    @Override
    public long next() {
        return this.callRetry(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                int increment = OSequenceCached.this.getIncrement();
                if (OSequenceCached.this.cacheStart + (long)increment >= OSequenceCached.this.cacheEnd) {
                    OSequenceCached.this.allocateCache(OSequenceCached.this.getCacheSize());
                }
                OSequenceCached.this.cacheStart = OSequenceCached.this.cacheStart + (long)increment;
                return OSequenceCached.this.cacheStart;
            }
        }, "next");
    }

    @Override
    public long current() {
        return this.cacheStart;
    }

    @Override
    public long reset() {
        return this.callRetry(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                long newValue = OSequenceCached.this.getStart();
                OSequenceCached.this.setValue(newValue);
                OSequenceCached.this.save();
                OSequenceCached.this.allocateCache(OSequenceCached.this.getCacheSize());
                return newValue;
            }
        }, "reset");
    }

    @Override
    public OSequence.SEQUENCE_TYPE getSequenceType() {
        return OSequence.SEQUENCE_TYPE.CACHED;
    }

    public int getCacheSize() {
        return (Integer)this.getDocument().field(FIELD_CACHE, OType.INTEGER);
    }

    public void setCacheSize(int cacheSize) {
        this.getDocument().field(FIELD_CACHE, cacheSize);
    }

    private void allocateCache(int cacheSize) {
        long value = this.getValue();
        long newValue = value + (long)(this.getIncrement() * cacheSize);
        this.setValue(newValue);
        this.save();
        this.cacheStart = value;
        this.cacheEnd = newValue - 1L;
    }
}

