/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordAbstract;
import com.orientechnologies.orient.core.record.impl.OBlob;
import com.orientechnologies.orient.core.serialization.OMemoryStream;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class ORecordBytes
extends ORecordAbstract
implements OBlob {
    private static final long serialVersionUID = 1L;
    private static final byte[] EMPTY_SOURCE = new byte[0];

    public ORecordBytes() {
        this.setup();
    }

    public ORecordBytes(ODatabaseDocumentInternal iDatabase) {
        this.setup();
        ODatabaseRecordThreadLocal.INSTANCE.set(iDatabase);
    }

    public ORecordBytes(ODatabaseDocumentInternal iDatabase, byte[] iSource) {
        this(iSource);
        ODatabaseRecordThreadLocal.INSTANCE.set(iDatabase);
    }

    public ORecordBytes(byte[] iSource) {
        super(iSource);
        this._dirty = true;
        this._contentChanged = true;
        this.setup();
    }

    public ORecordBytes(ORID iRecordId) {
        this._recordId = (ORecordId)iRecordId;
        this.setup();
    }

    public ORecordBytes reset(byte[] iSource) {
        this.reset();
        this._source = iSource;
        return this;
    }

    public ORecordBytes copy() {
        return (ORecordBytes)this.copyTo(new ORecordBytes());
    }

    @Override
    public ORecordBytes fromStream(byte[] iRecordBuffer) {
        this._source = iRecordBuffer;
        this._status = ORecordElement.STATUS.LOADED;
        return this;
    }

    @Override
    public ORecordAbstract clear() {
        this.clearSource();
        return super.clear();
    }

    @Override
    public byte[] toStream() {
        return this._source;
    }

    @Override
    public byte getRecordType() {
        return 98;
    }

    @Override
    protected void setup() {
        super.setup();
        this._recordFormat = ORecordSerializerFactory.instance().getFormat("ORecordDocumentRaw");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int fromInputStream(InputStream in) throws IOException {
        OMemoryStream out = new OMemoryStream();
        try {
            int readBytesCount;
            byte[] buffer = new byte[1024];
            while ((readBytesCount = in.read(buffer, 0, buffer.length)) != -1) {
                out.write(buffer, 0, readBytesCount);
            }
            out.flush();
            this._source = out.toByteArray();
        }
        finally {
            out.close();
        }
        this._size = this._source.length;
        return this._size;
    }

    @Override
    public int fromInputStream(InputStream in, int maxSize) throws IOException {
        int totalBytesCount;
        int readBytesCount;
        byte[] buffer = new byte[maxSize];
        for (totalBytesCount = 0; totalBytesCount < maxSize && (readBytesCount = in.read(buffer, totalBytesCount, buffer.length - totalBytesCount)) != -1; totalBytesCount += readBytesCount) {
        }
        if (totalBytesCount == 0) {
            this._source = EMPTY_SOURCE;
            this._size = 0;
        } else if (totalBytesCount == maxSize) {
            this._source = buffer;
            this._size = maxSize;
        } else {
            this._source = Arrays.copyOf(buffer, totalBytesCount);
            this._size = totalBytesCount;
        }
        return this._size;
    }

    @Override
    public void toOutputStream(OutputStream out) throws IOException {
        this.checkForLoading();
        if (this._source.length > 0) {
            out.write(this._source);
        }
    }
}

