/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.parser.OAndBlock;
import com.orientechnologies.orient.core.sql.parser.OBinaryCondition;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OOrBlock
extends OBooleanExpression {
    List<OBooleanExpression> subBlocks = new ArrayList<OBooleanExpression>();

    public OOrBlock(int id) {
        super(id);
    }

    public OOrBlock(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public boolean evaluate(OIdentifiable currentRecord, OCommandContext ctx) {
        if (this.getSubBlocks() == null) {
            return true;
        }
        for (OBooleanExpression block : this.subBlocks) {
            if (!block.evaluate(currentRecord, ctx)) continue;
            return true;
        }
        return false;
    }

    public boolean evaluate(Object currentRecord, OCommandContext ctx) {
        if (currentRecord instanceof OIdentifiable) {
            return this.evaluate((OIdentifiable)currentRecord, ctx);
        }
        if (currentRecord instanceof Map) {
            ODocument doc = new ODocument();
            doc.fromMap((Map)currentRecord);
            return this.evaluate(doc, ctx);
        }
        return false;
    }

    public List<OBooleanExpression> getSubBlocks() {
        return this.subBlocks;
    }

    public void setSubBlocks(List<OBooleanExpression> subBlocks) {
        this.subBlocks = subBlocks;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.subBlocks == null || this.subBlocks.size() == 0) {
            return;
        }
        boolean first = true;
        for (OBooleanExpression expr : this.subBlocks) {
            if (!first) {
                builder.append(" OR ");
            }
            expr.toString(params, builder);
            first = false;
        }
    }

    @Override
    protected boolean supportsBasicCalculation() {
        for (OBooleanExpression expr : this.subBlocks) {
            if (expr.supportsBasicCalculation()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected int getNumberOfExternalCalculations() {
        int result = 0;
        for (OBooleanExpression expr : this.subBlocks) {
            result += expr.getNumberOfExternalCalculations();
        }
        return result;
    }

    @Override
    protected List<Object> getExternalCalculationConditions() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (OBooleanExpression expr : this.subBlocks) {
            result.addAll(expr.getExternalCalculationConditions());
        }
        return result;
    }

    @Override
    public List<OBinaryCondition> getIndexedFunctionConditions(OClass iSchemaClass, ODatabaseDocumentInternal database) {
        if (this.subBlocks == null || this.subBlocks.size() > 1) {
            return null;
        }
        ArrayList<OBinaryCondition> result = new ArrayList<OBinaryCondition>();
        for (OBooleanExpression exp : this.subBlocks) {
            List<OBinaryCondition> sub = exp.getIndexedFunctionConditions(iSchemaClass, database);
            if (sub == null || sub.size() <= 0) continue;
            result.addAll(sub);
        }
        return result.size() == 0 ? null : result;
    }

    @Override
    public List<OAndBlock> flatten() {
        ArrayList<OAndBlock> result = new ArrayList<OAndBlock>();
        for (OBooleanExpression sub : this.subBlocks) {
            List<OAndBlock> childFlattened = sub.flatten();
            for (OAndBlock child : childFlattened) {
                result.add(child);
            }
        }
        return result;
    }
}

