/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache.local.twoq;

import com.orientechnologies.common.concur.lock.ODistributedCounter;
import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.concur.lock.OPartitionedLockManager;
import com.orientechnologies.common.concur.lock.OReadersWriterSpinLock;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OAllCacheEntriesAreUsedException;
import com.orientechnologies.orient.core.exception.OReadCacheException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.cache.OAbstractWriteCache;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cache.OCachePointer;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.cache.local.twoq.ConcurrentLRUList;
import com.orientechnologies.orient.core.storage.cache.local.twoq.LRUList;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OSessionStoragePerformanceStatistic;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;

public class O2QCache
implements OReadCache {
    public static final int MAX_PERCENT_OF_PINED_PAGES = 50;
    public static final int MIN_CACHE_SIZE = 256;
    private static final int MAX_AMOUNT_OF_WARNINGS_PINNED_PAGES = 10;
    private static final int MAX_CACHE_OVERFLOW = Runtime.getRuntime().availableProcessors() * 8;
    public static final String CACHE_STATE_FILE = "cache.stt";
    public static final String CACHE_STATISTIC_FILE_EXTENSION = ".stt";
    private final LRUList am;
    private final LRUList a1out;
    private final LRUList a1in;
    private final int pageSize;
    private final ODistributedCounter pinnedPagesWarningCounter = new ODistributedCounter();
    private volatile int pinnedPagesWarningsCache = 0;
    private final AtomicReference<MemoryData> memoryDataContainer = new AtomicReference();
    private final ConcurrentMap<Long, Set<Long>> filePages;
    private final int percentOfPinnedPages;
    private final OReadersWriterSpinLock cacheLock = new OReadersWriterSpinLock();
    private final OLockManager fileLockManager = new OPartitionedLockManager(true);
    private final OLockManager<PageKey> pageLockManager = new OPartitionedLockManager<PageKey>();
    private final ConcurrentMap<PinnedPage, OCacheEntry> pinnedPages = new ConcurrentHashMap<PinnedPage, OCacheEntry>();
    private final AtomicBoolean coldPagesRemovalInProgress = new AtomicBoolean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public O2QCache(long readCacheMaxMemory, int pageSize, boolean checkMinSize, int percentOfPinnedPages) {
        if (percentOfPinnedPages > 50) {
            throw new IllegalArgumentException("Percent of pinned pages cannot be more than " + percentOfPinnedPages + " but passed value is " + percentOfPinnedPages);
        }
        this.percentOfPinnedPages = percentOfPinnedPages;
        this.cacheLock.acquireWriteLock();
        try {
            this.pageSize = pageSize;
            this.filePages = new ConcurrentHashMap<Long, Set<Long>>();
            int normalizedSize = this.normalizeMemory(readCacheMaxMemory, pageSize);
            if (checkMinSize && normalizedSize < 256) {
                normalizedSize = 256;
            }
            MemoryData memoryData = new MemoryData(normalizedSize, 0);
            this.memoryDataContainer.set(memoryData);
            this.am = new ConcurrentLRUList();
            this.a1out = new ConcurrentLRUList();
            this.a1in = new ConcurrentLRUList();
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    LRUList getAm() {
        return this.am;
    }

    boolean inPinnedPages(long fileId, long pageIndex) {
        return this.pinnedPages.containsKey(new PinnedPage(fileId, pageIndex));
    }

    LRUList getA1out() {
        return this.a1out;
    }

    LRUList getA1in() {
        return this.a1in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addFile(String fileName, OWriteCache writeCache) throws IOException {
        this.cacheLock.acquireWriteLock();
        try {
            long fileId = writeCache.addFile(fileName);
            Set oldPages = this.filePages.put(fileId, Collections.newSetFromMap(new ConcurrentHashMap()));
            assert (oldPages == null || oldPages.isEmpty());
            long l = fileId;
            return l;
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addFile(String fileName, long fileId, OWriteCache writeCache) throws IOException {
        fileId = OAbstractWriteCache.checkFileIdCompatibility(writeCache.getId(), fileId);
        this.cacheLock.acquireWriteLock();
        try {
            long fid = writeCache.addFile(fileName, fileId);
            Set oldPages = this.filePages.put(fid, Collections.newSetFromMap(new ConcurrentHashMap()));
            assert (oldPages == null || oldPages.isEmpty());
            long l = fid;
            return l;
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pinPage(OCacheEntry cacheEntry) throws IOException {
        MemoryData memoryData = this.memoryDataContainer.get();
        if (100 * (memoryData.pinnedPages + 1) / memoryData.maxSize > this.percentOfPinnedPages) {
            if (this.pinnedPagesWarningsCache < 50) {
                this.pinnedPagesWarningCounter.increment();
                long warnings = this.pinnedPagesWarningCounter.get();
                if (warnings < 50L) {
                    this.pinnedPagesWarningsCache = (int)warnings;
                    OLogManager.instance().warn((Object)this, "Maximum amount of pinned pages is reached , given page " + cacheEntry + " will not be marked as pinned which may lead to performance degradation. You may consider to increase percent of pined pages by changing of property " + OGlobalConfiguration.DISK_CACHE_PINNED_PAGES.getKey(), new Object[0]);
                }
            }
            return;
        }
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireSharedLock(cacheEntry.getFileId());
            PageKey k = new PageKey(cacheEntry.getFileId(), cacheEntry.getPageIndex());
            try {
                Lock pageLock = this.pageLockManager.acquireExclusiveLock(k);
                try {
                    this.remove(cacheEntry.getFileId(), cacheEntry.getPageIndex());
                    this.pinnedPages.put(new PinnedPage(cacheEntry.getFileId(), cacheEntry.getPageIndex()), cacheEntry);
                }
                finally {
                    this.pageLockManager.releaseExclusiveLock(k);
                }
            }
            finally {
                this.fileLockManager.releaseSharedLock(cacheEntry.getFileId());
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
        MemoryData newMemoryData = new MemoryData(memoryData.maxSize, memoryData.pinnedPages + 1);
        while (!this.memoryDataContainer.compareAndSet(memoryData, newMemoryData)) {
            memoryData = this.memoryDataContainer.get();
            newMemoryData = new MemoryData(memoryData.maxSize, memoryData.pinnedPages + 1);
        }
        this.removeColdestPagesIfNeeded();
    }

    public void changeMaximumAmountOfMemory(long readCacheMaxMemory) throws IllegalStateException {
        MemoryData newMemoryData;
        MemoryData memoryData;
        int newMemorySize = this.normalizeMemory(readCacheMaxMemory, this.pageSize);
        do {
            if ((memoryData = this.memoryDataContainer.get()).maxSize == newMemorySize) {
                return;
            }
            if (100 * memoryData.pinnedPages / newMemorySize <= this.percentOfPinnedPages) continue;
            throw new IllegalStateException("Cannot decrease amount of memory used by disk cache because limit of pinned pages will be more than allowed limit " + this.percentOfPinnedPages);
        } while (!this.memoryDataContainer.compareAndSet(memoryData, newMemoryData = new MemoryData(newMemorySize, memoryData.pinnedPages)));
        if (newMemorySize < memoryData.maxSize) {
            this.removeColdestPagesIfNeeded();
        }
        OLogManager.instance().info((Object)this, "Disk cache size was changed from " + memoryData.maxSize + " pages to " + newMemorySize + " pages", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCacheEntry load(long fileId, long pageIndex, boolean checkPinnedPages, OWriteCache writeCache, int pageCount) throws IOException {
        OSessionStoragePerformanceStatistic sessionStoragePerformanceStatistic = writeCache.getPerformanceStatisticManager().getSessionPerformanceStatistic();
        if (sessionStoragePerformanceStatistic != null) {
            sessionStoragePerformanceStatistic.startPageReadFromCacheTimer();
        }
        try {
            fileId = OAbstractWriteCache.checkFileIdCompatibility(writeCache.getId(), fileId);
            UpdateCacheResult cacheResult = this.doLoad(fileId, pageIndex, checkPinnedPages, false, writeCache, pageCount, sessionStoragePerformanceStatistic);
            if (cacheResult == null) {
                OCacheEntry oCacheEntry = null;
                return oCacheEntry;
            }
            try {
                if (cacheResult.removeColdPages) {
                    this.removeColdestPagesIfNeeded();
                }
            }
            catch (RuntimeException e) {
                assert (!cacheResult.cacheEntry.isDirty());
                this.release(cacheResult.cacheEntry, writeCache);
                throw e;
            }
            OCacheEntry oCacheEntry = cacheResult.cacheEntry;
            return oCacheEntry;
        }
        finally {
            if (sessionStoragePerformanceStatistic != null) {
                sessionStoragePerformanceStatistic.stopPageReadFromCacheTimer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UpdateCacheResult doLoad(long fileId, long pageIndex, boolean checkPinnedPages, boolean addNewPages, OWriteCache writeCache, int pageCount, OSessionStoragePerformanceStatistic sessionStoragePerformanceStatistic) throws IOException {
        if (pageCount < 1) {
            throw new IllegalArgumentException("Amount of pages to load from cache should be not less than 1 but passed value is " + pageCount);
        }
        boolean removeColdPages = false;
        OCacheEntry cacheEntry = null;
        OModifiableBoolean cacheHit = new OModifiableBoolean(false);
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireSharedLock(fileId);
            try {
                UpdateCacheResult updateCacheResult;
                PageKey[] pageKeys = new PageKey[pageCount];
                for (int i = 0; i < pageKeys.length; ++i) {
                    pageKeys[i] = new PageKey(fileId, pageIndex + (long)i);
                }
                Lock[] pageLocks = this.pageLockManager.acquireExclusiveLocksInBatch((PageKey[])pageKeys);
                try {
                    if (checkPinnedPages) {
                        cacheEntry = (OCacheEntry)this.pinnedPages.get(new PinnedPage(fileId, pageIndex));
                    }
                    if (cacheEntry == null) {
                        UpdateCacheResult cacheResult = this.updateCache(fileId, pageIndex, addNewPages, writeCache, pageCount, cacheHit);
                        if (cacheResult == null) {
                            updateCacheResult = null;
                            return updateCacheResult;
                        }
                        cacheEntry = cacheResult.cacheEntry;
                        removeColdPages = cacheResult.removeColdPages;
                    } else {
                        cacheHit.setValue(true);
                    }
                    cacheEntry.incrementUsages();
                }
                finally {
                    Lock[] lockArray = pageLocks;
                    int n = lockArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Lock pageLock = lockArray[n2];
                        pageLock.unlock();
                        ++n2;
                    }
                    return updateCacheResult;
                }
            }
            finally {
                this.fileLockManager.releaseSharedLock(fileId);
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCacheEntry allocateNewPage(long fileId, OWriteCache writeCache) throws IOException {
        OSessionStoragePerformanceStatistic sessionStoragePerformanceStatistic = writeCache.getPerformanceStatisticManager().getSessionPerformanceStatistic();
        if (sessionStoragePerformanceStatistic != null) {
            sessionStoragePerformanceStatistic.startPageReadFromCacheTimer();
        }
        try {
            UpdateCacheResult cacheResult;
            fileId = OAbstractWriteCache.checkFileIdCompatibility(writeCache.getId(), fileId);
            this.cacheLock.acquireReadLock();
            try {
                Lock fileLock = this.fileLockManager.acquireExclusiveLock(fileId);
                try {
                    long filledUpTo = writeCache.getFilledUpTo(fileId);
                    assert (filledUpTo >= 0L);
                    cacheResult = this.doLoad(fileId, filledUpTo, false, true, writeCache, 1, sessionStoragePerformanceStatistic);
                }
                finally {
                    this.fileLockManager.releaseExclusiveLock(fileId);
                }
            }
            finally {
                this.cacheLock.releaseReadLock();
            }
            assert (cacheResult != null);
            try {
                if (cacheResult.removeColdPages) {
                    this.removeColdestPagesIfNeeded();
                }
            }
            catch (RuntimeException e) {
                assert (!cacheResult.cacheEntry.isDirty());
                this.release(cacheResult.cacheEntry, writeCache);
                throw e;
            }
            OCacheEntry oCacheEntry = cacheResult.cacheEntry;
            return oCacheEntry;
        }
        finally {
            if (sessionStoragePerformanceStatistic != null) {
                sessionStoragePerformanceStatistic.stopPageReadFromCacheTimer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(OCacheEntry cacheEntry, OWriteCache writeCache) {
        Future flushFuture;
        block20: {
            flushFuture = null;
            this.cacheLock.acquireReadLock();
            try {
                Lock fileLock = this.fileLockManager.acquireSharedLock(cacheEntry.getFileId());
                try {
                    PageKey k = new PageKey(cacheEntry.getFileId(), cacheEntry.getPageIndex());
                    Lock pageLock = this.pageLockManager.acquireExclusiveLock(k);
                    try {
                        cacheEntry.decrementUsages();
                        assert (cacheEntry.getUsagesCount() >= 0);
                        assert (cacheEntry.getUsagesCount() > 0 || !cacheEntry.isLockAcquiredByCurrentThread());
                        if (cacheEntry.getUsagesCount() != 0 || !cacheEntry.isDirty()) break block20;
                        OSessionStoragePerformanceStatistic sessionStoragePerformanceStatistic = writeCache.getPerformanceStatisticManager().getSessionPerformanceStatistic();
                        if (sessionStoragePerformanceStatistic != null) {
                            sessionStoragePerformanceStatistic.startPageWriteInCacheTimer();
                        }
                        try {
                            flushFuture = writeCache.store(cacheEntry.getFileId(), cacheEntry.getPageIndex(), cacheEntry.getCachePointer());
                        }
                        finally {
                            if (sessionStoragePerformanceStatistic != null) {
                                sessionStoragePerformanceStatistic.stopPageWriteInCacheTimer();
                            }
                        }
                        cacheEntry.clearDirty();
                    }
                    finally {
                        this.pageLockManager.releaseExclusiveLock(k);
                    }
                }
                finally {
                    this.fileLockManager.releaseSharedLock(cacheEntry.getFileId());
                }
            }
            finally {
                this.cacheLock.releaseReadLock();
            }
        }
        if (flushFuture != null) {
            try {
                flushFuture.get();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new OInterruptedException("File flush was interrupted");
            }
            catch (Exception e) {
                throw OException.wrapException(new OReadCacheException("File flush was abnormally terminated"), e);
            }
        }
    }

    @Override
    public void clear() {
        this.cacheLock.acquireWriteLock();
        try {
            this.clearCacheContent();
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncateFile(long fileId, OWriteCache writeCache) throws IOException {
        fileId = OAbstractWriteCache.checkFileIdCompatibility(writeCache.getId(), fileId);
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireExclusiveLock(fileId);
            try {
                writeCache.truncateFile(fileId);
                this.clearFile(fileId);
            }
            finally {
                this.fileLockManager.releaseExclusiveLock(fileId);
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
    }

    private void clearFile(long fileId) {
        Set pageEntries = (Set)this.filePages.get(fileId);
        if (pageEntries == null || pageEntries.isEmpty()) {
            assert (this.get(fileId, 0L, true) == null);
            return;
        }
        for (Long pageIndex : pageEntries) {
            OCacheEntry cacheEntry = this.get(fileId, pageIndex, true);
            if (cacheEntry == null) {
                cacheEntry = (OCacheEntry)this.pinnedPages.get(new PinnedPage(fileId, pageIndex));
            }
            if (cacheEntry != null) {
                if (cacheEntry.getUsagesCount() == 0) {
                    OCachePointer cachePointer;
                    cacheEntry = this.remove(fileId, pageIndex);
                    if (cacheEntry == null) {
                        MemoryData memoryData = this.memoryDataContainer.get();
                        cacheEntry = (OCacheEntry)this.pinnedPages.remove(new PinnedPage(fileId, pageIndex));
                        MemoryData newMemoryData = new MemoryData(memoryData.maxSize, memoryData.pinnedPages - 1);
                        while (!this.memoryDataContainer.compareAndSet(memoryData, newMemoryData)) {
                            memoryData = this.memoryDataContainer.get();
                            newMemoryData = new MemoryData(memoryData.maxSize, memoryData.pinnedPages - 1);
                        }
                    }
                    if ((cachePointer = cacheEntry.getCachePointer()) == null) continue;
                    cachePointer.decrementReadersReferrer();
                    cacheEntry.clearCachePointer();
                    continue;
                }
                throw new OStorageException("Page with index " + pageIndex + " for file with id " + fileId + " cannot be freed because it is used.");
            }
            throw new OStorageException("Page with index " + pageIndex + " was  not found in cache for file with id " + fileId);
        }
        assert (this.get(fileId, 0L, true) == null);
        pageEntries.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeFile(long fileId, boolean flush, OWriteCache writeCache) throws IOException {
        fileId = OAbstractWriteCache.checkFileIdCompatibility(writeCache.getId(), fileId);
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireExclusiveLock(fileId);
            try {
                writeCache.close(fileId, flush);
                this.clearFile(fileId);
            }
            finally {
                this.fileLockManager.releaseExclusiveLock(fileId);
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFile(long fileId, OWriteCache writeCache) throws IOException {
        fileId = OAbstractWriteCache.checkFileIdCompatibility(writeCache.getId(), fileId);
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireExclusiveLock(fileId);
            try {
                this.clearFile(fileId);
                this.filePages.remove(fileId);
                writeCache.deleteFile(fileId);
            }
            finally {
                this.fileLockManager.releaseExclusiveLock(fileId);
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeStorage(OWriteCache writeCache) throws IOException {
        if (writeCache == null) {
            return;
        }
        this.cacheLock.acquireWriteLock();
        try {
            long[] filesToClear;
            for (long fileId : filesToClear = writeCache.close()) {
                this.clearFile(fileId);
            }
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadCacheState(OWriteCache writeCache) {
        block16: {
            if (!OGlobalConfiguration.STORAGE_KEEP_DISK_CACHE_STATE.getValueAsBoolean()) {
                return;
            }
            this.cacheLock.acquireReadLock();
            try {
                File rootDirectory = writeCache.getRootDirectory();
                File stateFile = new File(rootDirectory, CACHE_STATE_FILE);
                if (!stateFile.exists()) break block16;
                RandomAccessFile cacheState = new RandomAccessFile(stateFile, "rw");
                try {
                    FileChannel channel = cacheState.getChannel();
                    InputStream stream = Channels.newInputStream(channel);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(stream, 65536);
                    DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
                    try {
                        long maxCacheSize = dataInputStream.readLong();
                        long currentMaxCacheSize = this.memoryDataContainer.get().maxSize;
                        if (maxCacheSize > currentMaxCacheSize) {
                            OLogManager.instance().info((Object)this, "Previous maximum cache size was %d current maximum cache size is %d. Cache state for storage %s will not be restored.", maxCacheSize, currentMaxCacheSize, rootDirectory);
                            return;
                        }
                        this.restoreQueue(writeCache, this.am, dataInputStream, true);
                        this.restoreQueue(writeCache, this.a1in, dataInputStream, true);
                        this.restoreQueue(writeCache, this.a1out, dataInputStream, false);
                    }
                    finally {
                        dataInputStream.close();
                    }
                }
                finally {
                    cacheState.close();
                }
            }
            catch (Exception e) {
                OLogManager.instance().warn((Object)this, "Cannot restore state of cache for storage placed under %s", writeCache.getRootDirectory(), e);
            }
            finally {
                this.cacheLock.releaseReadLock();
            }
        }
    }

    private void restoreQueue(OWriteCache writeCache, LRUList queue, DataInputStream dataInputStream, boolean loadPages) throws IOException {
        if (loadPages) {
            this.restoreQueueWithPageLoad(writeCache, queue, dataInputStream);
        } else {
            this.restoreQueueWithoutPageLoad(writeCache, queue, dataInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreQueueWithoutPageLoad(OWriteCache writeCache, LRUList queue, DataInputStream dataInputStream) throws IOException {
        OModifiableBoolean cacheHit = new OModifiableBoolean();
        int internalFileId = dataInputStream.readInt();
        while (internalFileId >= 0) {
            long pageIndex = dataInputStream.readLong();
            try {
                long fileId = writeCache.externalFileId(internalFileId);
                OCacheEntry cacheEntry = new OCacheEntry(fileId, pageIndex, null, false);
                Set<Long> pages = (HashSet<Long>)this.filePages.get(fileId);
                if (pages == null) {
                    pages = new HashSet<Long>();
                    Set op = this.filePages.putIfAbsent(fileId, pages);
                    if (op != null) {
                        pages = op;
                    }
                }
                queue.putToMRU(cacheEntry);
                pages.add(cacheEntry.getPageIndex());
            }
            finally {
                internalFileId = dataInputStream.readInt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreQueueWithPageLoad(OWriteCache writeCache, LRUList queue, DataInputStream dataInputStream) throws IOException {
        OModifiableBoolean cacheHit = new OModifiableBoolean();
        TreeMap<PageKey, OPair<Long, OCacheEntry>> filePositionMap = new TreeMap<PageKey, OPair<Long, OCacheEntry>>();
        TreeMap<Long, OCacheEntry> queuePositionMap = new TreeMap<Long, OCacheEntry>();
        long position = 0L;
        int internalFileId = dataInputStream.readInt();
        while (internalFileId >= 0) {
            long pageIndex = dataInputStream.readLong();
            try {
                long fileId = writeCache.externalFileId(internalFileId);
                OCacheEntry entry = new OCacheEntry(fileId, pageIndex, null, false);
                filePositionMap.put(new PageKey(fileId, pageIndex), new OPair<Long, OCacheEntry>(position, entry));
                queuePositionMap.put(position, entry);
                ++position;
            }
            finally {
                internalFileId = dataInputStream.readInt();
            }
        }
        for (Map.Entry entry : filePositionMap.entrySet()) {
            PageKey pageKey = (PageKey)entry.getKey();
            OPair pair = (OPair)entry.getValue();
            OCachePointer[] pointers = writeCache.load(pageKey.fileId, pageKey.pageIndex, 1, false, cacheHit);
            if (pointers.length == 0) {
                queuePositionMap.remove(pair.key);
                continue;
            }
            OCacheEntry cacheEntry = (OCacheEntry)pair.value;
            cacheEntry.setCachePointer(pointers[0]);
        }
        for (OCacheEntry cacheEntry : queuePositionMap.values()) {
            long fileId = cacheEntry.getFileId();
            Set<Long> pages = (HashSet<Long>)this.filePages.get(fileId);
            if (pages == null) {
                pages = new HashSet<Long>();
                Set op = this.filePages.putIfAbsent(fileId, pages);
                if (op != null) {
                    pages = op;
                }
            }
            queue.putToMRU(cacheEntry);
            pages.add(cacheEntry.getPageIndex());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeCacheState(OWriteCache writeCache) {
        if (!OGlobalConfiguration.STORAGE_KEEP_DISK_CACHE_STATE.getValueAsBoolean()) {
            return;
        }
        if (writeCache == null) {
            return;
        }
        this.cacheLock.acquireWriteLock();
        try {
            File rootDirectory = writeCache.getRootDirectory();
            File stateFile = new File(rootDirectory, CACHE_STATE_FILE);
            if (stateFile.exists() && !stateFile.delete()) {
                OLogManager.instance().warn((Object)this, "Cannot delete cache state file %s", stateFile);
            }
            HashSet<Long> filesToStore = new HashSet<Long>(writeCache.files().values());
            RandomAccessFile cacheState = new RandomAccessFile(stateFile, "rw");
            try {
                FileChannel channel = cacheState.getChannel();
                OutputStream channelStream = Channels.newOutputStream(channel);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(channelStream, 65536);
                DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
                try {
                    dataOutputStream.writeLong(this.memoryDataContainer.get().maxSize);
                    O2QCache.storeQueueState(writeCache, filesToStore, dataOutputStream, this.am);
                    dataOutputStream.writeInt(-1);
                    O2QCache.storeQueueState(writeCache, filesToStore, dataOutputStream, this.a1in);
                    dataOutputStream.writeInt(-1);
                    O2QCache.storeQueueState(writeCache, filesToStore, dataOutputStream, this.a1out);
                    dataOutputStream.writeInt(-1);
                }
                finally {
                    dataOutputStream.close();
                }
            }
            finally {
                cacheState.close();
            }
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Cannot store state of cache for storage placed under %s (error: %s)", writeCache.getRootDirectory(), e);
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    private static void storeQueueState(OWriteCache writeCache, Set<Long> filesToStore, DataOutputStream dataOutputStream, LRUList queue) throws IOException {
        Iterator<OCacheEntry> queueIterator = queue.reverseIterator();
        while (queueIterator.hasNext()) {
            OCacheEntry cacheEntry = queueIterator.next();
            long fileId = cacheEntry.getFileId();
            if (!filesToStore.contains(fileId)) continue;
            int internalId = writeCache.internalFileId(fileId);
            dataOutputStream.writeInt(internalId);
            dataOutputStream.writeLong(cacheEntry.getPageIndex());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteStorage(OWriteCache writeCache) throws IOException {
        this.cacheLock.acquireWriteLock();
        try {
            long[] filesToClear;
            for (long fileId : filesToClear = writeCache.delete()) {
                this.clearFile(fileId);
            }
            File rootDirectory = writeCache.getRootDirectory();
            File stateFile = new File(rootDirectory, CACHE_STATE_FILE);
            if (stateFile.exists() && !stateFile.delete()) {
                OLogManager.instance().error((Object)this, "Cache state file %s cannot be deleted", stateFile);
            }
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    private OCacheEntry get(long fileId, long pageIndex, boolean useOutQueue) {
        OCacheEntry cacheEntry = this.am.get(fileId, pageIndex);
        if (cacheEntry != null) {
            assert (this.filePages.get(fileId) != null);
            assert (((Set)this.filePages.get(fileId)).contains(pageIndex));
            return cacheEntry;
        }
        if (useOutQueue && (cacheEntry = this.a1out.get(fileId, pageIndex)) != null) {
            assert (this.filePages.get(fileId) != null);
            assert (((Set)this.filePages.get(fileId)).contains(pageIndex));
            return cacheEntry;
        }
        cacheEntry = this.a1in.get(fileId, pageIndex);
        return cacheEntry;
    }

    private void clearCacheContent() {
        OCachePointer cachePointer;
        for (OCacheEntry cacheEntry : this.am) {
            if (cacheEntry.getUsagesCount() == 0) {
                cachePointer = cacheEntry.getCachePointer();
                cachePointer.decrementReadersReferrer();
                cacheEntry.clearCachePointer();
                continue;
            }
            throw new OStorageException("Page with index " + cacheEntry.getPageIndex() + " for file id " + cacheEntry.getFileId() + " is used and cannot be removed");
        }
        for (OCacheEntry cacheEntry : this.a1in) {
            if (cacheEntry.getUsagesCount() == 0) {
                cachePointer = cacheEntry.getCachePointer();
                cachePointer.decrementReadersReferrer();
                cacheEntry.clearCachePointer();
                continue;
            }
            throw new OStorageException("Page with index " + cacheEntry.getPageIndex() + " for file id " + cacheEntry.getFileId() + " is used and cannot be removed");
        }
        this.a1out.clear();
        this.am.clear();
        this.a1in.clear();
        for (Set pages : this.filePages.values()) {
            pages.clear();
        }
        this.clearPinnedPages();
    }

    private void clearPinnedPages() {
        for (OCacheEntry pinnedEntry : this.pinnedPages.values()) {
            if (pinnedEntry.getUsagesCount() == 0) {
                OCachePointer cachePointer = pinnedEntry.getCachePointer();
                cachePointer.decrementReadersReferrer();
                pinnedEntry.clearCachePointer();
                MemoryData memoryData = this.memoryDataContainer.get();
                MemoryData newMemoryData = new MemoryData(memoryData.maxSize, memoryData.pinnedPages - 1);
                while (!this.memoryDataContainer.compareAndSet(memoryData, newMemoryData)) {
                    memoryData = this.memoryDataContainer.get();
                    newMemoryData = new MemoryData(memoryData.maxSize, memoryData.pinnedPages - 1);
                }
                continue;
            }
            throw new OStorageException("Page with index " + pinnedEntry.getPageIndex() + " for file with id " + pinnedEntry.getFileId() + "cannot be freed because it is used.");
        }
        this.pinnedPages.clear();
    }

    private boolean entryIsInAmQueue(long fileId, long pageIndex, OCacheEntry cacheEntry) {
        assert (this.filePages.get(fileId) != null);
        assert (((Set)this.filePages.get(fileId)).contains(pageIndex));
        this.am.putToMRU(cacheEntry);
        return false;
    }

    private boolean entryWasInA1OutQueue(long fileId, long pageIndex, OCachePointer dataPointer, OCacheEntry cacheEntry) {
        assert (this.filePages.get(fileId) != null);
        assert (((Set)this.filePages.get(fileId)).contains(pageIndex));
        assert (dataPointer != null);
        assert (cacheEntry.getCachePointer() == null);
        assert (!cacheEntry.isDirty());
        cacheEntry.setCachePointer(dataPointer);
        this.am.putToMRU(cacheEntry);
        return true;
    }

    private boolean entryIsInA1InQueue(long fileId, long pageIndex) {
        assert (this.filePages.get(fileId) != null);
        assert (((Set)this.filePages.get(fileId)).contains(pageIndex));
        return false;
    }

    private UpdateCacheResult entryIsAbsentInQueues(long fileId, long pageIndex, OCachePointer dataPointer) {
        OCacheEntry cacheEntry = new OCacheEntry(fileId, pageIndex, dataPointer, false);
        this.a1in.putToMRU(cacheEntry);
        Set pages = (Set)this.filePages.get(fileId);
        if (pages == null) {
            pages = Collections.newSetFromMap(new ConcurrentHashMap());
            Set oldPages = this.filePages.putIfAbsent(fileId, pages);
            if (oldPages != null) {
                pages = oldPages;
            }
        }
        pages.add(pageIndex);
        return new UpdateCacheResult(true, cacheEntry);
    }

    private UpdateCacheResult updateCache(long fileId, long pageIndex, boolean addNewPages, OWriteCache writeCache, int pageCount, OModifiableBoolean cacheHit) throws IOException {
        boolean removeColdPages;
        OCachePointer dataPointer;
        assert (pageCount > 0);
        OCacheEntry cacheEntry = this.am.get(fileId, pageIndex);
        if (cacheEntry != null) {
            cacheHit.setValue(true);
            return new UpdateCacheResult(this.entryIsInAmQueue(fileId, pageIndex, cacheEntry), cacheEntry);
        }
        OCachePointer[] dataPointers = null;
        cacheEntry = this.a1out.remove(fileId, pageIndex);
        if (cacheEntry != null) {
            dataPointers = writeCache.load(fileId, pageIndex, pageCount, false, cacheHit);
            dataPointer = dataPointers[0];
            removeColdPages = this.entryWasInA1OutQueue(fileId, pageIndex, dataPointer, cacheEntry);
        } else {
            cacheEntry = this.a1in.get(fileId, pageIndex);
            if (cacheEntry != null) {
                removeColdPages = this.entryIsInA1InQueue(fileId, pageIndex);
                cacheHit.setValue(true);
            } else {
                dataPointers = writeCache.load(fileId, pageIndex, pageCount, addNewPages, cacheHit);
                if (dataPointers.length == 0) {
                    return null;
                }
                dataPointer = dataPointers[0];
                UpdateCacheResult ucr = this.entryIsAbsentInQueues(fileId, pageIndex, dataPointer);
                cacheEntry = ucr.cacheEntry;
                removeColdPages = ucr.removeColdPages;
            }
        }
        if (dataPointers != null) {
            for (int n = 1; n < dataPointers.length; ++n) {
                removeColdPages = this.processFetchedPage(removeColdPages, dataPointers[n]);
            }
        }
        return new UpdateCacheResult(removeColdPages, cacheEntry);
    }

    private boolean processFetchedPage(boolean removeColdPages, OCachePointer dataPointer) {
        long pageIndex;
        long fileId = dataPointer.getFileId();
        if (this.pinnedPages.containsKey(new PinnedPage(fileId, pageIndex = dataPointer.getPageIndex()))) {
            return removeColdPages;
        }
        OCacheEntry cacheEntry = this.am.get(fileId, pageIndex);
        if (cacheEntry != null) {
            boolean rcp = this.entryIsInAmQueue(fileId, pageIndex, cacheEntry);
            removeColdPages = removeColdPages || rcp;
            dataPointer.decrementReadersReferrer();
            return removeColdPages;
        }
        cacheEntry = this.a1out.remove(fileId, pageIndex);
        if (cacheEntry != null) {
            boolean rcp = this.entryWasInA1OutQueue(fileId, pageIndex, dataPointer, cacheEntry);
            removeColdPages = removeColdPages || rcp;
            return removeColdPages;
        }
        cacheEntry = this.a1in.get(fileId, pageIndex);
        if (cacheEntry != null) {
            boolean rcp = this.entryIsInA1InQueue(fileId, pageIndex);
            removeColdPages = removeColdPages || rcp;
            dataPointer.decrementReadersReferrer();
            return removeColdPages;
        }
        boolean rcp = this.entryIsAbsentInQueues(fileId, pageIndex, dataPointer).removeColdPages;
        removeColdPages = removeColdPages || rcp;
        return removeColdPages;
    }

    private void removeColdestPagesIfNeeded() {
        boolean exclusiveCacheLock;
        if (!this.coldPagesRemovalInProgress.compareAndSet(false, true)) {
            return;
        }
        MemoryData memoryData = this.memoryDataContainer.get();
        boolean bl = exclusiveCacheLock = this.am.size() + this.a1in.size() - memoryData.get2QCacheSize() > MAX_CACHE_OVERFLOW;
        if (exclusiveCacheLock) {
            this.cacheLock.acquireWriteLock();
        } else {
            this.cacheLock.acquireReadLock();
        }
        try {
            if (exclusiveCacheLock) {
                this.removeColdPagesWithCacheLock();
            } else {
                this.removeColdPagesWithoutCacheLock();
            }
        }
        finally {
            if (exclusiveCacheLock) {
                this.cacheLock.releaseWriteLock();
            } else {
                this.cacheLock.releaseReadLock();
            }
            this.coldPagesRemovalInProgress.set(false);
        }
    }

    private void removeColdPagesWithCacheLock() {
        MemoryData memoryData = this.memoryDataContainer.get();
        while (this.am.size() + this.a1in.size() > memoryData.get2QCacheSize()) {
            Set pageEntries;
            OCachePointer cachePointer;
            if (this.a1in.size() > memoryData.K_IN) {
                OCacheEntry removedFromAInEntry = this.a1in.removeLRU();
                if (removedFromAInEntry == null) {
                    throw new OAllCacheEntriesAreUsedException("All records in aIn queue in 2q cache are used!");
                }
                assert (removedFromAInEntry.getUsagesCount() == 0);
                assert (!removedFromAInEntry.isDirty());
                cachePointer = removedFromAInEntry.getCachePointer();
                cachePointer.decrementReadersReferrer();
                removedFromAInEntry.clearCachePointer();
                this.a1out.putToMRU(removedFromAInEntry);
                while (this.a1out.size() > memoryData.K_OUT) {
                    OCacheEntry removedEntry = this.a1out.removeLRU();
                    assert (removedEntry.getUsagesCount() == 0);
                    assert (removedEntry.getCachePointer() == null);
                    assert (!removedEntry.isDirty());
                    pageEntries = (Set)this.filePages.get(removedEntry.getFileId());
                    pageEntries.remove(removedEntry.getPageIndex());
                }
                continue;
            }
            OCacheEntry removedEntry = this.am.removeLRU();
            if (removedEntry == null) {
                throw new OAllCacheEntriesAreUsedException("All records in aIn queue in 2q cache are used!");
            }
            assert (removedEntry.getUsagesCount() == 0);
            assert (!removedEntry.isDirty());
            cachePointer = removedEntry.getCachePointer();
            cachePointer.decrementReadersReferrer();
            removedEntry.clearCachePointer();
            pageEntries = (Set)this.filePages.get(removedEntry.getFileId());
            pageEntries.remove(removedEntry.getPageIndex());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeColdPagesWithoutCacheLock() {
        int iterationsCounter = 0;
        MemoryData memoryData = this.memoryDataContainer.get();
        while (this.am.size() + this.a1in.size() > memoryData.get2QCacheSize() && iterationsCounter < 1000) {
            Set pageEntries;
            Lock pageLock;
            OCachePointer cachePointer;
            PageKey k;
            Lock fileLock;
            ++iterationsCounter;
            if (this.a1in.size() > memoryData.K_IN) {
                OCacheEntry removedFromAInEntry = this.a1in.getLRU();
                if (removedFromAInEntry == null) {
                    throw new OAllCacheEntriesAreUsedException("All records in aIn queue in 2q cache are used!");
                }
                fileLock = this.fileLockManager.acquireSharedLock(removedFromAInEntry.getFileId());
                try {
                    k = new PageKey(removedFromAInEntry.getFileId(), removedFromAInEntry.getPageIndex());
                    this.pageLockManager.acquireExclusiveLock(k);
                    try {
                        if (this.a1in.get(removedFromAInEntry.getFileId(), removedFromAInEntry.getPageIndex()) == null || removedFromAInEntry.getUsagesCount() > 0) continue;
                        assert (!removedFromAInEntry.isDirty());
                        this.a1in.remove(removedFromAInEntry.getFileId(), removedFromAInEntry.getPageIndex());
                        cachePointer = removedFromAInEntry.getCachePointer();
                        cachePointer.decrementReadersReferrer();
                        removedFromAInEntry.clearCachePointer();
                        if (OLogManager.instance().isDebugEnabled()) {
                            OLogManager.instance().debug((Object)this, "Moving page in disk cache from a1in to a1out area: %s", removedFromAInEntry);
                        }
                        this.a1out.putToMRU(removedFromAInEntry);
                    }
                    finally {
                        this.pageLockManager.releaseExclusiveLock(k);
                        continue;
                    }
                }
                finally {
                    this.fileLockManager.releaseSharedLock(removedFromAInEntry.getFileId());
                    continue;
                }
                while (this.a1out.size() > memoryData.K_OUT) {
                    OCacheEntry removedEntry = this.a1out.getLRU();
                    fileLock = this.fileLockManager.acquireSharedLock(removedEntry.getFileId());
                    try {
                        PageKey k2 = new PageKey(removedEntry.getFileId(), removedEntry.getPageIndex());
                        pageLock = this.pageLockManager.acquireExclusiveLock(k2);
                        try {
                            if (this.a1out.remove(removedEntry.getFileId(), removedEntry.getPageIndex()) == null) continue;
                            assert (removedEntry.getUsagesCount() == 0);
                            assert (removedEntry.getCachePointer() == null);
                            assert (!removedEntry.isDirty());
                            pageEntries = (Set)this.filePages.get(removedEntry.getFileId());
                            pageEntries.remove(removedEntry.getPageIndex());
                        }
                        finally {
                            this.pageLockManager.releaseExclusiveLock(k2);
                        }
                    }
                    finally {
                        this.fileLockManager.releaseSharedLock(removedEntry.getFileId());
                    }
                }
                continue;
            }
            OCacheEntry removedEntry = this.am.getLRU();
            if (removedEntry == null) {
                throw new OAllCacheEntriesAreUsedException("All records in aIn queue in 2q cache are used!");
            }
            fileLock = this.fileLockManager.acquireSharedLock(removedEntry.getFileId());
            try {
                k = new PageKey(removedEntry.getFileId(), removedEntry.getPageIndex());
                pageLock = this.pageLockManager.acquireExclusiveLock(k);
                try {
                    if (this.am.get(removedEntry.getFileId(), removedEntry.getPageIndex()) == null || removedEntry.getUsagesCount() > 0) continue;
                    assert (!removedEntry.isDirty());
                    this.am.remove(removedEntry.getFileId(), removedEntry.getPageIndex());
                    cachePointer = removedEntry.getCachePointer();
                    cachePointer.decrementReadersReferrer();
                    removedEntry.clearCachePointer();
                    pageEntries = (Set)this.filePages.get(removedEntry.getFileId());
                    pageEntries.remove(removedEntry.getPageIndex());
                }
                finally {
                    this.pageLockManager.releaseExclusiveLock(k);
                }
            }
            finally {
                this.fileLockManager.releaseSharedLock(removedEntry.getFileId());
            }
        }
    }

    int getMaxSize() {
        return this.memoryDataContainer.get().maxSize;
    }

    @Override
    public long getUsedMemory() {
        return (long)(this.am.size() + this.a1in.size()) * (long)this.pageSize;
    }

    private OCacheEntry remove(long fileId, long pageIndex) {
        OCacheEntry cacheEntry = this.am.remove(fileId, pageIndex);
        if (cacheEntry != null) {
            if (cacheEntry.getUsagesCount() > 1) {
                throw new IllegalStateException("Record cannot be removed because it is used!");
            }
            return cacheEntry;
        }
        cacheEntry = this.a1out.remove(fileId, pageIndex);
        if (cacheEntry != null) {
            return cacheEntry;
        }
        cacheEntry = this.a1in.remove(fileId, pageIndex);
        if (cacheEntry != null && cacheEntry.getUsagesCount() > 1) {
            throw new IllegalStateException("Record cannot be removed because it is used!");
        }
        return cacheEntry;
    }

    private int normalizeMemory(long maxSize, int pageSize) {
        long tmpMaxSize = maxSize / (long)pageSize;
        if (tmpMaxSize >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)tmpMaxSize;
    }

    private static final class MemoryData {
        private final int K_IN;
        private final int K_OUT;
        private final int maxSize;
        private final int pinnedPages;

        public MemoryData(int maxSize, int pinnedPages) {
            this.K_IN = maxSize - pinnedPages >> 2;
            this.K_OUT = maxSize - pinnedPages >> 1;
            this.maxSize = maxSize;
            this.pinnedPages = pinnedPages;
        }

        public int get2QCacheSize() {
            return this.maxSize - this.pinnedPages;
        }
    }

    private static final class UpdateCacheResult {
        private final boolean removeColdPages;
        private final OCacheEntry cacheEntry;

        private UpdateCacheResult(boolean removeColdPages, OCacheEntry cacheEntry) {
            this.removeColdPages = removeColdPages;
            this.cacheEntry = cacheEntry;
        }
    }

    private static final class PageKey
    implements Comparable<PageKey> {
        private final long fileId;
        private final long pageIndex;

        private PageKey(long fileId, long pageIndex) {
            this.fileId = fileId;
            this.pageIndex = pageIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PageKey pageKey = (PageKey)o;
            if (this.fileId != pageKey.fileId) {
                return false;
            }
            return this.pageIndex == pageKey.pageIndex;
        }

        @Override
        public int compareTo(PageKey other) {
            if (this.fileId > other.fileId) {
                return 1;
            }
            if (this.fileId < other.fileId) {
                return -1;
            }
            if (this.pageIndex > other.pageIndex) {
                return 1;
            }
            if (this.pageIndex < other.pageIndex) {
                return -1;
            }
            return 0;
        }

        public int hashCode() {
            int result = (int)(this.fileId ^ this.fileId >>> 32);
            result = 31 * result + (int)(this.pageIndex ^ this.pageIndex >>> 32);
            return result;
        }
    }

    private static class PinnedPage
    implements Comparable<PinnedPage> {
        private final long fileId;
        private final long pageIndex;

        private PinnedPage(long fileId, long pageIndex) {
            this.fileId = fileId;
            this.pageIndex = pageIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PinnedPage that = (PinnedPage)o;
            if (this.fileId != that.fileId) {
                return false;
            }
            return this.pageIndex == that.pageIndex;
        }

        public String toString() {
            return "PinnedPage{fileId=" + this.fileId + ", pageIndex=" + this.pageIndex + '}';
        }

        public int hashCode() {
            int result = (int)(this.fileId ^ this.fileId >>> 32);
            result = 31 * result + (int)(this.pageIndex ^ this.pageIndex >>> 32);
            return result;
        }

        @Override
        public int compareTo(PinnedPage other) {
            if (this.fileId > other.fileId) {
                return 1;
            }
            if (this.fileId < other.fileId) {
                return -1;
            }
            if (this.pageIndex > other.pageIndex) {
                return 1;
            }
            if (this.pageIndex < other.pageIndex) {
                return -1;
            }
            return 0;
        }
    }
}

