/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.common.collection.closabledictionary.OClosableLinkedContainer;
import com.orientechnologies.common.directmemory.OByteBufferPool;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.compression.impl.OZIPCompressionUtil;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.local.OWOWCache;
import com.orientechnologies.orient.core.storage.fs.OFileClassic;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OFreezableStorageComponent;
import com.orientechnologies.orient.core.storage.impl.local.OStorageConfigurationSegment;
import com.orientechnologies.orient.core.storage.impl.local.OStorageVariableParser;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OPaginatedStorageDirtyFlag;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ODiskWriteAheadLog;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class OLocalPaginatedStorage
extends OAbstractPaginatedStorage
implements OFreezableStorageComponent {
    private static String[] ALL_FILE_EXTENSIONS = new String[]{".ocf", ".pls", ".pcl", ".oda", ".odh", ".otx", ".ocs", ".oef", ".oem", ".oet", ".fl", ".wal", ".wmr", ".hib", ".him", ".hit", ".hnb", ".cpm", ".sbt", ".cm", ".irs", ".sbc", ".nbt", ".stt"};
    private static final int ONE_KB = 1024;
    private final int DELETE_MAX_RETRIES;
    private final int DELETE_WAIT_TIME;
    private final OStorageVariableParser variableParser;
    private final OPaginatedStorageDirtyFlag dirtyFlag;
    private final String storagePath;
    private ExecutorService checkpointExecutor;
    private final OClosableLinkedContainer<Long, OFileClassic> files;

    public OLocalPaginatedStorage(String name, String filePath, String mode, int id, OReadCache readCache, OClosableLinkedContainer<Long, OFileClassic> files) throws IOException {
        super(name, filePath, mode, id);
        this.readCache = readCache;
        this.files = files;
        File f = new File(this.url);
        String sp = f.exists() || !OLocalPaginatedStorage.exists(f.getParent()) ? OSystemVariableResolver.resolveSystemVariables(OFileUtils.getPath(new File(this.url).getPath())) : OSystemVariableResolver.resolveSystemVariables(OFileUtils.getPath(new File(this.url).getParent()));
        this.storagePath = OIOUtils.getPathFromDatabaseName(sp);
        this.variableParser = new OStorageVariableParser(this.storagePath);
        this.configuration = new OStorageConfigurationSegment(this);
        this.DELETE_MAX_RETRIES = OGlobalConfiguration.FILE_DELETE_RETRY.getValueAsInteger();
        this.DELETE_WAIT_TIME = OGlobalConfiguration.FILE_DELETE_DELAY.getValueAsInteger();
        this.dirtyFlag = new OPaginatedStorageDirtyFlag(this.storagePath + File.separator + "dirty.fl");
    }

    @Override
    public void create(Map<String, Object> iProperties) {
        this.stateLock.acquireWriteLock();
        try {
            File storageFolder = new File(this.storagePath);
            if (!storageFolder.exists() && !storageFolder.mkdirs()) {
                throw new OStorageException("Cannot create folders in storage with path " + this.storagePath);
            }
            super.create(iProperties);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    protected String normalizeName(String name) {
        int firstIndexOf = name.lastIndexOf(47);
        int secondIndexOf = name.lastIndexOf(File.separator);
        if (firstIndexOf >= 0 || secondIndexOf >= 0) {
            return name.substring(Math.max(firstIndexOf, secondIndexOf) + 1);
        }
        return name;
    }

    @Override
    public boolean exists() {
        if (this.status == OStorage.STATUS.OPEN) {
            return true;
        }
        return OLocalPaginatedStorage.exists(this.storagePath);
    }

    @Override
    public String getURL() {
        return "plocal:" + this.url;
    }

    public String getStoragePath() {
        return this.storagePath;
    }

    public OStorageVariableParser getVariableParser() {
        return this.variableParser;
    }

    @Override
    public String getType() {
        return "plocal";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> backup(OutputStream out, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iOutput, int compressionLevel, int bufferSize) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Backup output is null");
        }
        this.freeze(false);
        try {
            List<String> list;
            block11: {
                if (callable != null) {
                    try {
                        callable.call();
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "Error on callback invocation during backup", e, new Object[0]);
                    }
                }
                OutputStream bo = bufferSize > 0 ? new BufferedOutputStream(out, bufferSize) : out;
                try {
                    list = OZIPCompressionUtil.compressDirectory(new File(this.getStoragePath()).getAbsolutePath(), bo, new String[]{".wal", ".fl"}, iOutput, compressionLevel);
                    if (bufferSize <= 0) break block11;
                }
                catch (Throwable throwable) {
                    if (bufferSize > 0) {
                        bo.flush();
                        bo.close();
                    }
                    throw throwable;
                }
                bo.flush();
                bo.close();
            }
            return list;
        }
        finally {
            this.release();
        }
    }

    @Override
    public void restore(InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) throws IOException {
        if (!this.isClosed()) {
            this.close(true, false);
        }
        OZIPCompressionUtil.uncompressDirectory(in, this.getStoragePath(), iListener);
        if (callable != null) {
            try {
                callable.call();
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Error on calling callback on database restore", new Object[0]);
            }
        }
        this.open(null, null, null);
    }

    @Override
    public OStorageConfiguration getConfiguration() {
        this.stateLock.acquireReadLock();
        try {
            OStorageConfiguration oStorageConfiguration = super.getConfiguration();
            return oStorageConfiguration;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OLogSequenceNumber copyWALToIncrementalBackup(ZipOutputStream zipOutputStream, long startSegment) throws IOException {
        File[] nonActiveSegments;
        OLogSequenceNumber lastLSN;
        long freezeId = this.getAtomicOperationsManager().freezeAtomicOperations(null, null);
        try {
            lastLSN = this.writeAheadLog.end();
            this.writeAheadLog.newSegment();
            nonActiveSegments = this.writeAheadLog.nonActiveSegments(startSegment);
        }
        finally {
            this.getAtomicOperationsManager().releaseAtomicOperations(freezeId);
        }
        for (File nonActiveSegment : nonActiveSegments) {
            FileInputStream fileInputStream = new FileInputStream(nonActiveSegment);
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                try {
                    ZipEntry entry = new ZipEntry(nonActiveSegment.getName());
                    zipOutputStream.putNextEntry(entry);
                    try {
                        byte[] buffer = new byte[4096];
                        int br = 0;
                        while ((br = bufferedInputStream.read(buffer)) >= 0) {
                            zipOutputStream.write(buffer, 0, br);
                        }
                    }
                    finally {
                        zipOutputStream.closeEntry();
                    }
                }
                finally {
                    bufferedInputStream.close();
                }
            }
            finally {
                fileInputStream.close();
            }
        }
        return lastLSN;
    }

    @Override
    protected File createWalTempDirectory() {
        File walDirectory = new File(this.getStoragePath(), "walIncrementalBackupRestoreDirectory");
        if (walDirectory.exists()) {
            OFileUtils.deleteRecursively(walDirectory);
        }
        if (!walDirectory.mkdirs()) {
            throw new OStorageException("Can not create temporary directory to store files created during incremental backup");
        }
        return walDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addFileToDirectory(String name, InputStream stream, File directory) throws IOException {
        byte[] buffer = new byte[4096];
        int rb = -1;
        int bl = 0;
        File walBackupFile = new File(directory, name);
        FileOutputStream outputStream = new FileOutputStream(walBackupFile);
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
            try {
                while (true) {
                    if (bl < buffer.length && (rb = stream.read(buffer, bl, buffer.length - bl)) > -1) {
                        bl += rb;
                        continue;
                    }
                    bufferedOutputStream.write(buffer, 0, bl);
                    bl = 0;
                    if (rb < 0) break;
                }
            }
            finally {
                bufferedOutputStream.close();
            }
        }
        finally {
            outputStream.close();
        }
    }

    @Override
    protected OWriteAheadLog createWalFromIBUFiles(File directory) throws IOException {
        ODiskWriteAheadLog restoreWAL = new ODiskWriteAheadLog(OGlobalConfiguration.WAL_CACHE_SIZE.getValueAsInteger(), OGlobalConfiguration.WAL_COMMIT_TIMEOUT.getValueAsInteger(), (long)OGlobalConfiguration.WAL_MAX_SEGMENT_SIZE.getValueAsInteger() * 1024L * 1024L, directory.getAbsolutePath(), false, this, OGlobalConfiguration.WAL_FILE_AUTOCLOSE_INTERVAL.getValueAsInteger());
        return restoreWAL;
    }

    @Override
    protected void preOpenSteps() throws IOException {
        if (this.configuration.binaryFormatVersion >= 11) {
            if (this.dirtyFlag.exists()) {
                this.dirtyFlag.open();
            } else {
                this.dirtyFlag.create();
                this.dirtyFlag.makeDirty();
            }
        } else if (this.dirtyFlag.exists()) {
            this.dirtyFlag.open();
        } else {
            this.dirtyFlag.create();
            this.dirtyFlag.clearDirty();
        }
    }

    @Override
    protected void preCreateSteps() throws IOException {
        this.dirtyFlag.create();
    }

    @Override
    protected void postCloseSteps(boolean onDelete) throws IOException {
        if (onDelete) {
            this.dirtyFlag.delete();
        } else {
            this.dirtyFlag.clearDirty();
            this.dirtyFlag.close();
        }
    }

    @Override
    protected void preCloseSteps() throws IOException {
        try {
            if (this.writeAheadLog != null) {
                this.checkpointExecutor.shutdown();
                if (!this.checkpointExecutor.awaitTermination(OGlobalConfiguration.WAL_FULL_CHECKPOINT_SHUTDOWN_TIMEOUT.getValueAsInteger(), TimeUnit.SECONDS)) {
                    throw new OStorageException("Cannot terminate full checkpoint task");
                }
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw OException.wrapException(new OStorageException("Error on closing of storage '" + this.name), e);
        }
    }

    @Override
    protected void postDeleteSteps() {
        File dbDir = new File(OIOUtils.getPathFromDatabaseName(OSystemVariableResolver.resolveSystemVariables(this.url)));
        if (!dbDir.exists() || !dbDir.isDirectory()) {
            dbDir = dbDir.getParentFile();
        }
        for (int i = 0; i < this.DELETE_MAX_RETRIES; ++i) {
            if (dbDir != null && dbDir.exists() && dbDir.isDirectory()) {
                int notDeletedFiles = 0;
                File[] storageFiles = dbDir.listFiles();
                if (storageFiles == null) continue;
                block1: for (File f : storageFiles) {
                    for (String ext : ALL_FILE_EXTENSIONS) {
                        if (!f.getPath().endsWith(ext)) continue;
                        if (f.delete()) continue block1;
                        ++notDeletedFiles;
                        continue block1;
                    }
                }
                if (notDeletedFiles == 0) {
                    if (!dbDir.delete()) {
                        OLogManager.instance().error((Object)this, "Cannot delete storage directory with path " + dbDir.getAbsolutePath() + " because directory is not empty. Files: " + Arrays.toString(dbDir.listFiles()), new Object[0]);
                    }
                    return;
                }
            } else {
                return;
            }
            OLogManager.instance().debug((Object)this, "Cannot delete database files because they are still locked by the OrientDB process: waiting %d ms and retrying %d/%d...", this.DELETE_WAIT_TIME, i, this.DELETE_MAX_RETRIES);
        }
        throw new OStorageException("Cannot delete database '" + this.name + "' located in: " + dbDir + ". Database files seem locked");
    }

    @Override
    protected void makeStorageDirty() throws IOException {
        this.dirtyFlag.makeDirty();
    }

    @Override
    protected void clearStorageDirty() throws IOException {
        this.dirtyFlag.clearDirty();
    }

    @Override
    protected boolean isDirty() throws IOException {
        return this.dirtyFlag.isDirty();
    }

    @Override
    protected boolean isWriteAllowedDuringIncrementalBackup() {
        return true;
    }

    @Override
    protected void initWalAndDiskCache() throws IOException {
        if (this.configuration.getContextConfiguration().getValueAsBoolean(OGlobalConfiguration.USE_WAL)) {
            this.checkpointExecutor = Executors.newSingleThreadExecutor(new FullCheckpointThreadFactory());
            ODiskWriteAheadLog diskWriteAheadLog = new ODiskWriteAheadLog(this);
            diskWriteAheadLog.addLowDiskSpaceListener(this);
            diskWriteAheadLog.checkFreeSpace();
            this.writeAheadLog = diskWriteAheadLog;
            this.writeAheadLog.addFullCheckpointListener(this);
        } else {
            this.writeAheadLog = null;
        }
        long diskCacheSize = OGlobalConfiguration.DISK_CACHE_SIZE.getValueAsLong() * 1024L * 1024L;
        long writeCacheSize = (long)Math.floor((double)OGlobalConfiguration.DISK_WRITE_CACHE_PART.getValueAsInteger() / 100.0 * (double)diskCacheSize);
        OWOWCache wowCache = new OWOWCache(false, OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024, OByteBufferPool.instance(), OGlobalConfiguration.DISK_WRITE_CACHE_PAGE_TTL.getValueAsLong() * 1000L, this.writeAheadLog, OGlobalConfiguration.DISK_WRITE_CACHE_PAGE_FLUSH_INTERVAL.getValueAsInteger(), writeCacheSize, diskCacheSize, this, true, this.files, this.getId());
        wowCache.loadRegisteredFiles();
        wowCache.addLowDiskSpaceListener(this);
        wowCache.addBackgroundExceptionListener(this);
        this.writeCache = wowCache;
    }

    public static boolean exists(String path) {
        return new File(path + "/" + "internal" + ".pcl").exists();
    }

    private static class FullCheckpointThreadFactory
    implements ThreadFactory {
        private FullCheckpointThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            return thread;
        }
    }
}

