/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OClusterEntryIterator;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OOfflineClusterException;
import java.io.IOException;

public class OOfflineCluster
implements OCluster {
    private final String name;
    private int id;
    private OAbstractPaginatedStorage storageLocal;

    public OOfflineCluster(OAbstractPaginatedStorage iStorage, int iId, String iName) {
        this.storageLocal = iStorage;
        this.id = iId;
        this.name = iName;
    }

    @Override
    public void configure(OStorage iStorage, int iId, String iClusterName, Object ... iParameters) throws IOException {
    }

    @Override
    public void configure(OStorage iStorage, OStorageClusterConfiguration iConfig) throws IOException {
    }

    @Override
    public void create(int iStartSize) throws IOException {
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void close(boolean flush) throws IOException {
    }

    @Override
    public void delete() throws IOException {
    }

    @Override
    public Object set(OCluster.ATTRIBUTES attribute, Object value) throws IOException {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = value != null ? value.toString() : null;
        switch (attribute) {
            case STATUS: {
                if (stringValue == null) {
                    throw new IllegalStateException("Value of attribute is null.");
                }
                return this.storageLocal.setClusterStatus(this.id, OStorageClusterConfiguration.STATUS.valueOf(stringValue.toUpperCase(this.storageLocal.getConfiguration().getLocaleInstance())));
            }
        }
        throw new IllegalArgumentException("Runtime change of attribute '" + (Object)((Object)attribute) + " is not supported on Offline cluster " + this.getName());
    }

    @Override
    public String encryption() {
        return null;
    }

    @Override
    public long getTombstonesCount() {
        return 0L;
    }

    @Override
    public void truncate() throws IOException {
        throw new OOfflineClusterException("Cannot truncate an offline cluster '" + this.name + "'");
    }

    @Override
    public OPhysicalPosition allocatePosition(byte recordType) throws IOException {
        throw new OOfflineClusterException("Cannot allocat a new position on offline cluster '" + this.name + "'");
    }

    @Override
    public OPhysicalPosition createRecord(byte[] content, int recordVersion, byte recordType, OPhysicalPosition allocatedPosition) throws IOException {
        throw new OOfflineClusterException("Cannot create a new record on offline cluster '" + this.name + "'");
    }

    @Override
    public boolean deleteRecord(long clusterPosition) throws IOException {
        throw new OOfflineClusterException("Cannot delete a record on offline cluster '" + this.name + "'");
    }

    @Override
    public void updateRecord(long clusterPosition, byte[] content, int recordVersion, byte recordType) throws IOException {
        throw new OOfflineClusterException("Cannot update a record on offline cluster '" + this.name + "'");
    }

    @Override
    public void recycleRecord(long clusterPosition, byte[] content, int recordVersion, byte recordType) throws IOException {
        throw new OOfflineClusterException("Cannot resurrect a record on offline cluster '" + this.name + "'");
    }

    @Override
    public ORawBuffer readRecord(long clusterPosition, boolean prefetchRecords) throws IOException {
        throw OException.wrapException(new ORecordNotFoundException(new ORecordId(this.id, clusterPosition), "Record with rid #" + this.id + ":" + clusterPosition + " was not found in database"), new OOfflineClusterException("Cannot read a record from the offline cluster '" + this.name + "'"));
    }

    @Override
    public ORawBuffer readRecordIfVersionIsNotLatest(long clusterPosition, int recordVersion) throws IOException, ORecordNotFoundException {
        throw OException.wrapException(new ORecordNotFoundException(new ORecordId(this.id, clusterPosition), "Record with rid #" + this.id + ":" + clusterPosition + " was not found in database"), new OOfflineClusterException("Cannot read a record from the offline cluster '" + this.name + "'"));
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public OPhysicalPosition getPhysicalPosition(OPhysicalPosition iPPosition) throws IOException {
        throw new OOfflineClusterException("Cannot read a record on offline cluster '" + this.name + "'");
    }

    @Override
    public long getEntries() {
        return 0L;
    }

    @Override
    public long getFirstPosition() throws IOException {
        return -1L;
    }

    @Override
    public long getLastPosition() throws IOException {
        return -1L;
    }

    @Override
    public long getNextPosition() throws IOException {
        return -1L;
    }

    @Override
    public String getFileName() {
        throw new OOfflineClusterException("Cannot return filename of offline cluster '" + this.name + "'");
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void synch() throws IOException {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getRecordsSize() throws IOException {
        return 0L;
    }

    @Override
    public float recordGrowFactor() {
        return 0.0f;
    }

    @Override
    public float recordOverflowGrowFactor() {
        return 0.0f;
    }

    @Override
    public String compression() {
        return null;
    }

    @Override
    public boolean isHashBased() {
        return false;
    }

    @Override
    public boolean isSystemCluster() {
        return false;
    }

    @Override
    public OClusterEntryIterator absoluteIterator() {
        return null;
    }

    @Override
    public OPhysicalPosition[] higherPositions(OPhysicalPosition position) throws IOException {
        return OCommonConst.EMPTY_PHYSICAL_POSITIONS_ARRAY;
    }

    @Override
    public OPhysicalPosition[] ceilingPositions(OPhysicalPosition position) throws IOException {
        return OCommonConst.EMPTY_PHYSICAL_POSITIONS_ARRAY;
    }

    @Override
    public OPhysicalPosition[] lowerPositions(OPhysicalPosition position) throws IOException {
        return OCommonConst.EMPTY_PHYSICAL_POSITIONS_ARRAY;
    }

    @Override
    public OPhysicalPosition[] floorPositions(OPhysicalPosition position) throws IOException {
        return OCommonConst.EMPTY_PHYSICAL_POSITIONS_ARRAY;
    }

    @Override
    public boolean hideRecord(long position) throws IOException {
        return false;
    }

    @Override
    public ORecordConflictStrategy getRecordConflictStrategy() {
        return null;
    }

    @Override
    public void acquireAtomicExclusiveLock() {
    }
}

