/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.memory;

import com.orientechnologies.common.directmemory.OByteBufferPool;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.cache.OAbstractWriteCache;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cache.OCachePointer;
import com.orientechnologies.orient.core.storage.cache.OPageDataVerificationError;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.cache.local.OBackgroundExceptionListener;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceListener;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OPerformanceStatisticManager;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OSessionStoragePerformanceStatistic;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ODirectMemoryOnlyDiskCache
extends OAbstractWriteCache
implements OReadCache,
OWriteCache {
    private final Lock metadataLock = new ReentrantLock();
    private final Map<String, Integer> fileNameIdMap = new HashMap<String, Integer>();
    private final Map<Integer, String> fileIdNameMap = new HashMap<Integer, String>();
    private final ConcurrentMap<Integer, MemoryFile> files = new ConcurrentHashMap<Integer, MemoryFile>();
    private int counter = 0;
    private final int pageSize;
    private final int id;
    private final OPerformanceStatisticManager performanceStatisticManager;

    public ODirectMemoryOnlyDiskCache(int pageSize, int id, OPerformanceStatisticManager performanceStatisticManager) {
        this.pageSize = pageSize;
        this.id = id;
        this.performanceStatisticManager = performanceStatisticManager;
    }

    @Override
    public OPerformanceStatisticManager getPerformanceStatisticManager() {
        return this.performanceStatisticManager;
    }

    @Override
    public File getRootDirectory() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addFile(String fileName, OWriteCache writeCache) {
        this.metadataLock.lock();
        try {
            Integer fileId = this.fileNameIdMap.get(fileName);
            if (fileId == null) {
                ++this.counter;
            } else {
                throw new OStorageException(fileName + " already exists.");
            }
            int id = this.counter;
            this.files.put(id, new MemoryFile(this.id, id));
            this.fileNameIdMap.put(fileName, id);
            fileId = id;
            this.fileIdNameMap.put(fileId, fileName);
            long l = ODirectMemoryOnlyDiskCache.composeFileId(this.id, fileId);
            return l;
        }
        finally {
            this.metadataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long fileIdByName(String fileName) {
        this.metadataLock.lock();
        try {
            Integer fileId = this.fileNameIdMap.get(fileName);
            if (fileId != null) {
                long l = fileId.intValue();
                return l;
            }
        }
        finally {
            this.metadataLock.unlock();
        }
        return -1L;
    }

    @Override
    public int internalFileId(long fileId) {
        return ODirectMemoryOnlyDiskCache.extractFileId(fileId);
    }

    @Override
    public long externalFileId(int fileId) {
        return ODirectMemoryOnlyDiskCache.composeFileId(this.id, fileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long bookFileId(String fileName) {
        this.metadataLock.lock();
        try {
            ++this.counter;
            long l = ODirectMemoryOnlyDiskCache.composeFileId(this.id, this.counter);
            return l;
        }
        finally {
            this.metadataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long loadFile(String fileName, OWriteCache writeCache) {
        this.metadataLock.lock();
        try {
            Integer fileId = this.fileNameIdMap.get(fileName);
            if (fileId == null) {
                throw new OStorageException("File " + fileName + " does not exist.");
            }
            long l = ODirectMemoryOnlyDiskCache.composeFileId(this.id, fileId);
            return l;
        }
        finally {
            this.metadataLock.unlock();
        }
    }

    public long loadFile(long fileId, OWriteCache writeCache) {
        int intId = ODirectMemoryOnlyDiskCache.extractFileId(fileId);
        MemoryFile memoryFile = (MemoryFile)this.files.get(intId);
        if (memoryFile == null) {
            throw new OStorageException("File with id " + intId + " does not exist");
        }
        return ODirectMemoryOnlyDiskCache.composeFileId(this.id, intId);
    }

    public long loadFile(String fileName, long fileId, OWriteCache writeCache) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addFile(String fileName, long fileId, OWriteCache writeCache) {
        int intId = ODirectMemoryOnlyDiskCache.extractFileId(fileId);
        this.metadataLock.lock();
        try {
            if (this.files.containsKey(intId)) {
                throw new OStorageException("File with id " + intId + " already exists.");
            }
            if (this.fileNameIdMap.containsKey(fileName)) {
                throw new OStorageException(fileName + " already exists.");
            }
            this.files.put(intId, new MemoryFile(this.id, intId));
            this.fileNameIdMap.put(fileName, intId);
            this.fileIdNameMap.put(intId, fileName);
            long l = ODirectMemoryOnlyDiskCache.composeFileId(this.id, intId);
            return l;
        }
        finally {
            this.metadataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCacheEntry load(long fileId, long pageIndex, boolean checkPinnedPages, OWriteCache writeCache, int pageCount) {
        OSessionStoragePerformanceStatistic sessionStoragePerformanceStatistic = this.performanceStatisticManager.getSessionPerformanceStatistic();
        if (sessionStoragePerformanceStatistic != null) {
            sessionStoragePerformanceStatistic.startPageReadFromCacheTimer();
        }
        try {
            int intId = ODirectMemoryOnlyDiskCache.extractFileId(fileId);
            MemoryFile memoryFile = this.getFile(intId);
            OCacheEntry cacheEntry = memoryFile.loadPage(pageIndex);
            if (cacheEntry == null) {
                OCacheEntry oCacheEntry = null;
                return oCacheEntry;
            }
            OCacheEntry oCacheEntry = cacheEntry;
            synchronized (oCacheEntry) {
                cacheEntry.incrementUsages();
            }
            oCacheEntry = cacheEntry;
            return oCacheEntry;
        }
        finally {
            if (sessionStoragePerformanceStatistic != null) {
                sessionStoragePerformanceStatistic.stopPageReadFromCacheTimer();
            }
        }
    }

    @Override
    public void pinPage(OCacheEntry cacheEntry) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCacheEntry allocateNewPage(long fileId, OWriteCache writeCache) {
        OSessionStoragePerformanceStatistic sessionStoragePerformanceStatistic = this.performanceStatisticManager.getSessionPerformanceStatistic();
        if (sessionStoragePerformanceStatistic != null) {
            sessionStoragePerformanceStatistic.startPageReadFromCacheTimer();
        }
        try {
            OCacheEntry cacheEntry;
            int intId = ODirectMemoryOnlyDiskCache.extractFileId(fileId);
            MemoryFile memoryFile = this.getFile(intId);
            OCacheEntry oCacheEntry = cacheEntry = memoryFile.addNewPage();
            synchronized (oCacheEntry) {
                cacheEntry.incrementUsages();
            }
            oCacheEntry = cacheEntry;
            return oCacheEntry;
        }
        finally {
            if (sessionStoragePerformanceStatistic != null) {
                sessionStoragePerformanceStatistic.stopPageReadFromCacheTimer();
            }
        }
    }

    private MemoryFile getFile(int fileId) {
        MemoryFile memoryFile = (MemoryFile)this.files.get(fileId);
        if (memoryFile == null) {
            throw new OStorageException("File with id " + fileId + " does not exist");
        }
        return memoryFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(OCacheEntry cacheEntry, OWriteCache writeCache) {
        OCacheEntry oCacheEntry = cacheEntry;
        synchronized (oCacheEntry) {
            cacheEntry.decrementUsages();
            assert (cacheEntry.getUsagesCount() > 0 || !cacheEntry.isLockAcquiredByCurrentThread());
        }
    }

    @Override
    public long getFilledUpTo(long fileId) {
        int intId = ODirectMemoryOnlyDiskCache.extractFileId(fileId);
        MemoryFile memoryFile = this.getFile(intId);
        return memoryFile.size();
    }

    @Override
    public void flush(long fileId) {
    }

    @Override
    public void close(long fileId, boolean flush) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFile(long fileId) {
        int intId = ODirectMemoryOnlyDiskCache.extractFileId(fileId);
        this.metadataLock.lock();
        try {
            String fileName = this.fileIdNameMap.remove(intId);
            if (fileName == null) {
                return;
            }
            this.fileNameIdMap.remove(fileName);
            MemoryFile file = (MemoryFile)this.files.remove(intId);
            if (file != null) {
                file.clear();
            }
        }
        finally {
            this.metadataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameFile(long fileId, String oldFileName, String newFileName) {
        int intId = ODirectMemoryOnlyDiskCache.extractFileId(fileId);
        this.metadataLock.lock();
        try {
            String fileName = this.fileIdNameMap.get(intId);
            if (fileName == null) {
                return;
            }
            this.fileNameIdMap.remove(fileName);
            fileName = newFileName + fileName.substring(fileName.lastIndexOf(oldFileName) + fileName.length());
            this.fileIdNameMap.put(intId, fileName);
            this.fileNameIdMap.put(fileName, intId);
        }
        finally {
            this.metadataLock.unlock();
        }
    }

    @Override
    public void truncateFile(long fileId) {
        int intId = ODirectMemoryOnlyDiskCache.extractFileId(fileId);
        MemoryFile file = this.getFile(intId);
        file.clear();
    }

    @Override
    public void flush() {
    }

    @Override
    public long[] close() {
        return new long[0];
    }

    @Override
    public void clear() {
        this.delete();
    }

    @Override
    public long[] delete() {
        this.metadataLock.lock();
        try {
            for (MemoryFile file : this.files.values()) {
                file.clear();
            }
            this.files.clear();
            this.fileIdNameMap.clear();
            this.fileNameIdMap.clear();
        }
        finally {
            this.metadataLock.unlock();
        }
        return new long[0];
    }

    @Override
    public void deleteStorage(OWriteCache writeCache) throws IOException {
        this.delete();
    }

    @Override
    public void closeStorage(OWriteCache writeCache) throws IOException {
        this.close();
    }

    @Override
    public void loadCacheState(OWriteCache writeCache) {
    }

    @Override
    public void storeCacheState(OWriteCache writeCache) {
    }

    @Override
    public void addBackgroundExceptionListener(OBackgroundExceptionListener listener) {
    }

    @Override
    public void removeBackgroundExceptionListener(OBackgroundExceptionListener listener) {
    }

    @Override
    public OPageDataVerificationError[] checkStoredPages(OCommandOutputListener commandOutputListener) {
        return OCommonConst.EMPTY_PAGE_DATA_VERIFICATION_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String name) {
        this.metadataLock.lock();
        try {
            Integer fileId = this.fileNameIdMap.get(name);
            if (fileId == null) {
                boolean bl = false;
                return bl;
            }
            MemoryFile memoryFile = (MemoryFile)this.files.get(fileId);
            boolean bl = memoryFile != null;
            return bl;
        }
        finally {
            this.metadataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(long fileId) {
        int intId = ODirectMemoryOnlyDiskCache.extractFileId(fileId);
        this.metadataLock.lock();
        try {
            MemoryFile memoryFile = (MemoryFile)this.files.get(intId);
            boolean bl = memoryFile != null;
            return bl;
        }
        finally {
            this.metadataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String fileNameById(long fileId) {
        int intId = ODirectMemoryOnlyDiskCache.extractFileId(fileId);
        this.metadataLock.lock();
        try {
            String string = this.fileIdNameMap.get(intId);
            return string;
        }
        finally {
            this.metadataLock.unlock();
        }
    }

    @Override
    public long getUsedMemory() {
        long totalPages = 0L;
        for (MemoryFile file : this.files.values()) {
            totalPages += file.getUsedMemory();
        }
        return totalPages * (long)this.pageSize;
    }

    @Override
    public void startFuzzyCheckpoints() {
    }

    @Override
    public boolean checkLowDiskSpace() {
        return true;
    }

    @Override
    public void makeFuzzyCheckpoint() {
    }

    @Override
    public void addLowDiskSpaceListener(OLowDiskSpaceListener listener) {
    }

    @Override
    public void removeLowDiskSpaceListener(OLowDiskSpaceListener listener) {
    }

    @Override
    public long loadFile(String fileName) {
        return this.loadFile(fileName, null);
    }

    @Override
    public long addFile(String fileName) {
        return this.addFile(fileName, null);
    }

    @Override
    public long addFile(String fileName, long fileId) {
        return this.addFile(fileName, fileId, null);
    }

    @Override
    public Future store(long fileId, long pageIndex, OCachePointer dataPointer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OCachePointer[] load(long fileId, long startPageIndex, int pageCount, boolean addNewPages, OModifiableBoolean cacheHit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getExclusiveWriteCachePagesSize() {
        return 0L;
    }

    @Override
    public void truncateFile(long fileId, OWriteCache writeCache) throws IOException {
        this.truncateFile(fileId);
    }

    @Override
    public int getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Long> files() {
        HashMap<String, Long> result = new HashMap<String, Long>();
        this.metadataLock.lock();
        try {
            for (Map.Entry<String, Integer> entry : this.fileNameIdMap.entrySet()) {
                if (entry.getValue() <= 0) continue;
                result.put(entry.getKey(), ODirectMemoryOnlyDiskCache.composeFileId(this.id, entry.getValue()));
            }
        }
        finally {
            this.metadataLock.unlock();
        }
        return result;
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    @Override
    public boolean fileIdsAreEqual(long firsId, long secondId) {
        int secondIntId;
        int firstIntId = ODirectMemoryOnlyDiskCache.extractFileId(firsId);
        return firstIntId == (secondIntId = ODirectMemoryOnlyDiskCache.extractFileId(secondId));
    }

    @Override
    public void closeFile(long fileId, boolean flush, OWriteCache writeCache) throws IOException {
        this.close(fileId, flush);
    }

    @Override
    public void deleteFile(long fileId, OWriteCache writeCache) throws IOException {
        this.deleteFile(fileId);
    }

    private static final class MemoryFile {
        private final int id;
        private final int storageId;
        private final ReadWriteLock clearLock = new ReentrantReadWriteLock();
        private final ConcurrentSkipListMap<Long, OCacheEntry> content = new ConcurrentSkipListMap();

        private MemoryFile(int storageId, int id) {
            this.storageId = storageId;
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private OCacheEntry loadPage(long index) {
            this.clearLock.readLock().lock();
            try {
                OCacheEntry oCacheEntry = this.content.get(index);
                return oCacheEntry;
            }
            finally {
                this.clearLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private OCacheEntry addNewPage() {
            this.clearLock.readLock().lock();
            try {
                OCacheEntry cacheEntry;
                long index = -1L;
                do {
                    if (this.content.isEmpty()) {
                        index = 0L;
                    } else {
                        long lastIndex = this.content.lastKey();
                        index = lastIndex + 1L;
                    }
                    OByteBufferPool bufferPool = OByteBufferPool.instance();
                    ByteBuffer buffer = bufferPool.acquireDirect(true);
                    OCachePointer cachePointer = new OCachePointer(buffer, bufferPool, new OLogSequenceNumber(-1L, -1L), this.id, index);
                    cachePointer.incrementReferrer();
                    cacheEntry = new OCacheEntry(OAbstractWriteCache.composeFileId(this.storageId, this.id), index, cachePointer, false);
                    OCacheEntry oldCacheEntry = this.content.putIfAbsent(index, cacheEntry);
                    if (oldCacheEntry == null) continue;
                    cachePointer.decrementReferrer();
                    index = -1L;
                } while (index < 0L);
                OCacheEntry oCacheEntry = cacheEntry;
                return oCacheEntry;
            }
            finally {
                this.clearLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long size() {
            this.clearLock.readLock().lock();
            try {
                if (this.content.isEmpty()) {
                    long l = 0L;
                    return l;
                }
                long l = this.content.lastKey() + 1L;
                return l;
            }
            finally {
                this.clearLock.readLock().unlock();
            }
        }

        private long getUsedMemory() {
            return this.content.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clear() {
            boolean thereAreNotReleased = false;
            this.clearLock.writeLock().lock();
            try {
                Iterator<OCacheEntry> iterator = this.content.values().iterator();
                while (iterator.hasNext()) {
                    OCacheEntry entry;
                    OCacheEntry oCacheEntry = entry = iterator.next();
                    synchronized (oCacheEntry) {
                        thereAreNotReleased |= entry.getUsagesCount() > 0;
                        entry.getCachePointer().decrementReferrer();
                    }
                }
                this.content.clear();
            }
            finally {
                this.clearLock.writeLock().unlock();
            }
            if (thereAreNotReleased) {
                throw new IllegalStateException("Some cache entries were not released. Storage may be in invalid state.");
            }
        }
    }
}

