/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.resource;

import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.common.concur.resource.OSharedContainer;
import com.orientechnologies.common.concur.resource.OSharedResource;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;

public class OSharedContainerImpl
implements OSharedContainer {
    protected Map<String, Object> sharedResources = new HashMap<String, Object>();

    @Override
    public synchronized boolean existsResource(String iName) {
        return this.sharedResources.containsKey(iName);
    }

    @Override
    public synchronized <T> T removeResource(String iName) {
        Object resource = this.sharedResources.remove(iName);
        if (resource instanceof OSharedResource) {
            ((OSharedResource)resource).releaseExclusiveLock();
        }
        return (T)resource;
    }

    @Override
    public synchronized <T> T getResource(String iName, Callable<T> iCallback) {
        Object value = this.sharedResources.get(iName);
        if (value == null) {
            try {
                value = iCallback.call();
            }
            catch (Exception e) {
                throw OException.wrapException(new ODatabaseException("Error on creation of shared resource"), e);
            }
            if (value instanceof OSharedResource) {
                ((OSharedResource)value).acquireExclusiveLock();
            }
            this.sharedResources.put(iName, value);
        }
        return (T)value;
    }

    public synchronized void clearResources() {
        for (Object resource : this.sharedResources.values()) {
            if (!(resource instanceof OCloseable)) continue;
            ((OCloseable)resource).close();
        }
        this.sharedResources.clear();
    }
}

