/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.sequence;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.exception.OSequenceException;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.sequence.OSequence;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceHelper;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceLibrary;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class OSequenceLibraryImpl
implements OSequenceLibrary {
    private final Map<String, OSequence> sequences = new ConcurrentHashMap<String, OSequence>();

    @Override
    public void create() {
        this.init();
    }

    @Override
    public void load() {
        this.sequences.clear();
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.get();
        if (((OMetadataInternal)db.getMetadata()).getImmutableSchemaSnapshot().existsClass("OSequence")) {
            Object result = db.query(new OSQLSynchQuery("SELECT FROM OSequence"), new Object[0]);
            for (ODocument document : result) {
                document.reload();
                OSequence sequence = OSequenceHelper.createSequence(document);
                if (sequence == null) continue;
                this.sequences.put(sequence.getName().toUpperCase(), sequence);
            }
        }
    }

    @Override
    public void close() {
        this.sequences.clear();
    }

    @Override
    public Set<String> getSequenceNames() {
        return this.sequences.keySet();
    }

    @Override
    public int getSequenceCount() {
        return this.sequences.size();
    }

    @Override
    public OSequence getSequence(String iName) {
        String name = iName.toUpperCase();
        OSequence seq = this.sequences.get(name);
        if (seq == null) {
            this.load();
            seq = this.sequences.get(name);
        }
        if (seq != null) {
            seq.bindOnLocalThread();
            seq.checkForUpdateToLastversion();
        }
        return seq;
    }

    @Override
    public OSequence createSequence(String iName, OSequence.SEQUENCE_TYPE sequenceType, OSequence.CreateParams params) {
        this.init();
        String key = iName.toUpperCase();
        this.validateSequenceNoExists(key);
        OSequence sequence = OSequenceHelper.createSequence(sequenceType, params, null).setName(iName);
        sequence.save();
        this.sequences.put(key, sequence);
        return sequence;
    }

    @Override
    public void dropSequence(String iName) {
        OSequence seq = this.getSequence(iName);
        if (seq != null) {
            ODatabaseRecordThreadLocal.INSTANCE.get().delete(seq.getDocument().getIdentity());
            this.sequences.remove(iName.toUpperCase());
        }
    }

    @Override
    public OSequence onSequenceCreated(ODocument iDocument) {
        this.init();
        String name = OSequence.getSequenceName(iDocument);
        if (name == null) {
            return null;
        }
        OSequence seq = this.getSequence(name = name.toUpperCase());
        if (seq != null) {
            return seq;
        }
        OSequence sequence = OSequenceHelper.createSequence(iDocument);
        this.sequences.put(name, sequence);
        return sequence;
    }

    @Override
    public OSequence onSequenceUpdated(ODocument iDocument) {
        String name = OSequence.getSequenceName(iDocument);
        if (name == null) {
            return null;
        }
        OSequence sequence = this.sequences.get(name = name.toUpperCase());
        if (sequence == null) {
            return null;
        }
        sequence.onUpdate(iDocument);
        return sequence;
    }

    @Override
    public void onSequenceDropped(ODocument iDocument) {
        String name = OSequence.getSequenceName(iDocument);
        if (name == null) {
            return;
        }
        name = name.toUpperCase();
        this.sequences.remove(name);
    }

    private void init() {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.get();
        if (db.getMetadata().getSchema().existsClass("OSequence")) {
            return;
        }
        OClassImpl sequenceClass = (OClassImpl)db.getMetadata().getSchema().createClass("OSequence");
        OSequence.initClass(sequenceClass);
    }

    private void validateSequenceNoExists(String iName) {
        if (this.sequences.containsKey(iName)) {
            throw new OSequenceException("Sequence '" + iName + "' already exists");
        }
    }

    private void validateSequenceExists(String iName) {
        if (!this.sequences.containsKey(iName)) {
            throw new OSequenceException("Sequence '" + iName + "' does not exists");
        }
    }
}

