/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.stream;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.entity.OClassDictionary;
import com.orientechnologies.orient.core.exception.OSerializationException;

public class OStreamSerializerHelper {
    public static final String SEPARATOR = "|";
    private static final char SHORT_FORM_PREFIX = '!';

    public static StringBuilder writeRecordType(Class<?> cls, StringBuilder iBuffer) {
        Character c = OClassDictionary.instance().getCodeByClass(cls);
        if (c != null) {
            iBuffer.append('!');
            iBuffer.append(c);
        } else {
            iBuffer.append(cls.getName());
            iBuffer.append(SEPARATOR);
        }
        return iBuffer;
    }

    public static Class<?> readRecordType(String iBuffer, StringBuilder iContent) throws ClassNotFoundException {
        int pos;
        Class<?> cls;
        if (iBuffer.charAt(0) == '!') {
            cls = OClassDictionary.instance().getClassByCode(iBuffer.charAt(1));
            pos = 1;
        } else {
            pos = iBuffer.indexOf(SEPARATOR);
            if (pos < 0) {
                String message = "Class signature not found in the buffer: " + iBuffer;
                OLogManager.instance().error(null, message, new Object[0]);
                throw new OSerializationException(message);
            }
            String className = iBuffer.substring(0, pos);
            cls = Class.forName(className);
        }
        iContent.append(iBuffer.substring(pos + 1));
        return cls;
    }
}

