/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.parser.OAlterClassStatement;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class OCommandExecutorSQLAlterClass
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_ALTER = "ALTER";
    public static final String KEYWORD_CLASS = "CLASS";
    private String className;
    private OClass.ATTRIBUTES attribute;
    private String value;
    private boolean unsafe = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCommandExecutorSQLAlterClass parse(OCommandRequest iRequest) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        String originalQuery = queryText = textRequest.getText();
        try {
            queryText = this.preParse(queryText, iRequest);
            textRequest.setText(queryText);
            ODatabaseDocumentInternal database = OCommandExecutorSQLAlterClass.getDatabase();
            this.init((OCommandRequestText)iRequest);
            StringBuilder word = new StringBuilder();
            int oldPos = 0;
            int pos = OCommandExecutorSQLAlterClass.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true);
            if (pos == -1 || !word.toString().equals(KEYWORD_ALTER)) {
                throw new OCommandSQLParsingException("Keyword ALTER not found", this.parserText, oldPos);
            }
            oldPos = pos;
            if ((pos = OCommandExecutorSQLAlterClass.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_CLASS)) {
                throw new OCommandSQLParsingException("Keyword CLASS not found", this.parserText, oldPos);
            }
            oldPos = pos;
            if ((pos = OCommandExecutorSQLAlterClass.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, false)) == -1) {
                throw new OCommandSQLParsingException("Expected <class>", this.parserText, oldPos);
            }
            this.className = this.decodeClassName(word.toString());
            oldPos = pos;
            if ((pos = OCommandExecutorSQLAlterClass.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true)) == -1) {
                throw new OCommandSQLParsingException("Missed the class's attribute to change", this.parserText, oldPos);
            }
            String attributeAsString = word.toString();
            try {
                this.attribute = OClass.ATTRIBUTES.valueOf(attributeAsString.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw new OCommandSQLParsingException("Unknown class's attribute '" + attributeAsString + "'. Supported attributes are: " + Arrays.toString((Object[])OClass.ATTRIBUTES.values()), this.parserText, oldPos);
            }
            this.value = this.parserText.substring(pos + 1).trim();
            if ("addcluster".equalsIgnoreCase(attributeAsString) || "removecluster".equalsIgnoreCase(attributeAsString)) {
                this.value = this.decodeClassName(this.value);
            }
            OAlterClassStatement stm = (OAlterClassStatement)this.preParsedStatement;
            if (this.preParsedStatement != null && stm.property == OClass.ATTRIBUTES.CUSTOM) {
                this.value = "" + stm.customKey.getStringValue() + "=" + stm.customValue.toString();
            }
            if (this.parserTextUpperCase.endsWith("UNSAFE")) {
                this.unsafe = true;
                this.value = this.value.substring(0, this.value.length() - "UNSAFE".length());
                int i = this.value.length() - 1;
                while (this.value.charAt(i) == ' ' || this.value.charAt(i) == '\t') {
                    this.value = this.value.substring(0, this.value.length() - 1);
                    --i;
                }
            }
            if (this.value.length() == 0) {
                throw new OCommandSQLParsingException("Missed the property's value to change for attribute '" + (Object)((Object)this.attribute) + "'", this.parserText, oldPos);
            }
            if (this.value.equalsIgnoreCase("null")) {
                this.value = null;
            }
        }
        finally {
            textRequest.setText(originalQuery);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        ODatabaseDocumentInternal database = OCommandExecutorSQLAlterClass.getDatabase();
        if (this.attribute == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        OClassImpl cls = (OClassImpl)database.getMetadata().getSchema().getClass(this.className);
        if (cls == null) {
            throw new OCommandExecutionException("Cannot alter class '" + this.className + "' because not found");
        }
        if (!this.unsafe && this.attribute == OClass.ATTRIBUTES.NAME && cls.isSubClassOf("E")) {
            throw new OCommandExecutionException("Cannot alter class '" + this.className + "' because is an Edge class and could break vertices. Use UNSAFE if you want to force it");
        }
        for (int clId : cls.getPolymorphicClusterIds()) {
            OCommandExecutorSQLAlterClass.getDatabase().getMetadata().getCommandCache().invalidateResultsOfCluster(OCommandExecutorSQLAlterClass.getDatabase().getClusterNameById(clId));
        }
        if (this.value != null && this.attribute == OClass.ATTRIBUTES.SUPERCLASS) {
            this.checkClassExists(database, this.className, this.decodeClassName(this.value));
        }
        if (this.value != null && this.attribute == OClass.ATTRIBUTES.SUPERCLASSES) {
            List<String> classes = Arrays.asList(this.value.split(",\\s*"));
            for (String cName : classes) {
                this.checkClassExists(database, this.className, this.decodeClassName(cName));
            }
        }
        if (!this.unsafe && this.value != null && this.attribute == OClass.ATTRIBUTES.NAME && !cls.getIndexes().isEmpty()) {
            throw new OCommandExecutionException("Cannot rename class '" + this.className + "' because it has indexes defined on it. Drop indexes before or use UNSAFE (at your won risk)");
        }
        cls.set(this.attribute, this.value);
        return Boolean.TRUE;
    }

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_COMMAND_QUICK_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    protected void checkClassExists(ODatabaseDocument database, String targetClass, String superClass) {
        if (superClass.startsWith("+") || superClass.startsWith("-")) {
            superClass = superClass.substring(1);
        }
        if (database.getMetadata().getSchema().getClass(this.decodeClassName(superClass)) == null) {
            throw new OCommandExecutionException("Cannot alter superClass of '" + targetClass + "' because " + superClass + " class not found");
        }
    }

    @Override
    public String getSyntax() {
        return "ALTER CLASS <class> <attribute-name> <attribute-value> [UNSAFE]";
    }

    @Override
    public boolean involveSchema() {
        return true;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }
}

