/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.functions.OSQLFunction;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionFactory;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionDifference;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionDistinct;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionDocument;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionFirst;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionIntersect;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionLast;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionList;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionMap;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionSet;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionSymmetricDifference;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionTraversedEdge;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionTraversedElement;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionTraversedVertex;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionUnionAll;
import com.orientechnologies.orient.core.sql.functions.geo.OSQLFunctionDistance;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionAbsoluteValue;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionAverage;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionDecimal;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionEval;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionMax;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionMin;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionSum;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionCoalesce;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionCount;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionDate;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionDecode;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionEncode;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionIf;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionIfNull;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionSysdate;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionUUID;
import com.orientechnologies.orient.core.sql.functions.sequence.OSQLFunctionSequence;
import com.orientechnologies.orient.core.sql.functions.stat.OSQLFunctionMedian;
import com.orientechnologies.orient.core.sql.functions.stat.OSQLFunctionMode;
import com.orientechnologies.orient.core.sql.functions.stat.OSQLFunctionPercentile;
import com.orientechnologies.orient.core.sql.functions.stat.OSQLFunctionStandardDeviation;
import com.orientechnologies.orient.core.sql.functions.stat.OSQLFunctionVariance;
import com.orientechnologies.orient.core.sql.functions.text.OSQLFunctionConcat;
import com.orientechnologies.orient.core.sql.functions.text.OSQLFunctionFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class ODefaultSQLFunctionFactory
implements OSQLFunctionFactory {
    private static final Map<String, Object> FUNCTIONS = new HashMap<String, Object>();

    public static void register(String iName, Object iImplementation) {
        FUNCTIONS.put(iName.toLowerCase(), iImplementation);
    }

    @Override
    public Set<String> getFunctionNames() {
        return FUNCTIONS.keySet();
    }

    @Override
    public boolean hasFunction(String name) {
        return FUNCTIONS.containsKey(name);
    }

    @Override
    public OSQLFunction createFunction(String name) {
        Object obj = FUNCTIONS.get(name);
        if (obj == null) {
            throw new OCommandExecutionException("Unknown function name :" + name);
        }
        if (obj instanceof OSQLFunction) {
            return (OSQLFunction)obj;
        }
        Class clazz = (Class)obj;
        try {
            return (OSQLFunction)clazz.newInstance();
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException("Error in creation of function " + name + "(). Probably there is not an empty constructor or the constructor generates errors"), e);
        }
    }

    static {
        ODefaultSQLFunctionFactory.register("avg", OSQLFunctionAverage.class);
        ODefaultSQLFunctionFactory.register("coalesce", new OSQLFunctionCoalesce());
        ODefaultSQLFunctionFactory.register("count", OSQLFunctionCount.class);
        ODefaultSQLFunctionFactory.register("date", OSQLFunctionDate.class);
        ODefaultSQLFunctionFactory.register("decode", new OSQLFunctionDecode());
        ODefaultSQLFunctionFactory.register("difference", OSQLFunctionDifference.class);
        ODefaultSQLFunctionFactory.register("symmetricDifference", OSQLFunctionSymmetricDifference.class);
        ODefaultSQLFunctionFactory.register("distance", new OSQLFunctionDistance());
        ODefaultSQLFunctionFactory.register("distinct", OSQLFunctionDistinct.class);
        ODefaultSQLFunctionFactory.register("document", OSQLFunctionDocument.class);
        ODefaultSQLFunctionFactory.register("encode", new OSQLFunctionEncode());
        ODefaultSQLFunctionFactory.register("eval", OSQLFunctionEval.class);
        ODefaultSQLFunctionFactory.register("first", new OSQLFunctionFirst());
        ODefaultSQLFunctionFactory.register("format", new OSQLFunctionFormat());
        ODefaultSQLFunctionFactory.register("traversedEdge", OSQLFunctionTraversedEdge.class);
        ODefaultSQLFunctionFactory.register("traversedElement", OSQLFunctionTraversedElement.class);
        ODefaultSQLFunctionFactory.register("traversedVertex", OSQLFunctionTraversedVertex.class);
        ODefaultSQLFunctionFactory.register("if", new OSQLFunctionIf());
        ODefaultSQLFunctionFactory.register("ifnull", new OSQLFunctionIfNull());
        ODefaultSQLFunctionFactory.register("intersect", OSQLFunctionIntersect.class);
        ODefaultSQLFunctionFactory.register("last", new OSQLFunctionLast());
        ODefaultSQLFunctionFactory.register("list", OSQLFunctionList.class);
        ODefaultSQLFunctionFactory.register("map", OSQLFunctionMap.class);
        ODefaultSQLFunctionFactory.register("max", OSQLFunctionMax.class);
        ODefaultSQLFunctionFactory.register("min", OSQLFunctionMin.class);
        ODefaultSQLFunctionFactory.register("set", OSQLFunctionSet.class);
        ODefaultSQLFunctionFactory.register("sysdate", OSQLFunctionSysdate.class);
        ODefaultSQLFunctionFactory.register("sum", OSQLFunctionSum.class);
        ODefaultSQLFunctionFactory.register("unionAll", OSQLFunctionUnionAll.class);
        ODefaultSQLFunctionFactory.register("mode", OSQLFunctionMode.class);
        ODefaultSQLFunctionFactory.register("percentile", OSQLFunctionPercentile.class);
        ODefaultSQLFunctionFactory.register("median", OSQLFunctionMedian.class);
        ODefaultSQLFunctionFactory.register("variance", OSQLFunctionVariance.class);
        ODefaultSQLFunctionFactory.register("stddev", OSQLFunctionStandardDeviation.class);
        ODefaultSQLFunctionFactory.register("uuid", OSQLFunctionUUID.class);
        ODefaultSQLFunctionFactory.register("concat", OSQLFunctionConcat.class);
        ODefaultSQLFunctionFactory.register("decimal", OSQLFunctionDecimal.class);
        ODefaultSQLFunctionFactory.register("sequence", new OSQLFunctionSequence());
        ODefaultSQLFunctionFactory.register("abs", OSQLFunctionAbsoluteValue.class);
    }
}

