/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.exception.OErrorCode;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OIterableRecordSource;
import com.orientechnologies.orient.core.sql.filter.OSQLTarget;
import com.orientechnologies.orient.core.sql.parser.OAndBlock;
import com.orientechnologies.orient.core.sql.parser.OBaseIdentifier;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OFromItem;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OJson;
import com.orientechnologies.orient.core.sql.parser.OLimit;
import com.orientechnologies.orient.core.sql.parser.OMatchExpression;
import com.orientechnologies.orient.core.sql.parser.OMatchFilter;
import com.orientechnologies.orient.core.sql.parser.OMatchPathItem;
import com.orientechnologies.orient.core.sql.parser.OSelectStatement;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OSuffixIdentifier;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.ParseException;
import com.orientechnologies.orient.core.sql.parser.Pattern;
import com.orientechnologies.orient.core.sql.parser.PatternEdge;
import com.orientechnologies.orient.core.sql.parser.PatternNode;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import com.orientechnologies.orient.core.sql.query.OBasicResultSet;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OMatchStatement
extends OStatement
implements OCommandExecutor,
OIterableRecordSource {
    String DEFAULT_ALIAS_PREFIX = "$ORIENT_DEFAULT_ALIAS_";
    private OSQLAsynchQuery<ODocument> request;
    long threshold = 20L;
    private int limitFromProtocol = -1;
    public static final String KEYWORD_MATCH = "MATCH";
    protected List<OMatchExpression> matchExpressions = new ArrayList<OMatchExpression>();
    protected List<OExpression> returnItems = new ArrayList<OExpression>();
    protected List<OIdentifier> returnAliases = new ArrayList<OIdentifier>();
    protected OLimit limit;
    protected Pattern pattern;
    private Map<String, OWhereClause> aliasFilters;
    private Map<String, String> aliasClasses;
    private OCommandContext context;
    private OProgressListener progressListener;

    public OMatchStatement() {
        super(-1);
    }

    public OMatchStatement(int id) {
        super(id);
    }

    public OMatchStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public <RET extends OCommandExecutor> RET parse(OCommandRequest iRequest) {
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        if (iRequest instanceof OSQLSynchQuery) {
            this.request = (OSQLSynchQuery)iRequest;
        } else if (iRequest instanceof OSQLAsynchQuery) {
            this.request = (OSQLAsynchQuery)iRequest;
        } else {
            this.request = new OSQLSynchQuery<ODocument>(textRequest.getText());
            if (textRequest.getResultListener() != null) {
                this.request.setResultListener(textRequest.getResultListener());
            }
        }
        String queryText = textRequest.getText();
        ByteArrayInputStream is = new ByteArrayInputStream(queryText.getBytes());
        OrientSql osql = new OrientSql(is);
        try {
            OMatchStatement result = (OMatchStatement)osql.parse();
            this.matchExpressions = result.matchExpressions;
            this.returnItems = result.returnItems;
            this.returnAliases = result.returnAliases;
            this.limit = result.limit;
        }
        catch (ParseException e) {
            OCommandSQLParsingException ex = new OCommandSQLParsingException(e, queryText);
            OErrorCode.QUERY_PARSE_ERROR.throwException(ex.getMessage(), ex);
        }
        this.assignDefaultAliases(this.matchExpressions);
        this.pattern = new Pattern();
        for (OMatchExpression expr : this.matchExpressions) {
            this.pattern.addExpression(expr);
        }
        LinkedHashMap<String, OWhereClause> aliasFilters = new LinkedHashMap<String, OWhereClause>();
        LinkedHashMap<String, String> aliasClasses = new LinkedHashMap<String, String>();
        for (OMatchExpression expr : this.matchExpressions) {
            this.addAliases(expr, aliasFilters, aliasClasses, this.context);
        }
        this.aliasFilters = aliasFilters;
        this.aliasClasses = aliasClasses;
        this.rebindFilters(aliasFilters);
        this.pattern.validate();
        return (RET)this;
    }

    private void rebindFilters(Map<String, OWhereClause> aliasFilters) {
        for (OMatchExpression expression : this.matchExpressions) {
            OWhereClause newFilter = aliasFilters.get(expression.origin.getAlias());
            expression.origin.setFilter(newFilter);
            for (OMatchPathItem item : expression.items) {
                newFilter = aliasFilters.get(item.filter.getAlias());
                item.filter.setFilter(newFilter);
            }
        }
    }

    private void assignDefaultAliases(List<OMatchExpression> matchExpressions) {
        int counter = 0;
        for (OMatchExpression expression : matchExpressions) {
            if (expression.origin.getAlias() == null) {
                expression.origin.setAlias(this.DEFAULT_ALIAS_PREFIX + counter++);
            }
            for (OMatchPathItem item : expression.items) {
                if (item.filter == null) {
                    item.filter = new OMatchFilter(-1);
                }
                if (item.filter.getAlias() != null) continue;
                item.filter.setAlias(this.DEFAULT_ALIAS_PREFIX + counter++);
            }
        }
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        this.context.setInputParameters(iArgs);
        return this.execute(this.request, this.context, this.progressListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(OSQLAsynchQuery<ODocument> request, OCommandContext context, OProgressListener progressListener) {
        Map<Object, Object> iArgs = context.getInputParameters();
        try {
            Map<String, Long> estimatedRootEntries = this.estimateRootEntries(this.aliasClasses, this.aliasFilters, context);
            if (estimatedRootEntries.values().contains(0L)) {
                OBasicResultSet oBasicResultSet = new OBasicResultSet();
                return oBasicResultSet;
            }
            List<EdgeTraversal> sortedEdges = this.getTopologicalSortedSchedule(estimatedRootEntries, this.pattern);
            MatchExecutionPlan executionPlan = new MatchExecutionPlan();
            executionPlan.sortedEdges = sortedEdges;
            this.calculateMatch(this.pattern, estimatedRootEntries, new MatchContext(), this.aliasClasses, this.aliasFilters, context, request, executionPlan);
            Object object = this.getResult(request);
            return object;
        }
        finally {
            if (request.getResultListener() != null) {
                request.getResultListener().end();
            }
        }
    }

    private void updateScheduleStartingAt(PatternNode startNode, Set<PatternNode> visitedNodes, Set<PatternEdge> visitedEdges, Map<String, Set<String>> remainingDependencies, List<EdgeTraversal> resultingSchedule) {
        visitedNodes.add(startNode);
        for (Set<String> dependencies : remainingDependencies.values()) {
            dependencies.remove(startNode.alias);
        }
        LinkedHashMap<PatternEdge, Boolean> edges = new LinkedHashMap<PatternEdge, Boolean>();
        for (PatternEdge patternEdge : startNode.out) {
            edges.put(patternEdge, true);
        }
        for (PatternEdge patternEdge : startNode.in) {
            edges.put(patternEdge, false);
        }
        for (Map.Entry entry : edges.entrySet()) {
            PatternNode neighboringNode;
            PatternEdge edge = (PatternEdge)entry.getKey();
            boolean isOutbound = (Boolean)entry.getValue();
            PatternNode patternNode = neighboringNode = isOutbound ? edge.in : edge.out;
            if (!remainingDependencies.get(neighboringNode.alias).isEmpty()) continue;
            if (visitedNodes.contains(neighboringNode)) {
                if (visitedEdges.contains(edge)) continue;
                boolean traversalDirection = startNode.optional || edge.item.isBidirectional() ? !isOutbound : isOutbound;
                visitedEdges.add(edge);
                resultingSchedule.add(new EdgeTraversal(edge, traversalDirection));
                continue;
            }
            if (startNode.optional) continue;
            if (visitedEdges.contains(edge)) {
                throw new AssertionError((Object)("The edge was visited, but the neighboring vertex was not: " + edge + " " + neighboringNode));
            }
            visitedEdges.add(edge);
            resultingSchedule.add(new EdgeTraversal(edge, isOutbound));
            this.updateScheduleStartingAt(neighboringNode, visitedNodes, visitedEdges, remainingDependencies, resultingSchedule);
        }
    }

    private Map<String, Set<String>> getDependencies(Pattern pattern) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (PatternNode node : pattern.aliasToNode.values()) {
            List<String> involvedAliases;
            HashSet<String> currentDependencies = new HashSet<String>();
            OWhereClause filter = this.aliasFilters.get(node.alias);
            if (filter != null && filter.baseExpression != null && (involvedAliases = filter.baseExpression.getMatchPatternInvolvedAliases()) != null) {
                currentDependencies.addAll(involvedAliases);
            }
            result.put(node.alias, currentDependencies);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private List<EdgeTraversal> getTopologicalSortedSchedule(Map<String, Long> estimatedRootEntries, Pattern pattern) {
        ArrayList<EdgeTraversal> resultingSchedule = new ArrayList<EdgeTraversal>();
        Map<String, Set<String>> remainingDependencies = this.getDependencies(pattern);
        HashSet<PatternNode> visitedNodes = new HashSet<PatternNode>();
        HashSet<PatternEdge> visitedEdges = new HashSet<PatternEdge>();
        ArrayList<OPair<Comparable, String>> rootWeights = new ArrayList<OPair<Comparable, String>>();
        for (Map.Entry<String, Long> entry : estimatedRootEntries.entrySet()) {
            rootWeights.add(new OPair<Comparable, String>(entry.getValue(), entry.getKey()));
        }
        Collections.sort(rootWeights);
        LinkedHashSet<Object> remainingStarts = new LinkedHashSet<Object>();
        for (OPair oPair : rootWeights) {
            remainingStarts.add(oPair.getValue());
        }
        for (String string : pattern.aliasToNode.keySet()) {
            if (remainingStarts.contains(string)) continue;
            remainingStarts.add(string);
        }
        while (resultingSchedule.size() < pattern.numOfEdges) {
            void var9_15;
            Object var9_13 = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : remainingStarts) {
                PatternNode currentNode = pattern.aliasToNode.get(string);
                if (visitedNodes.contains(currentNode)) {
                    arrayList.add(string);
                    continue;
                }
                if (!remainingDependencies.get(string).isEmpty()) continue;
                arrayList.add(string);
                PatternNode patternNode = currentNode;
                break;
            }
            remainingStarts.removeAll(arrayList);
            if (var9_15 == null) {
                throw new OCommandExecutionException("This query contains MATCH conditions that cannot be evaluated, like an undefined alias or a circular dependency on a $matched condition.");
            }
            this.updateScheduleStartingAt((PatternNode)var9_15, visitedNodes, visitedEdges, remainingDependencies, resultingSchedule);
        }
        if (resultingSchedule.size() != pattern.numOfEdges) {
            throw new AssertionError((Object)("Incorrect number of edges: " + resultingSchedule.size() + " vs " + pattern.numOfEdges));
        }
        return resultingSchedule;
    }

    protected Object getResult(OSQLAsynchQuery<ODocument> request) {
        if (request instanceof OSQLSynchQuery) {
            return ((OSQLSynchQuery)request).getResult();
        }
        return null;
    }

    private boolean calculateMatch(Pattern pattern, Map<String, Long> estimatedRootEntries, MatchContext matchContext, Map<String, String> aliasClasses, Map<String, OWhereClause> aliasFilters, OCommandContext iCommandContext, OSQLAsynchQuery<ODocument> request, MatchExecutionPlan executionPlan) {
        boolean rootFound = false;
        for (Map.Entry<String, Long> entryPoint : estimatedRootEntries.entrySet()) {
            if (entryPoint.getValue() >= this.threshold) continue;
            String nextAlias = entryPoint.getKey();
            Iterable<OIdentifiable> matches = this.fetchAliasCandidates(nextAlias, aliasFilters, iCommandContext, aliasClasses);
            HashSet ids = new HashSet();
            if (!matches.iterator().hasNext()) {
                if (pattern.get(nextAlias).isOptionalNode()) continue;
                return true;
            }
            matchContext.candidates.put(nextAlias, matches);
            executionPlan.preFetchedAliases.put(nextAlias, entryPoint.getValue());
            rootFound = true;
        }
        if (!rootFound) {
            String nextAlias = this.getNextAlias(estimatedRootEntries, matchContext);
            Iterable<OIdentifiable> matches = this.fetchAliasCandidates(nextAlias, aliasFilters, iCommandContext, aliasClasses);
            if (!matches.iterator().hasNext()) {
                return true;
            }
            matchContext.candidates.put(nextAlias, matches);
            executionPlan.preFetchedAliases.put(nextAlias, estimatedRootEntries.get(nextAlias));
        }
        EdgeTraversal firstEdge = executionPlan.sortedEdges.size() == 0 ? null : executionPlan.sortedEdges.get(0);
        String smallestAlias = null;
        smallestAlias = firstEdge != null ? (firstEdge.out ? firstEdge.edge.out.alias : firstEdge.edge.in.alias) : pattern.aliasToNode.values().iterator().next().alias;
        executionPlan.rootAlias = smallestAlias;
        Iterable<Object> allCandidates = matchContext.candidates.get(smallestAlias);
        if (allCandidates == null) {
            OSelectStatement select = this.buildSelectStatement(aliasClasses.get(smallestAlias), aliasFilters.get(smallestAlias));
            allCandidates = OMatchStatement.getDatabase().query(new OSQLSynchQuery(select.toString()), new Object[0]);
        }
        return this.processContextFromCandidates(pattern, executionPlan, matchContext, aliasClasses, aliasFilters, iCommandContext, request, allCandidates, smallestAlias, 0);
    }

    private boolean processContextFromCandidates(Pattern pattern, MatchExecutionPlan executionPlan, MatchContext matchContext, Map<String, String> aliasClasses, Map<String, OWhereClause> aliasFilters, OCommandContext iCommandContext, OSQLAsynchQuery<ODocument> request, Iterable<OIdentifiable> candidates, String alias, int startFromEdge) {
        for (OIdentifiable id : candidates) {
            MatchContext childContext = matchContext.copy(alias, id);
            childContext.currentEdgeNumber = startFromEdge;
            if (this.processContext(pattern, executionPlan, childContext, aliasClasses, aliasFilters, iCommandContext, request)) continue;
            return false;
        }
        return true;
    }

    private Iterable<OIdentifiable> fetchAliasCandidates(String nextAlias, Map<String, OWhereClause> aliasFilters, OCommandContext iCommandContext, Map<String, String> aliasClasses) {
        Iterator<OIdentifiable> it = this.query(aliasClasses.get(nextAlias), aliasFilters.get(nextAlias), iCommandContext);
        HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
        while (it.hasNext()) {
            result.add(it.next().getIdentity());
        }
        return result;
    }

    private boolean processContext(Pattern pattern, MatchExecutionPlan executionPlan, MatchContext matchContext, Map<String, String> aliasClasses, Map<String, OWhereClause> aliasFilters, OCommandContext iCommandContext, OSQLAsynchQuery<ODocument> request) {
        block22: {
            EdgeTraversal currentEdge;
            block23: {
                PatternNode rootNode;
                iCommandContext.setVariable("$matched", matchContext.matched);
                if (pattern.getNumOfEdges() == matchContext.matchedEdges.size() && this.allNodesCalculated(matchContext, pattern)) {
                    return this.addResult(matchContext, request, iCommandContext);
                }
                if (executionPlan.sortedEdges.size() == matchContext.currentEdgeNumber) {
                    return this.expandCartesianProduct(pattern, matchContext, aliasClasses, aliasFilters, iCommandContext, request);
                }
                currentEdge = executionPlan.sortedEdges.get(matchContext.currentEdgeNumber);
                PatternNode patternNode = rootNode = currentEdge.out ? currentEdge.edge.out : currentEdge.edge.in;
                if (!currentEdge.out) break block23;
                PatternEdge outEdge = currentEdge.edge;
                if (matchContext.matchedEdges.containsKey(outEdge)) break block22;
                OIdentifiable startingPoint = matchContext.matched.get(outEdge.out.alias);
                if (startingPoint == null) {
                    Iterable rightCandidates = matchContext.candidates.get(outEdge.out.alias);
                    return rightCandidates == null || this.processContextFromCandidates(pattern, executionPlan, matchContext, aliasClasses, aliasFilters, iCommandContext, request, rightCandidates, outEdge.out.alias, matchContext.currentEdgeNumber);
                }
                Iterable<OIdentifiable> rightValues = outEdge.executeTraversal(matchContext, iCommandContext, startingPoint, 0);
                if (outEdge.in.isOptionalNode() && (this.isEmptyResult(rightValues) || !this.contains(rightValues, matchContext.matched.get(outEdge.in.alias)))) {
                    MatchContext childContext = matchContext.copy(outEdge.in.alias, null);
                    childContext.matched.put(outEdge.in.alias, null);
                    childContext.currentEdgeNumber = matchContext.currentEdgeNumber + 1;
                    childContext.matchedEdges.put(outEdge, true);
                    if (!this.processContext(pattern, executionPlan, childContext, aliasClasses, aliasFilters, iCommandContext, request)) {
                        return false;
                    }
                }
                if (!(rightValues instanceof Iterable)) {
                    rightValues = Collections.singleton(rightValues);
                }
                String rightClassName = aliasClasses.get(outEdge.in.alias);
                OClass rightClass = OMatchStatement.getDatabase().getMetadata().getSchema().getClass(rightClassName);
                for (OIdentifiable rightValue : rightValues) {
                    Object childContext;
                    if (rightValue == null || rightClass != null && !this.matchesClass(rightValue, rightClass)) continue;
                    Iterable prevMatchedRightValues = matchContext.candidates.get(outEdge.in.alias);
                    if (matchContext.matched.containsKey(outEdge.in.alias)) {
                        if (!matchContext.matched.get(outEdge.in.alias).getIdentity().equals(rightValue.getIdentity())) continue;
                        childContext = matchContext.copy(outEdge.in.alias, rightValue.getIdentity());
                        ((MatchContext)childContext).currentEdgeNumber = matchContext.currentEdgeNumber + 1;
                        ((MatchContext)childContext).matchedEdges.put(outEdge, true);
                        if (!this.processContext(pattern, executionPlan, (MatchContext)childContext, aliasClasses, aliasFilters, iCommandContext, request)) {
                            return false;
                        }
                        break block22;
                    }
                    if (prevMatchedRightValues != null && prevMatchedRightValues.iterator().hasNext()) {
                        for (OIdentifiable id : prevMatchedRightValues) {
                            if (!id.getIdentity().equals(rightValue.getIdentity())) continue;
                            MatchContext childContext2 = matchContext.copy(outEdge.in.alias, id);
                            childContext2.currentEdgeNumber = matchContext.currentEdgeNumber + 1;
                            childContext2.matchedEdges.put(outEdge, true);
                            if (this.processContext(pattern, executionPlan, childContext2, aliasClasses, aliasFilters, iCommandContext, request)) continue;
                            return false;
                        }
                        continue;
                    }
                    childContext = matchContext.copy(outEdge.in.alias, rightValue.getIdentity());
                    ((MatchContext)childContext).currentEdgeNumber = matchContext.currentEdgeNumber + 1;
                    ((MatchContext)childContext).matchedEdges.put(outEdge, true);
                    if (this.processContext(pattern, executionPlan, (MatchContext)childContext, aliasClasses, aliasFilters, iCommandContext, request)) continue;
                    return false;
                }
                break block22;
            }
            PatternEdge inEdge = currentEdge.edge;
            if (!matchContext.matchedEdges.containsKey(inEdge)) {
                if (!inEdge.item.isBidirectional()) {
                    throw new RuntimeException("Invalid pattern to match!");
                }
                if (!matchContext.matchedEdges.containsKey(inEdge)) {
                    Set<Object> leftValues = inEdge.item.method.executeReverse(matchContext.matched.get(inEdge.in.alias), iCommandContext);
                    if (inEdge.out.isOptionalNode() && (this.isEmptyResult(leftValues) || !this.contains(leftValues, matchContext.matched.get(inEdge.out.alias)))) {
                        MatchContext childContext = matchContext.copy(inEdge.out.alias, null);
                        childContext.matched.put(inEdge.out.alias, null);
                        childContext.currentEdgeNumber = matchContext.currentEdgeNumber + 1;
                        childContext.matchedEdges.put(inEdge, true);
                        if (!this.processContext(pattern, executionPlan, childContext, aliasClasses, aliasFilters, iCommandContext, request)) {
                            return false;
                        }
                    }
                    if (!(leftValues instanceof Iterable)) {
                        leftValues = Collections.singleton(leftValues);
                    }
                    String leftClassName = aliasClasses.get(inEdge.out.alias);
                    OClass leftClass = OMatchStatement.getDatabase().getMetadata().getSchema().getClass(leftClassName);
                    for (OIdentifiable leftValue : (Iterable)leftValues) {
                        if (leftValue == null || leftClass != null && !this.matchesClass(leftValue, leftClass)) continue;
                        Iterable prevMatchedRightValues = matchContext.candidates.get(inEdge.out.alias);
                        if (matchContext.matched.containsKey(inEdge.out.alias)) {
                            if (!matchContext.matched.get(inEdge.out.alias).getIdentity().equals(leftValue.getIdentity())) continue;
                            MatchContext childContext = matchContext.copy(inEdge.out.alias, leftValue.getIdentity());
                            childContext.currentEdgeNumber = matchContext.currentEdgeNumber + 1;
                            childContext.matchedEdges.put(inEdge, true);
                            if (!this.processContext(pattern, executionPlan, childContext, aliasClasses, aliasFilters, iCommandContext, request)) {
                                return false;
                            }
                            break;
                        }
                        if (prevMatchedRightValues != null && prevMatchedRightValues.iterator().hasNext()) {
                            for (OIdentifiable id : prevMatchedRightValues) {
                                if (!id.getIdentity().equals(leftValue.getIdentity())) continue;
                                MatchContext childContext = matchContext.copy(inEdge.out.alias, id);
                                childContext.currentEdgeNumber = matchContext.currentEdgeNumber + 1;
                                childContext.matchedEdges.put(inEdge, true);
                                if (this.processContext(pattern, executionPlan, childContext, aliasClasses, aliasFilters, iCommandContext, request)) continue;
                                return false;
                            }
                            continue;
                        }
                        OWhereClause where = aliasFilters.get(inEdge.out.alias);
                        String className = aliasClasses.get(inEdge.out.alias);
                        OClass oClass = OMatchStatement.getDatabase().getMetadata().getSchema().getClass(className);
                        if (oClass != null && !this.matchesClass(leftValue, oClass) || where != null && !where.matchesFilters(leftValue, iCommandContext)) continue;
                        MatchContext childContext = matchContext.copy(inEdge.out.alias, leftValue.getIdentity());
                        childContext.currentEdgeNumber = matchContext.currentEdgeNumber + 1;
                        childContext.matchedEdges.put(inEdge, true);
                        if (this.processContext(pattern, executionPlan, childContext, aliasClasses, aliasFilters, iCommandContext, request)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean matchesClass(OIdentifiable identifiable, OClass oClass) {
        if (identifiable == null) {
            return false;
        }
        Object record = identifiable.getRecord();
        if (record == null) {
            return false;
        }
        if (record instanceof ODocument) {
            OClass schemaClass = ((ODocument)record).getSchemaClass();
            if (schemaClass == null) {
                return false;
            }
            return schemaClass.isSubClassOf(oClass);
        }
        return false;
    }

    private boolean contains(Object rightValues, OIdentifiable oIdentifiable) {
        if (oIdentifiable == null) {
            return true;
        }
        if (rightValues == null) {
            return false;
        }
        if (rightValues instanceof OIdentifiable) {
            return ((OIdentifiable)rightValues).getIdentity().equals(oIdentifiable.getIdentity());
        }
        Iterator iterator = null;
        if (rightValues instanceof Iterable) {
            iterator = ((Iterable)rightValues).iterator();
        }
        if (rightValues instanceof Iterator) {
            iterator = (Iterator)rightValues;
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (!(next instanceof OIdentifiable) || !((OIdentifiable)next).getIdentity().equals(oIdentifiable.getIdentity())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isEmptyResult(Object rightValues) {
        if (rightValues == null) {
            return true;
        }
        if (rightValues instanceof Iterable) {
            Iterator iterator = ((Iterable)rightValues).iterator();
            if (!iterator.hasNext()) {
                return true;
            }
            while (iterator.hasNext()) {
                Object nextElement = iterator.next();
                if (nextElement == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean expandCartesianProduct(Pattern pattern, MatchContext matchContext, Map<String, String> aliasClasses, Map<String, OWhereClause> aliasFilters, OCommandContext iCommandContext, OSQLAsynchQuery<ODocument> request) {
        for (String alias : pattern.aliasToNode.keySet()) {
            if (matchContext.matched.containsKey(alias)) continue;
            String target = aliasClasses.get(alias);
            if (target == null) {
                throw new OCommandExecutionException("Cannot execute MATCH statement on alias " + alias + ": class not defined");
            }
            Iterable<OIdentifiable> values = this.fetchAliasCandidates(alias, aliasFilters, iCommandContext, aliasClasses);
            for (OIdentifiable id : values) {
                boolean added;
                MatchContext childContext = matchContext.copy(alias, id);
                if (!(this.allNodesCalculated(childContext, pattern) ? !(added = this.addResult(childContext, request, iCommandContext)) : !(added = this.expandCartesianProduct(pattern, childContext, aliasClasses, aliasFilters, iCommandContext, request)))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean allNodesCalculated(MatchContext matchContext, Pattern pattern) {
        for (String alias : pattern.aliasToNode.keySet()) {
            if (matchContext.matched.containsKey(alias)) continue;
            return false;
        }
        return true;
    }

    private boolean addResult(MatchContext matchContext, OSQLAsynchQuery<ODocument> request, OCommandContext ctx) {
        ODocument doc = null;
        if (this.returnsElements()) {
            for (Map.Entry<String, OIdentifiable> entry : matchContext.matched.entrySet()) {
                if (!this.isExplicitAlias(entry.getKey()) || entry.getValue() == null) continue;
                Object record = entry.getValue().getRecord();
                if (request.getResultListener() == null || record == null || this.addSingleResult(request, (OBasicCommandContext)ctx, (ORecord)record)) continue;
                return false;
            }
        } else if (this.returnsPathElements()) {
            for (Map.Entry<String, OIdentifiable> entry : matchContext.matched.entrySet()) {
                if (entry.getValue() == null) continue;
                Object record = entry.getValue().getRecord();
                if (request.getResultListener() == null || record == null || this.addSingleResult(request, (OBasicCommandContext)ctx, (ORecord)record)) continue;
                return false;
            }
        } else if (this.returnsPatterns()) {
            doc = (ODocument)OMatchStatement.getDatabase().newInstance();
            doc.setTrackingChanges(false);
            for (Map.Entry<String, OIdentifiable> entry : matchContext.matched.entrySet()) {
                if (!this.isExplicitAlias(entry.getKey())) continue;
                doc.field(entry.getKey(), entry.getValue());
            }
        } else if (this.returnsPaths()) {
            doc = (ODocument)OMatchStatement.getDatabase().newInstance();
            doc.setTrackingChanges(false);
            for (Map.Entry<String, OIdentifiable> entry : matchContext.matched.entrySet()) {
                doc.field(entry.getKey(), entry.getValue());
            }
        } else if (this.returnsJson()) {
            doc = this.jsonToDoc(matchContext, ctx);
        } else {
            doc = (ODocument)OMatchStatement.getDatabase().newInstance();
            doc.setTrackingChanges(false);
            int i = 0;
            ODocument mapDoc = new ODocument();
            mapDoc.setTrackingChanges(false);
            mapDoc.fromMap(matchContext.matched);
            ctx.setVariable("$current", mapDoc);
            for (OExpression item : this.returnItems) {
                OIdentifier returnAliasIdentifier = this.returnAliases.get(i);
                OIdentifier returnAlias = returnAliasIdentifier == null ? item.getDefaultAlias() : returnAliasIdentifier;
                doc.field(returnAlias.getStringValue(), item.execute(mapDoc, ctx));
                ++i;
            }
            doc.setTrackingChanges(true);
        }
        return request.getResultListener() == null || doc == null || this.addSingleResult(request, (OBasicCommandContext)ctx, doc);
    }

    private boolean addSingleResult(OSQLAsynchQuery<ODocument> request, OBasicCommandContext ctx, ORecord record) {
        if (((OBasicCommandContext)this.context).addToUniqueResult(record)) {
            request.getResultListener().result(record);
            long currentCount = ctx.getResultsProcessed().incrementAndGet();
            long limitValue = this.limitFromProtocol;
            if (this.limit != null) {
                limitValue = this.limit.num.getValue().longValue();
            }
            if (limitValue > -1L && limitValue <= currentCount) {
                return false;
            }
        }
        return true;
    }

    private boolean returnsPathElements() {
        for (OExpression item : this.returnItems) {
            if (!item.toString().equalsIgnoreCase("$pathElements")) continue;
            return true;
        }
        return false;
    }

    private boolean returnsElements() {
        for (OExpression item : this.returnItems) {
            if (!item.toString().equalsIgnoreCase("$elements")) continue;
            return true;
        }
        return false;
    }

    private boolean returnsPatterns() {
        for (OExpression item : this.returnItems) {
            if (item.toString().equalsIgnoreCase("$patterns")) {
                return true;
            }
            if (!item.toString().equalsIgnoreCase("$matches")) continue;
            return true;
        }
        return false;
    }

    private boolean returnsPaths() {
        for (OExpression item : this.returnItems) {
            if (!item.toString().equalsIgnoreCase("$paths")) continue;
            return true;
        }
        return false;
    }

    private boolean returnsJson() {
        return this.returnItems.size() == 1 && this.returnItems.get((int)0).value instanceof OJson && this.returnAliases.get(0) == null;
    }

    private ODocument jsonToDoc(MatchContext matchContext, OCommandContext ctx) {
        if (this.returnItems.size() == 1 && this.returnItems.get((int)0).value instanceof OJson && this.returnAliases.get(0) == null) {
            ODocument result = new ODocument();
            result.setTrackingChanges(false);
            result.fromMap(((OJson)this.returnItems.get((int)0).value).toMap(matchContext.toDoc(), ctx));
            return result;
        }
        throw new IllegalStateException("Match RETURN statement is not a plain JSON");
    }

    private boolean isExplicitAlias(String key) {
        return !key.startsWith(this.DEFAULT_ALIAS_PREFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<OIdentifiable> query(String className, OWhereClause oWhereClause, OCommandContext ctx) {
        String text;
        ODatabaseDocumentInternal database = OMatchStatement.getDatabase();
        OClass schemaClass = database.getMetadata().getSchema().getClass(className);
        database.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_READ, (Object)schemaClass.getName().toLowerCase());
        Iterable<ORecord> baseIterable = this.fetchFromIndex(schemaClass, oWhereClause);
        if (oWhereClause == null) {
            text = "(select from " + className + ")";
        } else {
            StringBuilder builder = new StringBuilder();
            oWhereClause.toString(ctx.getInputParameters(), builder);
            OWhereClause oWhereClause2 = oWhereClause;
            synchronized (oWhereClause2) {
                this.replaceIdentifier(oWhereClause, "$currentMatch", "@this");
                text = "(select from " + className + " where " + builder.toString().replaceAll("\\$currentMatch", "@this") + ")";
                this.replaceIdentifier(oWhereClause, "@this", "$currentMatch");
            }
        }
        OSQLTarget target = new OSQLTarget(text, ctx);
        Iterable<? extends OIdentifiable> targetResult = target.getTargetRecords();
        if (targetResult == null) {
            return null;
        }
        return targetResult.iterator();
    }

    private void replaceIdentifier(SimpleNode node, String from, String to) {
        if (node instanceof OIdentifier) {
            if (from.equals(node.getValue())) {
                ((OIdentifier)node).setValue(to);
            }
        } else {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                this.replaceIdentifier((SimpleNode)node.jjtGetChild(i), from, to);
            }
        }
    }

    private OSelectStatement buildSelectStatement(String className, OWhereClause oWhereClause) {
        OSelectStatement stm = new OSelectStatement(-1);
        stm.whereClause = oWhereClause;
        stm.target = new OFromClause(-1);
        stm.target.item = new OFromItem(-1);
        stm.target.item.identifier = new OBaseIdentifier(-1);
        stm.target.item.identifier.suffix = new OSuffixIdentifier(-1);
        stm.target.item.identifier.suffix.identifier = new OIdentifier(-1);
        stm.target.item.identifier.suffix.identifier.value = className;
        return stm;
    }

    private Iterable<ORecord> fetchFromIndex(OClass schemaClass, OWhereClause oWhereClause) {
        return null;
    }

    private String getNextAlias(Map<String, Long> estimatedRootEntries, MatchContext matchContext) {
        Map.Entry<String, Long> lowerValue = null;
        for (Map.Entry<String, Long> entry : estimatedRootEntries.entrySet()) {
            if (matchContext.matched.containsKey(entry.getKey())) continue;
            if (lowerValue == null) {
                lowerValue = entry;
                continue;
            }
            if (lowerValue.getValue() <= entry.getValue()) continue;
            lowerValue = entry;
        }
        if (lowerValue == null) {
            throw new OCommandExecutionException("Cannot calculate this pattern (maybe a circular dependency on $matched conditions)");
        }
        return (String)lowerValue.getKey();
    }

    private Map<String, Long> estimateRootEntries(Map<String, String> aliasClasses, Map<String, OWhereClause> aliasFilters, OCommandContext ctx) {
        LinkedHashSet<String> allAliases = new LinkedHashSet<String>();
        allAliases.addAll(aliasClasses.keySet());
        allAliases.addAll(aliasFilters.keySet());
        OSchema schema = OMatchStatement.getDatabase().getMetadata().getSchema();
        LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        for (String alias : allAliases) {
            long upperBound;
            String className = aliasClasses.get(alias);
            if (className == null) continue;
            if (!schema.existsClass(className)) {
                throw new OCommandExecutionException("class not defined: " + className);
            }
            OClass oClass = schema.getClass(className);
            OWhereClause filter = aliasFilters.get(alias);
            if (filter != null) {
                List<String> aliasesOnPattern = filter.baseExpression.getMatchPatternInvolvedAliases();
                if (aliasesOnPattern != null && aliasesOnPattern.size() > 0) continue;
                upperBound = filter.estimate(oClass, this.threshold, ctx);
            } else {
                upperBound = oClass.count();
            }
            result.put(alias, upperBound);
        }
        return result;
    }

    private void addAliases(OMatchExpression expr, Map<String, OWhereClause> aliasFilters, Map<String, String> aliasClasses, OCommandContext context) {
        this.addAliases(expr.origin, aliasFilters, aliasClasses, context);
        for (OMatchPathItem item : expr.items) {
            if (item.filter == null) continue;
            this.addAliases(item.filter, aliasFilters, aliasClasses, context);
        }
    }

    private void addAliases(OMatchFilter matchFilter, Map<String, OWhereClause> aliasFilters, Map<String, String> aliasClasses, OCommandContext context) {
        String alias = matchFilter.getAlias();
        OWhereClause filter = matchFilter.getFilter();
        if (alias != null) {
            String clazz;
            if (filter != null && filter.baseExpression != null) {
                OWhereClause previousFilter = aliasFilters.get(alias);
                if (previousFilter == null) {
                    previousFilter = new OWhereClause(-1);
                    previousFilter.baseExpression = new OAndBlock(-1);
                    aliasFilters.put(alias, previousFilter);
                }
                OAndBlock filterBlock = (OAndBlock)previousFilter.baseExpression;
                if (filter != null && filter.baseExpression != null) {
                    filterBlock.subBlocks.add(filter.baseExpression);
                }
            }
            if ((clazz = matchFilter.getClassName(context)) != null) {
                String previousClass = aliasClasses.get(alias);
                if (previousClass == null) {
                    aliasClasses.put(alias, clazz);
                } else {
                    String lower = this.getLowerSubclass(clazz, previousClass);
                    if (lower == null) {
                        throw new OCommandExecutionException("classes defined for alias " + alias + " (" + clazz + ", " + previousClass + ") are not in the same hierarchy");
                    }
                    aliasClasses.put(alias, lower);
                }
            }
        }
    }

    private String getLowerSubclass(String className1, String className2) {
        OSchema schema = OMatchStatement.getDatabase().getMetadata().getSchema();
        OClass class1 = schema.getClass(className1);
        OClass class2 = schema.getClass(className2);
        if (class1 == null) {
            throw new OCommandExecutionException("Class " + className1 + " not found in the schema");
        }
        if (class2 == null) {
            throw new OCommandExecutionException("Class " + className2 + " not found in the schema");
        }
        if (class1.isSubClassOf(class2)) {
            return class1.getName();
        }
        if (class2.isSubClassOf(class1)) {
            return class2.getName();
        }
        return null;
    }

    @Override
    public <RET extends OCommandExecutor> RET setProgressListener(OProgressListener progressListener) {
        this.progressListener = progressListener;
        return (RET)this;
    }

    @Override
    public <RET extends OCommandExecutor> RET setLimit(int iLimit) {
        this.limitFromProtocol = iLimit;
        return (RET)this;
    }

    @Override
    public String getFetchPlan() {
        return null;
    }

    @Override
    public Map<Object, Object> getParameters() {
        return null;
    }

    @Override
    public OCommandContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(OCommandContext context) {
        this.context = context;
    }

    @Override
    public boolean isIdempotent() {
        return true;
    }

    @Override
    public Set<String> getInvolvedClusters() {
        return Collections.EMPTY_SET;
    }

    @Override
    public int getSecurityOperationType() {
        return ORole.PERMISSION_READ;
    }

    @Override
    public boolean involveSchema() {
        return false;
    }

    @Override
    public String getSyntax() {
        return "MATCH <match-statement> [, <match-statement] RETURN <alias>[, <alias>]";
    }

    @Override
    public boolean isLocalExecution() {
        return true;
    }

    @Override
    public boolean isCacheable() {
        return false;
    }

    @Override
    public long getDistributedTimeout() {
        return -1L;
    }

    @Override
    public Object mergeResults(Map<String, Object> results) throws Exception {
        return results;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append(KEYWORD_MATCH);
        builder.append(" ");
        boolean first = true;
        for (OMatchExpression expr : this.matchExpressions) {
            if (!first) {
                builder.append(", ");
            }
            expr.toString(params, builder);
            first = false;
        }
        builder.append(" RETURN ");
        first = true;
        int i = 0;
        for (OExpression expr : this.returnItems) {
            if (!first) {
                builder.append(", ");
            }
            expr.toString(params, builder);
            if (this.returnAliases != null && i < this.returnAliases.size() && this.returnAliases.get(i) != null) {
                builder.append(" AS ");
                this.returnAliases.get(i).toString(params, builder);
            }
            ++i;
            first = false;
        }
        if (this.limit != null) {
            this.limit.toString(params, builder);
        }
    }

    @Override
    public Iterator<OIdentifiable> iterator(Map<Object, Object> iArgs) {
        if (this.context == null) {
            this.context = new OBasicCommandContext();
        }
        Object result = this.execute(iArgs);
        return ((Iterable)result).iterator();
    }

    public static class MatchExecutionPlan {
        public List<EdgeTraversal> sortedEdges;
        public Map<String, Long> preFetchedAliases = new HashMap<String, Long>();
        public String rootAlias;
    }

    public static class EdgeTraversal {
        boolean out = true;
        PatternEdge edge;

        public EdgeTraversal(PatternEdge edge, boolean out) {
            this.edge = edge;
            this.out = out;
        }
    }

    class MatchContext {
        int currentEdgeNumber = 0;
        Map<String, Iterable> candidates = new LinkedHashMap<String, Iterable>();
        Map<String, OIdentifiable> matched = new LinkedHashMap<String, OIdentifiable>();
        Map<PatternEdge, Boolean> matchedEdges = new IdentityHashMap<PatternEdge, Boolean>();

        MatchContext() {
        }

        public MatchContext copy(String alias, OIdentifiable value) {
            MatchContext result = new MatchContext();
            result.candidates.putAll(this.candidates);
            result.candidates.remove(alias);
            result.matched.putAll(this.matched);
            result.matched.put(alias, value);
            result.matchedEdges.putAll(this.matchedEdges);
            result.currentEdgeNumber = this.currentEdgeNumber;
            return result;
        }

        public ODocument toDoc() {
            ODocument doc = new ODocument();
            doc.fromMap(this.matched);
            return doc;
        }
    }
}

