/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.ParseException;
import java.io.ByteArrayInputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;

public class OStatementCache {
    Map<String, OStatement> map;
    int mapSize;

    public OStatementCache(int size) {
        this.mapSize = size;
        this.map = new LinkedHashMap<String, OStatement>(size){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, OStatement> eldest) {
                return super.size() > OStatementCache.this.mapSize;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String statement) {
        Map<String, OStatement> map = this.map;
        synchronized (map) {
            return this.map.containsKey(statement);
        }
    }

    public static OStatement get(String statement, ODatabaseDocumentInternal db) {
        if (db == null) {
            return OStatementCache.parse(statement);
        }
        OStatementCache resource = db.getStorage().getResource(OStatementCache.class.getSimpleName(), new Callable<OStatementCache>(){

            @Override
            public OStatementCache call() throws Exception {
                return new OStatementCache(OGlobalConfiguration.STATEMENT_CACHE_SIZE.getValueAsInteger());
            }
        });
        return resource.get(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OStatement get(String statement) {
        OStatement result;
        Map<String, OStatement> map = this.map;
        synchronized (map) {
            result = this.map.remove(statement);
            if (result != null) {
                this.map.put(statement, result);
            }
        }
        if (result == null) {
            result = OStatementCache.parse(statement);
            map = this.map;
            synchronized (map) {
                this.map.put(statement, result);
            }
        }
        return result;
    }

    protected static OStatement parse(String statement) throws OCommandSQLParsingException {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(statement.getBytes());
            OrientSql osql = new OrientSql(is);
            OStatement result = osql.parse();
            return result;
        }
        catch (ParseException e) {
            OStatementCache.throwParsingException(e, statement);
            return null;
        }
    }

    protected static void throwParsingException(ParseException e, String statement) {
        throw new OCommandSQLParsingException(e, statement);
    }
}

