/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.exception;

import com.orientechnologies.common.exception.OErrorCode;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;

public abstract class OCoreException
extends OException {
    private OErrorCode errorCode;
    private final String dbName;
    private final String componentName;

    public OCoreException(OCoreException exception) {
        super(exception);
        this.dbName = exception.dbName;
        this.componentName = exception.componentName;
    }

    public OCoreException(String message) {
        this(message, null, null);
    }

    public OCoreException(String message, String componentName) {
        this(message, componentName, null);
    }

    public OCoreException(String message, String componentName, OErrorCode errorCode) {
        super(message);
        this.errorCode = errorCode;
        this.componentName = componentName != null ? componentName : null;
        ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        this.dbName = database != null ? database.getName() : null;
    }

    public OErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public final String getMessage() {
        StringBuilder builder = new StringBuilder(super.getMessage());
        if (this.dbName != null) {
            builder.append("\r\n\t").append("DB name=\"").append(this.dbName).append("\"");
        }
        if (this.componentName != null) {
            builder.append("\r\n\t").append("Component Name=\"").append(this.componentName).append("\"");
        }
        if (this.errorCode != null) {
            builder.append("\r\n\t").append("Error Code=\"").append(this.errorCode.getCode()).append("\"");
        }
        return builder.toString();
    }
}

