/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.OOrientShutdownListener;
import com.orientechnologies.orient.core.OOrientStartupListener;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.OHookReplacedRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeTimeLine;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OFastConcurrentModificationException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexRecorder;
import com.orientechnologies.orient.core.index.OIndexUnique;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;

public class OClassIndexManager
extends ODocumentHookAbstract
implements ORecordHook.Scoped,
OOrientStartupListener,
OOrientShutdownListener {
    private static final ORecordHook.SCOPE[] SCOPES = new ORecordHook.SCOPE[]{ORecordHook.SCOPE.CREATE, ORecordHook.SCOPE.UPDATE, ORecordHook.SCOPE.DELETE};
    private Deque<List<Lock[]>> lockedKeys = new ArrayDeque<List<Lock[]>>();

    public OClassIndexManager(ODatabaseDocument database) {
        super(database);
        Orient.instance().registerWeakOrientStartupListener(this);
        Orient.instance().registerWeakOrientShutdownListener(this);
    }

    @Override
    public ORecordHook.SCOPE[] getScopes() {
        return SCOPES;
    }

    @Override
    public void onShutdown() {
        this.lockedKeys = null;
    }

    @Override
    public void onStartup() {
        if (this.lockedKeys == null) {
            this.lockedKeys = new ArrayDeque<List<Lock[]>>();
        }
    }

    private void processCompositeIndexUpdate(OIndex<?> index, Set<String> dirtyFields, ODocument iRecord) {
        OCompositeIndexDefinition indexDefinition = (OCompositeIndexDefinition)index.getDefinition();
        List<String> indexFields = indexDefinition.getFields();
        String multiValueField = indexDefinition.getMultiValueField();
        for (String indexField : indexFields) {
            if (!dirtyFields.contains(indexField)) continue;
            ArrayList<Object> origValues = new ArrayList<Object>(indexFields.size());
            for (String field : indexFields) {
                if (field.equals(multiValueField)) continue;
                if (dirtyFields.contains(field)) {
                    origValues.add(iRecord.getOriginalValue(field));
                    continue;
                }
                origValues.add(iRecord.field(field));
            }
            if (multiValueField == null) {
                Object origValue = indexDefinition.createValue(origValues);
                Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
                if (!indexDefinition.isNullValuesIgnored() || origValue != null) {
                    this.removeFromIndex(index, origValue, iRecord);
                }
                if (!indexDefinition.isNullValuesIgnored() || newValue != null) {
                    this.putInIndex(index, newValue, iRecord.getIdentity());
                }
            } else {
                OMultiValueChangeTimeLine<Object, Object> multiValueChangeTimeLine = iRecord.getCollectionTimeLine(multiValueField);
                if (multiValueChangeTimeLine == null) {
                    if (dirtyFields.contains(multiValueField)) {
                        origValues.add(indexDefinition.getMultiValueDefinitionIndex(), iRecord.getOriginalValue(multiValueField));
                    } else {
                        origValues.add(indexDefinition.getMultiValueDefinitionIndex(), iRecord.field(multiValueField));
                    }
                    Object origValue = indexDefinition.createValue(origValues);
                    Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
                    this.processIndexUpdateFieldAssignment(index, iRecord, origValue, newValue);
                } else if (dirtyFields.size() == 1 && indexDefinition.isNullValuesIgnored()) {
                    HashMap<OCompositeKey, Integer> keysToAdd = new HashMap<OCompositeKey, Integer>();
                    HashMap<OCompositeKey, Integer> keysToRemove = new HashMap<OCompositeKey, Integer>();
                    for (OMultiValueChangeEvent<Object, Object> changeEvent : multiValueChangeTimeLine.getMultiValueChangeEvents()) {
                        indexDefinition.processChangeEvent(changeEvent, keysToAdd, keysToRemove, origValues.toArray());
                    }
                    for (OMultiValueChangeEvent<Object, Object> keyToRemove : keysToRemove.keySet()) {
                        this.removeFromIndex(index, keyToRemove, iRecord);
                    }
                    for (OMultiValueChangeEvent<Object, Object> keyToAdd : keysToAdd.keySet()) {
                        this.putInIndex(index, keyToAdd, iRecord.getIdentity());
                    }
                } else {
                    OTrackedMultiValue fieldValue = (OTrackedMultiValue)iRecord.field(multiValueField);
                    Object restoredMultiValue = fieldValue.returnOriginalState(multiValueChangeTimeLine.getMultiValueChangeEvents());
                    origValues.add(indexDefinition.getMultiValueDefinitionIndex(), restoredMultiValue);
                    Object origValue = indexDefinition.createValue(origValues);
                    Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
                    this.processIndexUpdateFieldAssignment(index, iRecord, origValue, newValue);
                }
            }
            return;
        }
    }

    private void processSingleIndexUpdate(OIndex<?> index, Set<String> dirtyFields, ODocument iRecord) {
        OIndexDefinition indexDefinition = index.getDefinition();
        List<String> indexFields = indexDefinition.getFields();
        if (indexFields.isEmpty()) {
            return;
        }
        String indexField = indexFields.get(0);
        if (!dirtyFields.contains(indexField)) {
            return;
        }
        OMultiValueChangeTimeLine<Object, Object> multiValueChangeTimeLine = iRecord.getCollectionTimeLine(indexField);
        if (multiValueChangeTimeLine != null) {
            OIndexDefinitionMultiValue indexDefinitionMultiValue = (OIndexDefinitionMultiValue)indexDefinition;
            HashMap<Object, Integer> keysToAdd = new HashMap<Object, Integer>();
            HashMap<Object, Integer> keysToRemove = new HashMap<Object, Integer>();
            for (OMultiValueChangeEvent<Object, Object> changeEvent : multiValueChangeTimeLine.getMultiValueChangeEvents()) {
                indexDefinitionMultiValue.processChangeEvent(changeEvent, keysToAdd, keysToRemove);
            }
            for (OMultiValueChangeEvent<Object, Object> keyToRemove : keysToRemove.keySet()) {
                this.removeFromIndex(index, keyToRemove, iRecord);
            }
            for (OMultiValueChangeEvent<Object, Object> keyToAdd : keysToAdd.keySet()) {
                this.putInIndex(index, keyToAdd, iRecord.getIdentity());
            }
        } else {
            Object origValue = indexDefinition.createValue(iRecord.getOriginalValue(indexField));
            Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
            this.processIndexUpdateFieldAssignment(index, iRecord, origValue, newValue);
        }
    }

    private void processIndexUpdateFieldAssignment(OIndex<?> index, ODocument iRecord, Object origValue, Object newValue) {
        OIndexDefinition indexDefinition = index.getDefinition();
        if (origValue instanceof Collection && newValue instanceof Collection) {
            HashSet valuesToRemove = new HashSet((Collection)origValue);
            HashSet valuesToAdd = new HashSet((Collection)newValue);
            valuesToRemove.removeAll((Collection)newValue);
            valuesToAdd.removeAll((Collection)origValue);
            for (Object valueToRemove : valuesToRemove) {
                if (indexDefinition.isNullValuesIgnored() && valueToRemove == null) continue;
                this.removeFromIndex(index, valueToRemove, iRecord);
            }
            for (Object valueToAdd : valuesToAdd) {
                if (indexDefinition.isNullValuesIgnored() && valueToAdd == null) continue;
                this.putInIndex(index, valueToAdd, iRecord);
            }
        } else {
            this.deleteIndexKey(index, iRecord, origValue);
            if (newValue instanceof Collection) {
                for (Object newValueItem : (Collection)newValue) {
                    this.putInIndex(index, newValueItem, iRecord.getIdentity());
                }
            } else if (!indexDefinition.isNullValuesIgnored() || newValue != null) {
                this.putInIndex(index, newValue, iRecord.getIdentity());
            }
        }
    }

    private boolean processCompositeIndexDelete(OIndex<?> index, Set<String> dirtyFields, ODocument iRecord) {
        OCompositeIndexDefinition indexDefinition = (OCompositeIndexDefinition)index.getDefinition();
        String multiValueField = indexDefinition.getMultiValueField();
        List<String> indexFields = indexDefinition.getFields();
        for (String indexField : indexFields) {
            if (!dirtyFields.contains(indexField)) continue;
            ArrayList<Object> origValues = new ArrayList<Object>(indexFields.size());
            for (String field : indexFields) {
                if (field.equals(multiValueField)) continue;
                if (dirtyFields.contains(field)) {
                    origValues.add(iRecord.getOriginalValue(field));
                    continue;
                }
                origValues.add(iRecord.field(field));
            }
            if (multiValueField != null) {
                OMultiValueChangeTimeLine<Object, Object> multiValueChangeTimeLine = iRecord.getCollectionTimeLine(multiValueField);
                if (multiValueChangeTimeLine != null) {
                    OTrackedMultiValue fieldValue = (OTrackedMultiValue)iRecord.field(multiValueField);
                    Object restoredMultiValue = fieldValue.returnOriginalState(multiValueChangeTimeLine.getMultiValueChangeEvents());
                    origValues.add(indexDefinition.getMultiValueDefinitionIndex(), restoredMultiValue);
                } else if (dirtyFields.contains(multiValueField)) {
                    origValues.add(indexDefinition.getMultiValueDefinitionIndex(), iRecord.getOriginalValue(multiValueField));
                } else {
                    origValues.add(indexDefinition.getMultiValueDefinitionIndex(), iRecord.field(multiValueField));
                }
            }
            Object origValue = indexDefinition.createValue(origValues);
            this.deleteIndexKey(index, iRecord, origValue);
            return true;
        }
        return false;
    }

    private void deleteIndexKey(OIndex<?> index, ODocument iRecord, Object origValue) {
        OIndexDefinition indexDefinition = index.getDefinition();
        if (origValue instanceof Collection) {
            for (Object valueItem : (Collection)origValue) {
                if (indexDefinition.isNullValuesIgnored() && valueItem == null) continue;
                this.removeFromIndex(index, valueItem, iRecord);
            }
        } else if (!indexDefinition.isNullValuesIgnored() || origValue != null) {
            this.removeFromIndex(index, origValue, iRecord);
        }
    }

    private boolean processSingleIndexDelete(OIndex<?> index, Set<String> dirtyFields, ODocument iRecord) {
        OIndexDefinition indexDefinition = index.getDefinition();
        List<String> indexFields = indexDefinition.getFields();
        if (indexFields.isEmpty()) {
            return false;
        }
        String indexField = indexFields.iterator().next();
        if (dirtyFields.contains(indexField)) {
            Object origValue;
            OMultiValueChangeTimeLine<Object, Object> multiValueChangeTimeLine = iRecord.getCollectionTimeLine(indexField);
            if (multiValueChangeTimeLine != null) {
                OTrackedMultiValue fieldValue = (OTrackedMultiValue)iRecord.field(indexField);
                Object restoredMultiValue = fieldValue.returnOriginalState(multiValueChangeTimeLine.getMultiValueChangeEvents());
                origValue = indexDefinition.createValue(restoredMultiValue);
            } else {
                origValue = indexDefinition.createValue(iRecord.getOriginalValue(indexField));
            }
            this.deleteIndexKey(index, iRecord, origValue);
            return true;
        }
        return false;
    }

    private ODocument checkIndexedPropertiesOnCreation(ODocument record, Collection<OIndex<?>> indexes) {
        ODocument replaced = null;
        TreeMap indexKeysMap = new TreeMap();
        for (OIndex<?> oIndex : indexes) {
            if (!(oIndex.getInternal() instanceof OIndexUnique)) continue;
            OIndexRecorder oIndexRecorder = new OIndexRecorder((OIndexUnique)oIndex.getInternal());
            this.addIndexEntry(record, record.getIdentity(), oIndexRecorder);
            indexKeysMap.put(oIndex, oIndexRecorder.getAffectedKeys());
        }
        if (OClassIndexManager.noTx(record)) {
            ArrayList<Lock[]> locks = new ArrayList<Lock[]>(indexKeysMap.size());
            for (Map.Entry entry : indexKeysMap.entrySet()) {
                OIndexInternal index = ((OIndex)entry.getKey()).getInternal();
                locks.add(index.lockKeysForUpdate((Collection)entry.getValue()));
            }
            this.lockedKeys.push(locks);
        }
        for (Map.Entry entry : indexKeysMap.entrySet()) {
            OIndex oIndex = (OIndex)entry.getKey();
            for (Object keyItem : (List)entry.getValue()) {
                ODocument r = oIndex.checkEntry(record, keyItem);
                if (r == null) continue;
                if (replaced == null) {
                    replaced = r;
                    continue;
                }
                throw new OIndexException("Cannot merge record from multiple indexes. Use this strategy when you have only one index");
            }
        }
        return replaced;
    }

    private void checkIndexedPropertiesOnUpdate(ODocument record, Collection<OIndex<?>> indexes) {
        TreeMap indexKeysMap = new TreeMap();
        HashSet<String> dirtyFields = new HashSet<String>(Arrays.asList(record.getDirtyFields()));
        if (dirtyFields.isEmpty()) {
            return;
        }
        for (OIndex<?> oIndex : indexes) {
            if (!(oIndex.getInternal() instanceof OIndexUnique)) continue;
            OIndexRecorder oIndexRecorder = new OIndexRecorder(oIndex.getInternal());
            this.processIndexUpdate(record, dirtyFields, oIndexRecorder);
            indexKeysMap.put(oIndex, oIndexRecorder.getAffectedKeys());
        }
        if (OClassIndexManager.noTx(record)) {
            ArrayList<Lock[]> locks = new ArrayList<Lock[]>(indexKeysMap.size());
            for (Map.Entry entry : indexKeysMap.entrySet()) {
                OIndexInternal index = ((OIndex)entry.getKey()).getInternal();
                locks.add(index.lockKeysForUpdate((Collection)entry.getValue()));
            }
            this.lockedKeys.push(locks);
        }
        for (Map.Entry entry : indexKeysMap.entrySet()) {
            OIndex oIndex = (OIndex)entry.getKey();
            for (Object keyItem : (List)entry.getValue()) {
                oIndex.checkEntry(record, keyItem);
            }
        }
    }

    private static ODocument checkForLoading(ODocument iRecord) {
        if (iRecord.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            try {
                return (ODocument)iRecord.load();
            }
            catch (ORecordNotFoundException e) {
                throw OException.wrapException(new OIndexException("Error during loading of record with id " + iRecord.getIdentity()), e);
            }
        }
        return iRecord;
    }

    @Override
    public ORecordHook.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return ORecordHook.DISTRIBUTED_EXECUTION_MODE.BOTH;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeCreate(ODocument document) {
        ODocument replaced = this.checkIndexes(document, ORecordHook.TYPE.BEFORE_CREATE);
        if (replaced != null) {
            OHookReplacedRecordThreadLocal.INSTANCE.set(replaced);
            return ORecordHook.RESULT.RECORD_REPLACED;
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public void onRecordAfterCreate(ODocument document) {
        OImmutableClass cls = ODocumentInternal.getImmutableSchemaClass(document = OClassIndexManager.checkForLoading(document));
        if (cls != null) {
            Set<OIndex<?>> indexes = cls.getIndexes();
            this.addIndexesEntries(document, indexes);
        }
    }

    @Override
    public void onRecordCreateFailed(ODocument iDocument) {
    }

    @Override
    public void onRecordCreateReplicated(ODocument iDocument) {
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeUpdate(ODocument iDocument) {
        this.checkIndexes(iDocument, ORecordHook.TYPE.BEFORE_UPDATE);
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public void onRecordAfterUpdate(ODocument iDocument) {
        HashSet<String> dirtyFields;
        OImmutableClass cls = ODocumentInternal.getImmutableSchemaClass(iDocument = OClassIndexManager.checkForLoading(iDocument));
        if (cls == null) {
            return;
        }
        Set<OIndex<?>> indexes = cls.getIndexes();
        if (!indexes.isEmpty() && !(dirtyFields = new HashSet<String>(Arrays.asList(iDocument.getDirtyFields()))).isEmpty()) {
            for (OIndex oIndex : indexes) {
                try {
                    this.processIndexUpdate(iDocument, dirtyFields, oIndex);
                }
                catch (ORecordDuplicatedException ex) {
                    iDocument.undo();
                    iDocument.setDirty();
                    this.database.save(iDocument);
                    throw ex;
                }
            }
        }
    }

    private void processIndexUpdate(ODocument iDocument, Set<String> dirtyFields, OIndex<?> index) {
        if (index.getDefinition() instanceof OCompositeIndexDefinition) {
            this.processCompositeIndexUpdate(index, dirtyFields, iDocument);
        } else {
            this.processSingleIndexUpdate(index, dirtyFields, iDocument);
        }
    }

    @Override
    public void onRecordUpdateFailed(ODocument iDocument) {
    }

    @Override
    public void onRecordUpdateReplicated(ODocument iDocument) {
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeDelete(ODocument iDocument) {
        OImmutableClass class_;
        int version = iDocument.getVersion();
        if (iDocument.fields() == 0 && iDocument.getIdentity().isPersistent()) {
            iDocument.reload();
            if (version > -1 && iDocument.getVersion() != version) {
                if (OFastConcurrentModificationException.enabled()) {
                    throw OFastConcurrentModificationException.instance();
                }
                throw new OConcurrentModificationException(iDocument.getIdentity(), iDocument.getVersion(), version, 2);
            }
        }
        if ((class_ = ODocumentInternal.getImmutableSchemaClass(iDocument)) != null) {
            Set<OIndex<?>> indexes = class_.getIndexes();
            TreeMap<OIndex, List<Object>> indexKeysMap = new TreeMap<OIndex, List<Object>>();
            for (OIndex oIndex : indexes) {
                if (!(oIndex.getInternal() instanceof OIndexUnique)) continue;
                OIndexRecorder indexRecorder = new OIndexRecorder((OIndexUnique)oIndex.getInternal());
                this.addIndexEntry(iDocument, iDocument.getIdentity(), indexRecorder);
                indexKeysMap.put(oIndex, indexRecorder.getAffectedKeys());
            }
            if (OClassIndexManager.noTx(iDocument)) {
                ArrayList<Lock[]> locks = new ArrayList<Lock[]>(indexKeysMap.size());
                for (Map.Entry entry : indexKeysMap.entrySet()) {
                    OIndexInternal index = ((OIndex)entry.getKey()).getInternal();
                    locks.add(index.lockKeysForUpdate((Collection)entry.getValue()));
                }
                this.lockedKeys.push(locks);
            }
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public void onRecordAfterDelete(ODocument iDocument) {
        this.deleteIndexEntries(iDocument);
    }

    @Override
    public void onRecordDeleteFailed(ODocument iDocument) {
    }

    @Override
    public void onRecordDeleteReplicated(ODocument iDocument) {
    }

    private void addIndexesEntries(ODocument document, Collection<OIndex<?>> indexes) {
        ORID rid = document.getIdentity();
        for (OIndex<?> index : indexes) {
            this.addIndexEntry(document, rid, index);
        }
    }

    private void addIndexEntry(ODocument document, OIdentifiable rid, OIndex<?> index) {
        OIndexDefinition indexDefinition = index.getDefinition();
        Object key = indexDefinition.getDocumentValueToIndex(document);
        if (key instanceof Collection) {
            for (Object keyItem : (Collection)key) {
                if (indexDefinition.isNullValuesIgnored() && keyItem == null) continue;
                this.putInIndex(index, keyItem, rid);
            }
        } else if (!indexDefinition.isNullValuesIgnored() || key != null) {
            try {
                this.putInIndex(index, key, rid);
            }
            catch (ORecordDuplicatedException e) {
                if (!this.database.getTransaction().isActive()) {
                    this.database.delete(document);
                }
                throw e;
            }
        }
    }

    private void deleteIndexEntries(ODocument iDocument) {
        OImmutableClass cls = ODocumentInternal.getImmutableSchemaClass(iDocument);
        if (cls == null) {
            return;
        }
        ArrayList indexes = new ArrayList(cls.getIndexes());
        if (!indexes.isEmpty()) {
            HashSet<String> dirtyFields = new HashSet<String>(Arrays.asList(iDocument.getDirtyFields()));
            if (!dirtyFields.isEmpty()) {
                Iterator indexIterator = indexes.iterator();
                while (indexIterator.hasNext()) {
                    OIndex oIndex = (OIndex)indexIterator.next();
                    boolean result = oIndex.getDefinition() instanceof OCompositeIndexDefinition ? this.processCompositeIndexDelete(oIndex, dirtyFields, iDocument) : this.processSingleIndexDelete(oIndex, dirtyFields, iDocument);
                    if (!result) continue;
                    indexIterator.remove();
                }
            }
            for (OIndex oIndex : indexes) {
                Object key = oIndex.getDefinition().getDocumentValueToIndex(iDocument);
                this.deleteIndexKey(oIndex, iDocument, key);
            }
        }
    }

    private ODocument checkIndexes(ODocument document, ORecordHook.TYPE hookType) {
        document = OClassIndexManager.checkForLoading(document);
        ODocument replaced = null;
        OImmutableClass cls = ODocumentInternal.getImmutableSchemaClass(document);
        if (cls != null) {
            Set<OIndex<?>> indexes = cls.getIndexes();
            switch (hookType) {
                case BEFORE_CREATE: {
                    replaced = this.checkIndexedPropertiesOnCreation(document, indexes);
                    break;
                }
                case BEFORE_UPDATE: {
                    this.checkIndexedPropertiesOnUpdate(document, indexes);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid hook type: " + (Object)((Object)hookType));
                }
            }
        }
        return replaced;
    }

    @Override
    public void onRecordFinalizeUpdate(ODocument document) {
        if (OClassIndexManager.noTx(document)) {
            this.unlockKeys();
        }
    }

    @Override
    public void onRecordFinalizeCreation(ODocument document) {
        if (OClassIndexManager.noTx(document)) {
            this.unlockKeys();
        }
    }

    @Override
    public void onRecordFinalizeDeletion(ODocument document) {
        if (OClassIndexManager.noTx(document)) {
            this.unlockKeys();
        }
    }

    private void unlockKeys() {
        if (this.lockedKeys == null) {
            return;
        }
        List<Lock[]> lockList = this.lockedKeys.poll();
        if (lockList == null) {
            return;
        }
        for (Lock[] locks : lockList) {
            for (Lock lock : locks) {
                try {
                    lock.unlock();
                }
                catch (RuntimeException e) {
                    OLogManager.instance().error((Object)this, "Error during unlock of index key", e, new Object[0]);
                }
            }
        }
    }

    protected void putInIndex(OIndex<?> index, Object key, OIdentifiable value) {
        index.put(key, value);
    }

    protected void removeFromIndex(OIndex<?> index, Object key, OIdentifiable value) {
        index.remove(key, value);
    }

    private static boolean noTx(ODocument document) {
        return !document.getDatabase().getTransaction().isActive();
    }
}

