/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache.pages;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.cache.pages.OPageCache;
import java.io.IOException;

public class OTinyPageCache
implements OPageCache {
    private final OReadCache readCache;
    private final OCacheEntry[] pages;
    private final long[] counters;

    public OTinyPageCache(OReadCache readCache, int maximumSize) {
        this.readCache = readCache;
        this.pages = new OCacheEntry[maximumSize];
        this.counters = new long[maximumSize * 2];
    }

    @Override
    public OCacheEntry loadPage(long fileId, long pageIndex, boolean checkPinnedPages, OWriteCache writeCache, int pageCount) throws IOException {
        long victimHits = Long.MAX_VALUE;
        int victimIndex = -1;
        for (int i = 0; i < this.pages.length; ++i) {
            long hits;
            OCacheEntry entry = this.pages[i];
            if (entry == null) {
                victimIndex = i;
                victimHits = 0L;
                continue;
            }
            int countersBase = i * 2;
            assert (this.counters[countersBase + 1] >= 1L);
            if (pageIndex == entry.getPageIndex() && fileId == entry.getFileId()) {
                int n = countersBase;
                this.counters[n] = this.counters[n] + 1L;
                int n2 = countersBase + 1;
                this.counters[n2] = this.counters[n2] + 1L;
                return entry;
            }
            if (victimHits == 0L || this.counters[countersBase] > 0L || (hits = this.counters[countersBase + 1]) >= victimHits) continue;
            victimIndex = i;
            victimHits = hits;
        }
        OCacheEntry entry = this.readCache.load(fileId, pageIndex, checkPinnedPages, writeCache, pageCount);
        if (entry == null) {
            return null;
        }
        if (victimIndex != -1) {
            int countersBase = victimIndex * 2;
            if (victimHits != 0L) {
                OCacheEntry victim = this.pages[victimIndex];
                for (long i = this.counters[countersBase]; i <= 0L; ++i) {
                    this.readCache.release(victim, writeCache);
                }
            }
            this.pages[victimIndex] = entry;
            this.counters[countersBase] = 1L;
            this.counters[countersBase + 1] = 1L;
        }
        return entry;
    }

    @Override
    public void releasePage(OCacheEntry cacheEntry, OWriteCache writeCache) {
        for (int i = 0; i < this.pages.length; ++i) {
            if (this.pages[i] != cacheEntry) continue;
            int n = i * 2;
            this.counters[n] = this.counters[n] - 1L;
            return;
        }
        this.readCache.release(cacheEntry, writeCache);
    }

    @Override
    public void releaseFilePages(long fileId, OWriteCache writeCache) {
        for (int i = 0; i < this.pages.length; ++i) {
            OCacheEntry entry = this.pages[i];
            if (entry == null || fileId != entry.getFileId()) continue;
            assert (this.counters[i * 2] <= 0L);
            this.pages[i] = null;
            for (long j = this.counters[i * 2]; j <= 0L; ++j) {
                this.readCache.release(entry, writeCache);
            }
        }
    }

    @Override
    public OCacheEntry purgePage(long fileId, long pageIndex, OWriteCache writeCache) {
        for (int i = 0; i < this.pages.length; ++i) {
            OCacheEntry entry = this.pages[i];
            if (entry == null || pageIndex != entry.getPageIndex() || fileId != entry.getFileId()) continue;
            assert (this.counters[i * 2] <= 0L);
            this.pages[i] = null;
            for (long j = this.counters[i * 2]; j < 0L; ++j) {
                this.readCache.release(entry, writeCache);
            }
            return entry;
        }
        return null;
    }

    @Override
    public void reset(OWriteCache writeCache) {
        for (int i = 0; i < this.pages.length; ++i) {
            OCacheEntry entry = this.pages[i];
            if (entry == null) continue;
            assert (this.counters[i * 2] <= 0L);
            this.pages[i] = null;
            for (long j = this.counters[i * 2]; j <= 0L; ++j) {
                this.readCache.release(entry, writeCache);
            }
        }
    }
}

