/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record.ridbag.sbtree;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OByteSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.types.OModifiableInteger;
import com.orientechnologies.common.util.OResettable;
import com.orientechnologies.common.util.OSizeable;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OAutoConvertToRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeListener;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBagDelegate;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.sbtree.OTreeInternal;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OBonsaiBucketPointer;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OSBTreeBonsai;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OSBTreeBonsaiLocal;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OLinkSerializer;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordSerializationContext;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORidBagDeleteSerializationOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORidBagUpdateSerializationOperation;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;

public class OSBTreeRidBag
implements ORidBagDelegate {
    private final OSBTreeCollectionManager collectionManager = ODatabaseRecordThreadLocal.INSTANCE.get().getSbTreeCollectionManager();
    private final NavigableMap<OIdentifiable, Change> changes = new ConcurrentSkipListMap<OIdentifiable, Change>();
    private final IdentityHashMap<OIdentifiable, OModifiableInteger> newEntries = new IdentityHashMap();
    private OBonsaiCollectionPointer collectionPointer = null;
    private int size;
    private boolean autoConvertToRecord = true;
    private List<OMultiValueChangeListener<OIdentifiable, OIdentifiable>> changeListeners;
    private transient ORecord owner;
    private boolean updateOwner = true;

    @Override
    public ORecord getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(ORecord owner) {
        if (owner != null && this.owner != null && !this.owner.equals(owner)) {
            throw new IllegalStateException("This data structure is owned by document " + owner + " if you want to use it in other document create new rid bag instance and copy content of current one.");
        }
        if (this.owner != null) {
            for (OIdentifiable entry : this.newEntries.keySet()) {
                ORecordInternal.unTrack(this.owner, entry);
            }
            for (OIdentifiable entry : this.changes.keySet()) {
                ORecordInternal.unTrack(this.owner, entry);
            }
        }
        this.owner = owner;
        if (this.owner != null) {
            for (OIdentifiable entry : this.newEntries.keySet()) {
                ORecordInternal.track(this.owner, entry);
            }
            for (OIdentifiable entry : this.changes.keySet()) {
                ORecordInternal.track(this.owner, entry);
            }
        }
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        return new RIDBagIterator(new IdentityHashMap<OIdentifiable, OModifiableInteger>(this.newEntries), this.changes, this.collectionPointer != null ? new SBTreeMapEntryIterator(1000) : null, this.autoConvertToRecord);
    }

    @Override
    public Iterator<OIdentifiable> rawIterator() {
        return new RIDBagIterator(new IdentityHashMap<OIdentifiable, OModifiableInteger>(this.newEntries), this.changes, this.collectionPointer != null ? new SBTreeMapEntryIterator(1000) : null, false);
    }

    @Override
    public void convertLinks2Records() {
        TreeMap newChanges = new TreeMap();
        for (Map.Entry entry : this.changes.entrySet()) {
            Object key = ((OIdentifiable)entry.getKey()).getRecord();
            if (key != null && this.owner != null) {
                ORecordInternal.unTrack(this.owner, (OIdentifiable)entry.getKey());
                ORecordInternal.track(this.owner, key);
            }
            newChanges.put(key == null ? (OIdentifiable)entry.getKey() : key, entry.getValue());
        }
        this.changes.clear();
        this.changes.putAll(newChanges);
    }

    @Override
    public boolean convertRecords2Links() {
        HashMap newChangedValues = new HashMap();
        for (Map.Entry entry : this.changes.entrySet()) {
            OIdentifiable identifiable = (OIdentifiable)entry.getKey();
            if (identifiable instanceof ORecord) {
                ORID identity = identifiable.getIdentity();
                ORecord record = (ORecord)identifiable;
                identity = record.getIdentity();
                newChangedValues.put(identity, entry.getValue());
                continue;
            }
            newChangedValues.put(((OIdentifiable)entry.getKey()).getIdentity(), entry.getValue());
        }
        for (Map.Entry entry : newChangedValues.entrySet()) {
            if (entry.getKey() instanceof ORecord) {
                ORecord record = (ORecord)entry.getKey();
                newChangedValues.put(record, entry.getValue());
                continue;
            }
            return false;
        }
        this.newEntries.clear();
        this.changes.clear();
        this.changes.putAll(newChangedValues);
        return true;
    }

    public void mergeChanges(OSBTreeRidBag treeRidBag) {
        for (Map.Entry<OIdentifiable, OModifiableInteger> entry : treeRidBag.newEntries.entrySet()) {
            this.mergeDiffEntry(entry.getKey(), entry.getValue().getValue());
        }
        for (Map.Entry<OIdentifiable, OModifiableInteger> entry : treeRidBag.changes.entrySet()) {
            int diff;
            OIdentifiable rec = entry.getKey();
            Change change = (Change)((Object)entry.getValue());
            if (change instanceof DiffChange) {
                diff = ((DiffChange)change).delta;
            } else if (change instanceof AbsoluteChange) {
                diff = ((AbsoluteChange)change).value - this.getAbsoluteValue(rec).value;
            } else {
                throw new IllegalArgumentException("change type is not supported");
            }
            this.mergeDiffEntry(rec, diff);
        }
    }

    @Override
    public boolean isAutoConvertToRecord() {
        return this.autoConvertToRecord;
    }

    @Override
    public void setAutoConvertToRecord(boolean convertToRecord) {
        this.autoConvertToRecord = convertToRecord;
    }

    @Override
    public boolean detach() {
        return this.convertRecords2Links();
    }

    @Override
    public void addAll(Collection<OIdentifiable> values) {
        for (OIdentifiable identifiable : values) {
            this.add(identifiable);
        }
    }

    @Override
    public void add(OIdentifiable identifiable) {
        if (identifiable == null) {
            throw new IllegalArgumentException("Impossible to add a null identifiable in a ridbag");
        }
        if (identifiable.getIdentity().isValid()) {
            Change counter = (Change)this.changes.get(identifiable);
            if (counter == null) {
                this.changes.put(identifiable, new DiffChange(1));
            } else {
                if (counter.isUndefined()) {
                    counter = this.getAbsoluteValue(identifiable);
                    this.changes.put(identifiable, counter);
                }
                counter.increment();
            }
        } else {
            OModifiableInteger counter = this.newEntries.get(identifiable);
            if (counter == null) {
                this.newEntries.put(identifiable, new OModifiableInteger(1));
            } else {
                counter.increment();
            }
        }
        if (this.size >= 0) {
            ++this.size;
        }
        if (this.owner != null) {
            ORecordInternal.track(this.owner, identifiable);
        }
        if (this.updateOwner) {
            this.fireCollectionChangedEvent((OMultiValueChangeEvent<OIdentifiable, OIdentifiable>)new OMultiValueChangeEvent<OIdentifiable, Object>(OMultiValueChangeEvent.OChangeType.ADD, identifiable, identifiable, null, false));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void remove(OIdentifiable identifiable) {
        if (this.removeFromNewEntries(identifiable)) {
            if (this.size >= 0) {
                --this.size;
            }
        } else {
            Change counter = (Change)this.changes.get(identifiable);
            if (counter == null) {
                if (!identifiable.getIdentity().isPersistent()) return;
                this.changes.put(identifiable, new DiffChange(-1));
                this.size = -1;
            } else {
                counter.decrement();
                if (this.size >= 0) {
                    this.size = counter.isUndefined() ? -1 : --this.size;
                }
            }
        }
        if (this.owner != null) {
            ORecordInternal.unTrack(this.owner, identifiable);
        }
        if (!this.updateOwner) return;
        this.fireCollectionChangedEvent(new OMultiValueChangeEvent<OIdentifiable, OIdentifiable>(OMultiValueChangeEvent.OChangeType.REMOVE, identifiable, null, identifiable, false));
    }

    @Override
    public boolean contains(OIdentifiable identifiable) {
        if (this.newEntries.containsKey(identifiable)) {
            return true;
        }
        Change counter = (Change)this.changes.get(identifiable);
        if (counter != null) {
            AbsoluteChange absoluteValue = this.getAbsoluteValue(identifiable);
            if (counter.isUndefined()) {
                this.changes.put(identifiable, absoluteValue);
            }
            counter = absoluteValue;
        } else {
            counter = this.getAbsoluteValue(identifiable);
        }
        return counter.applyTo(0) > 0;
    }

    @Override
    public int size() {
        if (this.size >= 0) {
            return this.size;
        }
        return this.updateSize();
    }

    @Override
    public String toString() {
        if (this.size >= 0) {
            return "[size=" + this.size + "]";
        }
        return "[...]";
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void addChangeListener(OMultiValueChangeListener<OIdentifiable, OIdentifiable> changeListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new LinkedList<OMultiValueChangeListener<OIdentifiable, OIdentifiable>>();
        }
        this.changeListeners.add(changeListener);
    }

    @Override
    public void removeRecordChangeListener(OMultiValueChangeListener<OIdentifiable, OIdentifiable> changeListener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(changeListener);
        }
    }

    @Override
    public Class<?> getGenericClass() {
        return OIdentifiable.class;
    }

    @Override
    public Object returnOriginalState(List<OMultiValueChangeEvent<OIdentifiable, OIdentifiable>> multiValueChangeEvents) {
        OSBTreeRidBag reverted = new OSBTreeRidBag();
        for (OIdentifiable identifiable : this) {
            reverted.add(identifiable);
        }
        ListIterator<OMultiValueChangeEvent<OIdentifiable, OIdentifiable>> listIterator = multiValueChangeEvents.listIterator(multiValueChangeEvents.size());
        block5: while (listIterator.hasPrevious()) {
            OMultiValueChangeEvent<OIdentifiable, OIdentifiable> event = listIterator.previous();
            switch (event.getChangeType()) {
                case ADD: {
                    reverted.remove(event.getKey());
                    continue block5;
                }
                case REMOVE: {
                    reverted.add(event.getOldValue());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Invalid change type : " + (Object)((Object)event.getChangeType()));
        }
        return reverted;
    }

    @Override
    public int getSerializedSize() {
        int result = 28;
        if (ODatabaseRecordThreadLocal.INSTANCE.get().getStorage() instanceof OStorageProxy || ORecordSerializationContext.getContext() == null) {
            result += this.getChangesSerializedSize();
        }
        return result;
    }

    @Override
    public int getSerializedSize(byte[] stream, int offset) {
        return this.getSerializedSize();
    }

    @Override
    public int serialize(byte[] stream, int offset, UUID ownerUuid) {
        for (Map.Entry<OIdentifiable, OModifiableInteger> entry : this.newEntries.entrySet()) {
            OIdentifiable identifiable = entry.getKey();
            assert (identifiable instanceof ORecord);
            Change c = (Change)this.changes.get(identifiable);
            int delta = entry.getValue().intValue();
            if (c == null) {
                this.changes.put(identifiable, new DiffChange(delta));
                continue;
            }
            c.applyDiff(delta);
        }
        this.newEntries.clear();
        boolean remoteMode = ODatabaseRecordThreadLocal.INSTANCE.get().getStorage() instanceof OStorageProxy;
        ORecordSerializationContext context = remoteMode ? null : ORecordSerializationContext.getContext();
        if (this.collectionPointer == null && context != null) {
            int clusterId = this.getHighLevelDocClusterId();
            assert (clusterId > -1);
            this.collectionPointer = ODatabaseRecordThreadLocal.INSTANCE.get().getSbTreeCollectionManager().createSBTree(clusterId, ownerUuid);
        }
        OBonsaiCollectionPointer collectionPointer = this.collectionPointer != null ? this.collectionPointer : OBonsaiCollectionPointer.INVALID;
        OLongSerializer.INSTANCE.serializeLiteral(collectionPointer.getFileId(), stream, offset);
        OBonsaiBucketPointer rootPointer = collectionPointer.getRootPointer();
        OLongSerializer.INSTANCE.serializeLiteral(rootPointer.getPageIndex(), stream, offset += 8);
        OIntegerSerializer.INSTANCE.serializeLiteral(rootPointer.getPageOffset(), stream, offset += 8);
        OIntegerSerializer.INSTANCE.serializeLiteral(this.size, stream, offset += 4);
        offset += 4;
        if (context == null) {
            ChangeSerializationHelper.INSTANCE.serializeChanges(this.changes, OLinkSerializer.INSTANCE, stream, offset);
        } else {
            ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
            for (Map.Entry change : this.changes.entrySet()) {
                ORecord newKey;
                OIdentifiable key = (OIdentifiable)change.getKey();
                if (db == null || !db.getTransaction().isActive() || key.getIdentity().isPersistent() || (newKey = db.getTransaction().getRecord(key.getIdentity())) == null) continue;
                this.changes.remove(key);
                this.changes.put(newKey, (Change)change.getValue());
            }
            this.collectionPointer = collectionPointer;
            context.push(new ORidBagUpdateSerializationOperation(this.changes, collectionPointer));
            OIntegerSerializer.INSTANCE.serializeLiteral(0, stream, offset);
            offset += 4;
        }
        return offset;
    }

    public void clearChanges() {
        this.changes.clear();
    }

    @Override
    public void requestDelete() {
        ORecordSerializationContext context = ORecordSerializationContext.getContext();
        if (context != null && this.collectionPointer != null) {
            context.push(new ORidBagDeleteSerializationOperation(this.collectionPointer, this));
        }
    }

    public void confirmDelete() {
        this.collectionPointer = null;
        this.changes.clear();
        this.newEntries.clear();
        this.size = 0;
        if (this.changeListeners != null) {
            this.changeListeners.clear();
        }
        this.changeListeners = null;
    }

    @Override
    public int deserialize(byte[] stream, int offset) {
        long fileId = OLongSerializer.INSTANCE.deserializeLiteral(stream, offset);
        long pageIndex = OLongSerializer.INSTANCE.deserializeLiteral(stream, offset += 8);
        int pageOffset = OIntegerSerializer.INSTANCE.deserializeLiteral(stream, offset += 8);
        offset += 4;
        this.collectionPointer = fileId == -1L ? null : new OBonsaiCollectionPointer(fileId, new OBonsaiBucketPointer(pageIndex, pageOffset));
        this.size = -1;
        this.changes.putAll(ChangeSerializationHelper.INSTANCE.deserializeChanges(stream, offset += 4));
        return offset;
    }

    public OBonsaiCollectionPointer getCollectionPointer() {
        return this.collectionPointer;
    }

    public void setCollectionPointer(OBonsaiCollectionPointer collectionPointer) {
        this.collectionPointer = collectionPointer;
    }

    @Override
    public List<OMultiValueChangeListener<OIdentifiable, OIdentifiable>> getChangeListeners() {
        if (this.changeListeners == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.changeListeners);
    }

    @Override
    public void fireCollectionChangedEvent(OMultiValueChangeEvent<OIdentifiable, OIdentifiable> event) {
        if (this.changeListeners != null) {
            for (OMultiValueChangeListener<OIdentifiable, OIdentifiable> changeListener : this.changeListeners) {
                if (changeListener == null) continue;
                changeListener.onAfterRecordChanged(event);
            }
        }
    }

    private OSBTreeBonsai<OIdentifiable, Integer> loadTree() {
        if (this.collectionPointer == null) {
            return null;
        }
        return this.collectionManager.loadSBTree(this.collectionPointer);
    }

    private void releaseTree() {
        if (this.collectionPointer == null) {
            return;
        }
        this.collectionManager.releaseSBTree(this.collectionPointer);
    }

    private void mergeDiffEntry(OIdentifiable key, int diff) {
        if (diff > 0) {
            for (int i = 0; i < diff; ++i) {
                this.add(key);
            }
        } else {
            for (int i = diff; i < 0; ++i) {
                this.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbsoluteChange getAbsoluteValue(OIdentifiable identifiable) {
        OSBTreeBonsai<OIdentifiable, Integer> tree = this.loadTree();
        try {
            Change change;
            Integer oldValue = tree == null ? Integer.valueOf(0) : tree.get(identifiable);
            if (oldValue == null) {
                oldValue = 0;
            }
            AbsoluteChange absoluteChange = new AbsoluteChange((change = (Change)this.changes.get(identifiable)) == null ? oldValue.intValue() : change.applyTo(oldValue));
            return absoluteChange;
        }
        finally {
            this.releaseTree();
        }
    }

    private int updateSize() {
        int size = 0;
        if (this.collectionPointer != null) {
            OSBTreeBonsai<OIdentifiable, Integer> tree = this.loadTree();
            try {
                size = tree.getRealBagSize(this.changes);
            }
            finally {
                this.releaseTree();
            }
        } else {
            for (Change change : this.changes.values()) {
                size += change.applyTo(0);
            }
        }
        for (OModifiableInteger diff : this.newEntries.values()) {
            size += diff.getValue();
        }
        this.size = size;
        return size;
    }

    private int getChangesSerializedSize() {
        HashSet changedIds = new HashSet(this.changes.keySet());
        changedIds.addAll(this.newEntries.keySet());
        return ChangeSerializationHelper.INSTANCE.getChangesSerializedSize(changedIds.size());
    }

    private int getHighLevelDocClusterId() {
        ORecordElement owner;
        for (owner = this.owner; owner != null && owner.getOwner() != null; owner = owner.getOwner()) {
        }
        if (owner != null) {
            return ((OIdentifiable)((Object)owner)).getIdentity().getClusterId();
        }
        return -1;
    }

    private boolean removeFromNewEntries(OIdentifiable identifiable) {
        OModifiableInteger counter = this.newEntries.get(identifiable);
        if (counter == null) {
            return false;
        }
        if (counter.getValue() == 1) {
            this.newEntries.remove(identifiable);
        } else {
            counter.decrement();
        }
        return true;
    }

    private Map.Entry<OIdentifiable, Integer> nextChangedNotRemovedSBTreeEntry(Iterator<Map.Entry<OIdentifiable, Integer>> iterator) {
        while (iterator.hasNext()) {
            final Map.Entry<OIdentifiable, Integer> entry = iterator.next();
            Change change = (Change)this.changes.get(entry.getKey());
            if (change == null) {
                return entry;
            }
            final int newValue = change.applyTo(entry.getValue());
            if (newValue <= 0) continue;
            return new Map.Entry<OIdentifiable, Integer>(){

                @Override
                public OIdentifiable getKey() {
                    return (OIdentifiable)entry.getKey();
                }

                @Override
                public Integer getValue() {
                    return newValue;
                }

                @Override
                public Integer setValue(Integer value) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return null;
    }

    public void debugPrint(PrintStream writer) throws IOException {
        OSBTreeBonsai<OIdentifiable, Integer> tree = this.loadTree();
        if (tree instanceof OSBTreeBonsaiLocal) {
            ((OSBTreeBonsaiLocal)tree).debugPrintBucket(writer);
        }
    }

    @Override
    public void replace(OMultiValueChangeEvent<Object, Object> event, Object newValue) {
    }

    private final class SBTreeMapEntryIterator
    implements Iterator<Map.Entry<OIdentifiable, Integer>>,
    OResettable {
        private final int prefetchSize;
        private LinkedList<Map.Entry<OIdentifiable, Integer>> preFetchedValues;
        private OIdentifiable firstKey;

        public SBTreeMapEntryIterator(int prefetchSize) {
            this.prefetchSize = prefetchSize;
            this.init();
        }

        @Override
        public boolean hasNext() {
            return this.preFetchedValues != null;
        }

        @Override
        public Map.Entry<OIdentifiable, Integer> next() {
            Map.Entry<OIdentifiable, Integer> entry = this.preFetchedValues.removeFirst();
            if (this.preFetchedValues.isEmpty()) {
                this.prefetchData(false);
            }
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.init();
        }

        private void prefetchData(boolean firstTime) {
            OSBTreeBonsai tree = OSBTreeRidBag.this.loadTree();
            try {
                tree.loadEntriesMajor(this.firstKey, firstTime, true, new OTreeInternal.RangeResultListener<OIdentifiable, Integer>(){

                    @Override
                    public boolean addResult(final Map.Entry<OIdentifiable, Integer> entry) {
                        SBTreeMapEntryIterator.this.preFetchedValues.add(new Map.Entry<OIdentifiable, Integer>(){

                            @Override
                            public OIdentifiable getKey() {
                                return (OIdentifiable)entry.getKey();
                            }

                            @Override
                            public Integer getValue() {
                                return (Integer)entry.getValue();
                            }

                            @Override
                            public Integer setValue(Integer v) {
                                throw new UnsupportedOperationException("setValue");
                            }
                        });
                        return SBTreeMapEntryIterator.this.preFetchedValues.size() <= SBTreeMapEntryIterator.this.prefetchSize;
                    }
                });
            }
            finally {
                OSBTreeRidBag.this.releaseTree();
            }
            if (this.preFetchedValues.isEmpty()) {
                this.preFetchedValues = null;
            } else {
                this.firstKey = this.preFetchedValues.getLast().getKey();
            }
        }

        private void init() {
            OSBTreeBonsai tree = OSBTreeRidBag.this.loadTree();
            try {
                this.firstKey = (OIdentifiable)tree.firstKey();
            }
            finally {
                OSBTreeRidBag.this.releaseTree();
            }
            if (this.firstKey == null) {
                this.preFetchedValues = null;
                return;
            }
            this.preFetchedValues = new LinkedList();
            this.prefetchData(true);
        }
    }

    private final class RIDBagIterator
    implements Iterator<OIdentifiable>,
    OResettable,
    OSizeable,
    OAutoConvertToRecord {
        private final NavigableMap<OIdentifiable, Change> changedValues;
        private final SBTreeMapEntryIterator sbTreeIterator;
        private boolean convertToRecord;
        private Iterator<Map.Entry<OIdentifiable, OModifiableInteger>> newEntryIterator;
        private Iterator<Map.Entry<OIdentifiable, Change>> changedValuesIterator;
        private Map.Entry<OIdentifiable, Change> nextChange;
        private Map.Entry<OIdentifiable, Integer> nextSBTreeEntry;
        private OIdentifiable currentValue;
        private int currentFinalCounter;
        private int currentCounter;
        private boolean currentRemoved;

        private RIDBagIterator(IdentityHashMap<OIdentifiable, OModifiableInteger> newEntries, NavigableMap<OIdentifiable, Change> changedValues, SBTreeMapEntryIterator sbTreeIterator, boolean convertToRecord) {
            this.newEntryIterator = newEntries.entrySet().iterator();
            this.changedValues = changedValues;
            this.convertToRecord = convertToRecord;
            this.changedValuesIterator = changedValues.entrySet().iterator();
            this.sbTreeIterator = sbTreeIterator;
            this.nextChange = this.nextChangedNotRemovedEntry(this.changedValuesIterator);
            if (sbTreeIterator != null) {
                this.nextSBTreeEntry = OSBTreeRidBag.this.nextChangedNotRemovedSBTreeEntry(sbTreeIterator);
            }
        }

        @Override
        public boolean hasNext() {
            return this.newEntryIterator.hasNext() || this.nextChange != null || this.nextSBTreeEntry != null || this.currentValue != null && this.currentCounter < this.currentFinalCounter;
        }

        @Override
        public OIdentifiable next() {
            this.currentRemoved = false;
            if (this.currentCounter < this.currentFinalCounter) {
                ++this.currentCounter;
                return this.currentValue;
            }
            if (this.newEntryIterator.hasNext()) {
                Map.Entry<OIdentifiable, OModifiableInteger> entry = this.newEntryIterator.next();
                this.currentValue = entry.getKey();
                this.currentFinalCounter = entry.getValue().intValue();
                this.currentCounter = 1;
                return this.currentValue;
            }
            if (this.nextChange != null && this.nextSBTreeEntry != null) {
                if (this.nextChange.getKey().compareTo(this.nextSBTreeEntry.getKey()) < 0) {
                    this.currentValue = this.nextChange.getKey();
                    this.currentFinalCounter = this.nextChange.getValue().applyTo(0);
                    this.currentCounter = 1;
                    this.nextChange = this.nextChangedNotRemovedEntry(this.changedValuesIterator);
                } else {
                    this.currentValue = this.nextSBTreeEntry.getKey();
                    this.currentFinalCounter = this.nextSBTreeEntry.getValue();
                    this.currentCounter = 1;
                    this.nextSBTreeEntry = OSBTreeRidBag.this.nextChangedNotRemovedSBTreeEntry(this.sbTreeIterator);
                    if (this.nextChange != null && this.nextChange.getKey().equals(this.currentValue)) {
                        this.nextChange = this.nextChangedNotRemovedEntry(this.changedValuesIterator);
                    }
                }
            } else if (this.nextChange != null) {
                this.currentValue = this.nextChange.getKey();
                this.currentFinalCounter = this.nextChange.getValue().applyTo(0);
                this.currentCounter = 1;
                this.nextChange = this.nextChangedNotRemovedEntry(this.changedValuesIterator);
            } else if (this.nextSBTreeEntry != null) {
                this.currentValue = this.nextSBTreeEntry.getKey();
                this.currentFinalCounter = this.nextSBTreeEntry.getValue();
                this.currentCounter = 1;
                this.nextSBTreeEntry = OSBTreeRidBag.this.nextChangedNotRemovedSBTreeEntry(this.sbTreeIterator);
            } else {
                throw new NoSuchElementException();
            }
            if (this.convertToRecord) {
                return this.currentValue.getRecord();
            }
            return this.currentValue;
        }

        @Override
        public void remove() {
            if (this.currentRemoved) {
                throw new IllegalStateException("Current element has already been removed");
            }
            if (this.currentValue == null) {
                throw new IllegalStateException("Next method was not called for given iterator");
            }
            if (OSBTreeRidBag.this.removeFromNewEntries(this.currentValue)) {
                if (OSBTreeRidBag.this.size >= 0) {
                    OSBTreeRidBag.this.size--;
                }
            } else {
                Change counter = (Change)this.changedValues.get(this.currentValue);
                if (counter != null) {
                    counter.decrement();
                    if (OSBTreeRidBag.this.size >= 0) {
                        if (counter.isUndefined()) {
                            OSBTreeRidBag.this.size = -1;
                        } else {
                            OSBTreeRidBag.this.size--;
                        }
                    }
                } else {
                    if (this.nextChange != null) {
                        this.changedValues.put(this.currentValue, new DiffChange(-1));
                        this.changedValuesIterator = this.changedValues.tailMap(this.nextChange.getKey(), false).entrySet().iterator();
                    } else {
                        this.changedValues.put(this.currentValue, new DiffChange(-1));
                    }
                    OSBTreeRidBag.this.size = -1;
                }
            }
            if (OSBTreeRidBag.this.owner != null) {
                ORecordInternal.unTrack(OSBTreeRidBag.this.owner, this.currentValue);
            }
            if (OSBTreeRidBag.this.updateOwner) {
                OSBTreeRidBag.this.fireCollectionChangedEvent(new OMultiValueChangeEvent<OIdentifiable, OIdentifiable>(OMultiValueChangeEvent.OChangeType.REMOVE, this.currentValue, null, this.currentValue, false));
            }
            this.currentRemoved = true;
        }

        @Override
        public void reset() {
            this.newEntryIterator = OSBTreeRidBag.this.newEntries.entrySet().iterator();
            this.changedValuesIterator = this.changedValues.entrySet().iterator();
            if (this.sbTreeIterator != null) {
                this.sbTreeIterator.reset();
            }
            this.nextChange = this.nextChangedNotRemovedEntry(this.changedValuesIterator);
            if (this.sbTreeIterator != null) {
                this.nextSBTreeEntry = OSBTreeRidBag.this.nextChangedNotRemovedSBTreeEntry(this.sbTreeIterator);
            }
        }

        @Override
        public int size() {
            return OSBTreeRidBag.this.size();
        }

        @Override
        public boolean isAutoConvertToRecord() {
            return this.convertToRecord;
        }

        @Override
        public void setAutoConvertToRecord(boolean convertToRecord) {
            this.convertToRecord = convertToRecord;
        }

        private Map.Entry<OIdentifiable, Change> nextChangedNotRemovedEntry(Iterator<Map.Entry<OIdentifiable, Change>> iterator) {
            while (iterator.hasNext()) {
                Map.Entry<OIdentifiable, Change> entry = iterator.next();
                if (entry.getValue().applyTo(0) <= 0) continue;
                return entry;
            }
            return null;
        }
    }

    public static class ChangeSerializationHelper {
        public static final ChangeSerializationHelper INSTANCE = new ChangeSerializationHelper();

        public Change deserializeChange(byte[] stream, int offset) {
            int value = OIntegerSerializer.INSTANCE.deserializeLiteral(stream, offset + 1);
            switch (OByteSerializer.INSTANCE.deserializeLiteral(stream, offset)) {
                case 1: {
                    return new AbsoluteChange(value);
                }
                case 0: {
                    return new DiffChange(value);
                }
            }
            throw new IllegalArgumentException("Change type is incorrect");
        }

        public Map<OIdentifiable, Change> deserializeChanges(byte[] stream, int offset) {
            int count = OIntegerSerializer.INSTANCE.deserializeLiteral(stream, offset);
            offset += 4;
            HashMap<OIdentifiable, Change> res = new HashMap<OIdentifiable, Change>();
            for (int i = 0; i < count; ++i) {
                ORecordId rid = OLinkSerializer.INSTANCE.deserialize(stream, offset);
                Change change = INSTANCE.deserializeChange(stream, offset += 10);
                offset += 5;
                ORecordId identifiable = rid.isTemporary() && rid.getRecord() != null ? rid.getRecord() : rid;
                res.put(identifiable, change);
            }
            return res;
        }

        public <K> void serializeChanges(Map<K, Change> changes, OBinarySerializer<K> keySerializer, byte[] stream, int offset) {
            OIntegerSerializer.INSTANCE.serializeLiteral(changes.size(), stream, offset);
            offset += 4;
            for (Map.Entry<K, Change> entry : changes.entrySet()) {
                Object key = entry.getKey();
                if (((OIdentifiable)key).getIdentity().isTemporary()) {
                    key = ((OIdentifiable)key).getRecord();
                }
                keySerializer.serialize(key, stream, offset, new Object[0]);
                offset += keySerializer.getObjectSize(key, new Object[0]);
                offset += entry.getValue().serialize(stream, offset);
            }
        }

        public int getChangesSerializedSize(int changesCount) {
            return changesCount * 15;
        }
    }

    private static class AbsoluteChange
    implements Change {
        private static final byte TYPE = 1;
        private int value;

        private AbsoluteChange(int value) {
            this.value = value;
            this.checkPositive();
        }

        @Override
        public void increment() {
            ++this.value;
        }

        @Override
        public void decrement() {
            --this.value;
            this.checkPositive();
        }

        @Override
        public int applyTo(Integer value) {
            return this.value;
        }

        @Override
        public boolean isUndefined() {
            return true;
        }

        @Override
        public void applyDiff(int delta) {
            this.value += delta;
            this.checkPositive();
        }

        @Override
        public int serialize(byte[] stream, int offset) {
            OByteSerializer.INSTANCE.serializeLiteral((byte)1, stream, offset);
            OIntegerSerializer.INSTANCE.serializeLiteral(this.value, stream, offset + 1);
            return 5;
        }

        private void checkPositive() {
            if (this.value < 0) {
                this.value = 0;
            }
        }
    }

    private static class DiffChange
    implements Change {
        private static final byte TYPE = 0;
        private int delta;

        private DiffChange(int delta) {
            this.delta = delta;
        }

        @Override
        public void increment() {
            ++this.delta;
        }

        @Override
        public void decrement() {
            --this.delta;
        }

        @Override
        public int applyTo(Integer value) {
            int result = value == null ? this.delta : value + this.delta;
            if (result < 0) {
                result = 0;
            }
            return result;
        }

        @Override
        public boolean isUndefined() {
            return this.delta < 0;
        }

        @Override
        public void applyDiff(int delta) {
            this.delta += delta;
        }

        @Override
        public int serialize(byte[] stream, int offset) {
            OByteSerializer.INSTANCE.serializeLiteral((byte)0, stream, offset);
            OIntegerSerializer.INSTANCE.serializeLiteral(this.delta, stream, offset + 1);
            return 5;
        }
    }

    public static interface Change {
        public static final int SIZE = 5;

        public void increment();

        public void decrement();

        public int applyTo(Integer var1);

        public boolean isUndefined();

        public void applyDiff(int var1);

        public int serialize(byte[] var1, int var2);
    }
}

